/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet;

import java.io.File;
import javax.script.ScriptEngine;
import mchorse.mappet.EventHandler;
import mchorse.mappet.Mappet;
import mchorse.mappet.api.conditions.blocks.AbstractConditionBlock;
import mchorse.mappet.api.conditions.blocks.ConditionConditionBlock;
import mchorse.mappet.api.conditions.blocks.DialogueConditionBlock;
import mchorse.mappet.api.conditions.blocks.EntityConditionBlock;
import mchorse.mappet.api.conditions.blocks.ExpressionConditionBlock;
import mchorse.mappet.api.conditions.blocks.FactionConditionBlock;
import mchorse.mappet.api.conditions.blocks.ItemConditionBlock;
import mchorse.mappet.api.conditions.blocks.MorphConditionBlock;
import mchorse.mappet.api.conditions.blocks.QuestConditionBlock;
import mchorse.mappet.api.conditions.blocks.StateConditionBlock;
import mchorse.mappet.api.conditions.blocks.WorldTimeConditionBlock;
import mchorse.mappet.api.dialogues.nodes.CraftingNode;
import mchorse.mappet.api.dialogues.nodes.QuestChainNode;
import mchorse.mappet.api.dialogues.nodes.QuestDialogueNode;
import mchorse.mappet.api.dialogues.nodes.ReactionNode;
import mchorse.mappet.api.dialogues.nodes.ReplyNode;
import mchorse.mappet.api.events.nodes.CancelNode;
import mchorse.mappet.api.events.nodes.CommandNode;
import mchorse.mappet.api.events.nodes.ConditionNode;
import mchorse.mappet.api.events.nodes.EventBaseNode;
import mchorse.mappet.api.events.nodes.SwitchNode;
import mchorse.mappet.api.events.nodes.TimerNode;
import mchorse.mappet.api.events.nodes.TriggerNode;
import mchorse.mappet.api.quests.chains.QuestNode;
import mchorse.mappet.api.triggers.blocks.AbstractTriggerBlock;
import mchorse.mappet.api.triggers.blocks.CommandTriggerBlock;
import mchorse.mappet.api.triggers.blocks.DialogueTriggerBlock;
import mchorse.mappet.api.triggers.blocks.EventTriggerBlock;
import mchorse.mappet.api.triggers.blocks.ItemTriggerBlock;
import mchorse.mappet.api.triggers.blocks.MorphTriggerBlock;
import mchorse.mappet.api.triggers.blocks.ScriptTriggerBlock;
import mchorse.mappet.api.triggers.blocks.SoundTriggerBlock;
import mchorse.mappet.api.triggers.blocks.StateTriggerBlock;
import mchorse.mappet.api.ui.components.UIButtonComponent;
import mchorse.mappet.api.ui.components.UIClickComponent;
import mchorse.mappet.api.ui.components.UIComponent;
import mchorse.mappet.api.ui.components.UIGraphicsComponent;
import mchorse.mappet.api.ui.components.UIIconButtonComponent;
import mchorse.mappet.api.ui.components.UILabelComponent;
import mchorse.mappet.api.ui.components.UILayoutComponent;
import mchorse.mappet.api.ui.components.UIMorphComponent;
import mchorse.mappet.api.ui.components.UIStackComponent;
import mchorse.mappet.api.ui.components.UIStringListComponent;
import mchorse.mappet.api.ui.components.UITextComponent;
import mchorse.mappet.api.ui.components.UITextareaComponent;
import mchorse.mappet.api.ui.components.UITextboxComponent;
import mchorse.mappet.api.ui.components.UIToggleComponent;
import mchorse.mappet.api.ui.components.UITrackpadComponent;
import mchorse.mappet.api.utils.factory.IFactory;
import mchorse.mappet.api.utils.factory.MapFactory;
import mchorse.mappet.capabilities.character.Character;
import mchorse.mappet.capabilities.character.CharacterStorage;
import mchorse.mappet.capabilities.character.ICharacter;
import mchorse.mappet.events.RegisterConditionBlockEvent;
import mchorse.mappet.events.RegisterDialogueNodeEvent;
import mchorse.mappet.events.RegisterEventNodeEvent;
import mchorse.mappet.events.RegisterQuestChainNodeEvent;
import mchorse.mappet.events.RegisterTriggerBlockEvent;
import mchorse.mappet.events.RegisterUIComponentEvent;
import mchorse.mappet.network.Dispatcher;
import mchorse.mappet.utils.MPIcons;
import mchorse.mappet.utils.MappetNpcSelector;
import mchorse.mappet.utils.MetamorphHandler;
import mchorse.mappet.utils.ScriptUtils;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.fml.common.IEntitySelectorFactory;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class CommonProxy {
    private static IFactory<EventBaseNode> events;
    private static IFactory<EventBaseNode> dialogues;
    private static IFactory<QuestNode> chains;
    private static IFactory<AbstractConditionBlock> conditionBlocks;
    private static IFactory<AbstractTriggerBlock> triggerBlocks;
    private static IFactory<UIComponent> uiComponents;
    public static File configFolder;
    public static EventHandler eventHandler;

    public static IFactory<EventBaseNode> getEvents() {
        return events;
    }

    public static IFactory<EventBaseNode> getDialogues() {
        return dialogues;
    }

    public static IFactory<QuestNode> getChains() {
        return chains;
    }

    public static IFactory<AbstractConditionBlock> getConditionBlocks() {
        return conditionBlocks;
    }

    public static IFactory<AbstractTriggerBlock> getTriggerBlocks() {
        return triggerBlocks;
    }

    public static IFactory<UIComponent> getUiComponents() {
        return uiComponents;
    }

    public void preInit(FMLPreInitializationEvent event) {
        String path = event.getModConfigurationDirectory().getAbsolutePath();
        configFolder = new File(path, "mappet");
        configFolder.mkdir();
        Dispatcher.register();
        eventHandler = new EventHandler();
        MinecraftForge.EVENT_BUS.register((Object)eventHandler);
        GameRegistry.registerEntitySelector((IEntitySelectorFactory)new MappetNpcSelector(), (String[])new String[]{"mpid", "mpe"});
        CapabilityManager.INSTANCE.register(ICharacter.class, (Capability.IStorage)new CharacterStorage(), Character::new);
    }

    public void init(FMLInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new MetamorphHandler());
        Mappet.EVENT_BUS.register((Object)eventHandler);
        this.initiateJS();
        MPIcons.register();
    }

    private void initiateJS() {
        try {
            ScriptEngine engine = ScriptUtils.tryCreatingEngine();
            if (!engine.eval("true").equals(Boolean.TRUE)) {
                throw new Exception("Something went wrong with JavaScript...");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void postInit(FMLPostInitializationEvent event) {
        MapFactory<EventBaseNode> eventNodes = new MapFactory<CommandNode>().register("command", CommandNode.class, 9710335).register("condition", ConditionNode.class, 16716947).register("switch", SwitchNode.class, 11796224).register("timer", TimerNode.class, 35071).register("trigger", TriggerNode.class, 0xFF0033).alias("trigger", "event").alias("trigger", "dialogue").alias("trigger", "script").register("cancel", CancelNode.class, 0xEEEEEE);
        events = eventNodes;
        Mappet.EVENT_BUS.post((Event)new RegisterEventNodeEvent(eventNodes));
        MapFactory<EventBaseNode> dialogueNodes = eventNodes.copy().register("reply", ReplyNode.class, 41215).register("reaction", ReactionNode.class, 0xFF0033).register("crafting", CraftingNode.class, 0xFF6600).register("quest_chain", QuestChainNode.class, 0xFFAA00).register("quest", QuestDialogueNode.class, 0xFFAA00).unregister("timer");
        dialogues = dialogueNodes;
        Mappet.EVENT_BUS.post((Event)new RegisterDialogueNodeEvent(dialogueNodes));
        MapFactory<QuestNode> questChainNodes = new MapFactory<QuestNode>().register("quest", QuestNode.class, 0xFFAA00);
        chains = questChainNodes;
        Mappet.EVENT_BUS.post((Event)new RegisterQuestChainNodeEvent(questChainNodes));
        MapFactory<AbstractConditionBlock> conditions = new MapFactory<QuestConditionBlock>().register("quest", QuestConditionBlock.class, 0xFFAA00).register("state", StateConditionBlock.class, 0xFF0033).register("dialogue", DialogueConditionBlock.class, 0x11FF33).register("faction", FactionConditionBlock.class, 11796224).register("item", ItemConditionBlock.class, 0xFF6600).register("world_time", WorldTimeConditionBlock.class, 35071).register("entity", EntityConditionBlock.class, 2965859).register("condition", ConditionConditionBlock.class, 16716947).register("morph", MorphConditionBlock.class, 5177568).register("expression", ExpressionConditionBlock.class, 0xEEEEEE);
        conditionBlocks = conditions;
        Mappet.EVENT_BUS.post((Event)new RegisterConditionBlockEvent(conditions));
        MapFactory<AbstractTriggerBlock> triggers = new MapFactory<CommandTriggerBlock>().register("command", CommandTriggerBlock.class, 9710335).register("sound", SoundTriggerBlock.class, 41215).register("event", EventTriggerBlock.class, 0xFF0033).register("dialogue", DialogueTriggerBlock.class, 0x11FF33).register("script", ScriptTriggerBlock.class, 2965859).register("item", ItemTriggerBlock.class, 0xFF6600).register("state", StateTriggerBlock.class, 0xFF0033).register("morph", MorphTriggerBlock.class, 5177568);
        triggerBlocks = triggers;
        Mappet.EVENT_BUS.post((Event)new RegisterTriggerBlockEvent(triggers));
        MapFactory<UIComponent> ui = new MapFactory<UIGraphicsComponent>().register("graphics", UIGraphicsComponent.class, 0xFFFFFF).register("button", UIButtonComponent.class, 0xFFFFFF).register("icon", UIIconButtonComponent.class, 0xFFFFFF).register("label", UILabelComponent.class, 0xFFFFFF).register("text", UITextComponent.class, 0xFFFFFF).register("textbox", UITextboxComponent.class, 0xFFFFFF).register("textarea", UITextareaComponent.class, 0xFFFFFF).register("toggle", UIToggleComponent.class, 0xFFFFFF).register("trackpad", UITrackpadComponent.class, 0xFFFFFF).register("strings", UIStringListComponent.class, 0xFFFFFF).register("item", UIStackComponent.class, 0xFFFFFF).register("layout", UILayoutComponent.class, 0xFFFFFF).register("morph", UIMorphComponent.class, 0xFFFFFF).register("clickarea", UIClickComponent.class, 0xFFFFFF);
        uiComponents = ui;
        Mappet.EVENT_BUS.post((Event)new RegisterUIComponentEvent(ui));
    }
}

