/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet;

import java.time.Instant;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import mchorse.mappet.Mappet;
import mchorse.mappet.RegisterHandler;
import mchorse.mappet.api.quests.Quest;
import mchorse.mappet.api.quests.Quests;
import mchorse.mappet.api.scripts.code.items.ScriptItemStack;
import mchorse.mappet.api.triggers.Trigger;
import mchorse.mappet.api.utils.DataContext;
import mchorse.mappet.api.utils.IExecutable;
import mchorse.mappet.capabilities.character.Character;
import mchorse.mappet.capabilities.character.CharacterProvider;
import mchorse.mappet.capabilities.character.ICharacter;
import mchorse.mappet.client.KeyboardHandler;
import mchorse.mappet.client.RenderingHandler;
import mchorse.mappet.commands.data.CommandDataClear;
import mchorse.mappet.events.StateChangedEvent;
import mchorse.mappet.network.Dispatcher;
import mchorse.mappet.network.common.events.PacketEventHotkeys;
import mchorse.mappet.network.common.quests.PacketQuest;
import mchorse.mappet.network.common.quests.PacketQuests;
import mchorse.mappet.network.common.scripts.PacketClick;
import mchorse.mappet.network.common.scripts.PacketPlayerSkin;
import mchorse.mappet.utils.ScriptUtils;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.ContainerChest;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EventHandler {
    public static final ResourceLocation CAPABILITY = new ResourceLocation("mappet", "character");
    private static Boolean isMohist;
    private Set<EntityPlayer> playersToCheck = new HashSet<EntityPlayer>();
    private List<IExecutable> executables = new ArrayList<IExecutable>();
    private List<IExecutable> secondList = new ArrayList<IExecutable>();
    private DataContext context;
    private Set<UUID> loggedInPlayers = new HashSet<UUID>();

    private static boolean isMohist() {
        if (isMohist != null) {
            return isMohist;
        }
        try {
            Class.forName("com.mohistmc.MohistMC");
            isMohist = true;
        }
        catch (Exception e) {
            isMohist = false;
        }
        return isMohist;
    }

    public void addExecutables(List<IExecutable> executionForks) {
        this.executables.addAll(executionForks);
    }

    public void addExecutable(IExecutable executable) {
        this.executables.add(executable);
    }

    public void reset() {
        this.playersToCheck.clear();
        this.executables.clear();
        this.secondList.clear();
        this.context = null;
    }

    private void trigger(Event event, Trigger trigger, DataContext context) {
        trigger.trigger(context);
        if (context.isCanceled()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onPlayerChat(ServerChatEvent event) {
        if (!Mappet.settings.playerChat.isEmpty()) {
            DataContext context = new DataContext((Entity)event.getPlayer()).set("message", event.getMessage());
            this.trigger((Event)event, Mappet.settings.playerChat, context);
        }
    }

    @SubscribeEvent
    public void onPlayerBreakBlock(BlockEvent.BreakEvent event) {
        if (!Mappet.settings.blockBreak.isEmpty()) {
            IBlockState state = event.getState();
            DataContext context = new DataContext((Entity)event.getPlayer()).set("block", state.func_177230_c().getRegistryName().toString()).set("meta", state.func_177230_c().func_176201_c(state)).set("x", event.getPos().func_177958_n()).set("y", event.getPos().func_177956_o()).set("z", event.getPos().func_177952_p());
            this.trigger((Event)event, Mappet.settings.blockBreak, context);
        }
    }

    @SubscribeEvent
    public void onPlayerPlaceBlock(BlockEvent.PlaceEvent event) {
        if (!Mappet.settings.blockPlace.isEmpty()) {
            IBlockState state = event.getPlacedBlock();
            DataContext context = new DataContext((Entity)event.getPlayer()).set("block", state.func_177230_c().getRegistryName().toString()).set("meta", state.func_177230_c().func_176201_c(state)).set("x", event.getPos().func_177958_n()).set("y", event.getPos().func_177956_o()).set("z", event.getPos().func_177952_p());
            this.trigger((Event)event, Mappet.settings.blockPlace, context);
        }
    }

    @SubscribeEvent
    public void onPlayerDamageEntity(LivingDamageEvent event) {
        DamageSource source = event.getSource();
        if (source.func_76346_g() instanceof EntityPlayer && !Mappet.settings.entityDamaged.isEmpty()) {
            DataContext context = new DataContext((Entity)event.getEntityLiving(), source.func_76346_g()).set("damage", event.getAmount());
            this.trigger((Event)event, Mappet.settings.entityDamaged, context);
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onPlayerCloseContainer(PlayerContainerEvent.Close event) {
        ContainerChest chest;
        this.playersToCheck.add(event.getEntityPlayer());
        if (Mappet.settings.playerCloseContainer.isEmpty()) {
            return;
        }
        DataContext context = new DataContext((Entity)event.getEntityPlayer());
        if (event.getContainer() instanceof ContainerChest && (chest = (ContainerChest)event.getContainer()).func_85151_d() instanceof TileEntity) {
            BlockPos pos = ((TileEntity)chest.func_85151_d()).func_174877_v();
            context.set("x", pos.func_177958_n());
            context.set("y", pos.func_177956_o());
            context.set("z", pos.func_177952_p());
        }
        Mappet.settings.playerCloseContainer.trigger(context);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onPlayerLeftClickEmpty(PlayerInteractEvent.LeftClickEmpty event) {
        if (!event.getEntityPlayer().field_70170_p.field_72995_K) {
            return;
        }
        Dispatcher.sendToServer(new PacketClick(EnumHand.MAIN_HAND));
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onPlayerRightClickEmpty(PlayerInteractEvent.RightClickEmpty event) {
        if (!event.getEntityPlayer().field_70170_p.field_72995_K || event.getHand() == EnumHand.OFF_HAND) {
            return;
        }
        Dispatcher.sendToServer(new PacketClick(EnumHand.OFF_HAND));
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onPlayerLeftClick(PlayerInteractEvent.LeftClickBlock event) {
        EntityPlayer player = event.getEntityPlayer();
        if (player.field_70170_p.field_72995_K || Mappet.settings.blockClick.isEmpty()) {
            return;
        }
        DataContext context = new DataContext((Entity)player).set("x", event.getPos().func_177958_n()).set("y", event.getPos().func_177956_o()).set("z", event.getPos().func_177952_p()).set("hand", event.getHand() == EnumHand.MAIN_HAND ? "main" : "off");
        this.trigger((Event)event, Mappet.settings.blockClick, context);
    }

    @SubscribeEvent
    public void onPlayerRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        EntityPlayer player = event.getEntityPlayer();
        if (player.field_70170_p.field_72995_K || Mappet.settings.blockInteract.isEmpty()) {
            return;
        }
        DataContext context = new DataContext((Entity)player).set("x", event.getPos().func_177958_n()).set("y", event.getPos().func_177956_o()).set("z", event.getPos().func_177952_p()).set("hand", event.getHand() == EnumHand.MAIN_HAND ? "main" : "off");
        this.trigger((Event)event, Mappet.settings.blockInteract, context);
    }

    @SubscribeEvent
    public void attachPlayerCapability(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof EntityPlayer) {
            event.addCapability(CAPABILITY, (ICapabilityProvider)new CharacterProvider());
        }
    }

    @SubscribeEvent
    public void onPlayerLogsIn(PlayerEvent.PlayerLoggedInEvent event) {
        EntityPlayerMP player = (EntityPlayerMP)event.player;
        ICharacter character = Character.get((EntityPlayer)player);
        Instant lastClear = Mappet.data.getLastClear();
        if (character != null) {
            if (character.getLastClear().isBefore(lastClear)) {
                CommandDataClear.clear(player, Mappet.data.getLastInventory());
                character.updateLastClear(lastClear);
            }
            this.syncData(player, character);
        }
        if (!Mappet.settings.playerLogIn.isEmpty()) {
            DataContext context = new DataContext((Entity)event.player);
            Mappet.settings.playerLogIn.trigger(context);
        }
        if (ScriptUtils.copiedNashorn) {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("mappet.nashorn_copied", new Object[0]));
        } else if (ScriptUtils.errorNashorn) {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("mappet.nashorn_error", new Object[0]));
        }
        this.loggedInPlayers.add(player.func_110124_au());
    }

    @SubscribeEvent
    public void onPlayerLogsOut(PlayerEvent.PlayerLoggedOutEvent event) {
        this.loggedInPlayers.remove(event.player.func_110124_au());
    }

    @SubscribeEvent
    public void onPlayerClone(PlayerEvent.Clone event) {
        EntityPlayer player = event.getEntityPlayer();
        ICharacter character = Character.get(player);
        ICharacter oldCharacter = Character.get(event.getOriginal());
        if (!EventHandler.isMohist()) {
            character.copy(oldCharacter, player);
        }
    }

    @SubscribeEvent
    public void onPlayerSpawn(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof EntityPlayer && !event.getEntity().field_70170_p.field_72995_K) {
            EntityPlayerMP player = (EntityPlayerMP)event.getEntity();
            ICharacter character = Character.get((EntityPlayer)player);
            this.syncData(player, character);
            if (this.loggedInPlayers.contains(player.func_110124_au()) && !Mappet.settings.playerRespawn.isEmpty()) {
                Mappet.settings.playerRespawn.trigger(new DataContext((Entity)player));
            }
        }
    }

    private void syncData(EntityPlayerMP player, ICharacter character) {
        if (!character.getQuests().quests.isEmpty()) {
            character.getQuests().initiate((EntityPlayer)player);
            Dispatcher.sendTo(new PacketQuests(character.getQuests()), player);
        }
        if (!Mappet.settings.hotkeys.hotkeys.isEmpty()) {
            Dispatcher.sendTo(new PacketEventHotkeys(Mappet.settings), player);
        }
    }

    @SubscribeEvent
    public void onPlayerPickUp(EntityItemPickupEvent event) {
        this.playersToCheck.add(event.getEntityPlayer());
        if (!Mappet.settings.playerItemPickup.isEmpty()) {
            DataContext context = new DataContext((Entity)event.getEntityPlayer());
            context.getValues().put("item", ScriptItemStack.create(event.getItem().func_92059_d()));
            this.trigger((Event)event, Mappet.settings.playerItemPickup, context);
        }
    }

    @SubscribeEvent
    public void onMobKilled(LivingDeathEvent event) {
        EntityPlayer player;
        ICharacter character;
        Trigger trigger;
        if (event.getEntity().field_70170_p.field_72995_K) {
            return;
        }
        Entity source = event.getSource().func_76346_g();
        Trigger trigger2 = trigger = event.getEntity() instanceof EntityPlayer ? Mappet.settings.playerDeath : Mappet.settings.entityDeath;
        if (!trigger.isEmpty()) {
            this.trigger((Event)event, trigger, new DataContext((Entity)event.getEntityLiving(), source));
        }
        if (source instanceof EntityPlayer && (character = Character.get(player = (EntityPlayer)source)) != null) {
            for (Quest quest : character.getQuests().quests.values()) {
                quest.mobWasKilled(player, event.getEntity());
            }
            this.playersToCheck.add(player);
        }
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            return;
        }
        for (EntityPlayer player : this.playersToCheck) {
            ICharacter character = Character.get(player);
            if (character == null) continue;
            Quests quests = character.getQuests();
            Iterator<Map.Entry<String, Quest>> it = quests.quests.entrySet().iterator();
            quests.iterating = true;
            while (it.hasNext()) {
                Map.Entry<String, Quest> entry = it.next();
                Quest quest = entry.getValue();
                if (quest.instant && quest.rewardIfComplete(player)) {
                    it.remove();
                    Dispatcher.sendTo(new PacketQuest(entry.getKey(), null), (EntityPlayerMP)player);
                    continue;
                }
                Dispatcher.sendTo(new PacketQuest(entry.getKey(), entry.getValue()), (EntityPlayerMP)player);
            }
            quests.flush(player);
        }
        this.playersToCheck.clear();
        if (!this.executables.isEmpty()) {
            this.secondList.addAll(this.executables);
            this.executables.clear();
            this.secondList.removeIf(IExecutable::update);
            this.secondList.addAll(this.executables);
            this.executables.clear();
            this.executables.addAll(this.secondList);
            this.secondList.clear();
        }
        if (!Mappet.settings.serverTick.isEmpty()) {
            if (this.context == null) {
                this.context = new DataContext(FMLCommonHandler.instance().getMinecraftServerInstance());
            }
            Mappet.settings.serverTick.trigger(this.context);
            this.context.cancel(false);
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            return;
        }
        ICharacter character = Character.get(event.player);
        if (character != null && !event.player.field_70170_p.field_72995_K) {
            character.getPositionCache().updatePlayer(event.player);
        }
        if (event.player.field_70170_p.field_72995_K && event.player == Minecraft.func_71410_x().field_71439_g) {
            this.onPlayerTickClient(event);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void onPlayerTickClient(TickEvent.PlayerTickEvent event) {
        RenderingHandler.update();
        if (!RegisterHandler.sentSkin) {
            Dispatcher.sendToServer(new PacketPlayerSkin(Minecraft.func_71410_x().field_71439_g.func_110306_p().toString()));
            RegisterHandler.sentSkin = true;
        }
        KeyboardHandler.updateHeldKeys();
    }

    @SubscribeEvent
    public void onStateChange(StateChangedEvent event) {
        for (EntityPlayer player : FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_181057_v()) {
            ICharacter character = Character.get(player);
            if (character == null || !event.isGlobal() && character.getStates() != event.states) continue;
            int i = 0;
            for (Quest quest : character.getQuests().quests.values()) {
                i += quest.stateWasUpdated(player) ? 1 : 0;
            }
            if (i <= 0) continue;
            this.playersToCheck.add(player);
        }
    }
}

