/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet.api.conditions.blocks;

import mchorse.mappet.api.conditions.blocks.AbstractConditionBlock;
import mchorse.mappet.api.utils.DataContext;
import mchorse.mappet.utils.EnumUtils;
import net.minecraft.client.resources.I18n;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class WorldTimeConditionBlock
extends AbstractConditionBlock {
    public TimeCheck check = TimeCheck.DAY;
    public int min;
    public int max = 24000;

    @Override
    public boolean evaluateBlock(DataContext context) {
        long time = context.world.func_72820_D();
        if (this.check == TimeCheck.DAY) {
            return time % 24000L < 12000L;
        }
        if (this.check == TimeCheck.NIGHT) {
            return time % 24000L >= 12000L;
        }
        if (this.check == TimeCheck.RANGE) {
            return time % 24000L >= (long)this.min && time % 24000L <= (long)this.max;
        }
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String stringify() {
        String label = this.check.stringify();
        if (this.check == TimeCheck.RANGE) {
            label = label + " " + this.min + "-" + this.max;
        }
        return label;
    }

    @Override
    public void serializeNBT(NBTTagCompound tag) {
        super.serializeNBT(tag);
        tag.func_74768_a("Check", this.check.ordinal());
        tag.func_74768_a("Min", this.min);
        tag.func_74768_a("Max", this.max);
    }

    @Override
    public void deserializeNBT(NBTTagCompound tag) {
        super.deserializeNBT(tag);
        this.check = EnumUtils.getValue(tag.func_74762_e("Check"), TimeCheck.values(), TimeCheck.DAY);
        this.min = tag.func_74762_e("Min");
        this.max = tag.func_74762_e("Max");
    }

    public static enum TimeCheck {
        DAY,
        NIGHT,
        RANGE;


        @SideOnly(value=Side.CLIENT)
        public String stringify() {
            return I18n.func_135052_a((String)this.getKey(), (Object[])new Object[0]);
        }

        public String getKey() {
            return "mappet.gui.conditions.world_time.types." + this.name().toLowerCase();
        }
    }
}

