/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet.api.data;

import mchorse.mappet.Mappet;
import mchorse.mappet.api.states.States;
import mchorse.mappet.api.utils.AbstractData;
import mchorse.mappet.capabilities.character.Character;
import mchorse.mappet.capabilities.character.ICharacter;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.NonNullList;

public class Data
extends AbstractData {
    public States global = new States();
    public States player = new States();
    public NonNullList<ItemStack> inventory = NonNullList.func_191196_a();

    public void save(EntityPlayer player) {
        ICharacter character = Character.get(player);
        if (character != null) {
            this.global.copy(Mappet.states);
            this.player.copy(character.getStates());
            int c = player.field_71071_by.func_70302_i_();
            for (int i = 0; i < c; ++i) {
                this.inventory.add((Object)player.field_71071_by.func_70301_a(i).func_77946_l());
            }
        }
    }

    public void apply(EntityPlayer player, boolean global) {
        ICharacter character = Character.get(player);
        if (character != null) {
            if (global) {
                Mappet.states.copy(this.global);
            }
            character.getStates().copy(this.player);
            player.field_71071_by.func_174888_l();
            int c = Math.min(this.inventory.size(), player.field_71071_by.func_70302_i_());
            for (int i = 0; i < c; ++i) {
                player.field_71071_by.func_70299_a(i, ((ItemStack)this.inventory.get(i)).func_77946_l());
            }
        }
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74782_a("Global", (NBTBase)this.global.serializeNBT());
        tag.func_74782_a("Player", (NBTBase)this.player.serializeNBT());
        NBTTagList inventory = new NBTTagList();
        for (ItemStack stack : this.inventory) {
            inventory.func_74742_a((NBTBase)stack.serializeNBT());
        }
        tag.func_74782_a("Inventory", (NBTBase)inventory);
        return tag;
    }

    public void deserializeNBT(NBTTagCompound tag) {
        if (tag.func_74764_b("Global")) {
            this.global.deserializeNBT(tag.func_74775_l("Global"));
        }
        if (tag.func_74764_b("Player")) {
            this.player.deserializeNBT(tag.func_74775_l("Player"));
        }
        NBTTagList inventory = tag.func_150295_c("Inventory", 10);
        for (int i = 0; i < inventory.func_74745_c(); ++i) {
            this.inventory.add((Object)new ItemStack(inventory.func_150305_b(i)));
        }
    }
}

