/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet.api.events.nodes;

import mchorse.mappet.api.events.EventContext;
import mchorse.mappet.api.events.nodes.EventBaseNode;
import mchorse.mappet.api.triggers.Trigger;
import mchorse.mappet.api.triggers.blocks.DataTriggerBlock;
import mchorse.mappet.api.triggers.blocks.DialogueTriggerBlock;
import mchorse.mappet.api.triggers.blocks.EventTriggerBlock;
import mchorse.mappet.api.triggers.blocks.ScriptTriggerBlock;
import mchorse.mappet.api.utils.DataContext;
import net.minecraft.client.resources.I18n;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TriggerNode
extends EventBaseNode {
    public Trigger trigger = new Trigger();
    public String customData = "";
    public boolean cancel;

    @Override
    @SideOnly(value=Side.CLIENT)
    protected String getDisplayTitle() {
        return I18n.func_135052_a((String)"mappet.gui.trigger.quantity", (Object[])new Object[]{this.trigger.blocks.size()});
    }

    @Override
    public int execute(EventContext context) {
        DataContext newContext = this.apply(context);
        this.trigger.trigger(newContext);
        if (this.cancel) {
            if (!context.data.isCanceled()) {
                context.data.cancel(newContext.isCanceled());
            }
            return this.booleanToExecutionCode(true);
        }
        return this.booleanToExecutionCode(!newContext.isCanceled());
    }

    public DataContext apply(EventContext event) {
        DataContext context = event.data.copy();
        context.parse(context.process(this.customData));
        return context;
    }

    @Override
    public NBTTagCompound serializeNBT() {
        NBTTagCompound tag = super.serializeNBT();
        tag.func_74782_a("Trigger", (NBTBase)this.trigger.serializeNBT());
        tag.func_74778_a("CustomData", this.customData);
        tag.func_74757_a("Cancel", this.cancel);
        return tag;
    }

    @Override
    public void deserializeNBT(NBTTagCompound tag) {
        super.deserializeNBT(tag);
        this.trigger.deserializeNBT(tag.func_74775_l("Trigger"));
        this.customData = tag.func_74779_i("CustomData");
        this.cancel = tag.func_74767_n("Cancel");
        String type = tag.func_74779_i("Type");
        DataTriggerBlock block = null;
        if (type.equals("event")) {
            block = new EventTriggerBlock();
            block.string = tag.func_74779_i("DataId");
        } else if (type.equals("dialogue")) {
            block = new DialogueTriggerBlock();
            block.string = tag.func_74779_i("DataId");
        } else if (type.equals("script")) {
            block = new ScriptTriggerBlock();
            block.string = tag.func_74779_i("DataId");
            ((ScriptTriggerBlock)block).function = tag.func_74779_i("Function");
        }
        if (block != null) {
            this.trigger.blocks.add(block);
        }
    }
}

