/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet.api.huds;

import javax.vecmath.Vector3f;
import mchorse.mclib.utils.DummyEntity;
import mchorse.mclib.utils.NBTUtils;
import mchorse.metamorph.api.Morph;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class HUDMorph
implements INBTSerializable<NBTTagCompound> {
    public Morph morph = new Morph();
    public boolean ortho;
    public float orthoX;
    public float orthoY;
    public int expire;
    public Vector3f translate = new Vector3f();
    public Vector3f scale = new Vector3f(1.0f, 1.0f, 1.0f);
    public Vector3f rotate = new Vector3f();
    @SideOnly(value=Side.CLIENT)
    private DummyEntity entity;
    private int tick;

    @SideOnly(value=Side.CLIENT)
    public DummyEntity getEntity() {
        if (this.entity == null) {
            this.entity = new DummyEntity((World)Minecraft.func_71410_x().field_71441_e);
            this.entity.field_70126_B = 0.0f;
            this.entity.field_70177_z = 0.0f;
            this.entity.field_70127_C = 0.0f;
            this.entity.field_70125_A = 0.0f;
            this.entity.field_70758_at = 0.0f;
            this.entity.field_70759_as = 0.0f;
            this.entity.field_70760_ar = 0.0f;
            this.entity.field_70761_aq = 0.0f;
            this.entity.field_70122_E = true;
        }
        return this.entity;
    }

    @SideOnly(value=Side.CLIENT)
    public void render(ScaledResolution resolution, float partialTicks) {
        if (this.morph.isEmpty()) {
            return;
        }
        float tx = this.translate.x;
        float ty = this.translate.y;
        float tz = this.translate.z;
        float sx = this.scale.x;
        float sy = this.scale.y;
        float sz = this.scale.z;
        float rx = this.rotate.x;
        float ry = this.rotate.y;
        float rz = this.rotate.z;
        if (this.ortho) {
            tx = (float)resolution.func_78326_a() * this.orthoX + tx;
            ty = (float)resolution.func_78328_b() * this.orthoY + ty;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)tx, (float)ty, (float)tz);
        GlStateManager.func_179114_b((float)rz, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179114_b((float)ry, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)rx, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)sx, (float)sy, (float)sz);
        this.morph.get().render((EntityLivingBase)this.getEntity(), 0.0, 0.0, 0.0, 0.0f, partialTicks);
        GlStateManager.func_179121_F();
    }

    @SideOnly(value=Side.CLIENT)
    public boolean update(boolean allowExpiring) {
        DummyEntity entity = this.getEntity();
        if (!this.morph.isEmpty()) {
            this.morph.get().update((EntityLivingBase)entity);
        }
        ++entity.field_70173_aa;
        ++this.tick;
        if (!allowExpiring) {
            return false;
        }
        return this.expire > 0 && this.tick >= this.expire;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        NBTTagCompound morph = this.morph.toNBT();
        if (morph != null) {
            tag.func_74782_a("Morph", (NBTBase)morph);
        }
        tag.func_74757_a("Ortho", this.ortho);
        tag.func_74776_a("OrthoX", this.orthoX);
        tag.func_74776_a("OrthoY", this.orthoY);
        tag.func_74768_a("Expire", this.expire);
        if (this.translate.x != 0.0f || this.translate.y != 0.0f || this.translate.z != 0.0f) {
            tag.func_74782_a("Translate", (NBTBase)NBTUtils.writeFloatList((NBTTagList)new NBTTagList(), (Vector3f)this.translate));
        }
        if (this.scale.x != 1.0f || this.scale.y != 1.0f || this.scale.z != 1.0f) {
            tag.func_74782_a("Scale", (NBTBase)NBTUtils.writeFloatList((NBTTagList)new NBTTagList(), (Vector3f)this.scale));
        }
        if (this.rotate.x != 0.0f || this.rotate.y != 0.0f || this.rotate.z != 0.0f) {
            tag.func_74782_a("Rotate", (NBTBase)NBTUtils.writeFloatList((NBTTagList)new NBTTagList(), (Vector3f)this.rotate));
        }
        return tag;
    }

    public void deserializeNBT(NBTTagCompound tag) {
        if (tag.func_74764_b("Morph")) {
            this.morph.fromNBT(tag.func_74775_l("Morph"));
        }
        this.ortho = tag.func_74767_n("Ortho");
        this.orthoX = tag.func_74760_g("OrthoX");
        this.orthoY = tag.func_74760_g("OrthoY");
        this.expire = tag.func_74762_e("Expire");
        NBTUtils.readFloatList((NBTTagList)tag.func_150295_c("Translate", 5), (Vector3f)this.translate);
        NBTUtils.readFloatList((NBTTagList)tag.func_150295_c("Scale", 5), (Vector3f)this.scale);
        NBTUtils.readFloatList((NBTTagList)tag.func_150295_c("Rotate", 5), (Vector3f)this.rotate);
    }
}

