/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet.api.npcs;

import java.util.ArrayList;
import java.util.List;
import mchorse.mappet.api.npcs.NpcDrop;
import mchorse.mappet.api.states.States;
import mchorse.mappet.api.triggers.Trigger;
import mchorse.mappet.utils.NBTUtils;
import mchorse.metamorph.api.MorphManager;
import mchorse.metamorph.api.morphs.AbstractMorph;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.util.INBTSerializable;

public class NpcState
implements INBTSerializable<NBTTagCompound> {
    public String id = "";
    public States states = new States();
    public boolean unique;
    public float pathDistance = 32.0f;
    public float maxHealth = 20.0f;
    public float health = 20.0f;
    public int regenDelay = 80;
    public int regenFrequency = 20;
    public float damage = 2.0f;
    public int damageDelay = 10;
    public boolean canRanged;
    public boolean canFallDamage = true;
    public boolean canGetBurned = true;
    public boolean invincible;
    public boolean killable = true;
    public float speed = 1.0f;
    public boolean canSwim = true;
    public boolean immovable;
    public boolean hasPost;
    public BlockPos postPosition;
    public float postRadius = 1.0f;
    public float fallback = 15.0f;
    public boolean patrolCirculate;
    public List<BlockPos> patrol = new ArrayList<BlockPos>();
    public String follow = "";
    public String faction = "";
    public AbstractMorph morph;
    public float sightDistance = 25.0f;
    public float sightRadius = 120.0f;
    public List<NpcDrop> drops = new ArrayList<NpcDrop>();
    public int xp = 0;
    public boolean lookAtPlayer;
    public boolean lookAround;
    public boolean wander;
    public float flee = 4.0f;
    public Trigger triggerDied = new Trigger();
    public Trigger triggerDamaged = new Trigger();
    public Trigger triggerInteract = new Trigger();
    public Trigger triggerTick = new Trigger();
    public Trigger triggerTarget = new Trigger();
    public Trigger triggerInitialize = new Trigger();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean edit(String property, String value) {
        if (property.equals("id")) {
            this.id = value;
            return true;
        } else if (property.equals("unique")) {
            this.unique = Boolean.parseBoolean(value);
            return true;
        } else if (property.equals("path_distance")) {
            this.pathDistance = Float.parseFloat(value);
            return true;
        } else if (property.equals("max_health")) {
            this.maxHealth = Float.parseFloat(value);
            return true;
        } else if (property.equals("health")) {
            this.health = Float.parseFloat(value);
            return true;
        } else if (property.equals("regen_delay")) {
            this.regenDelay = Integer.parseInt(value);
            return true;
        } else if (property.equals("regen_frequency")) {
            this.regenFrequency = Integer.parseInt(value);
            return true;
        } else if (property.equals("damage")) {
            this.damage = Float.parseFloat(value);
            return true;
        } else if (property.equals("damage_delay")) {
            this.damageDelay = Integer.parseInt(value);
            return true;
        } else if (property.equals("can_ranged")) {
            this.canRanged = Boolean.parseBoolean(value);
            return true;
        } else if (property.equals("can_fall_damage")) {
            this.canFallDamage = Boolean.parseBoolean(value);
            return true;
        } else if (property.equals("can_get_burned")) {
            this.canGetBurned = Boolean.parseBoolean(value);
            return true;
        } else if (property.equals("invincible")) {
            this.invincible = Boolean.parseBoolean(value);
            return true;
        } else if (property.equals("killable")) {
            this.killable = Boolean.parseBoolean(value);
            return true;
        } else if (property.equals("speed")) {
            this.speed = Float.parseFloat(value);
            return true;
        } else if (property.equals("can_swim")) {
            this.canSwim = Boolean.parseBoolean(value);
            return true;
        } else if (property.equals("immovable")) {
            this.immovable = Boolean.parseBoolean(value);
            return true;
        } else if (property.equals("has_post")) {
            this.hasPost = Boolean.parseBoolean(value);
            return true;
        } else if (property.equals("post")) {
            String[] splits = value.split(" ");
            if (splits.length < 3) return false;
            int x = Integer.parseInt(splits[0]);
            int y = Integer.parseInt(splits[1]);
            int z = Integer.parseInt(splits[2]);
            this.postPosition = new BlockPos(x, y, z);
            return true;
        } else if (property.equals("fallback")) {
            this.fallback = Float.parseFloat(value);
            return true;
        } else if (property.equals("patrol_circulate")) {
            this.patrolCirculate = Boolean.parseBoolean(value);
            return true;
        } else if (property.equals("follow")) {
            this.follow = value;
            return true;
        } else if (property.equals("morph")) {
            try {
                this.morph = MorphManager.INSTANCE.morphFromNBT(JsonToNBT.func_180713_a((String)value));
                return true;
            }
            catch (Exception e) {
                return false;
            }
        } else if (property.equals("xp")) {
            this.xp = Integer.parseInt(value);
            return true;
        } else if (property.equals("look_at_player")) {
            this.lookAtPlayer = Boolean.parseBoolean(value);
            return true;
        } else if (property.equals("look_around")) {
            this.lookAround = Boolean.parseBoolean(value);
            return true;
        } else if (property.equals("wander")) {
            this.wander = Boolean.parseBoolean(value);
            return true;
        } else {
            if (!property.equals("flee")) return false;
            this.flee = Float.parseFloat(value);
        }
        return true;
    }

    public NBTTagCompound serializeNBT() {
        return this.partialSerializeNBT(null);
    }

    public NBTTagCompound partialSerializeNBT(List<String> options) {
        boolean all = options == null;
        NBTTagCompound tag = new NBTTagCompound();
        if (!all && options.isEmpty()) {
            return tag;
        }
        if (all || options.contains("id")) {
            tag.func_74778_a("Id", this.id);
        }
        if (all || options.contains("states")) {
            tag.func_74782_a("States", (NBTBase)this.states.serializeNBT());
        }
        if (all || options.contains("unique")) {
            tag.func_74757_a("Unique", this.unique);
        }
        if (all || options.contains("path_distance")) {
            tag.func_74776_a("PathDistance", this.pathDistance);
        }
        if (all || options.contains("max_health")) {
            tag.func_74776_a("MaxHealth", this.maxHealth);
        }
        if (all || options.contains("health")) {
            tag.func_74776_a("Health", this.health);
        }
        if (all || options.contains("regen_delay")) {
            tag.func_74768_a("RegenDelay", this.regenDelay);
        }
        if (all || options.contains("regen_frequency")) {
            tag.func_74768_a("RegenFrequency", this.regenFrequency);
        }
        if (all || options.contains("damage")) {
            tag.func_74776_a("Damage", this.damage);
        }
        if (all || options.contains("damage_delay")) {
            tag.func_74768_a("DamageDelay", this.damageDelay);
        }
        if (all || options.contains("can_ranged")) {
            tag.func_74757_a("CanRanged", this.canRanged);
        }
        if (all || options.contains("can_fall_damage")) {
            tag.func_74757_a("CanFallDamage", this.canFallDamage);
        }
        if (all || options.contains("can_get_burned")) {
            tag.func_74757_a("CanGetBurned", this.canGetBurned);
        }
        if (all || options.contains("invincible")) {
            tag.func_74757_a("Invincible", this.invincible);
        }
        if (all || options.contains("killable")) {
            tag.func_74757_a("Killable", this.killable);
        }
        if (all || options.contains("speed")) {
            tag.func_74776_a("Speed", this.speed);
        }
        if (all || options.contains("can_swim")) {
            tag.func_74757_a("CanSwim", this.canSwim);
        }
        if (all || options.contains("immovable")) {
            tag.func_74757_a("Immovable", this.immovable);
        }
        if (all || options.contains("has_post")) {
            tag.func_74757_a("HasPost", this.hasPost);
        }
        if (all || options.contains("post")) {
            tag.func_74782_a("Post", (NBTBase)(this.postPosition == null ? new NBTTagList() : NBTUtils.blockPosTo(this.postPosition)));
        }
        if (all || options.contains("post_radius")) {
            tag.func_74776_a("PostRadius", this.postRadius);
        }
        if (all || options.contains("fallback")) {
            tag.func_74776_a("Fallback", this.fallback);
        }
        if (all || options.contains("patrol_circulate")) {
            tag.func_74757_a("PatrolCirculate", this.patrolCirculate);
        }
        if (all || options.contains("patrol")) {
            NBTTagList points = new NBTTagList();
            for (BlockPos pos : this.patrol) {
                points.func_74742_a(NBTUtils.blockPosTo(pos));
            }
            tag.func_74782_a("Patrol", (NBTBase)points);
        }
        if (all || options.contains("follow")) {
            tag.func_74778_a("Follow", this.follow);
        }
        if (all || options.contains("faction")) {
            tag.func_74778_a("Faction", this.faction);
        }
        if (all || options.contains("morph")) {
            tag.func_74782_a("Morph", (NBTBase)(this.morph == null ? new NBTTagCompound() : this.morph.toNBT()));
        }
        if (all || options.contains("sight_distance")) {
            tag.func_74776_a("SightDistance", this.sightDistance);
        }
        if (all || options.contains("sight_radius")) {
            tag.func_74776_a("SightRadius", this.sightRadius);
        }
        if (all || options.contains("drops")) {
            NBTTagList drops = new NBTTagList();
            for (NpcDrop drop : this.drops) {
                drops.func_74742_a((NBTBase)drop.serializeNBT());
            }
            tag.func_74782_a("Drops", (NBTBase)drops);
        }
        if (all || options.contains("xp")) {
            tag.func_74768_a("Xp", this.xp);
        }
        if (all || options.contains("look_at_player")) {
            tag.func_74757_a("LookAtPlayer", this.lookAtPlayer);
        }
        if (all || options.contains("look_around")) {
            tag.func_74757_a("LookAround", this.lookAround);
        }
        if (all || options.contains("wander")) {
            tag.func_74757_a("Wander", this.wander);
        }
        if (all || options.contains("flee")) {
            tag.func_74776_a("Flee", this.flee);
        }
        if (all || options.contains("trigger_died")) {
            tag.func_74782_a("TriggerDied", (NBTBase)this.triggerDied.serializeNBT());
        }
        if (all || options.contains("trigger_damaged")) {
            tag.func_74782_a("TriggerDamaged", (NBTBase)this.triggerDamaged.serializeNBT());
        }
        if (all || options.contains("trigger_interact")) {
            tag.func_74782_a("TriggerInteract", (NBTBase)this.triggerInteract.serializeNBT());
        }
        if (all || options.contains("trigger_tick")) {
            tag.func_74782_a("TriggerTick", (NBTBase)this.triggerTick.serializeNBT());
        }
        if (all || options.contains("trigger_target")) {
            tag.func_74782_a("TriggerTarget", (NBTBase)this.triggerTarget.serializeNBT());
        }
        if (all || options.contains("trigger_initialize")) {
            tag.func_74782_a("TriggerInitialize", (NBTBase)this.triggerInitialize.serializeNBT());
        }
        return tag;
    }

    public void deserializeNBT(NBTTagCompound tag) {
        int i;
        if (tag.func_74764_b("Id")) {
            this.id = tag.func_74779_i("Id");
        }
        if (tag.func_74764_b("States")) {
            this.states.deserializeNBT(tag.func_74775_l("States"));
        }
        if (tag.func_74764_b("Unique")) {
            this.unique = tag.func_74767_n("Unique");
        }
        if (tag.func_74764_b("PathDistance")) {
            this.pathDistance = tag.func_74760_g("PathDistance");
        }
        if (tag.func_74764_b("MaxHealth")) {
            this.maxHealth = tag.func_74760_g("MaxHealth");
        }
        if (tag.func_74764_b("Health")) {
            this.health = tag.func_74760_g("Health");
        }
        if (tag.func_74764_b("RegenDelay")) {
            this.regenDelay = tag.func_74762_e("RegenDelay");
        }
        if (tag.func_74764_b("RegenFrequency")) {
            this.regenFrequency = tag.func_74762_e("RegenFrequency");
        }
        if (tag.func_74764_b("Damage")) {
            this.damage = tag.func_74760_g("Damage");
        }
        if (tag.func_74764_b("DamageDelay")) {
            this.damageDelay = tag.func_74762_e("DamageDelay");
        }
        if (tag.func_74764_b("CanRanged")) {
            this.canRanged = tag.func_74767_n("CanRanged");
        }
        if (tag.func_74764_b("CanFallDamage")) {
            this.canFallDamage = tag.func_74767_n("CanFallDamage");
        }
        if (tag.func_74764_b("CanGetBurned")) {
            this.canGetBurned = tag.func_74767_n("CanGetBurned");
        }
        if (tag.func_74764_b("Invincible")) {
            this.invincible = tag.func_74767_n("Invincible");
        }
        if (tag.func_74764_b("Killable")) {
            this.killable = tag.func_74767_n("Killable");
        }
        if (tag.func_74764_b("Speed")) {
            this.speed = tag.func_74760_g("Speed");
        }
        if (tag.func_74764_b("CanSwim")) {
            this.canSwim = tag.func_74767_n("CanSwim");
        }
        if (tag.func_74764_b("Immovable")) {
            this.immovable = tag.func_74767_n("Immovable");
        }
        if (tag.func_74764_b("HasPost")) {
            this.hasPost = tag.func_74767_n("HasPost");
        }
        if (tag.func_150297_b("Post", 9)) {
            this.postPosition = NBTUtils.blockPosFrom(tag.func_74781_a("Post"));
        }
        if (tag.func_74764_b("PostRadius")) {
            this.postRadius = tag.func_74760_g("PostRadius");
        }
        if (tag.func_74764_b("Fallback")) {
            this.fallback = tag.func_74760_g("Fallback");
        }
        if (tag.func_74764_b("PatrolCirculate")) {
            this.patrolCirculate = tag.func_74767_n("PatrolCirculate");
        }
        if (tag.func_150297_b("Patrol", 9)) {
            NBTTagList points = tag.func_150295_c("Patrol", 9);
            this.patrol.clear();
            for (i = 0; i < points.func_74745_c(); ++i) {
                BlockPos pos = NBTUtils.blockPosFrom(points.func_179238_g(i));
                if (pos == null) continue;
                this.patrol.add(pos);
            }
        }
        if (tag.func_150297_b("Follow", 8)) {
            this.follow = tag.func_74779_i("Follow");
        }
        if (tag.func_74764_b("Faction")) {
            this.faction = tag.func_74779_i("Faction");
        }
        if (tag.func_150297_b("Morph", 10)) {
            this.morph = MorphManager.INSTANCE.morphFromNBT(tag.func_74775_l("Morph"));
        }
        if (tag.func_74764_b("SightDistance")) {
            this.sightDistance = tag.func_74760_g("SightDistance");
        }
        if (tag.func_74764_b("SightRadius")) {
            this.sightRadius = tag.func_74760_g("SightRadius");
        }
        if (tag.func_74764_b("Drops")) {
            NBTTagList drops = tag.func_150295_c("Drops", 10);
            this.drops.clear();
            for (i = 0; i < drops.func_74745_c(); ++i) {
                NBTTagCompound tagDrop = drops.func_150305_b(i);
                NpcDrop drop = new NpcDrop();
                drop.deserializeNBT(tagDrop);
                if (drop.chance <= 0.0f || drop.stack.func_190926_b()) continue;
                this.drops.add(drop);
            }
        }
        if (tag.func_74764_b("Xp")) {
            this.xp = tag.func_74762_e("Xp");
        }
        if (tag.func_74764_b("LookAtPlayer")) {
            this.lookAtPlayer = tag.func_74767_n("LookAtPlayer");
        }
        if (tag.func_74764_b("LookAround")) {
            this.lookAround = tag.func_74767_n("LookAround");
        }
        if (tag.func_74764_b("Wander")) {
            this.wander = tag.func_74767_n("Wander");
        }
        if (tag.func_74764_b("Flee")) {
            this.flee = tag.func_74760_g("Flee");
        }
        if (tag.func_74764_b("TriggerDied")) {
            this.triggerDied.deserializeNBT(tag.func_74775_l("TriggerDied"));
        }
        if (tag.func_74764_b("TriggerDamaged")) {
            this.triggerDamaged.deserializeNBT(tag.func_74775_l("TriggerDamaged"));
        }
        if (tag.func_74764_b("TriggerInteract")) {
            this.triggerInteract.deserializeNBT(tag.func_74775_l("TriggerInteract"));
        }
        if (tag.func_74764_b("TriggerTick")) {
            this.triggerTick.deserializeNBT(tag.func_74775_l("TriggerTick"));
        }
        if (tag.func_74764_b("TriggerTarget")) {
            this.triggerTarget.deserializeNBT(tag.func_74775_l("TriggerTarget"));
        }
        if (tag.func_74764_b("TriggerInitialize")) {
            this.triggerInitialize.deserializeNBT(tag.func_74775_l("TriggerInitialize"));
        }
    }
}

