/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet.api.quests.objectives;

import mchorse.mappet.api.quests.INBTPartialSerializable;
import mchorse.mappet.api.quests.objectives.CollectObjective;
import mchorse.mappet.api.quests.objectives.KillObjective;
import mchorse.mappet.api.quests.objectives.StateObjective;
import mchorse.mclib.utils.TextUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class AbstractObjective
implements INBTSerializable<NBTTagCompound>,
INBTPartialSerializable {
    public String message = "";

    public static AbstractObjective fromType(String type) {
        if (type.equals("collect")) {
            return new CollectObjective();
        }
        if (type.equals("kill")) {
            return new KillObjective();
        }
        if (type.equals("state")) {
            return new StateObjective();
        }
        return null;
    }

    public void initiate(EntityPlayer player) {
    }

    public abstract boolean isComplete(EntityPlayer var1);

    public abstract void complete(EntityPlayer var1);

    @SideOnly(value=Side.CLIENT)
    public String stringify(EntityPlayer player) {
        return TextUtils.processColoredText((String)this.stringifyObjective(player));
    }

    @SideOnly(value=Side.CLIENT)
    protected abstract String stringifyObjective(EntityPlayer var1);

    public abstract String getType();

    public NBTTagCompound serializeNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("Message", this.message);
        return tag;
    }

    public void deserializeNBT(NBTTagCompound tag) {
        if (tag.func_74764_b("Message")) {
            this.message = tag.func_74779_i("Message");
        }
    }
}

