/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet.api.regions;

import java.util.ArrayList;
import java.util.List;
import mchorse.mappet.Mappet;
import mchorse.mappet.api.conditions.Checker;
import mchorse.mappet.api.regions.shapes.AbstractShape;
import mchorse.mappet.api.regions.shapes.BoxShape;
import mchorse.mappet.api.states.States;
import mchorse.mappet.api.triggers.Trigger;
import mchorse.mappet.api.utils.DataContext;
import mchorse.mappet.api.utils.TargetMode;
import mchorse.mappet.utils.EntityUtils;
import mchorse.mappet.utils.EnumUtils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.util.INBTSerializable;

public class Region
implements INBTSerializable<NBTTagCompound> {
    public boolean passable = true;
    public Checker enabled = new Checker(true);
    public int delay;
    public int update = 3;
    public Trigger onEnter = new Trigger();
    public Trigger onExit = new Trigger();
    public List<AbstractShape> shapes = new ArrayList<AbstractShape>();
    public boolean writeState;
    public String state = "";
    public TargetMode target = TargetMode.GLOBAL;
    public boolean additive = true;
    public boolean once;

    public Region() {
        this.shapes.add(new BoxShape());
    }

    public boolean isEnabled(EntityPlayer player) {
        States states;
        if (this.once && (states = this.getStates(player)) != null && states.values.containsKey(this.state)) {
            return false;
        }
        return this.enabled.check(new DataContext((Entity)player));
    }

    public boolean isPlayerInside(EntityPlayer player, BlockPos pos) {
        for (AbstractShape shape : this.shapes) {
            if (!shape.isPlayerInside(player, pos)) continue;
            return true;
        }
        return false;
    }

    public boolean isPlayerInside(double x, double y, double z, BlockPos pos) {
        for (AbstractShape shape : this.shapes) {
            if (!shape.isPlayerInside(x, y, z, pos)) continue;
            return true;
        }
        return false;
    }

    public void triggerEnter(EntityPlayer player, BlockPos pos) {
        if (this.writeState && !this.state.isEmpty()) {
            States states = this.getStates(player);
            if (this.additive) {
                states.add(this.state, 1.0);
            } else {
                states.setNumber(this.state, 1.0);
            }
        }
        this.onEnter.trigger(new DataContext((Entity)player).set("x", pos.func_177958_n()).set("y", pos.func_177956_o()).set("z", pos.func_177952_p()));
    }

    public void triggerExit(EntityPlayer player, BlockPos pos) {
        if (this.writeState && !this.state.isEmpty()) {
            States states = this.getStates(player);
            if (!this.additive) {
                states.reset(this.state);
            }
        }
        this.onExit.trigger(new DataContext((Entity)player).set("x", pos.func_177958_n()).set("y", pos.func_177956_o()).set("z", pos.func_177952_p()));
    }

    private States getStates(EntityPlayer player) {
        return this.target == TargetMode.GLOBAL ? Mappet.states : EntityUtils.getStates((Entity)player);
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74757_a("Passable", this.passable);
        tag.func_74782_a("Enabled", this.enabled.serializeNBT());
        tag.func_74768_a("Delay", this.delay);
        tag.func_74768_a("Update", this.update);
        tag.func_74782_a("OnEnter", (NBTBase)this.onEnter.serializeNBT());
        tag.func_74782_a("OnExit", (NBTBase)this.onExit.serializeNBT());
        NBTTagList shapes = new NBTTagList();
        for (AbstractShape shape : this.shapes) {
            NBTTagCompound shapeTag = shape.serializeNBT();
            shapeTag.func_74778_a("Type", shape.getType());
            shapes.func_74742_a((NBTBase)shapeTag);
        }
        tag.func_74782_a("Shapes", (NBTBase)shapes);
        tag.func_74757_a("WriteState", this.writeState);
        tag.func_74778_a("State", this.state.trim());
        tag.func_74768_a("Target", this.target.ordinal());
        tag.func_74757_a("Additive", this.additive);
        tag.func_74757_a("Once", this.once);
        return tag;
    }

    public void deserializeNBT(NBTTagCompound tag) {
        if (tag.func_74764_b("Passable")) {
            this.passable = tag.func_74767_n("Passable");
        }
        if (tag.func_150297_b("Enabled", 10)) {
            this.enabled.deserializeNBT(tag.func_74781_a("Enabled"));
        }
        if (tag.func_150297_b("Delay", 99)) {
            this.delay = tag.func_74762_e("Delay");
        }
        if (tag.func_150297_b("Update", 99)) {
            this.update = tag.func_74762_e("Update");
        }
        if (tag.func_150297_b("OnEnter", 10)) {
            this.onEnter.deserializeNBT(tag.func_74775_l("OnEnter"));
        }
        if (tag.func_150297_b("OnExit", 10)) {
            this.onExit.deserializeNBT(tag.func_74775_l("OnExit"));
        }
        this.shapes.clear();
        if (tag.func_150297_b("Shape", 10)) {
            AbstractShape shape = this.readShape(tag.func_74775_l("Shape"));
            if (shape != null) {
                this.shapes.add(shape);
            }
        } else if (tag.func_150297_b("Shapes", 9)) {
            NBTTagList list = tag.func_150295_c("Shapes", 10);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                AbstractShape shape = this.readShape(list.func_150305_b(i));
                if (shape == null) continue;
                this.shapes.add(shape);
            }
        }
        if (this.shapes.isEmpty()) {
            this.shapes.add(new BoxShape());
        }
        this.writeState = tag.func_74767_n("WriteState");
        this.state = tag.func_74779_i("State");
        this.target = EnumUtils.getValue(tag.func_74762_e("Target"), TargetMode.values(), TargetMode.GLOBAL);
        this.additive = tag.func_74767_n("Additive");
        this.once = tag.func_74767_n("Once");
    }

    private AbstractShape readShape(NBTTagCompound shapeTag) {
        AbstractShape shape;
        if (shapeTag.func_74764_b("Type") && (shape = AbstractShape.fromString(shapeTag.func_74779_i("Type"))) != null) {
            shape.deserializeNBT(shapeTag);
            return shape;
        }
        return null;
    }
}

