/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet.api.scripts;

import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import mchorse.mappet.Mappet;
import mchorse.mappet.api.scripts.ScriptManager;
import mchorse.mappet.api.scripts.ScriptRange;
import mchorse.mappet.api.scripts.code.ScriptEvent;
import mchorse.mappet.api.scripts.code.ScriptFactory;
import mchorse.mappet.api.utils.AbstractData;
import mchorse.mappet.api.utils.DataContext;
import mchorse.mappet.events.RegisterScriptVariablesEvent;
import mchorse.mappet.utils.ScriptUtils;
import mchorse.mappet.utils.Utils;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraftforge.fml.common.eventhandler.Event;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

public class Script
extends AbstractData {
    public String code = "";
    public boolean unique;
    public List<String> libraries = new ArrayList<String>();
    private ScriptEngine engine;
    private List<ScriptRange> ranges;

    public void start(ScriptManager manager) throws ScriptException {
        if (this.engine == null) {
            this.engine = ScriptUtils.sanitize(ScriptUtils.tryCreatingEngine());
            this.engine.getContext().setAttribute("javax.script.filename", this.getId() + ".js", 100);
            Mappet.EVENT_BUS.post((Event)new RegisterScriptVariablesEvent(this.engine));
            StringBuilder finalCode = new StringBuilder();
            HashSet<String> alreadyLoaded = new HashSet<String>();
            int total = 0;
            for (String library : this.libraries) {
                if (library.equals(this.getId()) || alreadyLoaded.contains(library)) continue;
                try {
                    File jsFile = manager.getJSFile(library);
                    String code = FileUtils.readFileToString((File)jsFile, (Charset)Utils.getCharset());
                    finalCode.append(code);
                    finalCode.append("\n");
                    if (this.ranges == null) {
                        this.ranges = new ArrayList<ScriptRange>();
                    }
                    this.ranges.add(new ScriptRange(total, library));
                    total += StringUtils.countMatches((CharSequence)code, (CharSequence)"\n") + 1;
                }
                catch (Exception e) {
                    System.err.println("[Mappet] Script library " + library + ".js failed to load...");
                    e.printStackTrace();
                }
                alreadyLoaded.add(library);
            }
            finalCode.append(this.code);
            if (this.ranges != null) {
                this.ranges.add(new ScriptRange(total, this.getId()));
            }
            this.engine.put("mappet", new ScriptFactory());
            this.engine.eval(finalCode.toString());
        }
    }

    public Object execute(String function, DataContext context) throws ScriptException, NoSuchMethodException {
        if (function.isEmpty()) {
            function = "main";
        }
        try {
            return ((Invocable)((Object)this.engine)).invokeFunction(function, new ScriptEvent(context, this.getId(), function));
        }
        catch (ScriptException e) {
            ScriptException exception = this.processScriptException(e);
            throw exception == null ? e : exception;
        }
    }

    private ScriptException processScriptException(ScriptException e) {
        if (this.ranges == null) {
            return null;
        }
        ScriptRange range = null;
        for (int i = this.ranges.size() - 1; i >= 0; --i) {
            ScriptRange possibleRange = this.ranges.get(i);
            if (possibleRange.lineOffset > e.getLineNumber() - 1) continue;
            range = possibleRange;
            break;
        }
        if (range != null) {
            String message = e.getMessage();
            int lineNumber = e.getLineNumber() - range.lineOffset;
            message = message.replaceFirst(this.getId() + ".js", range.script + ".js (in " + this.getId() + ".js)");
            message = message.replaceFirst("at line number [\\d]+", "at line number " + lineNumber);
            return new ScriptException(message, range.script, lineNumber, e.getColumnNumber());
        }
        return null;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        NBTTagList libraries = new NBTTagList();
        for (String library : this.libraries) {
            libraries.func_74742_a((NBTBase)new NBTTagString(library));
        }
        tag.func_74757_a("Unique", this.unique);
        tag.func_74782_a("Libraries", (NBTBase)libraries);
        tag.func_74773_a("Code", this.code.getBytes());
        return tag;
    }

    public void deserializeNBT(NBTTagCompound tag) {
        this.unique = tag.func_74767_n("Unique");
        if (tag.func_150297_b("Libraries", 9)) {
            NBTTagList libraries = tag.func_150295_c("Libraries", 8);
            this.libraries.clear();
            int c = libraries.func_74745_c();
            for (int i = 0; i < c; ++i) {
                this.libraries.add(libraries.func_150307_f(i));
            }
        }
        this.code = new String(tag.func_74770_j("Code"));
    }
}

