/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet.api.scripts.code;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import jdk.nashorn.api.scripting.ScriptObjectMirror;
import mchorse.mappet.Mappet;
import mchorse.mappet.api.scripts.code.blocks.ScriptBlockState;
import mchorse.mappet.api.scripts.code.items.ScriptItemStack;
import mchorse.mappet.api.scripts.code.mappet.MappetUIBuilder;
import mchorse.mappet.api.scripts.code.nbt.ScriptNBTCompound;
import mchorse.mappet.api.scripts.code.nbt.ScriptNBTList;
import mchorse.mappet.api.scripts.user.IScriptFactory;
import mchorse.mappet.api.scripts.user.blocks.IScriptBlockState;
import mchorse.mappet.api.scripts.user.items.IScriptItemStack;
import mchorse.mappet.api.scripts.user.mappet.IMappetUIBuilder;
import mchorse.mappet.api.scripts.user.nbt.INBTCompound;
import mchorse.mappet.api.scripts.user.nbt.INBTList;
import mchorse.mappet.api.ui.UI;
import mchorse.metamorph.api.MorphManager;
import mchorse.metamorph.api.morphs.AbstractMorph;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.potion.Potion;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class ScriptFactory
implements IScriptFactory {
    @Override
    public IScriptBlockState createBlockState(String blockId, int meta) {
        ResourceLocation location = new ResourceLocation(blockId);
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(location);
        if (block != null) {
            IBlockState state = block.func_176203_a(meta);
            return ScriptBlockState.create(state);
        }
        return ScriptBlockState.create(null);
    }

    @Override
    public INBTCompound createCompound(String nbt) {
        NBTTagCompound tag = new NBTTagCompound();
        if (nbt != null) {
            try {
                tag = JsonToNBT.func_180713_a((String)nbt);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new ScriptNBTCompound(tag);
    }

    @Override
    public INBTCompound createCompoundFromJS(Object jsObject) {
        NBTBase base = this.convertToNBT(jsObject);
        return base instanceof NBTTagCompound ? new ScriptNBTCompound((NBTTagCompound)base) : null;
    }

    @Override
    public INBTList createList(String nbt) {
        NBTTagList list = new NBTTagList();
        if (nbt != null) {
            try {
                list = (NBTTagList)JsonToNBT.func_180713_a((String)("{List:" + nbt + "}")).func_74781_a("List");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new ScriptNBTList(list);
    }

    @Override
    public INBTList createListFromJS(Object jsObject) {
        NBTBase base = this.convertToNBT(jsObject);
        return base instanceof NBTTagList ? new ScriptNBTList((NBTTagList)base) : null;
    }

    private NBTBase convertToNBT(Object object) {
        if (object instanceof String) {
            return new NBTTagString((String)object);
        }
        if (object instanceof Double) {
            return new NBTTagDouble(((Double)object).doubleValue());
        }
        if (object instanceof Integer) {
            return new NBTTagInt(((Integer)object).intValue());
        }
        if (object instanceof ScriptObjectMirror) {
            ScriptObjectMirror mirror = (ScriptObjectMirror)object;
            if (mirror.isArray()) {
                NBTTagList list = new NBTTagList();
                int c = mirror.size();
                for (int i = 0; i < c; ++i) {
                    NBTBase base = this.convertToNBT(mirror.getSlot(i));
                    if (base == null) continue;
                    list.func_74742_a(base);
                }
                return list;
            }
            NBTTagCompound tag = new NBTTagCompound();
            for (String key : mirror.keySet()) {
                NBTBase base = this.convertToNBT(mirror.get((Object)key));
                if (base == null) continue;
                tag.func_74782_a(key, base);
            }
            return tag;
        }
        return null;
    }

    @Override
    public IScriptItemStack createItem(INBTCompound compound) {
        if (compound != null) {
            return ScriptItemStack.create(new ItemStack(compound.getNBTTagComound()));
        }
        return ScriptItemStack.EMPTY;
    }

    @Override
    public IScriptItemStack createItem(String itemId, int count, int meta) {
        Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemId));
        return ScriptItemStack.create(new ItemStack(item, count, meta));
    }

    @Override
    public IScriptItemStack createBlockItem(String blockId, int count, int meta) {
        Block item = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(blockId));
        return ScriptItemStack.create(new ItemStack(item, count, meta));
    }

    @Override
    public EnumParticleTypes getParticleType(String type) {
        return EnumParticleTypes.func_186831_a((String)type);
    }

    @Override
    public Potion getPotion(String type) {
        return Potion.func_180142_b((String)type);
    }

    @Override
    public AbstractMorph createMorph(INBTCompound compound) {
        if (compound == null) {
            return null;
        }
        return MorphManager.INSTANCE.morphFromNBT(compound.getNBTTagComound());
    }

    @Override
    public IMappetUIBuilder createUI(String script, String function) {
        script = script == null ? "" : script;
        function = function == null ? "" : function;
        return new MappetUIBuilder(new UI(), script, function);
    }

    @Override
    public Object get(String key) {
        return Mappet.scripts.objects.get(key);
    }

    @Override
    public void set(String key, Object object) {
        Mappet.scripts.objects.put(key, object);
    }

    @Override
    public String dump(Object object, boolean simple) {
        if (object instanceof ScriptObjectMirror) {
            return object.toString();
        }
        Class<?> clazz = object.getClass();
        StringBuilder output = new StringBuilder(simple ? clazz.getSimpleName() : clazz.getTypeName());
        output.append(" {\n");
        for (Field field : clazz.getDeclaredFields()) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            output.append("    ");
            if (!simple) {
                output.append(this.getModifier(field.getModifiers()));
            }
            output.append(field.getName());
            if (!simple) {
                output.append(" (");
                output.append(simple ? field.getType().getSimpleName() : field.getType().getTypeName());
                output.append(")");
            }
            String value = "";
            try {
                field.setAccessible(true);
                Object o = field.get(object);
                value = o == null ? "null" : o.toString();
            }
            catch (Exception o) {
                // empty catch block
            }
            output.append(": ").append(value).append("\n");
        }
        output.append("\n");
        for (AccessibleObject accessibleObject : clazz.getDeclaredMethods()) {
            if (Modifier.isStatic(((Method)accessibleObject).getModifiers())) continue;
            output.append("    ");
            if (!simple) {
                output.append(this.getModifier(((Method)accessibleObject).getModifiers()));
            }
            output.append(simple ? ((Method)accessibleObject).getReturnType().getSimpleName() : ((Method)accessibleObject).getReturnType().getTypeName());
            output.append(" ");
            output.append(((Method)accessibleObject).getName()).append("(");
            int size = ((Method)accessibleObject).getParameterCount();
            for (int i = 0; i < size; ++i) {
                Class<?> arg = ((Method)accessibleObject).getParameterTypes()[i];
                output.append(simple ? arg.getSimpleName() : arg.getTypeName());
                if (i >= size - 1) continue;
                output.append(", ");
            }
            output.append(")").append("\n");
        }
        output.append("}");
        return output.toString();
    }

    private String getModifier(int m) {
        String modifier;
        String string = modifier = Modifier.isFinal(m) ? "final " : "";
        if (Modifier.isPublic(m)) {
            modifier = modifier + "public ";
        } else if (Modifier.isProtected(m)) {
            modifier = modifier + "protected ";
        } else if (Modifier.isPrivate(m)) {
            modifier = modifier + "private ";
        }
        return modifier;
    }
}

