/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet.api.scripts.code;

import java.util.ArrayList;
import java.util.List;
import mchorse.mappet.Mappet;
import mchorse.mappet.api.npcs.Npc;
import mchorse.mappet.api.npcs.NpcState;
import mchorse.mappet.api.scripts.code.blocks.ScriptBlockState;
import mchorse.mappet.api.scripts.code.blocks.ScriptTileEntity;
import mchorse.mappet.api.scripts.code.entities.ScriptEntity;
import mchorse.mappet.api.scripts.code.entities.ScriptNpc;
import mchorse.mappet.api.scripts.code.items.ScriptInventory;
import mchorse.mappet.api.scripts.user.IScriptWorld;
import mchorse.mappet.api.scripts.user.blocks.IScriptBlockState;
import mchorse.mappet.api.scripts.user.blocks.IScriptTileEntity;
import mchorse.mappet.api.scripts.user.entities.IScriptEntity;
import mchorse.mappet.api.scripts.user.entities.IScriptNpc;
import mchorse.mappet.api.scripts.user.entities.IScriptPlayer;
import mchorse.mappet.api.scripts.user.items.IScriptInventory;
import mchorse.mappet.api.scripts.user.items.IScriptItemStack;
import mchorse.mappet.api.scripts.user.nbt.INBTCompound;
import mchorse.mappet.client.morphs.WorldMorph;
import mchorse.mappet.entities.EntityNpc;
import mchorse.mappet.network.Dispatcher;
import mchorse.mappet.network.common.scripts.PacketWorldMorph;
import mchorse.mappet.utils.WorldUtils;
import mchorse.mclib.utils.MathUtils;
import mchorse.metamorph.api.morphs.AbstractMorph;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.storage.AnvilChunkLoader;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class ScriptWorld
implements IScriptWorld {
    public static final int MAX_VOLUME = 100;
    private World world;
    private BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();

    public ScriptWorld(World world) {
        this.world = world;
    }

    @Override
    public World getMinecraftWorld() {
        return this.world;
    }

    @Override
    public void setBlock(IScriptBlockState state, int x, int y, int z) {
        if (!this.world.func_175667_e((BlockPos)this.pos.func_181079_c(x, y, z))) {
            return;
        }
        this.world.func_175656_a((BlockPos)this.pos, state.getMinecraftBlockState());
    }

    @Override
    public IScriptBlockState getBlock(int x, int y, int z) {
        if (!this.world.func_175667_e((BlockPos)this.pos.func_181079_c(x, y, z))) {
            return ScriptBlockState.AIR;
        }
        return ScriptBlockState.create(this.world.func_180495_p((BlockPos)this.pos));
    }

    @Override
    public boolean hasTileEntity(int x, int y, int z) {
        if (!this.world.func_175667_e((BlockPos)this.pos.func_181079_c(x, y, z))) {
            return false;
        }
        return this.world.func_175625_s((BlockPos)this.pos) != null;
    }

    @Override
    public IScriptTileEntity getTileEntity(int x, int y, int z) {
        if (!this.hasTileEntity(x, y, z)) {
            return null;
        }
        return new ScriptTileEntity(this.world.func_175625_s((BlockPos)this.pos.func_181079_c(x, y, z)));
    }

    @Override
    public boolean hasInventory(int x, int y, int z) {
        this.pos.func_181079_c(x, y, z);
        return this.world.func_175667_e((BlockPos)this.pos) && this.world.func_175625_s((BlockPos)this.pos) instanceof IInventory;
    }

    @Override
    public IScriptInventory getInventory(int x, int y, int z) {
        TileEntity tile;
        if (this.world.func_175667_e((BlockPos)this.pos.func_181079_c(x, y, z)) && (tile = this.world.func_175625_s((BlockPos)this.pos)) instanceof IInventory) {
            return new ScriptInventory((IInventory)tile);
        }
        return null;
    }

    @Override
    public boolean isRaining() {
        return this.world.func_72912_H().func_76059_o();
    }

    @Override
    public void setRaining(boolean raining) {
        this.world.func_72912_H().func_76084_b(raining);
    }

    @Override
    public long getTime() {
        return this.world.func_72820_D();
    }

    @Override
    public void setTime(long time) {
        this.world.func_72877_b(time);
    }

    @Override
    public long getTotalTime() {
        return this.world.func_82737_E();
    }

    @Override
    public int getDimensionId() {
        Integer[] ids;
        Integer[] integerArray = ids = DimensionManager.getIDs();
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int id = integerArray[i];
            WorldServer world = this.world.func_73046_m().func_71218_a(id);
            if (world != this.world) continue;
            return id;
        }
        return 0;
    }

    @Override
    public void spawnParticles(EnumParticleTypes type, boolean longDistance, double x, double y, double z, int n, double dx, double dy, double dz, double speed, int ... args) {
        ((WorldServer)this.world).func_180505_a(type, longDistance, x, y, z, n, dx, dy, dz, speed, args);
    }

    @Override
    public void spawnParticles(IScriptPlayer entity, EnumParticleTypes type, boolean longDistance, double x, double y, double z, int n, double dx, double dy, double dz, double speed, int ... args) {
        if (entity == null) {
            return;
        }
        ((WorldServer)this.world).func_184161_a(entity.getMinecraftPlayer(), type, longDistance, x, y, z, n, dx, dy, dz, speed, args);
    }

    @Override
    public IScriptEntity spawnEntity(String id, double x, double y, double z, INBTCompound compound) {
        if (!this.world.func_175667_e((BlockPos)this.pos.func_189532_c(x, y, z))) {
            return null;
        }
        NBTTagCompound tag = new NBTTagCompound();
        if (compound != null) {
            tag.func_179237_a(compound.getNBTTagComound());
        }
        tag.func_74778_a("id", id);
        Entity entity = AnvilChunkLoader.func_186054_a((NBTTagCompound)tag, (World)this.world, (double)x, (double)y, (double)z, (boolean)true);
        return entity == null ? null : ScriptEntity.create(entity);
    }

    @Override
    public IScriptNpc spawnNpc(String id, String state, double x, double y, double z) {
        Npc npc = (Npc)Mappet.npcs.load(id);
        if (npc == null) {
            return null;
        }
        NpcState npcState = npc.states.get(state);
        if (npcState == null) {
            return null;
        }
        EntityNpc entity = new EntityNpc(this.world);
        entity.func_70107_b(x, y, z);
        entity.setNpc(npc, npcState);
        entity.field_70170_p.func_72838_d((Entity)entity);
        entity.initialize();
        return new ScriptNpc(entity);
    }

    @Override
    public List<IScriptEntity> getEntities(double x1, double y1, double z1, double x2, double y2, double z2) {
        ArrayList<IScriptEntity> entities = new ArrayList<IScriptEntity>();
        double minX = Math.min(x1, x2);
        double minY = Math.min(y1, y2);
        double minZ = Math.min(z1, z2);
        double maxX = Math.max(x1, x2);
        double maxY = Math.max(y1, y2);
        double maxZ = Math.max(z1, z2);
        if (maxX - minX > 100.0 || maxY - minY > 100.0 || maxZ - minZ > 100.0) {
            return entities;
        }
        if (!this.world.func_175667_e((BlockPos)this.pos.func_189532_c(minX, minY, minZ)) || !this.world.func_175667_e((BlockPos)this.pos.func_189532_c(maxX, maxY, maxZ))) {
            return entities;
        }
        for (Entity entity : this.world.func_72872_a(Entity.class, new AxisAlignedBB(minX, minY, minZ, maxX, maxY, maxZ))) {
            entities.add(ScriptEntity.create(entity));
        }
        return entities;
    }

    @Override
    public List<IScriptEntity> getEntities(double x, double y, double z, double radius) {
        radius = Math.abs(radius);
        ArrayList<IScriptEntity> entities = new ArrayList<IScriptEntity>();
        if (radius > 50.0) {
            return entities;
        }
        double minX = x - radius;
        double minY = y - radius;
        double minZ = z - radius;
        double maxX = x + radius;
        double maxY = y + radius;
        double maxZ = z + radius;
        if (!this.world.func_175667_e((BlockPos)this.pos.func_189532_c(minX, minY, minZ)) || !this.world.func_175667_e((BlockPos)this.pos.func_189532_c(maxX, maxY, maxZ))) {
            return entities;
        }
        for (Entity entity : this.world.func_72872_a(Entity.class, new AxisAlignedBB(minX, minY, minZ, maxX, maxY, maxZ))) {
            AxisAlignedBB box = entity.func_174813_aQ();
            double eX = (box.field_72340_a + box.field_72336_d) / 2.0;
            double dX = x - eX;
            double eY = (box.field_72338_b + box.field_72337_e) / 2.0;
            double dY = y - eY;
            double eZ = (box.field_72339_c + box.field_72334_f) / 2.0;
            double dZ = z - eZ;
            if (!(dX * dX + dY * dY + dZ * dZ < radius * radius)) continue;
            entities.add(ScriptEntity.create(entity));
        }
        return entities;
    }

    @Override
    public void playSound(String event, double x, double y, double z, float volume, float pitch) {
        for (EntityPlayerMP player : this.world.func_73046_m().func_184103_al().func_181057_v()) {
            WorldUtils.playSound(player, event, x, y, z, volume, pitch);
        }
    }

    @Override
    public IScriptEntity dropItemStack(IScriptItemStack stack, double x, double y, double z, double mx, double my, double mz) {
        if (stack == null || stack.isEmpty()) {
            return null;
        }
        EntityItem item = new EntityItem(this.world, x, y, z, stack.getMinecraftItemStack().func_77946_l());
        item.field_70159_w = mx;
        item.field_70181_x = my;
        item.field_70179_y = mz;
        this.world.func_72838_d((Entity)item);
        return ScriptEntity.create((Entity)item);
    }

    @Override
    public void displayMorph(AbstractMorph morph, int expiration, double x, double y, double z, float yaw, float pitch, int range) {
        if (morph == null) {
            return;
        }
        WorldMorph worldMorph = new WorldMorph();
        worldMorph.morph = morph;
        worldMorph.expiration = expiration;
        worldMorph.x = x;
        worldMorph.y = y;
        worldMorph.z = z;
        worldMorph.yaw = yaw;
        worldMorph.pitch = pitch;
        int dimension = this.world.field_73011_w.getDimension();
        NetworkRegistry.TargetPoint point = new NetworkRegistry.TargetPoint(dimension, x, y, z, (double)MathUtils.clamp((int)range, (int)1, (int)256));
        Dispatcher.DISPATCHER.get().sendToAllAround((IMessage)new PacketWorldMorph(worldMorph), point);
    }
}

