/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet.api.scripts.code.entities;

import mchorse.mappet.Mappet;
import mchorse.mappet.api.huds.HUDScene;
import mchorse.mappet.api.scripts.code.entities.ScriptEntity;
import mchorse.mappet.api.scripts.code.items.ScriptInventory;
import mchorse.mappet.api.scripts.code.mappet.MappetQuests;
import mchorse.mappet.api.scripts.code.mappet.MappetUIBuilder;
import mchorse.mappet.api.scripts.code.mappet.MappetUIContext;
import mchorse.mappet.api.scripts.user.entities.IScriptPlayer;
import mchorse.mappet.api.scripts.user.items.IScriptInventory;
import mchorse.mappet.api.scripts.user.mappet.IMappetQuests;
import mchorse.mappet.api.scripts.user.mappet.IMappetUIBuilder;
import mchorse.mappet.api.scripts.user.mappet.IMappetUIContext;
import mchorse.mappet.api.scripts.user.nbt.INBT;
import mchorse.mappet.api.scripts.user.nbt.INBTCompound;
import mchorse.mappet.api.ui.UI;
import mchorse.mappet.api.ui.UIContext;
import mchorse.mappet.capabilities.character.Character;
import mchorse.mappet.capabilities.character.ICharacter;
import mchorse.mappet.network.Dispatcher;
import mchorse.mappet.network.common.huds.PacketHUDMorph;
import mchorse.mappet.network.common.huds.PacketHUDScene;
import mchorse.mappet.network.common.scripts.PacketEntityRotations;
import mchorse.mappet.network.common.scripts.PacketSound;
import mchorse.mappet.network.common.ui.PacketCloseUI;
import mchorse.mappet.network.common.ui.PacketUI;
import mchorse.mappet.utils.WorldUtils;
import mchorse.metamorph.api.MorphAPI;
import mchorse.metamorph.api.MorphUtils;
import mchorse.metamorph.api.morphs.AbstractMorph;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketAnimation;
import net.minecraft.network.play.server.SPacketEntityVelocity;
import net.minecraft.network.play.server.SPacketTitle;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.GameType;

public class ScriptPlayer
extends ScriptEntity<EntityPlayerMP>
implements IScriptPlayer {
    private IMappetQuests quests;
    private IScriptInventory inventory;
    private IScriptInventory enderChest;

    public ScriptPlayer(EntityPlayerMP entity) {
        super(entity);
    }

    @Override
    public EntityPlayerMP getMinecraftPlayer() {
        return (EntityPlayerMP)this.entity;
    }

    @Override
    public void setMotion(double x, double y, double z) {
        super.setMotion(x, y, z);
        ((EntityPlayerMP)this.entity).field_71135_a.func_147359_a((Packet)new SPacketEntityVelocity(((EntityPlayerMP)this.entity).func_145782_y(), x, y, z));
    }

    @Override
    public void setRotations(float pitch, float yaw, float yawHead) {
        super.setRotations(pitch, yaw, yawHead);
        Dispatcher.sendTo(new PacketEntityRotations(((EntityPlayerMP)this.entity).func_145782_y(), yaw, yawHead, pitch), (EntityPlayerMP)this.entity);
    }

    @Override
    public void swingArm(int arm) {
        super.swingArm(arm);
        ((EntityPlayerMP)this.entity).field_71135_a.func_147359_a((Packet)new SPacketAnimation(this.entity, arm == 1 ? 3 : 0));
    }

    @Override
    public int getGameMode() {
        return ((EntityPlayerMP)this.entity).field_71134_c.func_73081_b().func_77148_a();
    }

    @Override
    public void setGameMode(int gameMode) {
        GameType type = GameType.func_77146_a((int)gameMode);
        if (type.func_77148_a() >= 0) {
            ((EntityPlayerMP)this.entity).func_71033_a(type);
        }
    }

    @Override
    public IScriptInventory getInventory() {
        if (this.inventory == null) {
            this.inventory = new ScriptInventory((IInventory)((EntityPlayerMP)this.entity).field_71071_by);
        }
        return this.inventory;
    }

    @Override
    public IScriptInventory getEnderChest() {
        if (this.enderChest == null) {
            this.enderChest = new ScriptInventory((IInventory)((EntityPlayerMP)this.entity).func_71005_bN());
        }
        return this.enderChest;
    }

    @Override
    public void send(String message) {
        ((EntityPlayerMP)this.entity).func_145747_a((ITextComponent)new TextComponentString(message));
    }

    @Override
    public void sendRaw(INBT message) {
        ITextComponent component = ITextComponent.Serializer.func_186877_b((String)message.stringify());
        if (component != null) {
            ((EntityPlayerMP)this.entity).func_145747_a(component);
        }
    }

    @Override
    public String getSkin() {
        ICharacter character = Character.get((EntityPlayer)this.entity);
        String skin = character.getSkin();
        return skin == null ? "" : skin;
    }

    @Override
    public void sendTitleDurations(int fadeIn, int idle, int fadeOut) {
        SPacketTitle packet = new SPacketTitle(fadeIn, idle, fadeOut);
        this.getMinecraftPlayer().field_71135_a.func_147359_a((Packet)packet);
    }

    @Override
    public void sendTitle(String title) {
        SPacketTitle packet = new SPacketTitle(SPacketTitle.Type.TITLE, (ITextComponent)new TextComponentString(title));
        this.getMinecraftPlayer().field_71135_a.func_147359_a((Packet)packet);
    }

    @Override
    public void sendSubtitle(String title) {
        SPacketTitle packet = new SPacketTitle(SPacketTitle.Type.SUBTITLE, (ITextComponent)new TextComponentString(title));
        this.getMinecraftPlayer().field_71135_a.func_147359_a((Packet)packet);
    }

    @Override
    public void sendActionBar(String title) {
        SPacketTitle packet = new SPacketTitle(SPacketTitle.Type.ACTIONBAR, (ITextComponent)new TextComponentString(title));
        this.getMinecraftPlayer().field_71135_a.func_147359_a((Packet)packet);
    }

    @Override
    public void setXp(int level, int points) {
        ((EntityPlayerMP)this.entity).func_82242_a(-this.getXpLevel() - 1);
        ((EntityPlayerMP)this.entity).func_82242_a(level);
        ((EntityPlayerMP)this.entity).func_71023_q(points);
    }

    @Override
    public void addXp(int points) {
        ((EntityPlayerMP)this.entity).func_71023_q(points);
    }

    @Override
    public int getXpLevel() {
        return ((EntityPlayerMP)this.entity).field_71068_ca;
    }

    @Override
    public int getXpPoints() {
        return (int)(((EntityPlayerMP)this.entity).field_71106_cc * (float)((EntityPlayerMP)this.entity).func_71050_bK());
    }

    @Override
    public void playSound(String event, double x, double y, double z, float volume, float pitch) {
        WorldUtils.playSound((EntityPlayerMP)this.entity, event, x, y, z, volume, pitch);
    }

    @Override
    public void playStaticSound(String event, float volume, float pitch) {
        Dispatcher.sendTo(new PacketSound(event, volume, pitch), (EntityPlayerMP)this.entity);
    }

    @Override
    public IMappetQuests getQuests() {
        if (this.quests == null) {
            this.quests = new MappetQuests(Character.get((EntityPlayer)this.entity).getQuests(), (EntityPlayer)this.entity);
        }
        return this.quests;
    }

    @Override
    public boolean setMorph(AbstractMorph morph) {
        if (morph == null) {
            MorphAPI.demorph((EntityPlayer)((EntityPlayer)this.entity));
        } else {
            MorphAPI.morph((EntityPlayer)((EntityPlayer)this.entity), (AbstractMorph)morph, (boolean)true);
        }
        return true;
    }

    @Override
    public boolean openUI(IMappetUIBuilder in, boolean defaultData) {
        if (!(in instanceof MappetUIBuilder)) {
            return false;
        }
        MappetUIBuilder builder = (MappetUIBuilder)in;
        ICharacter character = Character.get((EntityPlayer)this.entity);
        if (character.getUIContext() == null) {
            UI ui = builder.getUI();
            UIContext context = new UIContext(ui, (EntityPlayer)this.entity, builder.getScript(), builder.getFunction());
            character.setUIContext(context);
            Dispatcher.sendTo(new PacketUI(ui), this.getMinecraftPlayer());
            if (defaultData) {
                context.populateDefaultData();
            }
            context.clearChanges();
            return true;
        }
        return false;
    }

    @Override
    public void closeUI() {
        Dispatcher.sendTo(new PacketCloseUI(), this.getMinecraftPlayer());
    }

    @Override
    public IMappetUIContext getUIContext() {
        ICharacter character = Character.get((EntityPlayer)this.entity);
        UIContext context = character.getUIContext();
        return context == null ? null : new MappetUIContext(context);
    }

    @Override
    public boolean setupHUD(String id) {
        HUDScene scene = (HUDScene)Mappet.huds.load(id);
        if (scene != null) {
            Dispatcher.sendTo(new PacketHUDScene(scene.getId(), scene.serializeNBT()), (EntityPlayerMP)this.entity);
        }
        return scene != null;
    }

    @Override
    public void changeHUDMorph(String id, int index, AbstractMorph morph) {
        if (morph == null) {
            return;
        }
        this.changeHUDMorph(id, index, MorphUtils.toNBT((AbstractMorph)morph));
    }

    @Override
    public void changeHUDMorph(String id, int index, INBTCompound morph) {
        if (morph == null) {
            return;
        }
        this.changeHUDMorph(id, index, morph.getNBTTagComound());
    }

    private void changeHUDMorph(String id, int index, NBTTagCompound tag) {
        Dispatcher.sendTo(new PacketHUDMorph(id, index, tag), (EntityPlayerMP)this.entity);
    }

    @Override
    public void closeHUD(String id) {
        Dispatcher.sendTo(new PacketHUDScene(id == null ? "" : id, null), (EntityPlayerMP)this.entity);
    }
}

