/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet.api.scripts.code.nbt;

import mchorse.mappet.api.scripts.code.nbt.ScriptNBTCompound;
import mchorse.mappet.api.scripts.user.nbt.INBT;
import mchorse.mappet.api.scripts.user.nbt.INBTCompound;
import mchorse.mappet.api.scripts.user.nbt.INBTList;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTPrimitive;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;

public class ScriptNBTList
implements INBTList {
    private NBTTagList list;

    public ScriptNBTList(NBTTagList list) {
        this.list = list == null ? new NBTTagList() : list;
    }

    @Override
    public NBTTagList getNBTTagList() {
        return this.list;
    }

    @Override
    public boolean isCompound() {
        return false;
    }

    @Override
    public boolean isList() {
        return true;
    }

    @Override
    public String stringify() {
        return this.list.toString();
    }

    public String toString() {
        return this.list.toString();
    }

    @Override
    public boolean isEmpty() {
        return this.list.func_82582_d();
    }

    @Override
    public int size() {
        return this.list.func_74745_c();
    }

    @Override
    public INBT copy() {
        return new ScriptNBTList(this.list.func_74737_b());
    }

    @Override
    public void combine(INBT nbt) {
        if (nbt instanceof INBTList) {
            NBTTagList list = ((INBTList)nbt).getNBTTagList();
            if (this.list.func_150303_d() == list.func_150303_d()) {
                for (int i = 0; i < list.func_74745_c(); ++i) {
                    this.list.func_74742_a(list.func_179238_g(i).func_74737_b());
                }
            }
        }
    }

    @Override
    public boolean isSame(INBT nbt) {
        if (nbt instanceof INBTList) {
            return this.list.equals((Object)((INBTList)nbt).getNBTTagList());
        }
        return false;
    }

    @Override
    public boolean has(int index) {
        return index >= 0 && index < this.size();
    }

    @Override
    public void remove(int index) {
        this.list.func_74744_a(index);
    }

    @Override
    public byte getByte(int index) {
        NBTBase base = this.list.func_179238_g(index);
        return base.func_74732_a() == 1 ? ((NBTPrimitive)base).func_150290_f() : (byte)0;
    }

    @Override
    public void setByte(int index, byte value) {
        this.list.func_150304_a(index, (NBTBase)new NBTTagByte(value));
    }

    @Override
    public void addByte(byte value) {
        this.list.func_74742_a((NBTBase)new NBTTagByte(value));
    }

    @Override
    public short getShort(int index) {
        NBTBase base = this.list.func_179238_g(index);
        return base.func_74732_a() == 2 ? ((NBTPrimitive)base).func_150289_e() : (short)0;
    }

    @Override
    public void setShort(int index, short value) {
        this.list.func_150304_a(index, (NBTBase)new NBTTagShort(value));
    }

    @Override
    public void addShort(short value) {
        this.list.func_74742_a((NBTBase)new NBTTagShort(value));
    }

    @Override
    public int getInt(int index) {
        NBTBase base = this.list.func_179238_g(index);
        return base.func_74732_a() == 3 ? ((NBTPrimitive)base).func_150287_d() : 0;
    }

    @Override
    public void setInt(int index, int value) {
        this.list.func_150304_a(index, (NBTBase)new NBTTagInt(value));
    }

    @Override
    public void addInt(int value) {
        this.list.func_74742_a((NBTBase)new NBTTagInt(value));
    }

    @Override
    public long getLong(int index) {
        NBTBase base = this.list.func_179238_g(index);
        return base.func_74732_a() == 4 ? ((NBTPrimitive)base).func_150291_c() : 0L;
    }

    @Override
    public void setLong(int index, long value) {
        this.list.func_150304_a(index, (NBTBase)new NBTTagLong(value));
    }

    @Override
    public void addLong(long value) {
        this.list.func_74742_a((NBTBase)new NBTTagLong(value));
    }

    @Override
    public float getFloat(int index) {
        NBTBase base = this.list.func_179238_g(index);
        return base.func_74732_a() == 5 ? ((NBTPrimitive)base).func_150288_h() : 0.0f;
    }

    @Override
    public void setFloat(int index, float value) {
        this.list.func_150304_a(index, (NBTBase)new NBTTagFloat(value));
    }

    @Override
    public void addFloat(float value) {
        this.list.func_74742_a((NBTBase)new NBTTagFloat(value));
    }

    @Override
    public double getDouble(int index) {
        NBTBase base = this.list.func_179238_g(index);
        return base.func_74732_a() == 6 ? ((NBTPrimitive)base).func_150286_g() : 0.0;
    }

    @Override
    public void setDouble(int index, double value) {
        this.list.func_150304_a(index, (NBTBase)new NBTTagDouble(value));
    }

    @Override
    public void addDouble(double value) {
        this.list.func_74742_a((NBTBase)new NBTTagDouble(value));
    }

    @Override
    public String getString(int index) {
        NBTBase base = this.list.func_179238_g(index);
        return base.func_74732_a() == 8 ? ((NBTTagString)base).func_150285_a_() : "";
    }

    @Override
    public void setString(int index, String value) {
        this.list.func_150304_a(index, (NBTBase)new NBTTagString(value));
    }

    @Override
    public void addString(String value) {
        this.list.func_74742_a((NBTBase)new NBTTagString(value));
    }

    @Override
    public boolean getBoolean(int index) {
        NBTBase base = this.list.func_179238_g(index);
        return base.func_74732_a() == 1 && ((NBTPrimitive)base).func_150290_f() != 0;
    }

    @Override
    public void setBoolean(int index, boolean value) {
        this.list.func_150304_a(index, (NBTBase)new NBTTagByte(value ? (byte)1 : 0));
    }

    @Override
    public void addBoolean(boolean value) {
        this.list.func_74742_a((NBTBase)new NBTTagByte(value ? (byte)1 : 0));
    }

    @Override
    public INBTCompound getCompound(int index) {
        return new ScriptNBTCompound(this.list.func_150305_b(index));
    }

    @Override
    public void setCompound(int index, INBTCompound value) {
        this.list.func_150304_a(index, (NBTBase)value.getNBTTagComound());
    }

    @Override
    public void addCompound(INBTCompound value) {
        this.list.func_74742_a((NBTBase)value.getNBTTagComound());
    }

    @Override
    public INBTList getList(int index) {
        NBTBase base = this.list.func_179238_g(index);
        return new ScriptNBTList(base.func_74732_a() == 9 ? (NBTTagList)base : null);
    }

    @Override
    public void setList(int index, INBTList value) {
        this.list.func_150304_a(index, (NBTBase)value.getNBTTagList());
    }

    @Override
    public void addList(INBTList value) {
        this.list.func_74742_a((NBTBase)value.getNBTTagList());
    }
}

