/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet.api.triggers.blocks;

import mchorse.mappet.api.triggers.blocks.AbstractTriggerBlock;
import mchorse.mappet.api.utils.DataContext;
import mchorse.mappet.api.utils.Target;
import mchorse.mappet.api.utils.TargetMode;
import mchorse.mappet.utils.EnumUtils;
import mchorse.mappet.utils.InventoryUtils;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemTriggerBlock
extends AbstractTriggerBlock {
    public Target target = new Target(TargetMode.SUBJECT);
    public ItemStack stack = ItemStack.field_190927_a;
    public ItemMode mode = ItemMode.TAKE;

    @Override
    @SideOnly(value=Side.CLIENT)
    public String stringify() {
        String displayName = this.stack.func_82833_r();
        if (this.stack.func_190916_E() > 1) {
            displayName = displayName + TextFormatting.GOLD + " (" + TextFormatting.GRAY + this.stack.func_190916_E() + TextFormatting.GOLD + ")";
        }
        if (this.mode == ItemMode.GIVE) {
            return I18n.func_135052_a((String)"mappet.gui.nodes.item.give", (Object[])new Object[]{displayName});
        }
        return I18n.func_135052_a((String)"mappet.gui.nodes.item.take", (Object[])new Object[]{displayName});
    }

    @Override
    public void trigger(DataContext context) {
        EntityPlayer player;
        if (this.stack.func_190926_b() || (player = this.target.getPlayer(context)) == null) {
            context.cancel();
            return;
        }
        if (this.mode == ItemMode.GIVE) {
            ItemStack copy = this.stack.func_77946_l();
            if (!player.func_191521_c(copy) && !copy.func_190926_b()) {
                player.func_71019_a(copy, false);
            }
            return;
        }
        if (InventoryUtils.countItems(player, this.stack) >= this.stack.func_190916_E()) {
            player.field_71071_by.func_174925_a(this.stack.func_77973_b(), -1, this.stack.func_190916_E(), null);
        } else {
            context.cancel();
        }
    }

    @Override
    public boolean isEmpty() {
        return this.stack.func_190926_b();
    }

    @Override
    protected void serializeNBT(NBTTagCompound tag) {
        super.serializeNBT(tag);
        tag.func_74782_a("Target", (NBTBase)this.target.serializeNBT());
        tag.func_74782_a("Stack", (NBTBase)this.stack.serializeNBT());
        tag.func_74768_a("Mode", this.mode.ordinal());
    }

    @Override
    public void deserializeNBT(NBTTagCompound tag) {
        super.deserializeNBT(tag);
        if (tag.func_74764_b("Target")) {
            this.target.deserializeNBT(tag.func_74775_l("Target"));
        }
        if (tag.func_74764_b("Stack")) {
            this.stack = new ItemStack(tag.func_74775_l("Stack"));
        }
        if (tag.func_74764_b("Mode")) {
            this.mode = EnumUtils.getValue(tag.func_74762_e("Mode"), ItemMode.values(), ItemMode.TAKE);
        }
    }

    public static enum ItemMode {
        TAKE,
        GIVE;

    }
}

