/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet.api.triggers.blocks;

import mchorse.mappet.api.triggers.blocks.AbstractTriggerBlock;
import mchorse.mappet.api.utils.DataContext;
import mchorse.mappet.api.utils.Target;
import mchorse.mappet.api.utils.TargetMode;
import mchorse.mappet.entities.EntityNpc;
import mchorse.metamorph.api.MorphAPI;
import mchorse.metamorph.api.MorphManager;
import mchorse.metamorph.api.morphs.AbstractMorph;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MorphTriggerBlock
extends AbstractTriggerBlock {
    public Target target = new Target(TargetMode.SUBJECT);
    public NBTTagCompound morph;

    @Override
    @SideOnly(value=Side.CLIENT)
    public String stringify() {
        if (this.morph == null) {
            return I18n.func_135052_a((String)"mappet.gui.triggers.morph.demorph", (Object[])new Object[0]);
        }
        return I18n.func_135052_a((String)"mappet.gui.triggers.morph.morph", (Object[])new Object[]{this.morph.func_74779_i("Name")});
    }

    @Override
    public void trigger(DataContext context) {
        Entity entity = this.target.getEntity(context);
        if (entity instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)entity;
            if (this.morph == null) {
                MorphAPI.demorph((EntityPlayer)player);
            } else {
                MorphAPI.morph((EntityPlayer)player, (AbstractMorph)MorphManager.INSTANCE.morphFromNBT(this.morph), (boolean)true);
            }
        } else if (entity instanceof EntityNpc) {
            EntityNpc npc = (EntityNpc)entity;
            npc.setMorph(MorphManager.INSTANCE.morphFromNBT(this.morph));
            npc.sendMorph();
        }
    }

    @Override
    public boolean isEmpty() {
        return this.morph == null;
    }

    @Override
    protected void serializeNBT(NBTTagCompound tag) {
        super.serializeNBT(tag);
        tag.func_74782_a("Target", (NBTBase)this.target.serializeNBT());
        if (this.morph != null) {
            tag.func_74782_a("Morph", (NBTBase)this.morph);
        }
    }

    @Override
    public void deserializeNBT(NBTTagCompound tag) {
        super.deserializeNBT(tag);
        if (tag.func_74764_b("Target")) {
            this.target.deserializeNBT(tag.func_74775_l("Target"));
        }
        this.morph = null;
        if (tag.func_74764_b("Morph")) {
            this.morph = tag.func_74775_l("Morph");
        }
    }
}

