/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet.api.ui.components;

import java.util.ArrayList;
import java.util.List;
import mchorse.mappet.api.ui.UIContext;
import mchorse.mappet.api.ui.components.UIComponent;
import mchorse.mappet.api.ui.utils.DiscardMethod;
import mchorse.mappet.client.gui.utils.GuiGraphics;
import mchorse.mappet.client.gui.utils.graphics.GradientGraphic;
import mchorse.mappet.client.gui.utils.graphics.Graphic;
import mchorse.mappet.client.gui.utils.graphics.IconGraphic;
import mchorse.mappet.client.gui.utils.graphics.ImageGraphic;
import mchorse.mappet.client.gui.utils.graphics.RectGraphic;
import mchorse.mappet.client.gui.utils.graphics.ShadowGraphic;
import mchorse.mappet.client.gui.utils.graphics.TextGraphic;
import mchorse.mclib.client.gui.framework.elements.GuiElement;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class UIGraphicsComponent
extends UIComponent {
    public List<Graphic> graphics = new ArrayList<Graphic>();

    public UIGraphicsComponent removeAll() {
        this.change("Graphics");
        this.graphics.clear();
        return this;
    }

    public Graphic rect(int color) {
        return this.rect(0, 0, 0, 0, color);
    }

    public Graphic rect(int x, int y, int w, int h, int color) {
        return this.addGraphic(new RectGraphic(x, y, w, h, color));
    }

    public Graphic gradient(int primary, int secondary) {
        return this.gradient(primary, secondary, false);
    }

    public Graphic gradient(int primary, int secondary, boolean horizontal) {
        return this.gradient(0, 0, 0, 0, primary, secondary, horizontal);
    }

    public Graphic gradient(int x, int y, int w, int h, int primary, int secondary) {
        return this.gradient(x, y, w, h, primary, secondary, false);
    }

    public Graphic gradient(int x, int y, int w, int h, int primary, int secondary, boolean horizontal) {
        return this.addGraphic(new GradientGraphic(x, y, w, h, primary, secondary, horizontal));
    }

    public Graphic image(String image, int textureWidth, int textureHeight) {
        return this.image(image, textureWidth, textureHeight, -1);
    }

    public Graphic image(String image, int textureWidth, int textureHeight, int primary) {
        return this.image(image, 0, 0, 0, 0, textureWidth, textureHeight, primary);
    }

    public Graphic image(String image, int x, int y, int w, int h) {
        return this.image(image, x, y, w, h, w, h, -1);
    }

    public Graphic image(String image, int x, int y, int w, int h, int textureWidth, int textureHeight) {
        return this.image(image, x, y, w, h, textureWidth, textureHeight, -1);
    }

    public Graphic image(String image, int x, int y, int w, int h, int textureWidth, int textureHeight, int primary) {
        return this.addGraphic(new ImageGraphic(new ResourceLocation(image), x, y, w, h, textureWidth, textureHeight, primary));
    }

    public Graphic text(String text, int x, int y, int color) {
        return this.text(text, x, y, color, 0.0f, 0.0f);
    }

    public Graphic text(String text, int x, int y, int color, float anchorX, float anchorY) {
        return this.text(text, x, y, 0, 0, color, anchorX, anchorY);
    }

    public Graphic text(String text, int x, int y, int w, int h, int color, float anchorX, float anchorY) {
        return this.addGraphic(new TextGraphic(text, x, y, w, h, color, anchorX, anchorY));
    }

    public Graphic icon(String icon, int x, int y, int color) {
        return this.icon(icon, x, y, color, 0.0f, 0.0f);
    }

    public Graphic icon(String icon, int x, int y, int color, float anchorX, float anchorY) {
        return this.addGraphic(new IconGraphic(icon, x, y, color, anchorX, anchorY));
    }

    public Graphic shadow(int primary, int secondary, int offset) {
        return this.shadow(0, 0, 0, 0, primary, secondary, offset);
    }

    public Graphic shadow(int x, int y, int w, int h, int primary, int secondary, int offset) {
        return this.addGraphic(new ShadowGraphic(x, y, w, h, primary, secondary, offset));
    }

    @DiscardMethod
    private <T extends Graphic> T addGraphic(T graphic) {
        this.change("Graphics");
        this.graphics.add(graphic);
        return graphic;
    }

    @Override
    @DiscardMethod
    @SideOnly(value=Side.CLIENT)
    public GuiElement create(Minecraft mc, UIContext context) {
        GuiGraphics element = new GuiGraphics(mc);
        element.graphics.addAll(this.graphics);
        return this.apply(element, context);
    }

    @Override
    @DiscardMethod
    @SideOnly(value=Side.CLIENT)
    protected void applyProperty(UIContext context, String key, GuiElement element) {
        super.applyProperty(context, key, element);
        if (key.equals("Graphics")) {
            GuiGraphics graphics = (GuiGraphics)element;
            graphics.graphics.clear();
            graphics.graphics.addAll(this.graphics);
        }
    }

    @Override
    @DiscardMethod
    public void serializeNBT(NBTTagCompound tag) {
        super.serializeNBT(tag);
        NBTTagList list = new NBTTagList();
        for (Graphic graphic : this.graphics) {
            list.func_74742_a((NBTBase)Graphic.toNBT(graphic));
        }
        tag.func_74782_a("Graphics", (NBTBase)list);
    }

    @Override
    @DiscardMethod
    public void deserializeNBT(NBTTagCompound tag) {
        super.deserializeNBT(tag);
        if (tag.func_74764_b("Graphics")) {
            NBTTagList list = tag.func_150295_c("Graphics", 10);
            this.graphics.clear();
            int c = list.func_74745_c();
            for (int i = 0; i < c; ++i) {
                Graphic graphic = Graphic.fromNBT(list.func_150305_b(i));
                if (graphic == null) continue;
                this.graphics.add(graphic);
            }
        }
    }
}

