/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet.api.ui.components;

import mchorse.mappet.api.ui.UIContext;
import mchorse.mappet.api.ui.components.UIComponent;
import mchorse.mappet.api.ui.components.UIParentComponent;
import mchorse.mappet.api.ui.utils.DiscardMethod;
import mchorse.mappet.api.ui.utils.LayoutType;
import mchorse.mclib.client.gui.framework.elements.GuiElement;
import mchorse.mclib.client.gui.framework.elements.GuiScrollElement;
import mchorse.mclib.client.gui.framework.elements.IGuiElement;
import mchorse.mclib.client.gui.utils.ScrollDirection;
import mchorse.mclib.client.gui.utils.resizers.layout.ColumnResizer;
import mchorse.mclib.client.gui.utils.resizers.layout.GridResizer;
import mchorse.mclib.client.gui.utils.resizers.layout.RowResizer;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class UILayoutComponent
extends UIParentComponent {
    public boolean scroll;
    public Integer scrollSize;
    public boolean horizontal;
    public LayoutType layoutType;
    public int margin;
    public int padding;
    public Integer width;
    public Integer items;

    public UILayoutComponent scroll() {
        this.scroll = true;
        return this;
    }

    public UILayoutComponent scrollSize(int scrollSize) {
        this.change("ScrollSize");
        this.scrollSize = scrollSize;
        return this;
    }

    public UILayoutComponent horizontal() {
        this.horizontal = true;
        return this;
    }

    public UILayoutComponent width(int width) {
        this.width = width;
        return this;
    }

    public UILayoutComponent items(int items) {
        this.items = items;
        return this;
    }

    @Override
    @DiscardMethod
    @SideOnly(value=Side.CLIENT)
    public GuiElement create(Minecraft mc, UIContext context) {
        GuiElement element;
        if (this.scroll) {
            GuiScrollElement scroll = new GuiScrollElement(mc, this.horizontal ? ScrollDirection.HORIZONTAL : ScrollDirection.VERTICAL);
            if (this.scrollSize != null) {
                scroll.scroll.scrollSize = this.scrollSize;
            }
            element = scroll;
        } else {
            element = new GuiElement(mc);
        }
        for (UIComponent component : this.getChildComponents()) {
            GuiElement created = component.create(mc, context);
            if (this.layoutType == null) {
                created.flex().relative(element);
            }
            element.add((IGuiElement)created);
        }
        if (this.layoutType != null) {
            this.applyLayout(element, this.layoutType);
        }
        return this.apply(element, context);
    }

    @DiscardMethod
    @SideOnly(value=Side.CLIENT)
    private void applyLayout(GuiElement element, LayoutType type) {
        if (type == LayoutType.COLUMN) {
            ColumnResizer column = element.flex().column(this.margin);
            if (this.scroll) {
                column.scroll();
            }
            if (!this.horizontal) {
                column.vertical();
            }
            if (this.width != null) {
                column.width(this.width.intValue());
            } else {
                column.stretch();
            }
            column.padding(this.padding);
        } else if (type == LayoutType.ROW) {
            RowResizer row = element.flex().row(this.margin);
            if (this.width != null) {
                row.width(this.width.intValue());
            }
            row.padding(this.padding);
        } else if (type == LayoutType.GRID) {
            GridResizer grid = element.flex().grid(this.margin);
            if (this.width != null) {
                grid.width(this.width.intValue());
            }
            if (this.items != null) {
                grid.items(this.items.intValue());
            }
            grid.padding(this.padding);
        }
    }

    @Override
    @DiscardMethod
    @SideOnly(value=Side.CLIENT)
    protected void applyProperty(UIContext context, String key, GuiElement element) {
        super.applyProperty(context, key, element);
        if (key.equals("ScrollSize") && element instanceof GuiScrollElement) {
            ((GuiScrollElement)element).scroll.scrollSize = this.scrollSize;
        }
    }

    @Override
    @DiscardMethod
    public void serializeNBT(NBTTagCompound tag) {
        super.serializeNBT(tag);
        tag.func_74757_a("Scroll", this.scroll);
        if (this.scrollSize != null) {
            tag.func_74768_a("ScrollSize", this.scrollSize.intValue());
        }
        tag.func_74757_a("Horizontal", this.horizontal);
        if (this.layoutType != null) {
            tag.func_74768_a("LayoutType", this.layoutType.ordinal());
        }
        tag.func_74768_a("Margin", this.margin);
        tag.func_74768_a("Padding", this.padding);
        if (this.width != null) {
            tag.func_74768_a("Width", this.width.intValue());
        }
        if (this.items != null) {
            tag.func_74768_a("Items", this.items.intValue());
        }
    }

    @Override
    @DiscardMethod
    public void deserializeNBT(NBTTagCompound tag) {
        int layoutType;
        super.deserializeNBT(tag);
        if (tag.func_74764_b("Scroll")) {
            this.scroll = tag.func_74767_n("Scroll");
        }
        if (tag.func_74764_b("ScrollSize")) {
            this.scrollSize = tag.func_74762_e("ScrollSize");
        }
        if (tag.func_74764_b("Horizontal")) {
            this.horizontal = tag.func_74767_n("Horizontal");
        }
        if (tag.func_74764_b("LayoutType") && (layoutType = tag.func_74762_e("LayoutType")) >= 0 && layoutType < LayoutType.values().length) {
            this.layoutType = LayoutType.values()[layoutType];
        }
        if (tag.func_74764_b("Margin")) {
            this.margin = tag.func_74762_e("Margin");
        }
        if (tag.func_74764_b("Padding")) {
            this.padding = tag.func_74762_e("Padding");
        }
        if (tag.func_74764_b("Width")) {
            this.width = tag.func_74762_e("Width");
        }
        if (tag.func_74764_b("Items")) {
            this.items = tag.func_74762_e("Items");
        }
    }
}

