/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet.api.ui.components;

import java.util.ArrayList;
import java.util.List;
import mchorse.mappet.CommonProxy;
import mchorse.mappet.api.ui.components.UIComponent;
import mchorse.mappet.api.ui.utils.DiscardMethod;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public abstract class UIParentComponent
extends UIComponent {
    public List<UIComponent> children = new ArrayList<UIComponent>();

    @Override
    @DiscardMethod
    public List<UIComponent> getChildComponents() {
        return this.children;
    }

    @Override
    @DiscardMethod
    public void serializeNBT(NBTTagCompound tag) {
        super.serializeNBT(tag);
        NBTTagList list = new NBTTagList();
        for (UIComponent component : this.children) {
            NBTTagCompound componentTag = component.serializeNBT();
            componentTag.func_74778_a("Type", CommonProxy.getUiComponents().getType(component));
            list.func_74742_a((NBTBase)componentTag);
        }
        tag.func_74782_a("Components", (NBTBase)list);
    }

    @Override
    @DiscardMethod
    public void deserializeNBT(NBTTagCompound tag) {
        super.deserializeNBT(tag);
        NBTTagList list = tag.func_150295_c("Components", 10);
        int c = list.func_74745_c();
        for (int i = 0; i < c; ++i) {
            NBTTagCompound componentTag = list.func_150305_b(i);
            UIComponent component = CommonProxy.getUiComponents().create(componentTag.func_74779_i("Type"));
            if (component == null) continue;
            component.deserializeNBT(componentTag);
            this.children.add(component);
        }
    }
}

