/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet.api.utils;

import mchorse.mappet.api.expressions.ExpressionManager;
import mchorse.mappet.api.utils.ComparisonMode;
import mchorse.mappet.utils.EnumUtils;
import mchorse.mclib.math.IValue;
import mchorse.mclib.math.MathBuilder;
import mchorse.mclib.math.Variable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class Comparison
implements INBTSerializable<NBTTagCompound> {
    private static final MathBuilder MATH;
    private static final Variable VALUE;
    private static final Variable VALUE2;
    public ComparisonMode comparison = ComparisonMode.EQUALS;
    public double value;
    public String expression = "";
    private IValue compiledValue;

    public boolean compare(double a) {
        if (this.comparison == ComparisonMode.EXPRESSION) {
            if (this.compiledValue == null) {
                try {
                    this.compiledValue = MATH.parse(this.expression);
                }
                catch (Exception e) {
                    this.compiledValue = ExpressionManager.ZERO;
                }
            }
            VALUE.set(a);
            VALUE2.set(a);
            return this.compiledValue.booleanValue();
        }
        return this.comparison.compare(a, this.value);
    }

    @SideOnly(value=Side.CLIENT)
    public String stringify(String id) {
        return this.comparison.stringify(id, this.value, this.expression);
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("Comparison", this.comparison.ordinal());
        tag.func_74780_a("Value", this.value);
        tag.func_74778_a("Expression", this.expression);
        return tag;
    }

    public void deserializeNBT(NBTTagCompound tag) {
        this.compiledValue = null;
        this.comparison = EnumUtils.getValue(tag.func_74762_e("Comparison"), ComparisonMode.values(), ComparisonMode.EQUALS);
        this.value = tag.func_74769_h("Value");
        this.expression = tag.func_74779_i("Expression");
    }

    static {
        VALUE = new Variable("value", 0.0);
        VALUE2 = new Variable("x", 0.0);
        MATH = new MathBuilder();
        MATH.register(VALUE);
        MATH.register(VALUE2);
    }
}

