/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet.api.utils.manager;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import mchorse.mappet.Mappet;
import mchorse.mappet.api.utils.AbstractData;
import mchorse.mappet.api.utils.manager.IManager;
import mchorse.mappet.api.utils.manager.ManagerCache;

public abstract class FolderManager<T extends AbstractData>
implements IManager<T> {
    protected Map<String, ManagerCache> cache = new HashMap<String, ManagerCache>();
    protected File folder;
    protected long lastCheck;

    public FolderManager(File folder) {
        if (folder != null) {
            this.folder = folder;
            this.folder.mkdirs();
        }
    }

    protected void doExpirationCheck() {
        int threshold = 30000;
        long current = System.currentTimeMillis();
        if (current - this.lastCheck > 30000L) {
            this.cache.values().removeIf(cache -> current - cache.lastUsed > 30000L);
            this.lastCheck = current;
        }
    }

    @Override
    public boolean exists(String name) {
        return this.getFile(name).exists();
    }

    @Override
    public boolean rename(String id, String newId) {
        File file = this.getFile(id);
        if (file != null && file.exists() && file.renameTo(this.getFile(newId))) {
            if (Mappet.generalDataCaching.get()) {
                this.cache.put(newId, this.cache.remove(id));
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean delete(String name) {
        File file = this.getFile(name);
        if (file != null && file.delete()) {
            this.cache.remove(name);
            return true;
        }
        return false;
    }

    @Override
    public Collection<String> getKeys() {
        HashSet<String> set = new HashSet<String>();
        if (this.folder == null) {
            return set;
        }
        for (File file : this.folder.listFiles()) {
            String name = file.getName();
            if (!file.isFile() || !this.isData(file)) continue;
            set.add(name.substring(0, name.lastIndexOf(".")));
        }
        return set;
    }

    protected boolean isData(File file) {
        return file.getName().endsWith(this.getExtension());
    }

    public File getFile(String name) {
        if (this.folder == null) {
            return null;
        }
        return new File(this.folder, name + this.getExtension());
    }

    protected String getExtension() {
        return ".json";
    }
}

