/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet.client.gui;

import java.util.List;
import java.util.Map;
import mchorse.mappet.api.quests.Quest;
import mchorse.mappet.api.quests.Quests;
import mchorse.mappet.api.quests.objectives.AbstractObjective;
import mchorse.mappet.capabilities.character.Character;
import mchorse.mappet.capabilities.character.ICharacter;
import mchorse.mclib.client.gui.framework.elements.utils.GuiDraw;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.text.TextFormatting;

public class GuiQuestTracker
extends Gui {
    public static void renderQuests(ScaledResolution size, float partial) {
        Minecraft mc = Minecraft.func_71410_x();
        ICharacter character = Character.get((EntityPlayer)mc.field_71439_g);
        if (character != null && !character.getQuests().quests.isEmpty()) {
            Quests quests = character.getQuests();
            int i = 0;
            int c = Math.min(quests.quests.size(), 3);
            int w = 160;
            int x = size.func_78326_a() - w;
            int y = 60;
            for (Map.Entry<String, Quest> entry : quests.quests.entrySet()) {
                if (i >= c) break;
                y += GuiQuestTracker.renderQuest(mc, entry.getValue(), x, y, w);
                ++i;
            }
        }
    }

    private static int renderQuest(Minecraft mc, Quest value, int x, int y, int w) {
        boolean questComplete = value.isComplete((EntityPlayer)mc.field_71439_g);
        String title = value.getProcessedTitle();
        if (questComplete) {
            title = TextFormatting.GOLD + title;
        }
        GlStateManager.func_179147_l();
        GlStateManager.func_179141_d();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GuiDraw.drawHorizontalGradientRect((int)x, (int)y, (int)(x + w), (int)(y + 16), (int)0x11000000, (int)-1442840576);
        mc.field_71466_p.func_175063_a(title, (float)(x + 4), (float)(y + 4), 0xFFFFFF);
        if (mc.field_71439_g.func_184812_l_()) {
            int lw = mc.field_71466_p.func_78256_a(value.getId());
            GuiDraw.drawTextBackground((FontRenderer)mc.field_71466_p, (String)value.getId(), (int)(x - 4 - lw), (int)(y + 4), (int)0xAAAAAA, (int)-2013265920, (int)2);
        }
        int original = y;
        y += 16;
        for (AbstractObjective objective : value.objectives) {
            String description = "- " + objective.stringify((EntityPlayer)mc.field_71439_g);
            List lines = mc.field_71466_p.func_78271_c(description, w - 6);
            boolean complete = questComplete || objective.isComplete((EntityPlayer)mc.field_71439_g);
            for (String line : lines) {
                mc.field_71466_p.func_175063_a(line, (float)(x + 4), (float)(y + 2), complete ? 0xFFFFFF : 0xAAAAAA);
                y += 12;
            }
        }
        return y - original + 6;
    }
}

