/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet.client.gui.factions;

import mchorse.mappet.api.factions.Faction;
import mchorse.mappet.api.factions.FactionRelation;
import mchorse.mclib.client.gui.framework.elements.GuiElement;
import mchorse.mclib.client.gui.framework.elements.utils.GuiContext;
import mchorse.mclib.client.gui.framework.elements.utils.GuiDraw;
import mchorse.mclib.utils.ColorUtils;
import mchorse.mclib.utils.Interpolations;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.util.text.TextFormatting;

public class GuiFactionCard
extends GuiElement {
    private Faction faction;
    private double score;

    public GuiFactionCard(Minecraft mc, Faction faction, double score) {
        super(mc);
        this.faction = faction;
        this.score = score;
        this.flex().h(24);
    }

    public void draw(GuiContext context) {
        super.draw(context);
        String title = this.faction.title;
        if (this.mc.field_71439_g.func_184812_l_()) {
            title = title + TextFormatting.GRAY + " (" + this.faction.getId() + ")";
        }
        this.font.func_175063_a(title, (float)this.area.x, (float)this.area.y, this.faction.color);
        FactionRelation.Threshold current = this.faction.ownRelation.get((int)this.score);
        FactionRelation.Threshold previous = null;
        int w = this.font.func_78256_a(current.title);
        this.font.func_175063_a(current.title, (float)(this.area.ex() - w), (float)this.area.y, 0xFFFFFF);
        int c = this.faction.ownRelation.thresholds.size();
        for (int i = 0; i < c; ++i) {
            FactionRelation.Threshold threshold = this.faction.ownRelation.thresholds.get(i);
            float a = (float)i / (float)c;
            float b = (float)(i + 1) / (float)c;
            if (threshold == current) {
                double anchor = i != 0 && i < c - 1 ? (this.score - (double)previous.score) / (double)(threshold.score - previous.score) : 1.0;
                int x = this.area.x(b);
                if (anchor < 1.0) {
                    x = this.area.x((float)Interpolations.lerp((double)a, (double)b, (double)anchor));
                    GuiDraw.drawVerticalGradientRect((int)this.area.x(a), (int)(this.area.y + 12), (int)x, (int)(this.area.y + 24), (int)(-16777216 + threshold.color), (int)(-16777216 + ColorUtils.multiplyColor((int)threshold.color, (float)0.7f)));
                    GuiDraw.drawVerticalGradientRect((int)x, (int)(this.area.y + 14), (int)this.area.x(b), (int)(this.area.y + 24), (int)threshold.color, (int)(-2013265920 + threshold.color));
                } else {
                    GuiDraw.drawVerticalGradientRect((int)this.area.x(a), (int)(this.area.y + 12), (int)x, (int)(this.area.y + 24), (int)(-16777216 + threshold.color), (int)(-16777216 + ColorUtils.multiplyColor((int)threshold.color, (float)0.7f)));
                }
                Gui.func_73734_a((int)(this.area.x(a) - 1), (int)(this.area.y + 24), (int)(this.area.x(b) + 1), (int)(this.area.y + 25), (int)-1);
            } else {
                GuiDraw.drawVerticalGradientRect((int)this.area.x(a), (int)(this.area.y + 14), (int)this.area.x(b), (int)(this.area.y + 24), (int)threshold.color, (int)(-2013265920 + threshold.color));
            }
            previous = threshold;
        }
        String label = String.valueOf((int)this.score);
        w = this.font.func_78256_a(label);
        GuiDraw.drawTextBackground((FontRenderer)this.font, (String)label, (int)(this.area.mx() - w / 2), (int)this.area.y, (int)0xFFFFFF, (int)-2013265920, (int)2);
    }
}

