/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet.client.gui.npc.utils;

import java.util.List;
import mchorse.mappet.api.npcs.NpcDrop;
import mchorse.mclib.client.gui.framework.elements.GuiElement;
import mchorse.mclib.client.gui.framework.elements.IGuiElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiIconElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiSlotElement;
import mchorse.mclib.client.gui.framework.elements.context.GuiSimpleContextMenu;
import mchorse.mclib.client.gui.framework.elements.input.GuiTrackpadElement;
import mchorse.mclib.client.gui.framework.elements.utils.GuiLabel;
import mchorse.mclib.client.gui.utils.Elements;
import mchorse.mclib.client.gui.utils.Icons;
import mchorse.mclib.client.gui.utils.keys.IKey;
import net.minecraft.client.Minecraft;

public class GuiNpcDrops
extends GuiElement {
    public GuiElement element;
    private List<NpcDrop> drops;

    public GuiNpcDrops(Minecraft mc) {
        super(mc);
        GuiLabel label = Elements.label((IKey)IKey.lang((String)"mappet.gui.npcs.drops.title"));
        GuiIconElement add = new GuiIconElement(mc, Icons.ADD, b -> this.addDrop(new NpcDrop(), true));
        add.flex().wh(10, 8);
        GuiElement row = Elements.row((Minecraft)mc, (int)5, (int)0, (int)this.font.field_78288_b, (GuiElement[])new GuiElement[]{label, add});
        this.element = new GuiElement(mc);
        row.flex().row(5).preferred(0);
        this.element.flex().column(5).vertical().stretch();
        this.flex().column(5).vertical().stretch();
        this.add(new IGuiElement[]{row, this.element});
    }

    private void addDrop(NpcDrop drop, boolean insert) {
        if (insert) {
            this.drops.add(drop);
        }
        GuiElement row = Elements.row((Minecraft)this.mc, (int)5, (int)0, (int)24, (GuiElement[])new GuiElement[0]);
        GuiSlotElement slot = new GuiSlotElement(this.mc, 0, null);
        GuiTrackpadElement chance = new GuiTrackpadElement(this.mc, v -> {
            drop.chance = v.floatValue() / 100.0f;
        });
        chance.setValue((double)(drop.chance * 100.0f));
        chance.limit(0.0, 100.0).flex().h(24);
        slot.callback = stack -> {
            drop.stack = stack.func_77946_l();
        };
        slot.setStack(drop.stack);
        row.context(() -> new GuiSimpleContextMenu(this.mc).action(Icons.REMOVE, IKey.lang((String)"mappet.gui.npcs.drops.context.remove"), () -> {
            int index = this.element.getChildren().indexOf(row);
            if (index != -1) {
                this.drops.remove(index);
                row.removeFromParent();
                this.getParentContainer().resize();
            }
        }, 0xFF0033));
        row.add(new IGuiElement[]{slot, chance});
        this.element.add((IGuiElement)row);
        this.getParentContainer().resize();
    }

    public void set(List<NpcDrop> drops) {
        this.drops = drops;
        this.element.removeAll();
        if (drops != null) {
            for (NpcDrop drop : this.drops) {
                this.addDrop(drop, false);
            }
        }
    }
}

