/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet.client.gui.panels;

import java.util.List;
import mchorse.mappet.api.utils.AbstractData;
import mchorse.mappet.api.utils.ContentType;
import mchorse.mappet.client.gui.GuiMappetDashboard;
import mchorse.mappet.network.Dispatcher;
import mchorse.mappet.network.common.content.PacketContentData;
import mchorse.mappet.network.common.content.PacketContentRequestData;
import mchorse.mappet.network.common.content.PacketContentRequestNames;
import mchorse.mclib.client.gui.framework.GuiBase;
import mchorse.mclib.client.gui.framework.elements.GuiElement;
import mchorse.mclib.client.gui.framework.elements.GuiScrollElement;
import mchorse.mclib.client.gui.framework.elements.IGuiElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiIconElement;
import mchorse.mclib.client.gui.framework.elements.context.GuiSimpleContextMenu;
import mchorse.mclib.client.gui.framework.elements.list.GuiStringSearchListElement;
import mchorse.mclib.client.gui.framework.elements.modals.GuiConfirmModal;
import mchorse.mclib.client.gui.framework.elements.modals.GuiModal;
import mchorse.mclib.client.gui.framework.elements.modals.GuiPromptModal;
import mchorse.mclib.client.gui.framework.elements.utils.GuiContext;
import mchorse.mclib.client.gui.framework.elements.utils.GuiDraw;
import mchorse.mclib.client.gui.framework.elements.utils.GuiDrawable;
import mchorse.mclib.client.gui.mclib.GuiAbstractDashboard;
import mchorse.mclib.client.gui.mclib.GuiDashboardPanel;
import mchorse.mclib.client.gui.utils.Icons;
import mchorse.mclib.client.gui.utils.keys.IKey;
import mchorse.mclib.client.gui.utils.resizers.IResizer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTTagCompound;

public abstract class GuiMappetDashboardPanel<T extends AbstractData>
extends GuiDashboardPanel<GuiMappetDashboard> {
    public static final IKey KEYS_CATEGORY = IKey.lang((String)"mappet.gui.panels.keys.category");
    public GuiElement iconBar;
    public GuiIconElement toggleSidebar;
    public GuiElement sidebar;
    public GuiElement buttons;
    public GuiIconElement add;
    public GuiIconElement dupe;
    public GuiIconElement rename;
    public GuiIconElement remove;
    public GuiStringSearchListElement names;
    public GuiElement editor;
    protected boolean update;
    protected T data;
    protected boolean allowed;
    protected boolean save;

    public GuiMappetDashboardPanel(Minecraft mc, GuiMappetDashboard dashboard) {
        super(mc, (GuiAbstractDashboard)dashboard);
        this.buttons = new GuiElement(mc);
        this.sidebar = new GuiElement(mc);
        this.sidebar.flex().relative((GuiElement)this).x(1.0f).w(200).h(1.0f).anchorX(1.0f);
        this.iconBar = new GuiElement(mc);
        this.iconBar.flex().relative(this.sidebar).x(-20).w(20).h(1.0f).column(0).stretch();
        this.toggleSidebar = new GuiIconElement(mc, Icons.RIGHTLOAD, element -> this.toggleSidebar());
        this.iconBar.add((IGuiElement)this.toggleSidebar);
        this.add = new GuiIconElement(mc, Icons.ADD, this::addNewData);
        this.dupe = new GuiIconElement(mc, Icons.DUPE, this::dupeData);
        this.rename = new GuiIconElement(mc, Icons.EDIT, this::renameData);
        this.remove = new GuiIconElement(mc, Icons.REMOVE, this::removeData);
        GuiDrawable drawable = new GuiDrawable(context -> this.font.func_175063_a(I18n.func_135052_a((String)this.getTitle(), (Object[])new Object[0]), (float)this.names.area.x, (float)(this.area.y + 10), 0xFFFFFF));
        this.names = new GuiStringSearchListElement(mc, list -> this.pickData((String)list.get(0)));
        this.names.label(IKey.lang((String)"mappet.gui.search"));
        this.names.flex().relative(this.sidebar).xy(10, 25).w(1.0f, -20).h(1.0f, -35);
        this.names.list.context(() -> {
            GuiSimpleContextMenu menu = new GuiSimpleContextMenu(mc);
            if (this.data != null) {
                menu.action(Icons.COPY, IKey.lang((String)"mappet.gui.panels.context.copy"), this::copy);
            }
            try {
                NBTTagCompound tag = JsonToNBT.func_180713_a((String)GuiScreen.func_146277_j());
                if (tag.func_74762_e("_ContentType") == this.getType().ordinal()) {
                    menu.action(Icons.PASTE, IKey.lang((String)"mappet.gui.panels.context.paste"), () -> this.paste(tag));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return menu.actions.getList().isEmpty() ? null : menu.shadow();
        });
        this.sidebar.add(new IGuiElement[]{drawable, this.names, this.buttons});
        this.editor = new GuiElement(mc);
        this.editor.flex().relative((GuiElement)this).wTo((IResizer)this.iconBar.area).h(1.0f);
        this.buttons.flex().relative((GuiElement)this.names).x(1.0f).y(-20).anchorX(1.0f).row(0).resize();
        this.buttons.add(new IGuiElement[]{this.add, this.dupe, this.rename, this.remove});
        this.markContainer();
        this.add(new IGuiElement[]{this.sidebar, this.iconBar, this.editor});
        this.keys().register(IKey.lang((String)"mappet.gui.panels.keys.toggle_sidebar"), 49, () -> this.toggleSidebar.clickItself(GuiBase.getCurrent())).category(KEYS_CATEGORY);
    }

    private void copy() {
        NBTTagCompound tag = (NBTTagCompound)this.data.serializeNBT();
        tag.func_74768_a("_ContentType", this.getType().ordinal());
        GuiScreen.func_146275_d((String)tag.toString());
    }

    private void paste(NBTTagCompound tag) {
        AbstractData data = this.getType().getManager().create("", tag);
        this.addNewData(this.add, data);
    }

    private void toggleSidebar() {
        this.sidebar.toggleVisible();
        this.toggleSidebar.both(this.sidebar.isVisible() ? Icons.RIGHTLOAD : Icons.LEFTLOAD);
        if (this.sidebar.isVisible()) {
            this.toggleWithSidebar();
            this.iconBar.flex().relative(this.sidebar).x(-20);
        } else {
            this.toggleFull();
            this.iconBar.flex().relative((GuiElement)this).x(1.0f, -20);
        }
        this.resize();
    }

    protected void toggleWithSidebar() {
        this.editor.flex().wTo((IResizer)this.iconBar.area);
    }

    protected void toggleFull() {
        this.editor.flex().wTo((IResizer)this.iconBar.area);
    }

    public abstract ContentType getType();

    public abstract String getTitle();

    public void pickData(String id) {
        this.save();
        Dispatcher.sendToServer(new PacketContentRequestData(this.getType(), id));
    }

    protected void addNewData(GuiIconElement element) {
        this.addNewData(element, null);
    }

    protected void addNewData(GuiIconElement element, T data) {
        GuiModal.addFullModal((GuiElement)this.sidebar, () -> new GuiPromptModal(this.mc, IKey.lang((String)"mappet.gui.panels.modals.add"), name -> this.addNewData((String)name, data)).filename());
    }

    protected void addNewData(String name, T data) {
        if (!this.names.list.getList().contains(name)) {
            this.save();
            Dispatcher.sendToServer(new PacketContentData(this.getType(), name, data == null ? new NBTTagCompound() : (NBTTagCompound)data.serializeNBT()));
            this.names.list.add((Object)name);
            this.names.list.sort();
            this.names.list.setCurrentScroll((Object)name);
            if (data == null) {
                data = this.getType().getManager().create(name);
                this.fillDefaultData(data);
            } else {
                ((AbstractData)data).setId(name);
            }
            this.fill(data);
        }
    }

    protected void fillDefaultData(T data) {
    }

    protected void dupeData(GuiIconElement element) {
        GuiModal.addFullModal((GuiElement)this.sidebar, () -> {
            GuiPromptModal promptModal = new GuiPromptModal(this.mc, IKey.lang((String)"mappet.gui.panels.modals.dupe"), this::dupeData);
            return promptModal.setValue(((AbstractData)this.data).getId()).filename();
        });
    }

    protected void dupeData(String name) {
        if (this.data != null && !this.names.list.getList().contains(name)) {
            this.save();
            Dispatcher.sendToServer(new PacketContentData(this.getType(), name, (NBTTagCompound)this.data.serializeNBT()));
            this.names.list.add((Object)name);
            this.names.list.sort();
            this.names.list.setCurrentScroll((Object)name);
            AbstractData data = this.getType().getManager().create(name, (NBTTagCompound)this.data.serializeNBT());
            this.fill(data);
        }
    }

    protected void renameData(GuiIconElement element) {
        GuiModal.addFullModal((GuiElement)this.sidebar, () -> {
            GuiPromptModal promptModal = new GuiPromptModal(this.mc, IKey.lang((String)"mappet.gui.panels.modals.rename"), this::renameData);
            return promptModal.setValue(((AbstractData)this.data).getId()).filename();
        });
    }

    protected void renameData(String name) {
        if (this.data != null && !this.names.list.getList().contains(name)) {
            Dispatcher.sendToServer(new PacketContentData(this.getType(), ((AbstractData)this.data).getId(), (NBTTagCompound)this.data.serializeNBT()).rename(name));
            this.names.list.remove((Object)((AbstractData)this.data).getId());
            this.names.list.add((Object)name);
            this.names.list.sort();
            this.names.list.setCurrentScroll((Object)name);
            ((AbstractData)this.data).setId(name);
        }
    }

    protected void removeData(GuiIconElement element) {
        GuiModal.addFullModal((GuiElement)this.sidebar, () -> new GuiConfirmModal(this.mc, IKey.lang((String)"mappet.gui.panels.modals.remove"), this::removeData));
    }

    protected void removeData(boolean confirm) {
        if (this.data != null && confirm) {
            Dispatcher.sendToServer(new PacketContentData(this.getType(), ((AbstractData)this.data).getId(), null));
            this.names.list.remove((Object)((AbstractData)this.data).getId());
            this.names.list.sort();
            this.names.list.setCurrentScroll((Object)"");
            this.fill(null);
        }
    }

    public final void fill(T data) {
        this.fill(data, true);
    }

    public void fill(T data, boolean allowed) {
        this.data = data;
        this.allowed = allowed;
        this.editor.setEnabled(allowed);
        this.remove.setEnabled(allowed);
        this.rename.setEnabled(allowed);
    }

    public void fillNames(List<String> names) {
        String value = (String)this.names.list.getCurrentFirst();
        this.names.list.clear();
        this.names.list.add(names);
        this.names.list.sort();
        this.names.list.setCurrentScroll((Object)value);
    }

    protected GuiScrollElement createScrollEditor() {
        GuiScrollElement scrollEditor = new GuiScrollElement(this.mc);
        scrollEditor.flex().relative(this.editor).wh(1.0f, 1.0f).column(5).stretch().vertical().scroll().padding(10);
        return scrollEditor;
    }

    public void open() {
        super.open();
        this.update = true;
        this.save = true;
    }

    public void appear() {
        super.appear();
        if (this.update) {
            this.update = false;
            this.requestDataNames();
        }
        if (this.data != null) {
            Dispatcher.sendToServer(new PacketContentRequestData(this.getType(), ((AbstractData)this.data).getId()));
        }
    }

    public void requestDataNames() {
        Dispatcher.sendToServer(new PacketContentRequestNames(this.getType()));
    }

    public void disappear() {
        super.disappear();
        if (this.save) {
            this.save();
        }
    }

    public void close() {
        super.close();
        if (this.save) {
            this.save();
        }
    }

    public void save() {
        if (!this.update && this.data != null && this.editor.isEnabled()) {
            this.preSave();
            Dispatcher.sendToServer(new PacketContentData(this.getType(), ((AbstractData)this.data).getId(), (NBTTagCompound)this.data.serializeNBT()));
        }
    }

    protected void preSave() {
    }

    public void draw(GuiContext context) {
        this.iconBar.area.draw(0x77000000);
        GuiDraw.drawHorizontalGradientRect((int)(this.iconBar.area.x - 6), (int)this.iconBar.area.y, (int)this.iconBar.area.x, (int)this.iconBar.area.ey(), (int)0, (int)0x29000000);
        if (this.sidebar.isVisible()) {
            this.sidebar.area.draw(-1442840576);
        }
        super.draw(context);
        if (!this.editor.isEnabled() && this.data != null) {
            GuiDraw.drawLockedArea((GuiElement)this.editor);
        }
    }
}

