/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet.client.gui.panels;

import java.util.ArrayList;
import mchorse.mappet.api.misc.ServerSettings;
import mchorse.mappet.api.states.States;
import mchorse.mappet.api.triggers.Trigger;
import mchorse.mappet.client.gui.GuiMappetDashboard;
import mchorse.mappet.client.gui.events.GuiTriggerHotkeysOverlayPanel;
import mchorse.mappet.client.gui.states.GuiStatesEditor;
import mchorse.mappet.client.gui.triggers.GuiTriggerElement;
import mchorse.mappet.client.gui.utils.overlays.GuiOverlay;
import mchorse.mappet.client.gui.utils.overlays.GuiOverlayPanel;
import mchorse.mappet.client.gui.utils.overlays.GuiStringOverlayPanel;
import mchorse.mappet.client.gui.utils.text.GuiText;
import mchorse.mappet.network.Dispatcher;
import mchorse.mappet.network.common.content.PacketRequestServerSettings;
import mchorse.mappet.network.common.content.PacketRequestStates;
import mchorse.mappet.network.common.content.PacketServerSettings;
import mchorse.mappet.network.common.content.PacketStates;
import mchorse.mclib.client.gui.framework.GuiBase;
import mchorse.mclib.client.gui.framework.elements.GuiElement;
import mchorse.mclib.client.gui.framework.elements.GuiScrollElement;
import mchorse.mclib.client.gui.framework.elements.IGuiElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiIconElement;
import mchorse.mclib.client.gui.framework.elements.list.GuiLabelListElement;
import mchorse.mclib.client.gui.framework.elements.utils.GuiLabel;
import mchorse.mclib.client.gui.mclib.GuiAbstractDashboard;
import mchorse.mclib.client.gui.mclib.GuiDashboardPanel;
import mchorse.mclib.client.gui.utils.Elements;
import mchorse.mclib.client.gui.utils.Icons;
import mchorse.mclib.client.gui.utils.Label;
import mchorse.mclib.client.gui.utils.keys.IKey;
import mchorse.mclib.utils.Direction;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;

public class GuiServerSettingsPanel
extends GuiDashboardPanel<GuiMappetDashboard> {
    public GuiElement states;
    public GuiStatesEditor statesEditor;
    public GuiLabel statesTitle;
    public GuiIconElement statesSwitch;
    public GuiIconElement statesAdd;
    public GuiLabelListElement<String> triggers;
    public GuiTriggerElement trigger;
    public GuiIconElement hotkeys;
    public GuiScrollElement editor;
    private ServerSettings settings;
    private String lastTarget;
    private String lastTrigger = "player_chat";

    public GuiServerSettingsPanel(Minecraft mc, GuiMappetDashboard dashboard) {
        super(mc, (GuiAbstractDashboard)dashboard);
        this.states = new GuiElement(mc);
        this.states.flex().relative((GuiElement)this).wh(0.5f, 1.0f);
        this.statesEditor = new GuiStatesEditor(mc);
        this.statesEditor.flex().relative(this.states).y(25).w(1.0f).h(1.0f, -25);
        this.statesTitle = Elements.label((IKey)IKey.str((String)"")).anchor(0.0f, 0.5f).background();
        this.statesTitle.flex().relative(this.states).xy(10, 10).wh(120, 20);
        this.statesSwitch = new GuiIconElement(mc, Icons.SEARCH, this::openSearch);
        this.statesSwitch.flex().relative(this.states).x(1.0f, -50).y(10);
        this.statesAdd = new GuiIconElement(mc, Icons.ADD, this::addState);
        this.statesAdd.flex().relative(this.states).x(1.0f, -30).y(10);
        this.triggers = new GuiLabelListElement(mc, l -> this.fillTrigger((Label<String>)((Label)l.get(0)), false));
        this.triggers.background().flex().relative((GuiElement)this).x(0.5f, 10).y(35).w(0.5f, -20).h(96);
        this.trigger = new GuiTriggerElement(mc).onClose(this::updateCurrentTrigger);
        this.trigger.flex().relative((GuiElement)this).x(1.0f, -10).y(1.0f, -10).wh(120, 20).anchor(1.0f, 1.0f);
        this.editor = new GuiScrollElement(mc);
        this.editor.flex().relative((GuiElement)this).x(0.5f).y(131).w(0.5f).h(1.0f, -161).column(5).scroll().stretch().padding(10);
        this.hotkeys = new GuiIconElement(mc, Icons.DOWNLOAD, b -> this.openHotkeysEditor());
        this.hotkeys.tooltip(IKey.lang((String)"mappet.gui.settings.hotkeys"), Direction.LEFT);
        this.hotkeys.flex().relative((GuiElement)this).x(1.0f, -16).y(20).wh(20, 20).anchor(0.5f, 0.5f);
        GuiLabel triggers = Elements.label((IKey)IKey.lang((String)"mappet.gui.settings.title")).anchor(0.0f, 0.5f).background();
        triggers.flex().relative((GuiElement)this).x(0.5f, 10).y(10).wh(120, 20);
        this.states.add(new IGuiElement[]{this.statesTitle, this.statesSwitch, this.statesAdd, this.statesEditor});
        this.add(new IGuiElement[]{this.states, this.hotkeys, this.triggers, this.editor, this.trigger, triggers});
    }

    private void updateCurrentTrigger() {
        Trigger trigger = this.settings.registered.get(this.lastTrigger);
        ((Label)this.triggers.getCurrentFirst()).title = this.createTooltip(this.lastTrigger, trigger);
    }

    public IKey createTooltip(String key, Trigger trigger) {
        IKey title = IKey.lang((String)("mappet.gui.settings.triggers." + key));
        if (trigger.blocks.isEmpty()) {
            return title;
        }
        IKey count = IKey.str((String)(" \u00a77(\u00a76" + trigger.blocks.size() + "\u00a77)\u00a7r"));
        return IKey.comp((IKey[])new IKey[]{title, count});
    }

    private void openSearch(GuiIconElement element) {
        ArrayList<String> targets = new ArrayList<String>();
        targets.add("~");
        for (EntityPlayer player : this.mc.field_71441_e.field_73010_i) {
            targets.add(player.func_146103_bH().getName());
        }
        GuiStringOverlayPanel overlay = new GuiStringOverlayPanel(this.mc, IKey.lang((String)"mappet.gui.states.pick"), false, targets, target -> {
            if (target.isEmpty()) {
                return;
            }
            this.save();
            Dispatcher.sendToServer(new PacketRequestStates((String)target));
        });
        GuiOverlay.addOverlay(GuiBase.getCurrent(), (GuiOverlayPanel)overlay.set(this.lastTarget), 0.4f, 0.6f);
    }

    private void addState(GuiIconElement element) {
        this.statesEditor.addNew();
    }

    private void openHotkeysEditor() {
        GuiTriggerHotkeysOverlayPanel overlay = new GuiTriggerHotkeysOverlayPanel(this.mc, this.settings.hotkeys);
        GuiOverlay.addOverlay(GuiBase.getCurrent(), (GuiOverlayPanel)overlay, 0.5f, 0.7f);
    }

    public void fill(NBTTagCompound tag) {
        this.settings = new ServerSettings(null);
        this.settings.deserializeNBT(tag);
        this.triggers.clear();
        for (String key : this.settings.registered.keySet()) {
            this.triggers.add(this.createTooltip(key, this.settings.registered.get(key)), (Object)key);
        }
        this.triggers.sort();
        this.triggers.setCurrentValue((Object)this.lastTrigger);
        this.fillTrigger((Label<String>)((Label)this.triggers.getCurrentFirst()), true);
        this.resize();
    }

    private void fillTrigger(Label<String> trigger, boolean select) {
        this.editor.removeAll();
        this.editor.add((IGuiElement)new GuiText(this.mc).text(IKey.lang((String)("mappet.gui.settings.triggers.descriptions." + (String)trigger.value))));
        this.editor.add((IGuiElement)Elements.label((IKey)IKey.lang((String)"mappet.gui.settings.variables")).background().marginTop(16).marginBottom(8));
        this.editor.add((IGuiElement)new GuiText(this.mc).text(IKey.lang((String)("mappet.gui.settings.triggers.variables." + (String)trigger.value))));
        this.trigger.set(this.settings.registered.get(trigger.value));
        if (select) {
            this.triggers.setCurrentScroll(trigger);
        }
        this.lastTrigger = (String)trigger.value;
        this.resize();
    }

    public void fillStates(String target, NBTTagCompound data) {
        States states = new States();
        this.statesTitle.label = target.equals("~") ? IKey.lang((String)"mappet.gui.states.server") : IKey.format((String)"mappet.gui.states.player", (Object[])new Object[]{target});
        states.deserializeNBT(data);
        this.statesEditor.set(states);
        this.lastTarget = target;
    }

    public void save() {
        if (this.settings != null) {
            Dispatcher.sendToServer(new PacketServerSettings(this.settings.serializeNBT()));
        }
        if (this.statesEditor.get() != null) {
            Dispatcher.sendToServer(new PacketStates(this.lastTarget, this.statesEditor.get().serializeNBT()));
        }
    }

    public void appear() {
        super.appear();
        Dispatcher.sendToServer(new PacketRequestServerSettings());
        Dispatcher.sendToServer(new PacketRequestStates("~"));
    }

    public void disappear() {
        super.disappear();
        this.save();
    }

    public void close() {
        super.close();
        this.save();
        this.statesEditor.set(null);
    }
}

