/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet.client.gui.quests;

import java.util.List;
import mchorse.mappet.api.quests.rewards.IReward;
import mchorse.mappet.api.quests.rewards.ItemStackReward;
import mchorse.mappet.client.gui.quests.rewards.GuiItemStackReward;
import mchorse.mappet.client.gui.quests.rewards.GuiReward;
import mchorse.mclib.client.gui.framework.elements.GuiElement;
import mchorse.mclib.client.gui.framework.elements.IGuiElement;
import mchorse.mclib.client.gui.framework.elements.context.GuiSimpleContextMenu;
import mchorse.mclib.client.gui.utils.Icons;
import mchorse.mclib.client.gui.utils.keys.IKey;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;

public class GuiRewards
extends GuiElement {
    public List<IReward> rewards;

    public GuiRewards(Minecraft mc) {
        super(mc);
        this.flex().column(10).vertical().stretch();
    }

    public GuiSimpleContextMenu getAdds() {
        return new GuiSimpleContextMenu(Minecraft.func_71410_x()).action(Icons.ADD, IKey.lang((String)"mappet.gui.quests.rewards.context.add_item"), () -> this.addReward(new ItemStackReward(new ItemStack[0]), true));
    }

    private void addReward(IReward reward, boolean add) {
        GuiItemStackReward element = null;
        if (reward instanceof ItemStackReward) {
            element = new GuiItemStackReward(this.mc, (ItemStackReward)reward);
        }
        if (element != null) {
            this.add((IGuiElement)element);
            GuiItemStackReward finalElement = element;
            element.context(() -> new GuiSimpleContextMenu(Minecraft.func_71410_x()).action(Icons.REMOVE, IKey.lang((String)"mappet.gui.quests.rewards.context.remove"), () -> this.removeReward(finalElement), 0xFF0033));
            if (add) {
                this.rewards.add(reward);
                this.getParentContainer().resize();
            }
        }
    }

    private void removeReward(GuiReward element) {
        if (this.rewards.remove(element.reward)) {
            element.removeFromParent();
            this.getParentContainer().resize();
        }
    }

    public void set(List<IReward> rewards) {
        this.rewards = rewards;
        this.removeAll();
        for (IReward reward : this.rewards) {
            this.addReward(reward, false);
        }
        this.getParentContainer().resize();
    }
}

