/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet.client.gui.scripts;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import mchorse.mappet.client.gui.scripts.utils.HighlightedTextLine;
import mchorse.mappet.client.gui.scripts.utils.SyntaxHighlighter;
import mchorse.mappet.client.gui.scripts.utils.TextLineNumber;
import mchorse.mappet.client.gui.scripts.utils.TextSegment;
import mchorse.mappet.client.gui.utils.text.GuiMultiTextElement;
import mchorse.mappet.client.gui.utils.text.undo.TextEditUndo;
import mchorse.mappet.client.gui.utils.text.utils.Cursor;
import mchorse.mclib.client.gui.framework.elements.utils.GuiContext;
import mchorse.mclib.client.gui.framework.elements.utils.GuiDraw;
import mchorse.mclib.utils.ColorUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.init.SoundEvents;

public class GuiTextEditor
extends GuiMultiTextElement<HighlightedTextLine> {
    private SyntaxHighlighter highlighter;
    private int placements;
    private boolean lines = true;
    private List<TextLineNumber> numbers = new ArrayList<TextLineNumber>(40);
    private int lineNumber = 0;

    public GuiTextEditor(Minecraft mc, Consumer<String> callback) {
        super(mc, callback);
        this.highlighter = new SyntaxHighlighter();
    }

    @Override
    protected HighlightedTextLine createTextLine(String line) {
        return new HighlightedTextLine(line);
    }

    public GuiTextEditor disableLines() {
        this.lines = false;
        return this;
    }

    public SyntaxHighlighter getHighlighter() {
        return this.highlighter;
    }

    public void resetHighlight() {
        for (HighlightedTextLine textLine : this.text) {
            textLine.resetSegments();
        }
    }

    @Override
    public void setText(String text) {
        super.setText(text);
        this.resetHighlight();
    }

    @Override
    protected void recalculateSizes() {
        double power = Math.ceil(Math.log10(this.text.size() + 1));
        this.placements = (int)power * 6;
        super.recalculateSizes();
    }

    @Override
    protected void changedLine(int i) {
        String line = ((HighlightedTextLine)this.text.get((int)i)).text;
        if (line.contains("/*") || line.contains("*/")) {
            this.changedLineAfter(i);
        } else {
            super.changedLine(i);
            ((HighlightedTextLine)this.text.get(i)).resetSegments();
        }
    }

    @Override
    protected void changedLineAfter(int i) {
        super.changedLineAfter(i);
        while (i < this.text.size()) {
            ((HighlightedTextLine)this.text.get(i)).resetSegments();
            ++i;
        }
    }

    @Override
    protected String getFromChar(char typedChar) {
        if (this.wasDoubleInsert(typedChar, ')', '(') || this.wasDoubleInsert(typedChar, ']', '[') || this.wasDoubleInsert(typedChar, '}', '{') || this.wasDoubleInsert(typedChar, '\"', '\"') || this.wasDoubleInsert(typedChar, '\'', '\'')) {
            this.moveCursor(1, 0);
            this.playSound(SoundEvents.field_187845_fY);
            return "";
        }
        if (typedChar == '(') {
            return "()";
        }
        if (typedChar == '[') {
            return "[]";
        }
        if (typedChar == '{') {
            return "{}";
        }
        if (typedChar == '\"') {
            return "\"\"";
        }
        if (typedChar == '\'') {
            return "''";
        }
        return super.getFromChar(typedChar);
    }

    private boolean wasDoubleInsert(char input, char target, char supplementary) {
        if (input != target) {
            return false;
        }
        String line = ((HighlightedTextLine)this.text.get((int)this.cursor.line)).text;
        return line.length() >= 2 && this.cursor.offset > 0 && this.cursor.offset < line.length() && line.charAt(this.cursor.offset) == target && line.charAt(this.cursor.offset - 1) == supplementary;
    }

    @Override
    protected void keyNewLine(TextEditUndo undo) {
        String line = ((HighlightedTextLine)this.text.get((int)this.cursor.line)).text;
        boolean unwrap = line.length() >= 2 && this.cursor.offset > 0 && this.cursor.offset < line.length() && line.charAt(this.cursor.offset) == '}' && line.charAt(this.cursor.offset - 1) == '{';
        int indent = this.getIndent(line) + (unwrap ? 4 : 0);
        super.keyNewLine(undo);
        String margin = this.createIndent(indent);
        this.writeString(margin);
        this.cursor.offset = indent;
        undo.postText = undo.postText + margin;
        if (unwrap) {
            super.keyNewLine(undo);
            margin = this.createIndent(indent - 4);
            this.writeString(margin);
            --this.cursor.line;
            this.cursor.offset = indent;
            undo.postText = undo.postText + margin;
        }
    }

    @Override
    protected void keyBackspace(TextEditUndo undo, boolean ctrl) {
        String line = ((HighlightedTextLine)this.text.get((int)this.cursor.line)).text;
        if (!(line = this.cursor.start(line)).isEmpty() && line.trim().isEmpty()) {
            int offset = 4 - line.length() % 4;
            this.startSelecting();
            this.cursor.offset -= offset;
            String deleted = this.getSelectedText();
            this.deleteSelection();
            this.deselect();
            undo.text = deleted;
        } else {
            super.keyBackspace(undo, ctrl);
        }
    }

    @Override
    protected void keyTab(TextEditUndo undo) {
        if (this.isSelected()) {
            boolean shift = GuiScreen.func_146272_n();
            Cursor min = this.getMin();
            if (shift) {
                min.offset = Math.max(min.offset - 4, 0);
            }
            Cursor temp = new Cursor();
            List<String> splits = GuiMultiTextElement.splitNewlineString(this.getSelectedText());
            for (int i = 0; i < splits.size(); ++i) {
                if (shift) {
                    int indent = this.getIndent(splits.get(i));
                    splits.set(i, splits.get(i).substring(Math.min(indent, 4)));
                    continue;
                }
                splits.set(i, "    " + splits.get(i));
            }
            String result = String.join((CharSequence)"\n", splits);
            temp.copy(min);
            this.deleteSelection();
            this.writeString(result);
            this.getMin().set(min.line, splits.get(splits.size() - 1).length());
            min.copy(temp);
            if (!shift) {
                min.offset += 4;
            }
            undo.postText = result;
        } else {
            super.keyTab(undo);
        }
    }

    public int getIndent(int i) {
        if (this.hasLine(i)) {
            return this.getIndent(((HighlightedTextLine)this.text.get((int)i)).text);
        }
        return 0;
    }

    public int getIndent(String line) {
        for (int j = 0; j < line.length(); ++j) {
            char c = line.charAt(j);
            if (c == ' ') continue;
            return j;
        }
        return line.length();
    }

    public String createIndent(int i) {
        StringBuilder builder = new StringBuilder();
        while (i > 0) {
            builder.append(' ');
            --i;
        }
        return builder.toString();
    }

    @Override
    protected void drawTextLine(String line, int i, int j, int nx, int ny) {
        if (this.lines && j == 0) {
            String label = String.valueOf(i + 1);
            int x = this.area.x + 5 + this.placements - this.font.func_78256_a(label);
            if (this.lineNumber >= this.numbers.size()) {
                this.numbers.add(new TextLineNumber());
            }
            this.numbers.get(this.lineNumber).set(label, x, ny);
            ++this.lineNumber;
        }
        HighlightedTextLine textLine = (HighlightedTextLine)this.text.get(i);
        if (textLine.segments == null) {
            textLine.setSegments(this.highlighter.parse(this.font, this.text, textLine.text, i));
            if (textLine.wrappedLines != null) {
                textLine.calculateWrappedSegments(this.font);
            }
        }
        List<TextSegment> segments = textLine.segments;
        if (textLine.wrappedSegments != null) {
            List<TextSegment> list = segments = j < textLine.wrappedSegments.size() ? textLine.wrappedSegments.get(j) : null;
        }
        if (segments != null) {
            for (TextSegment segment : segments) {
                this.font.func_175065_a(segment.text, (float)nx, (float)ny, segment.color, this.highlighter.getStyle().shadow);
                nx += segment.width;
            }
        }
    }

    @Override
    protected int getShiftX() {
        return this.lines ? 10 + this.placements : 0;
    }

    @Override
    protected void drawBackground() {
        this.area.draw(-16777216 + ColorUtils.multiplyColor((int)this.highlighter.getStyle().background, (float)0.8f));
    }

    @Override
    protected void drawForeground(GuiContext context) {
        if (this.lines) {
            int x = this.area.x + this.getShiftX();
            Gui.func_73734_a((int)this.area.x, (int)this.area.y, (int)x, (int)this.area.ey(), (int)(-16777216 + this.highlighter.getStyle().background));
            for (TextLineNumber number : this.numbers) {
                if (!number.draw) break;
                this.font.func_78276_b(number.line, number.x, number.y, this.highlighter.getStyle().lineNumbers);
                number.draw = false;
            }
            this.lineNumber = 0;
            int a = (int)(Math.min((float)this.horizontal.scroll / 10.0f, 1.0f) * 68.0f);
            if (a > 0) {
                GuiDraw.drawHorizontalGradientRect((int)x, (int)this.area.y, (int)(x + 10), (int)this.area.ey(), (int)(a << 24), (int)0);
            }
        }
    }
}

