/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet.client.gui.utils;

import java.util.Collection;
import java.util.function.Consumer;
import mchorse.mappet.ClientProxy;
import mchorse.mappet.api.utils.ContentType;
import mchorse.mappet.api.utils.TargetMode;
import mchorse.mappet.client.gui.utils.overlays.GuiContentNamesOverlayPanel;
import mchorse.mappet.client.gui.utils.overlays.GuiOverlay;
import mchorse.mappet.client.gui.utils.overlays.GuiOverlayPanel;
import mchorse.mappet.client.gui.utils.overlays.GuiPromptOverlayPanel;
import mchorse.mclib.McLib;
import mchorse.mclib.client.InputRenderer;
import mchorse.mclib.client.gui.framework.GuiBase;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiCirculateElement;
import mchorse.mclib.client.gui.framework.elements.context.GuiSimpleContextMenu;
import mchorse.mclib.client.gui.framework.elements.input.GuiTextElement;
import mchorse.mclib.client.gui.framework.elements.utils.GuiContext;
import mchorse.mclib.client.gui.framework.elements.utils.GuiDraw;
import mchorse.mclib.client.gui.utils.Area;
import mchorse.mclib.client.gui.utils.Icons;
import mchorse.mclib.client.gui.utils.keys.IKey;
import mchorse.mclib.utils.ColorUtils;
import mchorse.mclib.utils.Interpolation;
import mchorse.mclib.utils.Interpolations;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.SoundEvent;

public class GuiMappetUtils {
    public static GuiTextElement fullWindowContext(GuiTextElement text, IKey title) {
        Minecraft mc = Minecraft.func_71410_x();
        text.context(() -> new GuiSimpleContextMenu(mc).action(Icons.EDIT, IKey.lang((String)"mappet.gui.overlays.text_fullscreen"), () -> {
            GuiPromptOverlayPanel panel = new GuiPromptOverlayPanel(mc, title, text);
            GuiOverlay overlay = new GuiOverlay(mc, panel);
            panel.flex().w(1.0f, -30).h(54);
            GuiOverlay.addOverlay(GuiBase.getCurrent(), overlay);
        }));
        return text;
    }

    public static void openPicker(ContentType type, String value, Consumer<String> callback) {
        ClientProxy.requestNames(type, names -> {
            GuiContentNamesOverlayPanel overlay = new GuiContentNamesOverlayPanel(Minecraft.func_71410_x(), type.getPickLabel(), type, (Collection<String>)names, callback);
            overlay.set(value);
            GuiOverlay.addOverlay(GuiBase.getCurrent(), (GuiOverlayPanel)overlay, 0.5f, 0.7f);
        });
    }

    public static void drawRightClickHere(GuiContext context, Area area) {
        int primary = McLib.primaryColor.get();
        double ticks = (double)((float)context.tick + context.partialTicks) % 80.0;
        double factor = Math.abs(ticks / 80.0 * 2.0 - 1.0);
        factor = Interpolation.EXP_INOUT.interpolate(0.0, 1.0, factor);
        double factor2 = Interpolations.envelope((double)ticks, (double)37.0, (double)40.0, (double)40.0, (double)43.0);
        factor2 = Interpolation.CUBIC_OUT.interpolate(0.0, 1.0, factor2);
        int offset = (int)(factor * 70.0 + factor2 * 2.0);
        GuiDraw.drawDropCircleShadow((int)area.mx(), (int)(area.my() + (int)(factor * 70.0)), (int)16, (int)0, (int)16, (int)(-2013265920 + primary), (int)primary);
        InputRenderer.renderMouseButtons((int)(area.mx() - 6), (int)(area.my() - 8 + offset), (int)0, (boolean)false, (factor2 > 0.0 ? 1 : 0) != 0, (boolean)false, (boolean)false);
        String label = I18n.func_135052_a((String)"mappet.gui.right_click", (Object[])new Object[0]);
        int w = (int)((float)area.w / 1.1f);
        int color = ColorUtils.multiplyColor((int)0x444444, (float)(1.0f - (float)factor));
        GuiDraw.drawMultiText((FontRenderer)context.font, (String)label, (int)(area.mx() - w / 2), (int)(area.my() - 20), (int)color, (int)w, (int)12, (float)0.5f, (float)1.0f);
        GuiDraw.drawVerticalGradientRect((int)area.x, (int)(area.my() + 20), (int)area.ex(), (int)(area.my() + 40), (int)0, (int)-16777216);
        Gui.func_73734_a((int)area.x, (int)(area.my() + 40), (int)area.ex(), (int)(area.my() + 90), (int)-16777216);
    }

    public static GuiCirculateElement createTargetCirculate(Minecraft mc, TargetMode defaultTarget, Consumer<TargetMode> callback) {
        GuiCirculateElement button = new GuiCirculateElement(mc, b -> {
            if (callback != null) {
                callback.accept(TargetMode.values()[b.getValue()]);
            }
        });
        for (TargetMode target : TargetMode.values()) {
            button.addLabel(IKey.lang((String)("mappet.gui.conditions.targets." + target.name().toLowerCase())));
        }
        button.setValue(defaultTarget.ordinal());
        return button;
    }

    public static void playSound(SoundEvent event) {
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)event, (float)1.0f));
    }
}

