/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet.client.gui.utils.graphics;

import mchorse.mappet.client.gui.utils.graphics.Graphic;
import mchorse.mclib.client.gui.framework.elements.utils.GuiDraw;
import mchorse.mclib.client.gui.utils.Area;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class GradientGraphic
extends Graphic {
    public int secondary;
    public boolean horizontal;

    public GradientGraphic() {
    }

    public GradientGraphic(int x, int y, int w, int h, int primary, int secondary, boolean horizontal) {
        this.pixels.set(x, y, w, h);
        this.primary = primary;
        this.secondary = secondary;
        this.horizontal = horizontal;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected void drawGraphic(Area area) {
        if (this.horizontal) {
            GuiDraw.drawHorizontalGradientRect((int)area.x, (int)area.y, (int)area.ex(), (int)area.ey(), (int)this.primary, (int)this.secondary);
        } else {
            GuiDraw.drawVerticalGradientRect((int)area.x, (int)area.y, (int)area.ex(), (int)area.ey(), (int)this.primary, (int)this.secondary);
        }
    }

    @Override
    public void serializeNBT(NBTTagCompound tag) {
        super.serializeNBT(tag);
        tag.func_74768_a("Secondary", this.secondary);
        tag.func_74757_a("Horizontal", this.horizontal);
    }

    @Override
    public void deserializeNBT(NBTTagCompound tag) {
        super.deserializeNBT(tag);
        this.secondary = tag.func_74762_e("Secondary");
        this.horizontal = tag.func_74767_n("Horizontal");
    }
}

