/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet.tile;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import mchorse.mappet.api.regions.Region;
import mchorse.mappet.capabilities.character.Character;
import mchorse.mappet.capabilities.character.ICharacter;
import mchorse.mappet.utils.PositionCache;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketEntityVelocity;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.mutable.MutableInt;

public class TileRegion
extends TileEntity
implements ITickable {
    public Region region = new Region();
    private Set<UUID> players = new HashSet<UUID>(10);
    private Map<UUID, MutableInt> delays = new HashMap<UUID, MutableInt>();
    private int tick;

    public void set(NBTTagCompound tag) {
        this.region = new Region();
        this.region.deserializeNBT(tag);
        this.func_70296_d();
    }

    public void func_73660_a() {
        int frequency;
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (!this.delays.isEmpty()) {
            this.checkDelays();
        }
        if (this.tick % (frequency = Math.max(this.region.update, 1)) == 0) {
            this.checkRegion();
        }
        ++this.tick;
    }

    private void checkDelays() {
        Iterator<Map.Entry<UUID, MutableInt>> it = this.delays.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<UUID, MutableInt> trigger = it.next();
            int delay = trigger.getValue().intValue();
            if (delay <= 0) {
                UUID id = trigger.getKey();
                EntityPlayer player = this.field_145850_b.func_152378_a(id);
                if (player != null) {
                    this.region.triggerEnter(player, this.func_174877_v());
                }
                it.remove();
            }
            trigger.getValue().setValue(delay - 1);
        }
    }

    private void checkRegion() {
        for (EntityPlayer player : this.field_145850_b.field_73010_i) {
            boolean enabled = this.region.isEnabled(player);
            if (!this.region.passable) {
                boolean bl = enabled = !enabled;
            }
            if (player.func_175149_v()) continue;
            UUID id = player.func_146103_bH().getId();
            boolean wasInside = this.players.contains(id);
            if (this.region.isPlayerInside(player, this.func_174877_v())) {
                if (!enabled) continue;
                if (!this.region.passable) {
                    this.handlePassing(player);
                    continue;
                }
                if (wasInside) continue;
                if (this.region.delay > 0) {
                    this.delays.put(id, new MutableInt(this.region.delay));
                } else {
                    this.region.triggerEnter(player, this.func_174877_v());
                }
                this.players.add(id);
                continue;
            }
            if (!wasInside) continue;
            if (this.delays.containsKey(id)) {
                this.delays.remove(id);
            } else {
                this.region.triggerExit(player, this.func_174877_v());
            }
            this.players.remove(id);
        }
    }

    private void handlePassing(EntityPlayer player) {
        ICharacter character = Character.get(player);
        Vec3d last = player.func_174791_d();
        if (character == null) {
            return;
        }
        PositionCache cache = character.getPositionCache();
        Vec3d vec = cache.lastPosition;
        if (vec != null && !this.region.isPlayerInside(vec.field_72450_a, vec.field_72448_b + (double)(player.field_70131_O / 2.0f), vec.field_72449_c, this.func_174877_v())) {
            this.teleportPlayer(player, vec, last);
            cache.resetLastPositionTimer();
            return;
        }
        vec = cache.lastLastPosition;
        if (vec != null && !this.region.isPlayerInside(vec.field_72450_a, vec.field_72448_b + (double)(player.field_70131_O / 2.0f), vec.field_72449_c, this.func_174877_v())) {
            this.teleportPlayer(player, vec, last);
            cache.resetLastPositionTimer();
            return;
        }
        if (vec == null) {
            return;
        }
        if ((vec = vec.func_178786_a(player.field_70165_t, player.field_70163_u, player.field_70161_v)).func_189985_c() > 0.0) {
            vec = vec.func_72432_b();
            vec = vec.func_186678_a(-0.5);
            double x = player.field_70165_t;
            double y = player.field_70163_u;
            double z = player.field_70161_v;
            while (this.region.isPlayerInside(player, this.func_174877_v())) {
                player.field_70165_t += vec.field_72450_a;
                player.field_70163_u += vec.field_72448_b;
                player.field_70161_v += vec.field_72449_c;
            }
            vec = new Vec3d(x, y, z);
            player.field_70165_t = x;
            player.field_70163_u = y;
            player.field_70161_v = z;
            this.teleportPlayer(player, vec, last);
        }
        cache.resetLastPositionTimer();
    }

    private void teleportPlayer(EntityPlayer player, Vec3d vec, Vec3d last) {
        player.func_70634_a(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
        Vec3d motion = last.func_178788_d(player.func_174791_d()).func_186678_a(-0.5);
        if (motion.func_72438_d(Vec3d.field_186680_a) < 0.25) {
            motion = motion.func_72432_b();
        }
        double y = Math.abs(motion.field_72448_b) < 0.01 ? 0.2 : motion.field_72448_b;
        ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)new SPacketEntityVelocity(player.func_145782_y(), motion.field_72450_a, y, motion.field_72449_c));
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        float range = 128.0f;
        return range * range;
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, this.func_145832_p(), this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        tag.func_74782_a("Region", (NBTBase)this.region.serializeNBT());
        return super.func_189515_b(tag);
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        if (tag.func_74764_b("Region")) {
            this.region.deserializeNBT(tag.func_74775_l("Region"));
        }
    }
}

