/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet.utils;

import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.lang.reflect.Method;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import mchorse.mappet.CommonProxy;
import org.apache.commons.io.FileUtils;

public class ScriptUtils {
    public static boolean copiedNashorn;
    public static boolean errorNashorn;
    private static ScriptEngineManager manager;

    public static ScriptEngine tryCreatingEngine() {
        for (String name : ImmutableSet.of((Object)"nashorn", (Object)"Nashorn", (Object)"javascript", (Object)"JavaScript", (Object)"js", (Object)"JS", (Object[])new String[]{"ecmascript", "ECMAScript"})) {
            ScriptEngine engine = ScriptUtils.getManager().getEngineByName(name);
            if (engine == null) continue;
            return engine;
        }
        try {
            Class<?> factoryClass = Class.forName("jdk.nashorn.api.scripting.NashornScriptEngineFactory");
            Object factory = factoryClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            Method getScriptEnging = factoryClass.getDeclaredMethod("getScriptEngine", new Class[0]);
            return (ScriptEngine)getScriptEnging.invoke(factory, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            ScriptUtils.tryCopyingNashorn();
            errorNashorn = true;
            return null;
        }
    }

    private static void tryCopyingNashorn() {
        if (copiedNashorn) {
            return;
        }
        File home = new File(System.getProperty("java.home"));
        File nashorn = new File(home, "lib/ext/nashorn.jar");
        File modsNashorn = new File(CommonProxy.configFolder.getParentFile(), "mods/nashorn.jar");
        if (nashorn.isFile() && !modsNashorn.isFile()) {
            try {
                FileUtils.copyFile((File)nashorn, (File)modsNashorn);
                copiedNashorn = true;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static ScriptEngineManager getManager() {
        try {
            if (manager == null) {
                manager = new ScriptEngineManager();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return manager;
    }

    public static ScriptEngine sanitize(ScriptEngine engine) {
        Bindings bindings = engine.getBindings(100);
        bindings.remove("load");
        bindings.remove("loadWithNewGlobal");
        bindings.remove("exit");
        bindings.remove("quit");
        return engine;
    }
}

