/*
 * Decompiled with CFR 0.152.
 */
package com.modularwarfare;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.google.gson.stream.JsonReader;
import com.modularwarfare.ModConfig;
import com.modularwarfare.common.CommonProxy;
import com.modularwarfare.common.MWTab;
import com.modularwarfare.common.armor.ItemMWArmor;
import com.modularwarfare.common.armor.ItemSpecialArmor;
import com.modularwarfare.common.backpacks.ItemBackpack;
import com.modularwarfare.common.entity.EntityBullet;
import com.modularwarfare.common.entity.debug.EntityDebugDot;
import com.modularwarfare.common.entity.decals.EntityBulletHole;
import com.modularwarfare.common.entity.decals.EntityShell;
import com.modularwarfare.common.entity.grenades.EntityGrenade;
import com.modularwarfare.common.entity.item.EntityItemLoot;
import com.modularwarfare.common.extra.ItemLight;
import com.modularwarfare.common.grenades.ItemGrenade;
import com.modularwarfare.common.guns.ItemAmmo;
import com.modularwarfare.common.guns.ItemAttachment;
import com.modularwarfare.common.guns.ItemBullet;
import com.modularwarfare.common.guns.ItemGun;
import com.modularwarfare.common.guns.ItemSpray;
import com.modularwarfare.common.handler.CommonEventHandler;
import com.modularwarfare.common.handler.GuiHandler;
import com.modularwarfare.common.handler.ServerTickHandler;
import com.modularwarfare.common.hitbox.playerdata.PlayerDataHandler;
import com.modularwarfare.common.network.NetworkHandler;
import com.modularwarfare.common.protector.ModularProtector;
import com.modularwarfare.common.type.BaseType;
import com.modularwarfare.common.type.ContentTypes;
import com.modularwarfare.common.type.TypeEntry;
import com.modularwarfare.utility.GSONUtils;
import com.modularwarfare.utility.ZipContentPack;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import net.lingala.zip4j.core.ZipFile;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.io.ZipInputStream;
import net.lingala.zip4j.model.FileHeader;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLConstructionEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.Logger;

@Mod(modid="modularwarfare", name="ModularWarfare", version="1.0.9f", acceptedMinecraftVersions="[1.12.2]")
public class ModularWarfare {
    public static final String MOD_NAME;
    public static List<File> contentPacks;
    public static HashMap<String, MWTab> MODS_TABS;
    public static PlayerDataHandler PLAYERHANDLER;
    public static HashMap<String, ZipContentPack> zipContentsPack;
    public static HashMap<String, ItemAttachment> attachmentTypes;
    public static HashMap<String, ItemGrenade> grenadeTypes;
    public static LinkedHashMap<String, ItemMWArmor> armorTypes;
    public static HashMap<String, ItemGun> gunTypes;
    public static Gson gson;
    private static final int[] lIIlllIll;
    public static File MOD_DIR;
    public static HashMap<String, ItemBullet> bulletTypes;
    public static final String MOD_VERSION;
    @SidedProxy(clientSide="com.modularwarfare.client.ClientProxy", serverSide="com.modularwarfare.common.CommonProxy")
    public static CommonProxy PROXY;
    public static boolean DEV_ENV;
    public static ArrayList<BaseType> baseTypes;
    public static final String MOD_ID;
    @Mod.Instance(value="modularwarfare")
    public static ModularWarfare INSTANCE;
    public static LinkedHashMap<String, ItemSpecialArmor> specialArmorTypes;
    public static HashMap<String, ItemSpray> sprayTypes;
    public static HashMap<String, ItemAmmo> ammoTypes;
    public static ModularProtector PROTECTOR;
    public static NetworkHandler NETWORK;
    public static HashMap<String, ItemBackpack> backpackTypes;
    public static Logger LOGGER;

    private static void getTypeFiles(List<File> contentPacks) {
        for (File file : contentPacks) {
            BaseType parsedType;
            JsonReader jsonReader;
            if (file.getName().contains("cache")) continue;
            if (file.isDirectory()) {
                for (TypeEntry type : ContentTypes.values) {
                    File subFolder = new File(file, "/" + type.name + "/");
                    if (!subFolder.exists()) continue;
                    File[] fileArray = subFolder.listFiles();
                    int n = fileArray.length;
                    for (int i = lIIlllIll[0]; i < n; ++i) {
                        File typeFile = fileArray[i];
                        try {
                            if (!typeFile.isFile()) continue;
                            jsonReader = new JsonReader((Reader)new FileReader(typeFile));
                            parsedType = (BaseType)GSONUtils.fromJson(gson, jsonReader, type.typeClass);
                            parsedType.id = type.id;
                            parsedType.contentPack = file.getName();
                            parsedType.isInDirectory = lIIlllIll[6];
                            baseTypes.add(parsedType);
                            continue;
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                }
                continue;
            }
            if (!zipContentsPack.containsKey(file.getName())) continue;
            for (FileHeader fileHeader : ModularWarfare.zipContentsPack.get((Object)file.getName()).fileHeaders) {
                for (TypeEntry type : ContentTypes.values) {
                    String typeName;
                    String zipName = fileHeader.getFileName();
                    if (!zipName.startsWith((typeName = type.toString()) + "/") || zipName.split(typeName + "/").length <= lIIlllIll[6] || zipName.split(typeName + "/")[lIIlllIll[6]].length() <= 0 || zipName.contains("render")) continue;
                    ZipInputStream stream = null;
                    try {
                        stream = zipContentsPack.get(file.getName()).getZipFile().getInputStream(fileHeader);
                        jsonReader = new JsonReader((Reader)new InputStreamReader(stream));
                        try {
                            parsedType = (BaseType)GSONUtils.fromJson(gson, jsonReader, type.typeClass);
                            parsedType.id = type.id;
                            parsedType.contentPack = file.getName();
                            parsedType.isInDirectory = lIIlllIll[0];
                            baseTypes.add(parsedType);
                        }
                        catch (JsonSyntaxException ex) {
                            LOGGER.warn("Detected an error in the file " + zipName);
                            LOGGER.warn(ex.getMessage());
                        }
                    }
                    catch (ZipException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    @Mod.EventHandler
    public void onPreInitialization(FMLPreInitializationEvent event) {
        LOGGER = event.getModLog();
        PROXY.preload();
        if (FMLCommonHandler.instance().getSide().isServer()) {
            MOD_DIR = new File(event.getModConfigurationDirectory().getParentFile(), "ModularWarfare");
            if (!MOD_DIR.exists()) {
                MOD_DIR.mkdir();
                LOGGER.info("Created ModularWarfare folder, it's recommended to install content packs.");
                LOGGER.info("As the mod itself doesn't come with any content.");
            }
            new ModConfig(new File(MOD_DIR, "mod_config.json"));
            DEV_ENV = ModConfig.INSTANCE.dev_mode;
            contentPacks = PROXY.getContentList();
        }
        ContentTypes.registerTypes();
        ModularWarfare.loadContentPacks(lIIlllIll[0]);
        PROXY.registerEventHandlers();
        MinecraftForge.EVENT_BUS.register((Object)new CommonEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public static void loadContentPacks(boolean reload) {
        ModularWarfare.loadContent();
        if (DEV_ENV) {
            PROXY.generateJsonModels(baseTypes);
        }
        for (BaseType baseType : baseTypes) {
            baseType.loadExtraValues();
            ContentTypes.values.get((int)baseType.id).typeAssignFunction.accept(baseType, reload);
        }
        if (DEV_ENV) {
            if (reload) {
                return;
            }
            PROXY.generateLangFiles(baseTypes, DEV_ENV);
        }
    }

    public static void loadContent() {
        Method method = null;
        try {
            Class[] classArray = new Class[lIIlllIll[6]];
            classArray[ModularWarfare.lIIlllIll[0]] = URL.class;
            method = URLClassLoader.class.getDeclaredMethod("addURL", classArray);
            method.setAccessible(lIIlllIll[6]);
        }
        catch (Exception e) {
            LOGGER.error("Failed to get class loader. All content loading will now fail.");
            e.printStackTrace();
        }
        for (File file : contentPacks) {
            if (!MODS_TABS.containsKey(file.getName())) {
                MODS_TABS.put(file.getName(), new MWTab(file.getName()));
            }
            if (!CommonProxy.zipJar.matcher(file.getName()).matches() || zipContentsPack.containsKey(file.getName())) continue;
            try {
                ZipFile zipFile = new ZipFile(file);
                if (zipFile.isEncrypted()) {
                    if (FMLCommonHandler.instance().getSide() == Side.CLIENT) {
                        PROTECTOR.applyPassword(zipFile, file.getName());
                    } else {
                        LOGGER.info("Can't use password protected content-pack on server-side.");
                    }
                }
                ZipContentPack zipContentPack = new ZipContentPack(file.getName(), zipFile.getFileHeaders(), zipFile);
                zipContentsPack.put(file.getName(), zipContentPack);
                LOGGER.info("Registered content pack");
            }
            catch (ZipException e) {
                e.printStackTrace();
            }
        }
        ModularWarfare.getTypeFiles(contentPacks);
    }

    public static <T> T getRenderConfig(BaseType baseType, Class<T> typeClass) {
        if (baseType.isInDirectory) {
            try {
                File contentPackDir = new File(MOD_DIR, baseType.contentPack);
                if (contentPackDir.exists() && contentPackDir.isDirectory()) {
                    File renderConfig = new File(contentPackDir, "/" + baseType.getAssetDir() + "/render");
                    File typeRender = new File(renderConfig, baseType.internalName + ".render.json");
                    JsonReader jsonReader = new JsonReader((Reader)new FileReader(typeRender));
                    return GSONUtils.fromJson(gson, jsonReader, typeClass);
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        } else if (zipContentsPack.containsKey(baseType.contentPack)) {
            String typeName = baseType.getAssetDir();
            FileHeader foundFile = ModularWarfare.zipContentsPack.get((Object)baseType.contentPack).fileHeaders.stream().filter(fileHeader -> (fileHeader.getFileName().startsWith(typeName + "/render/") && fileHeader.getFileName().replace(typeName + "/render/", "").equalsIgnoreCase(baseType.internalName + ".render.json") ? lIIlllIll[6] : lIIlllIll[0]) != 0).findFirst().orElse(null);
            if (foundFile != null) {
                try {
                    ZipInputStream stream = zipContentsPack.get(baseType.contentPack).getZipFile().getInputStream(foundFile);
                    JsonReader jsonReader = new JsonReader((Reader)new InputStreamReader(stream));
                    return GSONUtils.fromJson(gson, jsonReader, typeClass);
                }
                catch (ZipException e) {
                    e.printStackTrace();
                }
            } else {
                LOGGER.info(baseType.internalName + ".render.json not found. Aborting");
            }
        }
        return null;
    }

    @SubscribeEvent
    public void registerEntities(RegistryEvent.Register<EntityEntry> event) {
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("modularwarfare", "bullethole"), EntityBulletHole.class, (String)"bullethole", (int)lIIlllIll[1], (Object)this, (int)lIIlllIll[2], (int)lIIlllIll[3], (boolean)lIIlllIll[0]);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("modularwarfare", "shell"), EntityShell.class, (String)"shell", (int)lIIlllIll[4], (Object)this, (int)lIIlllIll[5], (int)lIIlllIll[6], (boolean)lIIlllIll[0]);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("modularwarfare", "debugdot"), EntityDebugDot.class, (String)"debugdot", (int)lIIlllIll[7], (Object)this, (int)lIIlllIll[5], (int)lIIlllIll[8], (boolean)lIIlllIll[0]);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("modularwarfare", "itemloot"), EntityItemLoot.class, (String)"itemloot", (int)lIIlllIll[9], (Object)this, (int)lIIlllIll[5], (int)lIIlllIll[6], (boolean)lIIlllIll[6]);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("modularwarfare", "grenade"), EntityGrenade.class, (String)"grenade", (int)lIIlllIll[10], (Object)this, (int)lIIlllIll[5], (int)lIIlllIll[6], (boolean)lIIlllIll[6]);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("modularwarfare", "bullet"), EntityBullet.class, (String)"bullet", (int)lIIlllIll[11], (Object)this, (int)lIIlllIll[5], (int)lIIlllIll[6], (boolean)lIIlllIll[6]);
    }

    @Mod.EventHandler
    public void onServerStarting(FMLServerStartingEvent event) {
    }

    @Mod.EventHandler
    public void onInitialization(FMLInitializationEvent event) {
        new ServerTickHandler();
        PROXY.load();
        NETWORK = new NetworkHandler();
        NETWORK.initialise();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)INSTANCE, (IGuiHandler)new GuiHandler());
    }

    static {
        ModularWarfare.lIllIlIl();
        MOD_VERSION = "1.0.9f";
        MOD_ID = "modularwarfare";
        MOD_NAME = "ModularWarfare";
        DEV_ENV = lIIlllIll[0];
        PLAYERHANDLER = new PlayerDataHandler();
        gson = new GsonBuilder().setPrettyPrinting().create();
        zipContentsPack = new HashMap();
        contentPacks = new ArrayList<File>();
        gunTypes = new HashMap();
        ammoTypes = new HashMap();
        attachmentTypes = new HashMap();
        armorTypes = new LinkedHashMap();
        specialArmorTypes = new LinkedHashMap();
        bulletTypes = new HashMap();
        sprayTypes = new HashMap();
        backpackTypes = new HashMap();
        grenadeTypes = new HashMap();
        baseTypes = new ArrayList();
        MODS_TABS = new HashMap();
    }

    @Mod.EventHandler
    public void constructionEvent(FMLConstructionEvent event) {
        if (FMLCommonHandler.instance().getSide() == Side.CLIENT) {
            PROTECTOR = new ModularProtector();
            PROXY.construction(event);
        }
    }

    @SubscribeEvent
    public void registerItems(RegistryEvent.Register<Item> event) {
        for (File file : contentPacks) {
            ArrayList<Item> tabOrder = new ArrayList<Item>();
            for (ItemGun itemGun : gunTypes.values()) {
                if (!itemGun.type.contentPack.equals(file.getName())) continue;
                event.getRegistry().register((IForgeRegistryEntry)itemGun);
                tabOrder.add(itemGun);
            }
            for (ItemAmmo itemAmmo : ammoTypes.values()) {
                if (!itemAmmo.type.contentPack.equals(file.getName())) continue;
                event.getRegistry().register((IForgeRegistryEntry)itemAmmo);
                tabOrder.add(itemAmmo);
            }
            for (ItemBullet itemBullet : bulletTypes.values()) {
                if (!itemBullet.type.contentPack.equals(file.getName())) continue;
                event.getRegistry().register((IForgeRegistryEntry)itemBullet);
                tabOrder.add(itemBullet);
            }
            for (ItemMWArmor itemArmor : armorTypes.values()) {
                if (!itemArmor.type.contentPack.equals(file.getName())) continue;
                event.getRegistry().register((IForgeRegistryEntry)itemArmor);
                tabOrder.add((Item)itemArmor);
            }
            for (ItemAttachment itemAttachment : attachmentTypes.values()) {
                if (!itemAttachment.type.contentPack.equals(file.getName())) continue;
                event.getRegistry().register((IForgeRegistryEntry)itemAttachment);
                tabOrder.add(itemAttachment);
            }
            for (ItemSpecialArmor itemSpecialArmor : specialArmorTypes.values()) {
                if (!itemSpecialArmor.type.contentPack.equals(file.getName())) continue;
                event.getRegistry().register((IForgeRegistryEntry)itemSpecialArmor);
                tabOrder.add(itemSpecialArmor);
            }
            for (ItemSpray itemSpray : sprayTypes.values()) {
                if (!itemSpray.type.contentPack.equals(file.getName())) continue;
                event.getRegistry().register((IForgeRegistryEntry)itemSpray);
                tabOrder.add(itemSpray);
            }
            for (ItemBackpack itemBackpack : backpackTypes.values()) {
                if (!itemBackpack.type.contentPack.equals(file.getName())) continue;
                event.getRegistry().register((IForgeRegistryEntry)itemBackpack);
                tabOrder.add(itemBackpack);
            }
            for (ItemGrenade itemGrenade : grenadeTypes.values()) {
                if (!itemGrenade.type.contentPack.equals(file.getName())) continue;
                event.getRegistry().register((IForgeRegistryEntry)itemGrenade);
                tabOrder.add(itemGrenade);
            }
            MODS_TABS.get(file.getName()).preInitialize(tabOrder);
        }
        event.getRegistry().register((IForgeRegistryEntry)new ItemLight("light"));
    }

    @Mod.EventHandler
    public void onPostInitialization(FMLPostInitializationEvent event) {
        NETWORK.postInitialise();
        PROXY.init();
    }

    private static void lIllIlIl() {
        lIIlllIll = new int[12];
        ModularWarfare.lIIlllIll[0] = (0xB ^ 0x7A ^ 72 + 1 - -23 + 31) & (47 + 133 - 13 + 2 ^ 153 + 60 - 121 + 75 ^ -" ".length());
        ModularWarfare.lIIlllIll[1] = "   ".length();
        ModularWarfare.lIIlllIll[2] = 0xEC ^ 0xBC;
        ModularWarfare.lIIlllIll[3] = 0x52 ^ 0x58;
        ModularWarfare.lIIlllIll[4] = 194 + 188 - 307 + 120 ^ 121 + 64 - 12 + 26;
        ModularWarfare.lIIlllIll[5] = 0x4C ^ 0xC;
        ModularWarfare.lIIlllIll[6] = " ".length();
        ModularWarfare.lIIlllIll[7] = 4 ^ 0x44 ^ (0xD4 ^ 0x91);
        ModularWarfare.lIIlllIll[8] = 2 ^ 0x37 ^ (0x6C ^ 0x6B);
        ModularWarfare.lIIlllIll[9] = 0xA3 ^ 0xA5;
        ModularWarfare.lIIlllIll[10] = 0x63 ^ 0x35 ^ (0xEC ^ 0xBD);
        ModularWarfare.lIIlllIll[11] = 0xC9 ^ 0xA3 ^ (0x59 ^ 0x3B);
    }
}

