/*
 * Decompiled with CFR 0.152.
 */
package com.modularwarfare.client.anim;

import com.modularwarfare.ModularWarfare;
import com.modularwarfare.api.WeaponAnimations;
import com.modularwarfare.client.anim.ReloadType;
import com.modularwarfare.client.anim.StateEntry;
import com.modularwarfare.client.anim.StateType;
import com.modularwarfare.client.input.KeyBindingDisable;
import com.modularwarfare.client.input.KeyBindingEnable;
import com.modularwarfare.client.model.ModelGun;
import com.modularwarfare.common.guns.GunType;
import com.modularwarfare.common.guns.ItemGun;
import com.modularwarfare.common.guns.WeaponSoundType;
import com.modularwarfare.common.guns.WeaponType;
import com.modularwarfare.common.network.PacketGunReloadSound;
import java.util.ArrayList;
import java.util.Optional;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;

public class AnimStateMachine {
    public int reloadAmmoCount;
    public boolean attachmentMode;
    private float reloadTime;
    private int shootStateIndex;
    public float reloadProgress = 0.0f;
    public float lastGunSlide = 0.0f;
    public float hammerRotation = 0.0f;
    public boolean isFired;
    public float gunRecoil = 0.0f;
    private float shootProgress = 0.0f;
    private StateEntry currentReloadState;
    public int bulletsToRender;
    public float revolverBarrelRotationPerShoot = 0.0f;
    public float lastGunRecoil = 0.0f;
    public boolean isGunEmpty;
    public ItemStack cachedAmmoStack;
    public boolean reloading = lIIIIlIlI[0];
    public int timeUntilPullback;
    private ArrayList<StateEntry> shootStateEntries;
    public float revolverBarrelRotation = 0.0f;
    public float gunPullback = -1.0f;
    private ArrayList<StateEntry> reloadStateEntries;
    public int flashInt;
    private int reloadStateIndex = lIIIIlIlI[0];
    public float gunSlide = 0.0f;
    private static final int[] lIIIIlIlI;
    private float shootTime;
    public boolean tiltHold = lIIIIlIlI[0];
    private StateEntry currentShootState;
    public boolean wasSprinting;
    public boolean hasPlayedReloadSound;
    public boolean shooting;
    private ReloadType reloadType;
    public int muzzleFlashTime;
    public float lastGunPullback = -1.0f;

    public boolean isReloadState(StateType stateType) {
        return (this.currentReloadState != null ? (this.currentReloadState.stateType == stateType ? lIIIIlIlI[1] : lIIIIlIlI[0]) : lIIIIlIlI[0]) != 0;
    }

    private ArrayList<StateEntry> adjustTiming(ArrayList<StateEntry> animEntries) {
        float currentTiming = 0.0f;
        float dividedAmount = 0.0f;
        float cutOffTime = 0.0f;
        for (StateEntry entry : animEntries) {
            currentTiming += entry.stateTime;
        }
        if (currentTiming < 1.0f) {
            dividedAmount = (1.0f - currentTiming) / (float)animEntries.size();
        }
        if (dividedAmount > 0.0f) {
            for (StateEntry entry : animEntries) {
                entry.stateTime += dividedAmount;
            }
        }
        for (StateEntry entry : animEntries) {
            entry.cutOffTime += (cutOffTime += entry.stateTime);
        }
        return animEntries;
    }

    public void triggerShoot(ModelGun model, GunType gunType, int fireTickDelay) {
        int result;
        Random r = new Random();
        this.gunRecoil = 1.0f;
        this.lastGunRecoil = 1.0f;
        this.gunSlide = 1.0f;
        this.lastGunSlide = 1.0f;
        this.hammerRotation = model.hammerAngle;
        if (gunType.weaponType == WeaponType.Revolver && gunType.internalAmmoStorage != null) {
            this.revolverBarrelRotationPerShoot = lIIIIlIlI[2] / gunType.internalAmmoStorage;
            this.revolverBarrelRotation += this.revolverBarrelRotationPerShoot;
        }
        this.timeUntilPullback = model.hammerDelay;
        this.muzzleFlashTime = lIIIIlIlI[3];
        int Low = lIIIIlIlI[1];
        int High = lIIIIlIlI[4];
        this.flashInt = result = r.nextInt(High - Low) + Low;
        ArrayList<StateEntry> animEntries = WeaponAnimations.getAnimation(model.config.extra.reloadAnimation).getShootStates(model, gunType);
        if (animEntries.size() > 0) {
            this.shootStateEntries = this.adjustTiming(animEntries);
            this.shooting = lIIIIlIlI[1];
            this.shootTime = fireTickDelay;
        }
    }

    public boolean isShootState(StateType stateType) {
        return (this.currentShootState != null ? (this.currentShootState.stateType == stateType ? lIIIIlIlI[1] : lIIIIlIlI[0]) : lIIIIlIlI[0]) != 0;
    }

    static {
        AnimStateMachine.lIIllIII();
    }

    public boolean isReloadType(ReloadType type) {
        return (this.reloadType != null && this.reloadType == type ? lIIIIlIlI[1] : lIIIIlIlI[0]) != 0;
    }

    public Optional<StateEntry> getReloadState() {
        return Optional.ofNullable(this.currentReloadState);
    }

    private Optional<StateEntry> getState(StateType stateType) {
        StateEntry stateEntry = null;
        if (this.reloadStateEntries == null) {
            return Optional.ofNullable(stateEntry);
        }
        for (StateEntry entry : this.reloadStateEntries) {
            if (entry.stateType != stateType) continue;
            stateEntry = entry;
            break;
        }
        return Optional.ofNullable(stateEntry);
    }

    public AnimStateMachine() {
        this.attachmentMode = lIIIIlIlI[0];
        this.shooting = lIIIIlIlI[0];
        this.shootStateIndex = lIIIIlIlI[0];
        this.timeUntilPullback = lIIIIlIlI[0];
        this.isFired = lIIIIlIlI[0];
        this.bulletsToRender = lIIIIlIlI[1];
        this.reloadAmmoCount = lIIIIlIlI[1];
        this.isGunEmpty = lIIIIlIlI[0];
        this.muzzleFlashTime = lIIIIlIlI[0];
        this.flashInt = lIIIIlIlI[0];
        this.hasPlayedReloadSound = lIIIIlIlI[0];
        this.wasSprinting = lIIIIlIlI[0];
    }

    public void onTickUpdate() {
        if (this.reloading) {
            AnimStateMachine.disableSprinting(lIIIIlIlI[1]);
            Minecraft.func_71410_x().field_71439_g.func_70031_b(lIIIIlIlI[0]);
            if (this.currentReloadState == null) {
                this.currentReloadState = this.reloadStateEntries.get(lIIIIlIlI[0]);
            }
            if (this.currentReloadState.stateType == StateType.Tilt) {
                this.tiltHold = lIIIIlIlI[1];
            }
            if (this.currentReloadState.stateType == StateType.Untilt) {
                this.tiltHold = lIIIIlIlI[0];
            }
            if (this.reloadProgress >= this.currentReloadState.cutOffTime && this.reloadStateIndex + lIIIIlIlI[1] < this.reloadStateEntries.size()) {
                this.reloadStateIndex += lIIIIlIlI[1];
                this.currentReloadState.finished = lIIIIlIlI[1];
                this.currentReloadState = this.reloadStateEntries.get(this.reloadStateIndex);
            }
            this.reloadProgress += 1.0f / this.reloadTime;
            if (this.reloadProgress >= 0.8f) {
                AnimStateMachine.disableSprinting(lIIIIlIlI[0]);
                Minecraft.func_71410_x().field_71439_g.func_70031_b(this.wasSprinting);
            }
            if (this.reloadProgress >= 1.0f) {
                this.isGunEmpty = lIIIIlIlI[0];
                this.reloading = lIIIIlIlI[0];
                this.reloadProgress = 0.0f;
                this.reloadStateEntries = null;
                this.currentReloadState = null;
                this.reloadStateIndex = lIIIIlIlI[0];
                this.reloadType = null;
            }
            if (!this.hasPlayedReloadSound) {
                ModularWarfare.NETWORK.sendToServer(new PacketGunReloadSound(WeaponSoundType.Load));
                this.hasPlayedReloadSound = lIIIIlIlI[1];
            }
        }
        if (this.shooting) {
            if (this.currentShootState == null) {
                this.currentShootState = this.shootStateEntries.get(lIIIIlIlI[0]);
            }
            if (this.shootProgress >= this.currentShootState.cutOffTime && this.shootStateIndex + lIIIIlIlI[1] < this.shootStateEntries.size()) {
                this.shootStateIndex += lIIIIlIlI[1];
                this.currentShootState.finished = lIIIIlIlI[1];
                this.currentShootState = this.shootStateEntries.get(this.shootStateIndex);
            }
            this.shootProgress += 1.0f / this.shootTime;
            if (this.shootProgress >= 1.0f) {
                this.shooting = lIIIIlIlI[0];
                this.shootProgress = 0.0f;
                this.shootStateEntries = null;
                this.currentShootState = null;
                this.shootStateIndex = lIIIIlIlI[0];
            }
        }
        this.lastGunSlide = this.gunSlide;
        if (this.isGunEmpty) {
            this.gunSlide = 0.5f;
            this.lastGunSlide = 0.5f;
        }
        if (!this.isGunEmpty && (double)this.gunSlide > 0.9) {
            this.gunSlide -= 0.1f;
        } else if (this.gunSlide > 0.0f && !this.isGunEmpty) {
            this.gunSlide *= 0.5f;
        }
        this.lastGunRecoil = this.gunRecoil;
        if (this.gunRecoil > 0.0f) {
            this.gunRecoil *= 0.5f;
        }
        if (this.isFired) {
            this.gunPullback += 0.5f;
            if (this.gunPullback >= 0.999f) {
                this.isFired = lIIIIlIlI[0];
            }
        }
        if (this.timeUntilPullback > 0) {
            this.timeUntilPullback -= lIIIIlIlI[1];
            if (this.timeUntilPullback == 0) {
                this.isFired = lIIIIlIlI[1];
                this.gunPullback = -1.0f;
                this.lastGunPullback = -1.0f;
            }
        } else {
            this.hammerRotation *= 0.6f;
        }
        if (this.muzzleFlashTime > 0) {
            this.muzzleFlashTime -= lIIIIlIlI[1];
        }
    }

    private static void lIIllIII() {
        lIIIIlIlI = new int[5];
        AnimStateMachine.lIIIIlIlI[0] = (0xE7 ^ 0xBB) & ~(8 ^ 0x54);
        AnimStateMachine.lIIIIlIlI[1] = " ".length();
        AnimStateMachine.lIIIIlIlI[2] = -(0xFFFFE7FF & 0x7C93) & (0xFFFFFFFA & 0x65FF);
        AnimStateMachine.lIIIIlIlI[3] = "  ".length();
        AnimStateMachine.lIIIIlIlI[4] = 138 + 57 - 176 + 139 ^ 87 + 111 - 125 + 79;
    }

    public void onRenderTickUpdate() {
        if (this.reloading && this.currentReloadState != null) {
            this.currentReloadState.onTick(this.reloadTime);
        }
        if (this.shooting && this.currentShootState != null) {
            this.currentShootState.onTick(this.shootTime);
        }
    }

    public Optional<StateEntry> getShootState() {
        return Optional.ofNullable(this.currentShootState);
    }

    public boolean shouldRenderAmmo() {
        if (this.reloading) {
            switch (1.$SwitchMap$com$modularwarfare$client$anim$ReloadType[this.reloadType.ordinal()]) {
                case 1: {
                    Optional<StateEntry> state = this.getState(StateType.Load);
                    return (state.isPresent() ? (state.get().currentValue < 1.0f ? lIIIIlIlI[1] : lIIIIlIlI[0]) : lIIIIlIlI[0]) != 0;
                }
                case 2: {
                    Optional<StateEntry> state = this.getState(StateType.Unload);
                    return (state.isPresent() ? (state.get().currentValue < 1.0f ? lIIIIlIlI[1] : lIIIIlIlI[0]) : lIIIIlIlI[0]) != 0;
                }
            }
        }
        return lIIIIlIlI[1];
    }

    public static void disableSprinting(boolean bool) {
        if (bool) {
            if (!(Minecraft.func_71410_x().field_71474_y.field_151444_V instanceof KeyBindingDisable)) {
                Minecraft.func_71410_x().field_71474_y.field_151444_V = new KeyBindingDisable(Minecraft.func_71410_x().field_71474_y.field_151444_V);
            }
        } else if (Minecraft.func_71410_x().field_71474_y.field_151444_V instanceof KeyBindingDisable) {
            Minecraft.func_71410_x().field_71474_y.field_151444_V = new KeyBindingEnable(Minecraft.func_71410_x().field_71474_y.field_151444_V);
        }
    }

    public void triggerReload(int reloadTime, int reloadCount, ModelGun model, ReloadType reloadType, boolean wasSprinting) {
        ArrayList<StateEntry> animEntries = WeaponAnimations.getAnimation(model.config.extra.reloadAnimation).getReloadStates(reloadType, reloadCount);
        this.reloadStateEntries = this.adjustTiming(animEntries);
        if (Minecraft.func_71410_x().field_71439_g.func_184582_a(EntityEquipmentSlot.MAINHAND) != null && Minecraft.func_71410_x().field_71439_g.func_184582_a(EntityEquipmentSlot.MAINHAND).func_77973_b() instanceof ItemGun) {
            ItemGun gun = (ItemGun)Minecraft.func_71410_x().field_71439_g.func_184582_a(EntityEquipmentSlot.MAINHAND).func_77973_b();
            if (gun.type.weaponType == WeaponType.Revolver && gun.type.internalAmmoStorage != null) {
                this.bulletsToRender = gun.type.internalAmmoStorage - reloadCount;
            }
        }
        this.reloadTime = reloadType != ReloadType.Full ? (float)reloadTime * 0.65f : (float)reloadTime;
        this.reloadType = reloadType;
        this.reloading = lIIIIlIlI[1];
        this.hasPlayedReloadSound = lIIIIlIlI[0];
        this.wasSprinting = wasSprinting;
    }
}

