/*
 * Decompiled with CFR 0.152.
 */
package com.modularwarfare.client.model;

import com.modularwarfare.common.vector.Vector3f;
import com.modularwarfare.utility.RayUtil;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public class InstantBulletRenderer {
    private static ArrayList<InstantShotTrail> trails;
    private static final int[] lI;
    private static TextureManager textureManager;

    private static void ll() {
        lI = new int[1];
        InstantBulletRenderer.lI[0] = " ".length();
    }

    public static void RenderAllTrails(float partialTicks) {
        for (InstantShotTrail trail : trails) {
            trail.Render(partialTicks);
        }
    }

    static {
        InstantBulletRenderer.ll();
        trails = new ArrayList();
    }

    public static void UpdateAllTrails() {
        for (int i = trails.size() - lI[0]; i >= 0; --i) {
            if (!trails.get(i).Update()) continue;
            trails.remove(i);
        }
    }

    public static void AddTrail(InstantShotTrail trail) {
        trails.add(trail);
    }

    public static class InstantShotTrail {
        private float distanceToTarget;
        private float bulletSpeed;
        private int ticksExisted = lllIIlII[0];
        private Vector3f hitPos;
        private float width;
        private ResourceLocation texture;
        private static final int[] lllIIlII;
        private float length;
        private Vector3f origin;

        private static void lIIIIIlI() {
            lllIIlII = new int[7];
            InstantShotTrail.lllIIlII[0] = ("   ".length() ^ (0xC1 ^ 0x82)) & (0x14 ^ 0x62 ^ (0x25 ^ 0x13) ^ -" ".length());
            InstantShotTrail.lllIIlII[1] = " ".length();
            InstantShotTrail.lllIIlII[2] = -(0xFFFFE07B & 0x7F86) & (0xFFFFEBE3 & Short.MAX_VALUE);
            InstantShotTrail.lllIIlII[3] = 0xFFFFFB57 & 0xFB8;
            InstantShotTrail.lllIIlII[4] = -(0xFFFFB96F & 0x57BD) & (0xFFFF9DFF & 0x7F7D);
            InstantShotTrail.lllIIlII[5] = -(0xFFFFFEF9 & 0x6F3F) & (0xFFFFFF7D & 0x7FBB);
            InstantShotTrail.lllIIlII[6] = "   ".length() ^ (3 ^ 7);
        }

        public boolean Update() {
            this.ticksExisted += lllIIlII[1];
            if (this.length > 0.0f) {
                this.length -= 0.05f;
            }
            return (float)this.ticksExisted * this.bulletSpeed >= this.distanceToTarget - this.length / 4.0f ? lllIIlII[1] : lllIIlII[0];
        }

        static {
            InstantShotTrail.lIIIIIlI();
        }

        public void Render(float partialTicks) {
            float x_ = OpenGlHelper.lastBrightnessX;
            float y_ = OpenGlHelper.lastBrightnessY;
            if (textureManager == null) {
                textureManager = Minecraft.func_71410_x().field_71446_o;
            }
            textureManager.func_110577_a(this.texture);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179094_E();
            Entity camera = Minecraft.func_71410_x().func_175606_aa();
            double x = camera.field_70142_S + (camera.field_70165_t - camera.field_70142_S) * (double)partialTicks;
            double y = camera.field_70137_T + (camera.field_70163_u - camera.field_70137_T) * (double)partialTicks;
            double z = camera.field_70136_U + (camera.field_70161_v - camera.field_70136_U) * (double)partialTicks;
            GL11.glTranslatef((float)(-((float)x)), (float)(-((float)y) + 0.1f), (float)(-((float)z)));
            float parametric = ((float)this.ticksExisted + partialTicks) * this.bulletSpeed;
            Vector3f dPos = Vector3f.sub(this.hitPos, this.origin, null);
            dPos.normalise();
            float startParametric = parametric - this.length * 0.5f;
            Vector3f startPos = new Vector3f(this.origin.x + dPos.x * startParametric, this.origin.y + dPos.y * startParametric, this.origin.z + dPos.z * startParametric);
            float endParametric = parametric + this.length * 0.5f;
            Vector3f endPos = new Vector3f(this.origin.x + dPos.x * endParametric, this.origin.y + dPos.y * endParametric, this.origin.z + dPos.z * endParametric);
            dPos.normalise();
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            Vector3f vectorToPlayer = new Vector3f(player.field_70165_t - (double)this.hitPos.x, player.field_70163_u - (double)this.hitPos.y, player.field_70161_v - (double)this.hitPos.z);
            vectorToPlayer.normalise();
            Vector3f trailTangent = Vector3f.cross(dPos, vectorToPlayer, null);
            trailTangent.normalise();
            trailTangent.scale(-this.width * 0.5f);
            Vector3f normal = Vector3f.cross(trailTangent, dPos, null);
            normal.normalise();
            GlStateManager.func_179091_B();
            GL11.glNormal3f((float)normal.x, (float)normal.y, (float)normal.z);
            GL11.glEnable((int)lllIIlII[2]);
            GL11.glEnable((int)lllIIlII[3]);
            GL11.glHint((int)lllIIlII[4], (int)lllIIlII[5]);
            Tessellator tessellator = Tessellator.func_178181_a();
            tessellator.func_178180_c().func_181668_a(lllIIlII[6], DefaultVertexFormats.field_181707_g);
            tessellator.func_178180_c().func_181662_b((double)(startPos.x + trailTangent.x), (double)(startPos.y + trailTangent.y), (double)(startPos.z + trailTangent.z)).func_187315_a(0.0, 0.0).func_181675_d();
            tessellator.func_178180_c().func_181662_b((double)(startPos.x - trailTangent.x), (double)(startPos.y - trailTangent.y), (double)(startPos.z - trailTangent.z)).func_187315_a(0.0, 1.0).func_181675_d();
            tessellator.func_178180_c().func_181662_b((double)(endPos.x - trailTangent.x), (double)(endPos.y - trailTangent.y), (double)(endPos.z - trailTangent.z)).func_187315_a(1.0, 1.0).func_181675_d();
            tessellator.func_178180_c().func_181662_b((double)(endPos.x + trailTangent.x), (double)(endPos.y + trailTangent.y), (double)(endPos.z + trailTangent.z)).func_187315_a(1.0, 0.0).func_181675_d();
            tessellator.func_78381_a();
            GL11.glDisable((int)lllIIlII[2]);
            GL11.glDisable((int)lllIIlII[3]);
            GlStateManager.func_179101_C();
            GlStateManager.func_179121_F();
        }

        public InstantShotTrail(Vector3f origin, Vector3f hitPos, float bulletSpeed, boolean isPunched) {
            this.bulletSpeed = bulletSpeed;
            this.origin = origin;
            this.hitPos = hitPos;
            this.length = 15.0f * new Random().nextFloat();
            if (!isPunched) {
                this.texture = new ResourceLocation("modularwarfare", "textures/skins/defaultbullettrail.png");
                this.width = 0.3f;
            } else {
                this.texture = new ResourceLocation("modularwarfare", "textures/skins/punchedbullettrail.png");
                this.width = 0.1f;
            }
            Vector3f dPos = Vector3f.sub(hitPos, origin, null);
            RayTraceResult result = RayUtil.rayTraceBlocks((World)Minecraft.func_71410_x().field_71441_e, origin.toVec3(), hitPos.toVec3(), lllIIlII[1], lllIIlII[1], lllIIlII[0]);
            if (result != null && result.field_72307_f != null) {
                dPos = Vector3f.sub(new Vector3f(result.field_72307_f), origin, null);
            }
            this.distanceToTarget = dPos.length();
            if (Math.abs(this.distanceToTarget) > 300.0f) {
                this.distanceToTarget = 300.0f;
            }
        }
    }
}

