/*
 * Decompiled with CFR 0.152.
 */
package com.modularwarfare.client.model.renders;

import com.modularwarfare.ModularWarfare;
import com.modularwarfare.api.GunBobbingEvent;
import com.modularwarfare.api.WeaponAnimation;
import com.modularwarfare.api.WeaponAnimations;
import com.modularwarfare.client.ClientProxy;
import com.modularwarfare.client.ClientRenderHooks;
import com.modularwarfare.client.anim.AnimStateMachine;
import com.modularwarfare.client.anim.ReloadType;
import com.modularwarfare.client.anim.StateEntry;
import com.modularwarfare.client.anim.StateType;
import com.modularwarfare.client.config.GunRenderConfig;
import com.modularwarfare.client.model.ModelAmmo;
import com.modularwarfare.client.model.ModelAttachment;
import com.modularwarfare.client.model.ModelBullet;
import com.modularwarfare.client.model.ModelCustomArmor;
import com.modularwarfare.client.model.ModelGun;
import com.modularwarfare.client.model.objects.BreakActionData;
import com.modularwarfare.client.model.objects.CustomItemRenderType;
import com.modularwarfare.client.model.objects.CustomItemRenderer;
import com.modularwarfare.client.model.objects.RenderVariables;
import com.modularwarfare.client.model.renders.RenderArms;
import com.modularwarfare.client.model.renders.RenderParameters;
import com.modularwarfare.client.scope.ScopeUtils;
import com.modularwarfare.common.armor.ItemMWArmor;
import com.modularwarfare.common.guns.AmmoType;
import com.modularwarfare.common.guns.AttachmentEnum;
import com.modularwarfare.common.guns.AttachmentType;
import com.modularwarfare.common.guns.GunType;
import com.modularwarfare.common.guns.ItemAmmo;
import com.modularwarfare.common.guns.ItemAttachment;
import com.modularwarfare.common.guns.ItemBullet;
import com.modularwarfare.common.guns.ItemGun;
import com.modularwarfare.common.guns.WeaponFireMode;
import com.modularwarfare.common.guns.WeaponScopeType;
import com.modularwarfare.common.guns.WeaponType;
import com.modularwarfare.common.network.PacketAimingRequest;
import com.modularwarfare.utility.ModUtil;
import com.modularwarfare.utility.OptifineHelper;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Timer;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.Vector3f;

public class RenderGunStatic
extends CustomItemRenderer {
    public static boolean isLightOn;
    private ItemStack light;
    public static float prevBobModifier;
    private float slowDiff;
    public int oldMagCount;
    private Timer timer;
    private static final int[] lIIIlIIlI;

    private void renderMovingArm(EntityPlayer player, ModelGun model, AnimStateMachine anim, Optional<StateEntry> currentState) {
        ItemStack itemStack;
        Minecraft mc = Minecraft.func_71410_x();
        mc.func_110434_K().func_110577_a(Minecraft.func_71410_x().field_71439_g.func_110306_p());
        Render render = Minecraft.func_71410_x().func_175598_ae().func_78713_a((Entity)Minecraft.func_71410_x().field_71439_g);
        RenderPlayer renderplayer = (RenderPlayer)render;
        int rightArm = model.config.arms.leftHandAmmo && model.config.arms.rightArm.armPos != null ? lIIIlIIlI[1] : lIIIlIIlI[4];
        String movingArmState = RenderGunStatic.getMovingArmState(model, anim);
        WeaponAnimation weaponAnimation = WeaponAnimations.getAnimation(model.config.extra.reloadAnimation);
        float tiltProgress = currentState.isPresent() ? (currentState.get().stateType == StateType.Tilt || currentState.get().stateType == StateType.Untilt ? currentState.get().currentValue : (anim.tiltHold ? 1.0f : 0.0f)) : 0.0f;
        Vector3f leftArmOffset = new Vector3f(0.0f, 0.0f, 0.0f);
        if (player.func_184614_ca() != null && player.func_184614_ca().func_77973_b() instanceof ItemGun && (itemStack = GunType.getAttachment(player.func_184614_ca(), AttachmentEnum.Grip)) != null && itemStack.func_77973_b() != Items.field_190931_a) {
            ItemAttachment itemAttachment = (ItemAttachment)itemStack.func_77973_b();
            leftArmOffset = ((ModelAttachment)itemAttachment.type.model).config.grip.leftArmOffset;
        }
        GL11.glPushMatrix();
        GL11.glScalef((float)(1.0f / model.config.extra.modelScale), (float)(1.0f / model.config.extra.modelScale), (float)(1.0f / model.config.extra.modelScale));
        GL11.glTranslatef((float)leftArmOffset.x, (float)leftArmOffset.y, (float)leftArmOffset.z);
        if (!model.config.arms.leftHandAmmo && model.config.arms.rightArm.armPos != null && model.config.arms.rightArm.armReloadPos != null) {
            GL11.glPushMatrix();
            if (movingArmState == "Pump") {
                RenderArms.renderArmPump(model, anim, RenderParameters.smoothing, model.config.arms.rightArm.armRot, model.config.arms.rightArm.armPos, model.config.arms.leftHandAmmo);
            } else if (movingArmState == "Bolt") {
                RenderArms.renderArmBolt(model, anim, RenderParameters.smoothing, model.config.arms.rightArm.armChargeRot, model.config.arms.rightArm.armChargePos, model.config.arms.leftHandAmmo);
            } else if (movingArmState == "Default") {
                GL11.glTranslatef((float)leftArmOffset.x, (float)leftArmOffset.y, (float)leftArmOffset.z);
                RenderArms.renderArmDefault(model, anim, RenderParameters.smoothing, model.config.arms.rightArm.armRot, model.config.arms.rightArm.armPos, lIIIlIIlI[1], model.config.arms.leftHandAmmo);
            } else if (movingArmState == "Load") {
                RenderArms.renderArmLoad(model, anim, weaponAnimation, RenderParameters.smoothing, tiltProgress, model.config.arms.rightArm.armReloadRot, model.config.arms.rightArm.armReloadPos, model.config.arms.rightArm.armRot, model.config.arms.rightArm.armPos, model.config.arms.leftHandAmmo);
            } else if (movingArmState == "Reload") {
                RenderArms.renderArmReload(model, anim, weaponAnimation, RenderParameters.smoothing, tiltProgress, model.config.arms.rightArm.armReloadRot, model.config.arms.rightArm.armReloadPos, model.config.arms.rightArm.armRot, model.config.arms.rightArm.armPos, model.config.arms.leftHandAmmo);
            }
            GL11.glScalef((float)model.config.arms.rightArm.armScale.x, (float)model.config.arms.rightArm.armScale.y, (float)model.config.arms.rightArm.armScale.z);
            renderplayer.func_177087_b().func_78087_a(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f, (Entity)player);
            renderplayer.func_177087_b().field_178723_h.field_82906_o = 0.0f;
            renderplayer.func_177138_b((AbstractClientPlayer)mc.field_71439_g);
            this.renderRightSleeve(player, (ModelBiped)renderplayer.func_177087_b());
            GL11.glPopMatrix();
        }
        if (model.config.arms.leftHandAmmo && model.config.arms.leftArm.armPos != null && model.config.arms.leftArm.armReloadPos != null) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)leftArmOffset.x, (float)leftArmOffset.y, (float)leftArmOffset.z);
            if (movingArmState == "Charge") {
                RenderArms.renderArmCharge(model, anim, RenderParameters.smoothing, model.config.arms.leftArm.armChargeRot, model.config.arms.leftArm.armChargePos, model.config.arms.leftArm.armRot, model.config.arms.leftArm.armPos, model.config.arms.leftHandAmmo);
            } else if (movingArmState == "Pump") {
                RenderArms.renderArmPump(model, anim, RenderParameters.smoothing, model.config.arms.leftArm.armRot, model.config.arms.leftArm.armPos, model.config.arms.leftHandAmmo);
            } else if (movingArmState == "Default") {
                GL11.glTranslatef((float)leftArmOffset.x, (float)leftArmOffset.y, (float)leftArmOffset.z);
                RenderArms.renderArmDefault(model, anim, RenderParameters.smoothing, model.config.arms.leftArm.armRot, model.config.arms.leftArm.armPos, lIIIlIIlI[4], model.config.arms.leftHandAmmo);
            } else if (movingArmState == "Load") {
                RenderArms.renderArmLoad(model, anim, weaponAnimation, RenderParameters.smoothing, tiltProgress, model.config.arms.leftArm.armReloadRot, model.config.arms.leftArm.armReloadPos, model.config.arms.leftArm.armRot, model.config.arms.leftArm.armPos, model.config.arms.leftHandAmmo);
            } else if (movingArmState == "Unload") {
                RenderArms.renderArmUnload(model, anim, weaponAnimation, RenderParameters.smoothing, tiltProgress, model.config.arms.leftArm.armReloadRot, model.config.arms.leftArm.armReloadPos, model.config.arms.leftArm.armRot, model.config.arms.leftArm.armPos, model.config.arms.leftHandAmmo);
            } else if (movingArmState == "Reload") {
                RenderArms.renderArmReload(model, anim, weaponAnimation, RenderParameters.smoothing, tiltProgress, model.config.arms.leftArm.armReloadRot, model.config.arms.leftArm.armReloadPos, model.config.arms.leftArm.armRot, model.config.arms.leftArm.armPos, model.config.arms.leftHandAmmo);
            }
            GL11.glScalef((float)model.config.arms.leftArm.armScale.x, (float)model.config.arms.leftArm.armScale.y, (float)model.config.arms.leftArm.armScale.z);
            renderplayer.func_177087_b().field_178724_i.field_82908_p = 0.0f;
            renderplayer.func_177139_c((AbstractClientPlayer)mc.field_71439_g);
            this.renderLeftSleeve(player, (ModelBiped)renderplayer.func_177087_b());
            GL11.glPopMatrix();
        }
        GL11.glPopMatrix();
    }

    public static String getMovingArmState(ModelGun model, AnimStateMachine anim) {
        float chargeCurrent;
        float pumpCurrent;
        WeaponAnimation wepAnim = WeaponAnimations.getAnimation(model.config.extra.reloadAnimation);
        Optional<StateEntry> currentShootState = anim.getShootState();
        Optional<StateEntry> currentReloadState = anim.getReloadState();
        float f = currentShootState.isPresent() ? (currentShootState.get().stateType == StateType.PumpOut || currentShootState.get().stateType == StateType.PumpIn ? currentShootState.get().currentValue : 1.0f) : (pumpCurrent = 1.0f);
        float f2 = currentReloadState.isPresent() ? (currentReloadState.get().stateType == StateType.Charge || currentReloadState.get().stateType == StateType.Uncharge ? currentReloadState.get().currentValue : 1.0f) : (chargeCurrent = 1.0f);
        if (!model.config.arms.leftHandAmmo) {
            if ((anim.isShootState(StateType.PumpIn) || anim.isShootState(StateType.PumpOut)) && (double)pumpCurrent < 0.9 && model.isType(GunRenderConfig.Arms.EnumArm.Right, GunRenderConfig.Arms.EnumAction.Charge) && pumpCurrent != -1.0f) {
                return "Pump";
            }
            if (anim.isReloadState(StateType.Charge) && (double)chargeCurrent < 0.9 && model.isType(GunRenderConfig.Arms.EnumArm.Right, GunRenderConfig.Arms.EnumAction.Bolt)) {
                return "Bolt";
            }
            if (!anim.reloading) {
                return "Default";
            }
            if (anim.isReloadState(StateType.Load)) {
                return "Load";
            }
            return "Reload";
        }
        if (anim.isReloadState(StateType.Charge) && model.isType(GunRenderConfig.Arms.EnumArm.Left, GunRenderConfig.Arms.EnumAction.Charge) && chargeCurrent != -1.0f) {
            return "Charge";
        }
        if ((anim.isShootState(StateType.PumpIn) || anim.isShootState(StateType.PumpOut)) && !anim.reloading && model.isType(GunRenderConfig.Arms.EnumArm.Left, GunRenderConfig.Arms.EnumAction.Pump)) {
            return "Pump";
        }
        if (!anim.reloading) {
            return "Default";
        }
        if (anim.isReloadState(StateType.Load)) {
            return "Load";
        }
        if (anim.isReloadState(StateType.Unload)) {
            return "Unload";
        }
        return "Reload";
    }

    private void renderStaticArm(EntityPlayer player, ModelGun model, AnimStateMachine anim, Optional<StateEntry> currentState) {
        Vector3f reloadArmPos;
        boolean rightArm;
        Minecraft mc = Minecraft.func_71410_x();
        mc.func_110434_K().func_110577_a(Minecraft.func_71410_x().field_71439_g.func_110306_p());
        Render render = Minecraft.func_71410_x().func_175598_ae().func_78713_a((Entity)Minecraft.func_71410_x().field_71439_g);
        RenderPlayer renderplayer = (RenderPlayer)render;
        float tiltProgress = currentState.isPresent() ? (currentState.get().stateType == StateType.Tilt || currentState.get().stateType == StateType.Untilt ? currentState.get().currentValue : (anim.tiltHold ? 1.0f : 0.0f)) : 0.0f;
        String staticArmState = RenderGunStatic.getStaticArmState(model, anim);
        GL11.glPushMatrix();
        boolean bl = rightArm = model.config.arms.leftHandAmmo && model.config.arms.rightArm.armPos != null ? lIIIlIIlI[1] : lIIIlIIlI[4];
        if (staticArmState == "ToFrom" && rightArm && model.config.arms.actionArm == GunRenderConfig.Arms.EnumArm.Left) {
            rightArm = lIIIlIIlI[4];
        }
        Vector3f armScale = rightArm ? model.config.arms.rightArm.armScale : model.config.arms.leftArm.armScale;
        Vector3f armRot = rightArm ? model.config.arms.rightArm.armRot : model.config.arms.leftArm.armRot;
        Vector3f armPos = rightArm ? model.config.arms.rightArm.armPos : model.config.arms.leftArm.armPos;
        Vector3f chargeArmRot = model.config.arms.actionArm == GunRenderConfig.Arms.EnumArm.Right ? model.config.arms.rightArm.armChargeRot : model.config.arms.leftArm.armChargeRot;
        Vector3f chargeArmPos = model.config.arms.actionArm == GunRenderConfig.Arms.EnumArm.Right ? model.config.arms.rightArm.armChargePos : model.config.arms.leftArm.armChargePos;
        Vector3f reloadArmRot = rightArm ? model.config.arms.rightArm.armReloadRot : model.config.arms.leftArm.armReloadRot;
        Vector3f vector3f = reloadArmPos = rightArm ? model.config.arms.rightArm.armReloadPos : model.config.arms.leftArm.armReloadPos;
        if (staticArmState == "Pump") {
            RenderArms.renderArmPump(model, anim, RenderParameters.smoothing, armRot, armPos, !model.config.arms.leftHandAmmo ? lIIIlIIlI[1] : lIIIlIIlI[4]);
        } else if (staticArmState == "Charge") {
            RenderArms.renderArmCharge(model, anim, RenderParameters.smoothing, chargeArmRot, chargeArmPos, armRot, armPos, !model.config.arms.leftHandAmmo ? lIIIlIIlI[1] : lIIIlIIlI[4]);
        } else if (staticArmState == "Bolt") {
            RenderArms.renderArmBolt(model, anim, RenderParameters.smoothing, chargeArmRot, chargeArmPos, !model.config.arms.leftHandAmmo ? lIIIlIIlI[1] : lIIIlIIlI[4]);
        } else if (staticArmState == "Default") {
            RenderArms.renderArmDefault(model, anim, RenderParameters.smoothing, armRot, armPos, rightArm, !model.config.arms.leftHandAmmo ? lIIIlIIlI[1] : lIIIlIIlI[4]);
        } else if (staticArmState == "Reload") {
            RenderArms.renderStaticArmReload(model, anim, RenderParameters.smoothing, tiltProgress, reloadArmRot, reloadArmPos, armRot, armPos, !model.config.arms.leftHandAmmo ? lIIIlIIlI[1] : lIIIlIIlI[4]);
        } else if (staticArmState == "ToFrom") {
            RenderArms.renderToFrom(model, anim, RenderParameters.smoothing, chargeArmRot, chargeArmPos, armRot, armPos, !model.config.arms.leftHandAmmo ? lIIIlIIlI[1] : lIIIlIIlI[4]);
        }
        GL11.glScalef((float)armScale.x, (float)armScale.y, (float)armScale.z);
        renderplayer.func_177087_b().func_78087_a(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f, (Entity)player);
        renderplayer.func_177087_b().field_178723_h.field_82906_o = 0.0f;
        if (rightArm) {
            renderplayer.func_177138_b((AbstractClientPlayer)Minecraft.func_71410_x().field_71439_g);
            this.renderRightSleeve(player, (ModelBiped)renderplayer.func_177087_b());
        } else {
            renderplayer.func_177139_c((AbstractClientPlayer)Minecraft.func_71410_x().field_71439_g);
            this.renderLeftSleeve(player, (ModelBiped)renderplayer.func_177087_b());
        }
        GL11.glPopMatrix();
    }

    @SideOnly(value=Side.CLIENT)
    private void renderWorldOntoScope(AttachmentType type, ModelAttachment modelAttachment) {
        ItemStack gunStack;
        GL11.glPushMatrix();
        if (isLightOn) {
            GlStateManager.func_179144_i((int)ScopeUtils.MIRROR_TEX);
            GL11.glDisable((int)lIIIlIIlI[6]);
            Minecraft.func_71410_x().field_71460_t.func_175072_h();
            ModelGun.glowOn(lIIIlIIlI[1]);
            modelAttachment.renderScope(0.0625f);
            ModelGun.glowOff();
            GL11.glEnable((int)lIIIlIIlI[6]);
            Minecraft.func_71410_x().field_71460_t.func_180436_i();
        } else {
            GlStateManager.func_179144_i((int)ScopeUtils.MIRROR_TEX);
            ModelGun.glowOn(lIIIlIIlI[1]);
            modelAttachment.renderScope(0.0625f);
            ModelGun.glowOff();
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71439_g.func_184582_a(EntityEquipmentSlot.MAINHAND) != null && mc.field_71474_y.field_74320_O == 0 && mc.field_71439_g.func_184582_a(EntityEquipmentSlot.MAINHAND).func_77973_b() instanceof ItemGun && GunType.getAttachment(gunStack = mc.field_71439_g.func_184582_a(EntityEquipmentSlot.MAINHAND), AttachmentEnum.Flashlight) != null && isLightOn) {
            GL11.glDisable((int)lIIIlIIlI[6]);
            Minecraft.func_71410_x().field_71460_t.func_175072_h();
            GL11.glDisable((int)lIIIlIIlI[7]);
            GL11.glPushMatrix();
            GL11.glPushAttrib((int)lIIIlIIlI[8]);
            GL11.glEnable((int)lIIIlIIlI[7]);
            GL11.glDepthMask((boolean)lIIIlIIlI[4]);
            GL11.glBlendFunc((int)lIIIlIIlI[9], (int)lIIIlIIlI[10]);
            renderEngine.func_110577_a(new ResourceLocation("modularwarfare", "textures/gui/light.png"));
            modelAttachment.renderOverlay(0.0625f);
            GL11.glBlendFunc((int)lIIIlIIlI[10], (int)lIIIlIIlI[12]);
            GL11.glDepthMask((boolean)lIIIlIIlI[1]);
            GL11.glDisable((int)lIIIlIIlI[7]);
            GL11.glPopAttrib();
            GL11.glPopMatrix();
            GL11.glEnable((int)lIIIlIIlI[6]);
            Minecraft.func_71410_x().field_71460_t.func_180436_i();
        }
        GL11.glPopMatrix();
    }

    public static String getStaticArmState(ModelGun model, AnimStateMachine anim) {
        float chargeCurrent;
        float pumpCurrent;
        Optional<StateEntry> currentShootState = anim.getShootState();
        Optional<StateEntry> currentReloadState = anim.getReloadState();
        float f = currentShootState.isPresent() ? (currentShootState.get().stateType == StateType.PumpOut || currentShootState.get().stateType == StateType.PumpIn ? currentShootState.get().currentValue : 1.0f) : (pumpCurrent = 1.0f);
        float f2 = currentReloadState.isPresent() ? (currentReloadState.get().stateType == StateType.Charge || currentReloadState.get().stateType == StateType.Uncharge ? currentReloadState.get().currentValue : 1.0f) : (currentShootState.isPresent() ? (currentShootState.get().stateType == StateType.Charge || currentShootState.get().stateType == StateType.Uncharge ? currentShootState.get().currentValue : 1.0f) : (chargeCurrent = 1.0f));
        if (model.config.arms.leftHandAmmo) {
            if (anim.isReloadState(StateType.MoveHands) || anim.isReloadState(StateType.ReturnHands)) {
                return "ToFrom";
            }
            if (anim.isShootState(StateType.MoveHands) || anim.isShootState(StateType.ReturnHands)) {
                return "ToFrom";
            }
            if (!anim.reloading && model.isType(GunRenderConfig.Arms.EnumArm.Right, GunRenderConfig.Arms.EnumAction.Pump)) {
                return "Pump";
            }
            if ((double)chargeCurrent < 0.66 && model.isType(GunRenderConfig.Arms.EnumArm.Right, GunRenderConfig.Arms.EnumAction.Charge) && chargeCurrent != -1.0f) {
                return "Charge";
            }
            if ((anim.isReloadState(StateType.Charge) || anim.isReloadState(StateType.Uncharge)) && model.isType(GunRenderConfig.Arms.EnumArm.Right, GunRenderConfig.Arms.EnumAction.Bolt)) {
                return "Bolt";
            }
            if ((anim.isShootState(StateType.Charge) || anim.isShootState(StateType.Uncharge)) && model.isType(GunRenderConfig.Arms.EnumArm.Right, GunRenderConfig.Arms.EnumAction.Bolt)) {
                return "Bolt";
            }
            if (!anim.reloading && !model.isType(GunRenderConfig.Arms.EnumArm.Right, GunRenderConfig.Arms.EnumAction.Pump)) {
                return "Default";
            }
            return "Reload";
        }
        if (!anim.reloading && model.isType(GunRenderConfig.Arms.EnumArm.Left, GunRenderConfig.Arms.EnumAction.Pump)) {
            return "Pump";
        }
        if ((double)chargeCurrent < 0.9 && model.isType(GunRenderConfig.Arms.EnumArm.Right, GunRenderConfig.Arms.EnumAction.Charge) && chargeCurrent != -1.0f) {
            return "Charge";
        }
        if ((double)chargeCurrent < 0.9 && model.isType(GunRenderConfig.Arms.EnumArm.Right, GunRenderConfig.Arms.EnumAction.Bolt)) {
            return "Bolt";
        }
        if (!anim.reloading && !model.isType(GunRenderConfig.Arms.EnumArm.Left, GunRenderConfig.Arms.EnumAction.Pump)) {
            return "Default";
        }
        return "Reload";
    }

    public void renderRightSleeve(EntityPlayer player, ModelBiped modelplayer) {
        ItemStack armorStack;
        if (player.field_71071_by.func_70440_f(lIIIlIIlI[0]) != null && (armorStack = player.field_71071_by.func_70440_f(lIIIlIIlI[0])).func_77973_b() instanceof ItemMWArmor) {
            ModelCustomArmor modelArmor = (ModelCustomArmor)((ItemMWArmor)armorStack.func_77973_b()).type.bipedModel;
            int skinId = lIIIlIIlI[4];
            String path = skinId > 0 ? ((ItemMWArmor)armorStack.func_77973_b()).type.modelSkins[skinId].getSkin() : ((ItemMWArmor)armorStack.func_77973_b()).type.modelSkins[lIIIlIIlI[4]].getSkin();
            this.bindTexture("armor", path);
            GL11.glPushMatrix();
            float modelScale = modelArmor.config.extra.modelScale;
            GL11.glScalef((float)modelScale, (float)modelScale, (float)modelScale);
            modelArmor.showChest(lIIIlIIlI[1]);
            modelArmor.renderRightArm((AbstractClientPlayer)player, modelplayer);
            GL11.glPopMatrix();
        }
    }

    private void renderGun(CustomItemRenderType renderType, ItemStack item, AnimStateMachine anim, GunType gunType, Object ... data) {
        Vector3f adjustedScale;
        int cachedUnload;
        float pumpCurrent;
        int isAmmoEmpty;
        float pumpLast;
        float pumpCurrent2;
        Minecraft mc = Minecraft.func_71410_x();
        ModelGun model = (ModelGun)gunType.model;
        float min = -1.5f;
        float max = 1.5f;
        float randomNum = new Random().nextFloat();
        float randomShake = min + randomNum * (max - min);
        Optional<StateEntry> currentReloadState = anim.getReloadState();
        Optional<StateEntry> currentShootState = anim.getShootState();
        float tiltProgress = currentReloadState.isPresent() ? (currentReloadState.get().stateType == StateType.Tilt || currentReloadState.get().stateType == StateType.Untilt ? currentReloadState.get().currentValue : (anim.tiltHold ? 1.0f : 0.0f)) : 0.0f;
        float worldScale = 0.0625f;
        if (renderEngine == null) {
            renderEngine = Minecraft.func_71410_x().field_71446_o;
        }
        if (model == null) {
            return;
        }
        GL11.glPushMatrix();
        switch (1.$SwitchMap$com$modularwarfare$client$model$objects$CustomItemRenderType[renderType.ordinal()]) {
            case 1: {
                GL11.glTranslatef((float)-0.5f, (float)-0.08f, (float)0.0f);
                GL11.glRotatef((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glTranslatef((float)(model.config.itemFrame.translate.x * worldScale), (float)(model.config.itemFrame.translate.y * worldScale), (float)(model.config.itemFrame.translate.z * worldScale));
                break;
            }
            case 2: {
                EntityLivingBase entityLivingBase = (EntityLivingBase)data[lIIIlIIlI[1]];
                float crouchOffset = entityLivingBase.func_70093_af() ? -0.18f : 0.0f;
                GL11.glRotatef((float)0.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glRotatef((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glTranslatef((float)0.25f, (float)0.0f, (float)-0.05f);
                GL11.glScalef((float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glScalef((float)model.config.thirdPerson.thirdPersonScale, (float)model.config.thirdPerson.thirdPersonScale, (float)model.config.thirdPerson.thirdPersonScale);
                GL11.glTranslatef((float)model.config.thirdPerson.thirdPersonOffset.x, (float)(model.config.thirdPerson.thirdPersonOffset.y + crouchOffset), (float)model.config.thirdPerson.thirdPersonOffset.z);
                break;
            }
            case 3: {
                EntityLivingBase entityLivingBase = (EntityLivingBase)data[lIIIlIIlI[1]];
                GL11.glScalef((float)model.config.thirdPerson.thirdPersonScale, (float)model.config.thirdPerson.thirdPersonScale, (float)model.config.thirdPerson.thirdPersonScale);
                GL11.glTranslatef((float)-0.32f, (float)1.3f, (float)-0.23f);
                GL11.glTranslatef((float)model.config.thirdPerson.backPersonOffset.x, (float)model.config.thirdPerson.backPersonOffset.y, (float)model.config.thirdPerson.backPersonOffset.z);
                if (entityLivingBase.func_70093_af()) {
                    GlStateManager.func_179114_b((float)20.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                    GlStateManager.func_179109_b((float)0.0f, (float)-0.3f, (float)-0.2f);
                }
                GL11.glRotatef((float)90.0f, (float)0.0f, (float)20.0f, (float)0.0f);
                GL11.glRotatef((float)270.0f, (float)0.0f, (float)0.0f, (float)-90.0f);
                GL11.glRotatef((float)90.0f, (float)20.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)20.0f, (float)0.0f, (float)0.0f, (float)20.0f);
                break;
            }
            case 4: {
                ItemAttachment attachmentSight;
                EntityLivingBase entityLivingBase = (EntityLivingBase)data[lIIIlIIlI[1]];
                float modelScale = model.config.extra.modelScale;
                float rotateX = 0.0f;
                float rotateY = 0.0f;
                float rotateZ = 0.0f;
                float translateX = 0.0f;
                float translateY = 0.0f;
                float translateZ = 0.0f;
                float crouchZoom = anim.reloading ? 0.0f : (anim.isReloadState(StateType.Charge) ? 0.0f : model.config.extra.crouchZoom);
                float hipRecover = RenderParameters.reloadSwitch;
                Vector3f customHipRotation = new Vector3f(model.config.aim.rotateHipPosition.x + model.config.sprint.sprintRotate.x * RenderParameters.sprintSwitch * hipRecover, model.config.aim.rotateHipPosition.y + model.config.sprint.sprintRotate.y * RenderParameters.sprintSwitch * hipRecover, model.config.aim.rotateHipPosition.z + model.config.sprint.sprintRotate.z * RenderParameters.sprintSwitch * hipRecover);
                Vector3f customHipTranslate = new Vector3f(model.config.aim.translateHipPosition.x + model.config.sprint.sprintTranslate.x * RenderParameters.sprintSwitch * hipRecover, model.config.aim.translateHipPosition.y + 0.04f + model.config.sprint.sprintTranslate.y * RenderParameters.sprintSwitch * hipRecover, model.config.aim.translateHipPosition.z - 0.15f + model.config.sprint.sprintTranslate.z * RenderParameters.sprintSwitch * hipRecover);
                Vector3f customAimRotation = new Vector3f(model.config.aim.rotateAimPosition.x, model.config.aim.rotateAimPosition.y, model.config.aim.rotateAimPosition.z);
                Vector3f customAimTranslate = new Vector3f(model.config.aim.translateAimPosition.x, model.config.aim.translateAimPosition.y, model.config.aim.translateAimPosition.z);
                AttachmentEnum[] attachmentEnumArray = AttachmentEnum.values();
                int n = attachmentEnumArray.length;
                for (int i = lIIIlIIlI[4]; i < n; ++i) {
                    AttachmentEnum attachment = attachmentEnumArray[i];
                    ItemStack itemStack = GunType.getAttachment(item, attachment);
                    if (itemStack == null || itemStack.func_77973_b() == Items.field_190931_a) continue;
                    AttachmentType attachmentType = ((ItemAttachment)itemStack.func_77973_b()).type;
                    if (attachmentType.attachmentType != AttachmentEnum.Sight || model.config.attachments.aimPointMap == null) continue;
                    for (String internalName : model.config.attachments.aimPointMap.keySet()) {
                        if (!internalName.equals(attachmentType.internalName)) continue;
                        Vector3f trans = model.config.attachments.aimPointMap.get(internalName).get(lIIIlIIlI[4]);
                        Vector3f rot = model.config.attachments.aimPointMap.get(internalName).get(lIIIlIIlI[1]);
                        customAimTranslate.translate(trans.x * worldScale, -trans.y * worldScale, -trans.z * worldScale);
                        customAimRotation.translate(rot.x, rot.y, rot.z);
                    }
                }
                RenderParameters.VAL = (float)(Math.sin(RenderParameters.SMOOTH_SWING / 100.0f) * 8.0);
                RenderParameters.VAL2 = (float)(Math.sin(RenderParameters.SMOOTH_SWING / 80.0f) * 8.0);
                RenderParameters.VALROT = (float)(Math.sin(RenderParameters.SMOOTH_SWING / 90.0f) * (double)1.2f);
                if (!anim.shooting) {
                    RenderParameters.VALSPRINT = (float)(Math.cos(RenderParameters.SMOOTH_SWING / 5.0f) * 5.0) * (0.95f - RenderParameters.adsSwitch) * gunType.moveSpeedModifier;
                }
                RenderParameters.adsSwitch = anim.reloading ? 0.0f : RenderParameters.adsSwitch;
                rotateX = 0.0f + customHipRotation.x - RenderParameters.VALROT * (0.95f - RenderParameters.adsSwitch) - (0.0f + customAimRotation.x + customHipRotation.x * RenderParameters.adsSwitch);
                rotateY = 46.0f + customHipRotation.y + RenderParameters.swayHorizontal - (1.0f + customAimRotation.y + customHipRotation.y + RenderParameters.swayHorizontal) * RenderParameters.adsSwitch;
                rotateZ = 1.0f + customHipRotation.z + RenderParameters.swayVertical - (1.0f + customAimRotation.z + customHipRotation.z + RenderParameters.swayVertical) * RenderParameters.adsSwitch;
                translateX = -1.3f + customHipTranslate.x - (0.0f + customAimTranslate.x + customHipTranslate.x) * RenderParameters.adsSwitch;
                translateY = 0.834f + customHipTranslate.y - RenderParameters.VAL / 500.0f * (0.95f - RenderParameters.adsSwitch) - (-0.064f + customAimTranslate.y + customHipTranslate.y) * RenderParameters.adsSwitch;
                translateZ = -1.05f + customHipTranslate.z - RenderParameters.VAL2 / 500.0f * (0.95f - RenderParameters.adsSwitch) - (0.35f + customAimTranslate.z + customHipTranslate.z) * RenderParameters.adsSwitch;
                if (this.timer == null) {
                    this.timer = (Timer)ReflectionHelper.getPrivateValue(Minecraft.class, (Object)mc, (String)"timer", (String)"field_71428_T");
                }
                float partialTicks = this.timer.field_194147_b;
                float bobModifier = !entityLivingBase.func_70051_ag() ? (RenderParameters.adsSwitch == 0.0f ? (!anim.reloading ? 0.7f : 0.2f) : 0.15f) : (!anim.reloading ? (RenderParameters.adsSwitch == 0.0f ? 0.75f : 0.15f) : 0.4f);
                float yawReducer = 1.0f;
                if (ClientRenderHooks.isAimingScope) {
                    bobModifier *= 0.5f;
                    yawReducer = 0.5f;
                }
                GunBobbingEvent event = new GunBobbingEvent(bobModifier);
                MinecraftForge.EVENT_BUS.post((Event)event);
                bobModifier = event.bobbing;
                EntityPlayer entityplayer = (EntityPlayer)Minecraft.func_71410_x().func_175606_aa();
                float f1 = (entityplayer.field_70140_Q - entityplayer.field_70141_P) * bobModifier;
                float f2 = -(entityplayer.field_70140_Q + f1 * partialTicks) * bobModifier;
                float f3 = (entityplayer.field_71107_bF + (entityplayer.field_71109_bG - entityplayer.field_71107_bF) * partialTicks) * bobModifier * yawReducer;
                float f4 = (entityplayer.field_70727_aS + (entityplayer.field_70726_aT - entityplayer.field_70727_aS) * partialTicks) * bobModifier;
                GlStateManager.func_179109_b((float)(MathHelper.func_76126_a((float)(f2 * (float)Math.PI)) * f3 * 0.5f * anim.reloadProgress), (float)(-Math.abs(MathHelper.func_76134_b((float)(f2 * (float)Math.PI)) * f3) * anim.reloadProgress), (float)0.0f);
                GlStateManager.func_179114_b((float)(MathHelper.func_76126_a((float)(f2 * (float)Math.PI)) * f3 * 3.0f), (float)0.0f, (float)0.0f, (float)1.0f);
                GlStateManager.func_179114_b((float)(Math.abs(MathHelper.func_76134_b((float)(f2 * (float)Math.PI - 0.2f)) * f3) * 5.0f), (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)f4, (float)1.0f, (float)0.0f, (float)0.0f);
                prevBobModifier = bobModifier;
                GL11.glRotatef((float)rotateX, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)rotateY, (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glRotatef((float)rotateZ, (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glTranslatef((float)(translateX + crouchZoom * RenderParameters.crouchSwitch), (float)0.0f, (float)0.0f);
                GL11.glTranslatef((float)0.0f, (float)translateY, (float)0.0f);
                GL11.glTranslatef((float)0.0f, (float)0.0f, (float)translateZ);
                if (!Minecraft.func_71410_x().field_71439_g.field_70122_E) {
                    RenderParameters.VALSPRINT *= 0.15f;
                }
                GL11.glRotatef((float)(Minecraft.func_71410_x().field_71439_g.func_70051_ag() ? RenderParameters.VALSPRINT : 0.0f), (float)1.0f, (float)1.0f, (float)-1.0f);
                Vector3f customAttachmentModeRotation = new Vector3f(model.config.attachments.attachmentModeRotate.x * RenderParameters.attachmentSwitch, model.config.attachments.attachmentModeRotate.y * RenderParameters.attachmentSwitch, model.config.attachments.attachmentModeRotate.z * RenderParameters.attachmentSwitch);
                GL11.glRotatef((float)customAttachmentModeRotation.x, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)customAttachmentModeRotation.y, (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glRotatef((float)customAttachmentModeRotation.z, (float)0.0f, (float)0.0f, (float)1.0f);
                float gunRotX = RenderParameters.GUN_ROT_X_LAST + (RenderParameters.GUN_ROT_X - RenderParameters.GUN_ROT_X_LAST) * partialTicks;
                float gunRotY = RenderParameters.GUN_ROT_Y_LAST + (RenderParameters.GUN_ROT_Y - RenderParameters.GUN_ROT_Y_LAST) * partialTicks;
                GL11.glRotatef((float)gunRotX, (float)0.0f, (float)-1.0f, (float)0.0f);
                GL11.glRotatef((float)gunRotY, (float)0.0f, (float)0.0f, (float)-1.0f);
                WeaponScopeType scopeType = gunType.scopeType;
                if (GunType.getAttachment(item, AttachmentEnum.Sight) != null && GunType.getAttachment(item, AttachmentEnum.Sight).func_77973_b() != null && (attachmentSight = (ItemAttachment)GunType.getAttachment(item, AttachmentEnum.Sight).func_77973_b()) != null && attachmentSight.type.sight.scopeType != WeaponScopeType.DEFAULT) {
                    scopeType = attachmentSight.type.sight.scopeType;
                }
                if (scopeType != WeaponScopeType.DEFAULT) {
                    if (RenderParameters.adsSwitch == 1.0f) {
                        if (scopeType != WeaponScopeType.REDDOT) {
                            GL11.glTranslatef((float)model.config.extra.gunOffsetScoping, (float)0.0f, (float)0.0f);
                        }
                        if (!ClientRenderHooks.isAimingScope) {
                            ClientRenderHooks.isAimingScope = lIIIlIIlI[1];
                            ModularWarfare.NETWORK.sendToServer(new PacketAimingRequest(entityplayer.getDisplayNameString(), lIIIlIIlI[1]));
                        }
                    } else if (ClientRenderHooks.isAimingScope) {
                        ClientRenderHooks.isAimingScope = lIIIlIIlI[4];
                        ModularWarfare.NETWORK.sendToServer(new PacketAimingRequest(entityplayer.getDisplayNameString(), lIIIlIIlI[4]));
                    }
                } else if (RenderParameters.adsSwitch == 1.0f) {
                    if (!ClientRenderHooks.isAiming) {
                        ClientRenderHooks.isAiming = lIIIlIIlI[1];
                        ModularWarfare.NETWORK.sendToServer(new PacketAimingRequest(entityplayer.getDisplayNameString(), lIIIlIIlI[1]));
                    }
                } else if (ClientRenderHooks.isAiming) {
                    ClientRenderHooks.isAiming = lIIIlIIlI[4];
                    ModularWarfare.NETWORK.sendToServer(new PacketAimingRequest(entityplayer.getDisplayNameString(), lIIIlIIlI[4]));
                }
                if (anim.reloading && WeaponAnimations.getAnimation(model.config.extra.reloadAnimation) != null) {
                    WeaponAnimations.getAnimation(model.config.extra.reloadAnimation).onGunAnimation(tiltProgress, anim);
                }
                GL11.glTranslatef((float)(-(anim.lastGunRecoil + (anim.gunRecoil - anim.lastGunRecoil) * RenderParameters.smoothing) * model.config.extra.modelRecoilBackwards), (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)((anim.lastGunRecoil + (anim.gunRecoil - anim.lastGunRecoil) * RenderParameters.smoothing) * model.config.extra.modelRecoilUpwards), (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glRotatef((float)((-anim.lastGunRecoil + (anim.gunRecoil - anim.lastGunRecoil) * RenderParameters.smoothing) * randomShake * model.config.extra.modelRecoilShake), (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glRotatef((float)((-anim.lastGunRecoil + (anim.gunRecoil - anim.lastGunRecoil) * RenderParameters.smoothing) * randomShake * model.config.extra.modelRecoilShake), (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glPushMatrix();
                GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                if (this.light == null) {
                    ClientProxy cfr_ignored_0 = (ClientProxy)ModularWarfare.PROXY;
                    this.light = new ItemStack((Item)ClientProxy.itemLight, lIIIlIIlI[1]);
                }
                IBakedModel lightmodel = Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178089_a(this.light);
                int lightVar = ModUtil.getBrightness((Entity)Minecraft.func_71410_x().field_71439_g);
                float wantedDiff = lIIIlIIlI[5] - lightVar;
                if (wantedDiff > this.slowDiff) {
                    this.slowDiff = Math.min(this.slowDiff + 0.1f, wantedDiff);
                }
                if (wantedDiff < this.slowDiff) {
                    this.slowDiff = Math.max(this.slowDiff - 0.1f, wantedDiff);
                }
                if (isLightOn && GunType.getAttachment(item, AttachmentEnum.Flashlight) != null) {
                    float alpha = 0.25f + this.slowDiff * 0.05f;
                    GL11.glDisable((int)lIIIlIIlI[6]);
                    Minecraft.func_71410_x().field_71460_t.func_175072_h();
                    GL11.glDisable((int)lIIIlIIlI[7]);
                    GL11.glPushMatrix();
                    GL11.glPushAttrib((int)lIIIlIIlI[8]);
                    GL11.glEnable((int)lIIIlIIlI[7]);
                    GL11.glDepthMask((boolean)lIIIlIIlI[4]);
                    GL11.glBlendFunc((int)lIIIlIIlI[9], (int)lIIIlIIlI[10]);
                    GlStateManager.func_179137_b((double)-0.33, (double)-0.33, (double)-3.0);
                    GlStateManager.func_179139_a((double)3.5, (double)3.5, (double)1.0);
                    ModUtil.renderLightModel(lightmodel, (int)(alpha * (this.slowDiff * 10.0f)));
                    ModUtil.renderLightModel(lightmodel, (int)(alpha * 255.0f));
                    if ((double)alpha > 0.9) {
                        ModUtil.renderLightModel(lightmodel, lIIIlIIlI[11]);
                    }
                    GL11.glBlendFunc((int)lIIIlIIlI[10], (int)lIIIlIIlI[12]);
                    GL11.glDepthMask((boolean)lIIIlIIlI[1]);
                    GL11.glDisable((int)lIIIlIIlI[7]);
                    GL11.glPopAttrib();
                    GL11.glPopMatrix();
                    GL11.glEnable((int)lIIIlIIlI[6]);
                    Minecraft.func_71410_x().field_71460_t.func_180436_i();
                }
                GL11.glPopMatrix();
                if (!(anim.gunRecoil > 0.1f) || !entityplayer.func_70051_ag()) break;
                RenderParameters.swayHorizontal = 0.0f;
                RenderParameters.swayVertical = 0.0f;
                RenderParameters.swayHorizontalEP = Float.valueOf(0.0f);
                RenderParameters.swayVerticalEP = Float.valueOf(0.0f);
                RenderParameters.reloadSwitch = 0.0f;
                RenderParameters.sprintSwitch = 0.0f;
                break;
            }
        }
        if (renderType == CustomItemRenderType.EQUIPPED_FIRST_PERSON && model.hasArms()) {
            this.renderStaticArm((EntityPlayer)mc.field_71439_g, model, anim, currentReloadState);
        }
        GL11.glPushMatrix();
        float modelScale = model.config.extra.modelScale;
        int skinId = lIIIlIIlI[4];
        if (item.func_77942_o() && item.func_77978_p().func_74764_b("skinId")) {
            skinId = item.func_77978_p().func_74762_e("skinId");
        }
        String path = skinId > 0 ? gunType.modelSkins[skinId].getSkin() : gunType.modelSkins[lIIIlIIlI[4]].getSkin();
        this.bindTexture("guns", path);
        GL11.glEnable((int)lIIIlIIlI[13]);
        GL11.glScalef((float)modelScale, (float)modelScale, (float)modelScale);
        GL11.glTranslatef((float)(3.0f * worldScale), (float)(5.37f * worldScale), (float)(0.01f * worldScale));
        GL11.glTranslatef((float)(model.config.extra.translateAll.x * worldScale), (float)(-model.config.extra.translateAll.y * worldScale), (float)(-model.config.extra.translateAll.z * worldScale));
        if (renderType == CustomItemRenderType.ENTITY && !(Minecraft.func_71410_x().field_71462_r instanceof GuiInventory)) {
            GlStateManager.func_179091_B();
            RenderHelper.func_74519_b();
            GlStateManager.func_179145_e();
            GlStateManager.func_179126_j();
        }
        model.renderPart("gunModel", worldScale);
        if (GunType.getAttachment(item, AttachmentEnum.Sight) == null && !model.config.attachments.scopeIsOnSlide) {
            model.renderPart("defaultScopeModel", worldScale);
        }
        model.renderPart("defaultBarrelModel", worldScale);
        model.renderPart("defaultStockModel", worldScale);
        model.renderPart("defaultGripModel", worldScale);
        model.renderPart("defaultGadgetModel", worldScale);
        Object pumpAttachment = null;
        if (pumpAttachment == null) {
            int isAmmoEmpty2;
            GL11.glPushMatrix();
            float f = currentShootState.isPresent() ? (currentShootState.get().stateType == StateType.PumpOut || currentShootState.get().stateType == StateType.PumpIn ? currentShootState.get().currentValue : 1.0f) : (pumpCurrent2 = 1.0f);
            pumpLast = currentShootState.isPresent() ? (currentShootState.get().stateType == StateType.PumpOut || currentShootState.get().stateType == StateType.PumpIn ? currentShootState.get().lastValue : 1.0f) : 1.0f;
            int n = isAmmoEmpty2 = !ItemGun.hasNextShot(item) ? lIIIlIIlI[1] : lIIIlIIlI[4];
            if (model.config.arms.actionType == GunRenderConfig.Arms.EnumAction.Bolt) {
                if (anim.isReloadState(StateType.Uncharge) || anim.isReloadState(StateType.Charge)) {
                    StateEntry boltState = anim.getReloadState().get();
                    pumpCurrent2 = boltState.currentValue;
                    pumpLast = boltState.lastValue;
                }
                if (anim.isShootState(StateType.Charge) && isAmmoEmpty2 == 0 || anim.isShootState(StateType.Uncharge)) {
                    StateEntry boltState = anim.getShootState().get();
                    pumpCurrent2 = boltState.currentValue;
                    pumpLast = boltState.lastValue;
                }
                if ((isAmmoEmpty2 != 0 || anim.reloading) && !anim.isReloadState(StateType.Uncharge)) {
                    GL11.glTranslatef((float)(-model.config.extra.gunSlideDistance), (float)0.0f, (float)0.0f);
                }
                GL11.glTranslatef((float)model.config.bolt.boltRotationPoint.x, (float)model.config.bolt.boltRotationPoint.y, (float)model.config.bolt.boltRotationPoint.z);
                GL11.glRotatef((float)(model.config.bolt.boltRotation * (1.0f - Math.abs(pumpLast + (pumpCurrent2 - pumpLast) * RenderParameters.smoothing))), (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glTranslatef((float)(-model.config.bolt.boltRotationPoint.x), (float)(-model.config.bolt.boltRotationPoint.y), (float)(-model.config.bolt.boltRotationPoint.z));
            }
            GL11.glTranslatef((float)(-(1.0f - Math.abs(pumpLast + (pumpCurrent2 - pumpLast) * RenderParameters.smoothing)) * model.config.bolt.pumpHandleDistance), (float)0.0f, (float)0.0f);
            if (gunType.weaponType == WeaponType.DMR && !anim.isGunEmpty) {
                GL11.glTranslatef((float)(-(anim.lastGunSlide + (anim.gunSlide - anim.lastGunSlide) * RenderParameters.smoothing) * model.config.extra.gunSlideDistance), (float)0.0f, (float)0.0f);
            }
            if (model.config.arms.actionType == GunRenderConfig.Arms.EnumAction.Bolt) {
                model.renderPart("boltModel", worldScale);
            }
            model.renderPart("pumpModel", worldScale);
            GL11.glPopMatrix();
        }
        if (model.config.extra.chargeHandleDistance != 0.0f && gunType.weaponType == WeaponType.Shotgun) {
            GL11.glPushMatrix();
            float f = currentShootState.isPresent() ? (currentShootState.get().stateType == StateType.PumpOut || currentShootState.get().stateType == StateType.PumpIn ? currentShootState.get().currentValue : 1.0f) : (pumpCurrent2 = 1.0f);
            pumpLast = currentShootState.isPresent() ? (currentShootState.get().stateType == StateType.PumpOut || currentShootState.get().stateType == StateType.PumpIn ? currentShootState.get().lastValue : 1.0f) : 1.0f;
            GL11.glTranslatef((float)(-(1.0f - Math.abs(pumpLast + (pumpCurrent2 - pumpLast) * RenderParameters.smoothing)) * model.config.extra.chargeHandleDistance), (float)0.0f, (float)0.0f);
            model.renderPart("chargeModel", worldScale);
            GL11.glPopMatrix();
        }
        if (GunType.getAttachment(item, AttachmentEnum.Slide) == null) {
            float lastCharge;
            float currentCharge;
            float f = currentReloadState.isPresent() ? (currentReloadState.get().stateType == StateType.Charge || currentReloadState.get().stateType == StateType.Uncharge ? currentReloadState.get().currentValue : 1.0f) : (currentCharge = 1.0f);
            float f2 = currentReloadState.isPresent() ? (currentReloadState.get().stateType == StateType.Charge || currentReloadState.get().stateType == StateType.Uncharge ? currentReloadState.get().lastValue : 1.0f) : (lastCharge = 1.0f);
            if (model.config.extra.needExtraChargeModel) {
                GL11.glPushMatrix();
                GL11.glTranslatef((float)(-(1.0f - Math.abs(lastCharge + (currentCharge - lastCharge) * RenderParameters.smoothing)) * model.config.extra.chargeHandleDistance), (float)0.0f, (float)0.0f);
                model.renderPart("chargeModel", worldScale);
                GL11.glPopMatrix();
            }
            GL11.glPushMatrix();
            GL11.glPushMatrix();
            if (!anim.isGunEmpty) {
                GL11.glTranslatef((float)(-(anim.lastGunSlide + (anim.gunSlide - anim.lastGunSlide) * RenderParameters.smoothing) * model.config.extra.gunSlideDistance), (float)0.0f, (float)0.0f);
            } else {
                GL11.glTranslatef((float)(-model.config.extra.gunSlideDistance), (float)0.0f, (float)0.0f);
            }
            GL11.glTranslatef((float)(-(1.0f - Math.abs(lastCharge + (currentCharge - lastCharge) * RenderParameters.smoothing)) * model.config.extra.chargeHandleDistance), (float)0.0f, (float)0.0f);
            model.renderPart("slideModel", worldScale);
            GL11.glPopMatrix();
            if (GunType.getAttachment(item, AttachmentEnum.Sight) == null && model.config.attachments.scopeIsOnSlide) {
                model.renderPart("defaultScopeModel", worldScale);
            }
            if (model.switchIsOnSlide) {
                GL11.glPushMatrix();
                WeaponFireMode fireMode = GunType.getFireMode(item);
                float switchAngle = fireMode == WeaponFireMode.SEMI ? model.switchSemiRot : (fireMode == WeaponFireMode.FULL ? model.switchAutoRot : (fireMode == WeaponFireMode.BURST ? model.switchBurstRot : 0.0f));
                GL11.glTranslatef((float)model.switchRotationPoint.x, (float)model.switchRotationPoint.y, (float)model.switchRotationPoint.z);
                GL11.glRotatef((float)switchAngle, (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glTranslatef((float)(-model.switchRotationPoint.x), (float)(-model.switchRotationPoint.y), (float)(-model.switchRotationPoint.z));
                model.renderPart("switchModel", worldScale);
                GL11.glPopMatrix();
            }
            GL11.glPopMatrix();
        }
        for (BreakActionData breakAction : model.config.breakAction.breakActions) {
            float breakProgress = currentReloadState.isPresent() ? (currentReloadState.get().stateType == StateType.Tilt || currentReloadState.get().stateType == StateType.Untilt ? currentReloadState.get().currentValue : (anim.tiltHold ? 1.0f : 0.0f)) : 0.0f;
            GL11.glPushMatrix();
            GL11.glTranslatef((float)breakAction.breakPoint.x, (float)breakAction.breakPoint.y, (float)breakAction.breakPoint.z);
            GL11.glRotatef((float)(breakProgress * -breakAction.angle), (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glTranslatef((float)(-breakAction.breakPoint.x), (float)(-breakAction.breakPoint.y), (float)(-breakAction.breakPoint.z));
            model.renderPart(breakAction.modelName, worldScale);
            if (GunType.getAttachment(item, AttachmentEnum.Sight) == null && model.config.breakAction.scopeIsOnBreakAction && breakAction.scopePart) {
                model.renderPart("defaultScopeModel", worldScale);
            }
            GL11.glPopMatrix();
        }
        int n = isAmmoEmpty = !ItemGun.hasNextShot(item) ? lIIIlIIlI[1] : lIIIlIIlI[4];
        if (model.slideLockOnEmpty) {
            if (isAmmoEmpty != 0) {
                anim.isGunEmpty = lIIIlIIlI[1];
            } else if (isAmmoEmpty == 0 && !anim.reloading) {
                anim.isGunEmpty = lIIIlIIlI[4];
            }
        }
        GL11.glPushMatrix();
        GL11.glTranslatef((float)(model.config.hammerAction.hammerRotationPoint.x * worldScale), (float)(model.config.hammerAction.hammerRotationPoint.y * worldScale), (float)(model.config.hammerAction.hammerRotationPoint.z * worldScale));
        if (!anim.isGunEmpty) {
            GL11.glRotatef((float)50.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glRotatef((float)(-anim.hammerRotation * 2.0f), (float)0.0f, (float)0.0f, (float)1.0f);
        }
        GL11.glTranslatef((float)(-model.config.hammerAction.hammerRotationPoint.x * worldScale), (float)(-model.config.hammerAction.hammerRotationPoint.y * worldScale), (float)(-model.config.hammerAction.hammerRotationPoint.z * worldScale));
        model.renderPart("hammerModel", worldScale);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        float f = currentShootState.isPresent() ? (currentShootState.get().stateType == StateType.PumpOut || currentShootState.get().stateType == StateType.PumpIn ? currentShootState.get().currentValue : 1.0f) : (pumpCurrent = 1.0f);
        float pumpLast2 = currentShootState.isPresent() ? (currentShootState.get().stateType == StateType.PumpOut || currentShootState.get().stateType == StateType.PumpIn ? currentShootState.get().lastValue : 1.0f) : 1.0f;
        GL11.glTranslatef((float)model.leverRotationPoint.x, (float)model.leverRotationPoint.y, (float)model.leverRotationPoint.z);
        GL11.glRotatef((float)(model.leverRotation * (1.0f - Math.abs(pumpLast2 + (pumpCurrent - pumpLast2) * RenderParameters.smoothing))), (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glTranslatef((float)(-model.leverRotationPoint.x), (float)(-model.leverRotationPoint.y), (float)(-model.leverRotationPoint.z));
        model.renderPart("leverActionModel", worldScale);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)model.triggerRotationPoint.x, (float)model.triggerRotationPoint.y, (float)model.triggerRotationPoint.z);
        GL11.glRotatef((float)(model.triggerRotation * (RenderParameters.triggerPullSwitch * 50.0f)), (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glTranslatef((float)(-model.triggerRotationPoint.x), (float)(-model.triggerRotationPoint.y), (float)(-model.triggerRotationPoint.z));
        model.renderPart("triggerModel", worldScale);
        GL11.glPopMatrix();
        if (!model.switchIsOnSlide) {
            GL11.glPushMatrix();
            WeaponFireMode fireMode = GunType.getFireMode(item);
            float switchAngle = fireMode == WeaponFireMode.SEMI ? model.switchSemiRot : (fireMode == WeaponFireMode.FULL ? model.switchAutoRot : (fireMode == WeaponFireMode.BURST ? model.switchBurstRot : 0.0f));
            GL11.glTranslatef((float)model.switchRotationPoint.x, (float)model.switchRotationPoint.y, (float)model.switchRotationPoint.z);
            GL11.glRotatef((float)switchAngle, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glTranslatef((float)(-model.switchRotationPoint.x), (float)(-model.switchRotationPoint.y), (float)(-model.switchRotationPoint.z));
            model.renderPart("switchModel", worldScale);
            GL11.glPopMatrix();
        }
        if (gunType.weaponType == WeaponType.Revolver) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)(model.config.revolverBarrel.cylinderOriginPoint.x * worldScale), (float)(model.config.revolverBarrel.cylinderOriginPoint.y * worldScale), (float)(model.config.revolverBarrel.cylinderOriginPoint.z * worldScale));
            float updatedTiltProgress = currentReloadState.isPresent() ? (currentReloadState.get().stateType == StateType.Tilt || currentReloadState.get().stateType == StateType.Untilt ? currentReloadState.get().currentValue : (anim.tiltHold ? 1.0f : 0.0f)) : 0.0f;
            GL11.glTranslatef((float)(updatedTiltProgress * model.config.revolverBarrel.cylinderReloadTranslation.x * worldScale), (float)(updatedTiltProgress * model.config.revolverBarrel.cylinderReloadTranslation.y * worldScale), (float)(updatedTiltProgress * model.config.revolverBarrel.cylinderReloadTranslation.z * worldScale));
            GL11.glRotatef((float)anim.revolverBarrelRotation, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glTranslatef((float)(-model.config.revolverBarrel.cylinderOriginPoint.x * worldScale), (float)(-model.config.revolverBarrel.cylinderOriginPoint.y * worldScale), (float)(-model.config.revolverBarrel.cylinderOriginPoint.z * worldScale));
            model.renderPart("revolverBarrelModel", worldScale);
            GL11.glPopMatrix();
        }
        GL11.glPushMatrix();
        int n2 = cachedUnload = anim.isReloadType(ReloadType.Unload) && anim.cachedAmmoStack != null ? lIIIlIIlI[1] : lIIIlIIlI[4];
        if (ItemGun.hasAmmoLoaded(item) || cachedUnload != 0) {
            ItemStack stackAmmo;
            ItemStack itemStack = stackAmmo = cachedUnload != 0 ? anim.cachedAmmoStack : new ItemStack(item.func_77978_p().func_74775_l("ammo"));
            if (stackAmmo.func_77973_b() instanceof ItemAmmo) {
                ItemAmmo itemAmmo = (ItemAmmo)stackAmmo.func_77973_b();
                AmmoType ammoType = itemAmmo.type;
                int shouldNormalRender = lIIIlIIlI[1];
                if (anim.reloading && model.config.extra.reloadAnimation != null && WeaponAnimations.getAnimation(model.config.extra.reloadAnimation) != null) {
                    float ammoProgress = currentReloadState.isPresent() ? (currentReloadState.get().stateType == StateType.Unload || currentReloadState.get().stateType == StateType.Load ? currentReloadState.get().currentValue : 0.0f) : 1.0f;
                    WeaponAnimations.getAnimation(model.config.extra.reloadAnimation).onAmmoAnimation(model, ammoProgress, anim.reloadAmmoCount, anim);
                }
                if (ammoType.isDynamicAmmo && ammoType.model != null) {
                    ModelAmmo modelAmmo = (ModelAmmo)ammoType.model;
                    if (model.config.maps.ammoMap.containsKey(ammoType.internalName)) {
                        Vector3f ammoOffset = model.config.maps.ammoMap.get((Object)ammoType.internalName).offset;
                        Vector3f ammoScale = model.config.maps.ammoMap.get((Object)ammoType.internalName).scale;
                        GL11.glTranslatef((float)ammoOffset.x, (float)ammoOffset.y, (float)ammoOffset.z);
                        if (ammoType.magazineCount > lIIIlIIlI[1]) {
                            int magCount = stackAmmo.func_77978_p().func_74762_e("magcount");
                            if (!anim.reloading) {
                                this.oldMagCount = magCount;
                            } else if (anim.reloading) {
                                magCount = this.oldMagCount;
                            }
                            if (modelAmmo.magCountOffset.containsKey(magCount)) {
                                shouldNormalRender = lIIIlIIlI[4];
                                GL11.glPushMatrix();
                                RenderVariables magRenderVar = modelAmmo.magCountOffset.get(magCount);
                                Vector3f magOffset = magRenderVar.offset;
                                Vector3f magRotate = magRenderVar.rotation;
                                GL11.glTranslatef((float)magOffset.x, (float)magOffset.y, (float)magOffset.z);
                                if (magRotate != null && magRenderVar.angle != null) {
                                    GL11.glRotatef((float)magRenderVar.angle.floatValue(), (float)magRotate.x, (float)magRotate.y, (float)magRotate.z);
                                }
                                Vector3f adjustedScale2 = new Vector3f(ammoScale.x / modelScale, ammoScale.y / modelScale, ammoScale.z / modelScale);
                                GL11.glScalef((float)adjustedScale2.x, (float)adjustedScale2.y, (float)adjustedScale2.z);
                                int skinIdAmmo = lIIIlIIlI[4];
                                if (stackAmmo.func_77942_o() && stackAmmo.func_77978_p().func_74764_b("skinId")) {
                                    skinIdAmmo = stackAmmo.func_77978_p().func_74762_e("skinId");
                                }
                                if (ammoType.sameTextureAsGun) {
                                    this.bindTexture("guns", path);
                                } else {
                                    String pathAmmo = skinIdAmmo > 0 ? ammoType.modelSkins[skinIdAmmo].getSkin() : ammoType.modelSkins[lIIIlIIlI[4]].getSkin();
                                    this.bindTexture("ammo", pathAmmo);
                                }
                                if (anim.shouldRenderAmmo()) {
                                    if (cachedUnload == 0) {
                                        anim.cachedAmmoStack = stackAmmo;
                                    }
                                    modelAmmo.renderAmmo(worldScale);
                                }
                                GL11.glPopMatrix();
                            }
                        }
                        if (shouldNormalRender != 0) {
                            adjustedScale = new Vector3f(ammoScale.x / modelScale, ammoScale.y / modelScale, ammoScale.z / modelScale);
                            GL11.glScalef((float)adjustedScale.x, (float)adjustedScale.y, (float)adjustedScale.z);
                        }
                    }
                    if (shouldNormalRender != 0 && anim.shouldRenderAmmo()) {
                        if (cachedUnload == 0) {
                            anim.cachedAmmoStack = stackAmmo;
                        }
                        int skinIdAmmo = lIIIlIIlI[4];
                        if (stackAmmo.func_77942_o() && stackAmmo.func_77978_p().func_74764_b("skinId")) {
                            skinIdAmmo = stackAmmo.func_77978_p().func_74762_e("skinId");
                        }
                        if (ammoType.sameTextureAsGun) {
                            this.bindTexture("guns", path);
                        } else {
                            String pathAmmo = skinIdAmmo > 0 ? ammoType.modelSkins[skinIdAmmo].getSkin() : ammoType.modelSkins[lIIIlIIlI[4]].getSkin();
                            this.bindTexture("ammo", pathAmmo);
                        }
                        modelAmmo.renderAmmo(worldScale);
                    }
                } else if (anim.shouldRenderAmmo()) {
                    if (cachedUnload == 0) {
                        anim.cachedAmmoStack = stackAmmo;
                    }
                    float updatedTiltProgress = currentReloadState.isPresent() ? (currentReloadState.get().stateType == StateType.Tilt || currentReloadState.get().stateType == StateType.Untilt ? currentReloadState.get().currentValue : (anim.tiltHold ? 1.0f : 0.0f)) : 0.0f;
                    GL11.glPushMatrix();
                    GL11.glTranslatef((float)model.cylinderRotationPoint.x, (float)model.cylinderRotationPoint.y, (float)model.cylinderRotationPoint.z);
                    GL11.glRotatef((float)(updatedTiltProgress * model.cylinderRotation), (float)1.0f, (float)0.0f, (float)0.0f);
                    GL11.glTranslatef((float)(-model.cylinderRotationPoint.x), (float)(-model.cylinderRotationPoint.y), (float)(-model.cylinderRotationPoint.z));
                    model.renderPart("ammoModel", worldScale);
                    GL11.glPopMatrix();
                }
            }
        } else if (ItemGun.getUsedBullet(item, gunType) != null) {
            ItemBullet itemBullet = ItemGun.getUsedBullet(item, gunType);
            ModelBullet bulletModel = (ModelBullet)itemBullet.type.model;
            if (gunType.weaponType == WeaponType.Revolver) {
                GlStateManager.func_179094_E();
                if (itemBullet.type.model != null && anim.reloading) {
                    GL11.glTranslatef((float)(model.config.revolverBarrel.cylinderOriginPoint.x * worldScale), (float)(model.config.revolverBarrel.cylinderOriginPoint.y * worldScale), (float)(model.config.revolverBarrel.cylinderOriginPoint.z * worldScale));
                    float updatedTiltProgress = currentReloadState.isPresent() ? (currentReloadState.get().stateType == StateType.Tilt || currentReloadState.get().stateType == StateType.Untilt ? currentReloadState.get().currentValue : (anim.tiltHold ? 1.0f : 0.0f)) : 0.0f;
                    GL11.glTranslatef((float)(updatedTiltProgress * model.config.revolverBarrel.cylinderReloadTranslation.x * worldScale), (float)(updatedTiltProgress * model.config.revolverBarrel.cylinderReloadTranslation.y * worldScale), (float)(updatedTiltProgress * model.config.revolverBarrel.cylinderReloadTranslation.z * worldScale));
                    GL11.glRotatef((float)anim.revolverBarrelRotation, (float)1.0f, (float)0.0f, (float)0.0f);
                    GL11.glTranslatef((float)(-model.config.revolverBarrel.cylinderOriginPoint.x * worldScale), (float)(-model.config.revolverBarrel.cylinderOriginPoint.y * worldScale), (float)(-model.config.revolverBarrel.cylinderOriginPoint.z * worldScale));
                }
                this.bindTexture("bullets", itemBullet.type.modelSkins[lIIIlIIlI[4]].getSkin());
                if (currentReloadState.isPresent() && currentReloadState.get().stateType == StateType.Tilt) {
                    bulletModel.renderAll(worldScale);
                } else if (model.config.revolverBarrel.numberBullets != null) {
                    bulletModel.renderBullet(anim.bulletsToRender, worldScale);
                }
                GlStateManager.func_179121_F();
            }
            if (anim.reloading && model.config.extra.reloadAnimation != null && WeaponAnimations.getAnimation(model.config.extra.reloadAnimation) != null && anim.reloading && model.config.extra.reloadAnimation != null && WeaponAnimations.getAnimation(model.config.extra.reloadAnimation) != null) {
                float ammoProgress = currentReloadState.isPresent() ? (currentReloadState.get().stateType == StateType.Unload || currentReloadState.get().stateType == StateType.Load ? currentReloadState.get().currentValue : 0.0f) : 1.0f;
                WeaponAnimations.getAnimation(model.config.extra.reloadAnimation).onAmmoAnimation(model, ammoProgress, anim.reloadAmmoCount, anim);
            }
            if (itemBullet.type.model != null && anim.reloading) {
                GL11.glPushMatrix();
                if (model.config.maps.bulletMap.containsKey(itemBullet.baseType.internalName)) {
                    RenderVariables renderVar = model.config.maps.bulletMap.get(itemBullet.type.internalName);
                    Vector3f offset = renderVar.offset;
                    GL11.glTranslatef((float)offset.x, (float)offset.y, (float)offset.z);
                    if (renderVar.scale != null) {
                        Vector3f scale = renderVar.scale;
                        GL11.glScalef((float)scale.x, (float)scale.y, (float)scale.z);
                    }
                }
                this.bindTexture("bullets", itemBullet.type.modelSkins[lIIIlIIlI[4]].getSkin());
                bulletModel.renderBullet(worldScale);
                GL11.glPopMatrix();
            }
        }
        int shouldRenderFlash = lIIIlIIlI[1];
        if (GunType.getAttachment(item, AttachmentEnum.Barrel) != null) {
            AttachmentType attachmentType = ((ItemAttachment)GunType.getAttachment((ItemStack)item, (AttachmentEnum)AttachmentEnum.Barrel).func_77973_b()).type;
            if (attachmentType.attachmentType == AttachmentEnum.Barrel) {
                int n3 = shouldRenderFlash = !attachmentType.barrel.hideFlash ? lIIIlIIlI[1] : lIIIlIIlI[4];
            }
        }
        if (anim.muzzleFlashTime > 0 && model.staticModel.getPart("flashModel") != null && !mc.field_71439_g.func_70090_H() && renderType != CustomItemRenderType.BACK && shouldRenderFlash != 0) {
            GlStateManager.func_179094_E();
            GL11.glEnable((int)lIIIlIIlI[7]);
            GL11.glEnable((int)lIIIlIIlI[14]);
            GL11.glHint((int)lIIIlIIlI[15], (int)lIIIlIIlI[16]);
            int punched = lIIIlIIlI[4];
            if (item.func_77942_o() && item.func_77978_p().func_74764_b("punched")) {
                punched = item.func_77978_p().func_74767_n("punched") ? 1 : 0;
            }
            if (punched == 0) {
                renderEngine.func_110577_a(new ResourceLocation("modularwarfare", "skins/flash/" + anim.flashInt + ".png"));
            } else {
                renderEngine.func_110577_a(new ResourceLocation("modularwarfare", "skins/flash/" + ThreadLocalRandom.current().nextInt(lIIIlIIlI[1], lIIIlIIlI[17]) + "_punched.png"));
            }
            float lastBrightnessX = OpenGlHelper.lastBrightnessX;
            float lastBrightnessY = OpenGlHelper.lastBrightnessY;
            GlStateManager.func_179132_a((boolean)lIIIlIIlI[4]);
            GlStateManager.func_179140_f();
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
            model.renderPart("flashModel", worldScale);
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)lastBrightnessX, (float)lastBrightnessY);
            GlStateManager.func_179145_e();
            GlStateManager.func_179132_a((boolean)lIIIlIIlI[1]);
            GL11.glDisable((int)lIIIlIIlI[7]);
            GL11.glDisable((int)lIIIlIIlI[14]);
            GlStateManager.func_179121_F();
        }
        if (!ModularWarfare.DEV_ENV && model.hasArms() && renderType == CustomItemRenderType.EQUIPPED_FIRST_PERSON) {
            GL11.glPushMatrix();
            this.renderMovingArm((EntityPlayer)mc.field_71439_g, model, anim, currentReloadState);
            GL11.glPopMatrix();
        } else if (renderType == CustomItemRenderType.EQUIPPED_FIRST_PERSON && model.hasArms()) {
            this.renderMovingArm((EntityPlayer)mc.field_71439_g, model, anim, currentReloadState);
        }
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        AttachmentEnum[] attachmentEnumArray = AttachmentEnum.values();
        int n4 = attachmentEnumArray.length;
        for (int i = lIIIlIIlI[4]; i < n4; ++i) {
            AttachmentEnum attachment = attachmentEnumArray[i];
            ItemStack itemStack = GunType.getAttachment(item, attachment);
            if (itemStack == null || itemStack.func_77973_b() == Items.field_190931_a) continue;
            AttachmentType attachmentType = ((ItemAttachment)itemStack.func_77973_b()).type;
            ModelAttachment attachmentModel = (ModelAttachment)attachmentType.model;
            if (attachmentModel == null) continue;
            GL11.glPushMatrix();
            skinId = lIIIlIIlI[4];
            if (itemStack.func_77942_o() && itemStack.func_77978_p().func_74764_b("skinId")) {
                skinId = itemStack.func_77978_p().func_74762_e("skinId");
            }
            adjustedScale = new Vector3f(attachmentModel.config.extra.modelScale, attachmentModel.config.extra.modelScale, attachmentModel.config.extra.modelScale);
            GL11.glScalef((float)adjustedScale.x, (float)adjustedScale.y, (float)adjustedScale.z);
            if (model.config.attachments.attachmentPointMap != null && model.config.attachments.attachmentPointMap.size() >= lIIIlIIlI[1] && model.config.attachments.attachmentPointMap.containsKey((Object)attachment)) {
                Vector3f attachmentVecTranslate = model.config.attachments.attachmentPointMap.get((Object)attachment).get(lIIIlIIlI[4]);
                Vector3f attachmentVecRotate = model.config.attachments.attachmentPointMap.get((Object)attachment).get(lIIIlIIlI[1]);
                GL11.glTranslatef((float)(attachmentVecTranslate.x / attachmentModel.config.extra.modelScale), (float)(attachmentVecTranslate.y / attachmentModel.config.extra.modelScale), (float)(attachmentVecTranslate.z / attachmentModel.config.extra.modelScale));
                GL11.glRotatef((float)attachmentVecRotate.x, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)attachmentVecRotate.y, (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glRotatef((float)attachmentVecRotate.z, (float)0.0f, (float)0.0f, (float)1.0f);
            }
            if (model.config.attachments.positionPointMap != null) {
                for (String internalName : model.config.attachments.positionPointMap.keySet()) {
                    if (!internalName.equals(attachmentType.internalName)) continue;
                    Vector3f trans = model.config.attachments.positionPointMap.get(internalName).get(lIIIlIIlI[4]);
                    Vector3f rot = model.config.attachments.positionPointMap.get(internalName).get(lIIIlIIlI[1]);
                    GL11.glTranslatef((float)(trans.x / attachmentModel.config.extra.modelScale * worldScale), (float)(trans.y / attachmentModel.config.extra.modelScale * worldScale), (float)(trans.z / attachmentModel.config.extra.modelScale * worldScale));
                    GL11.glRotatef((float)rot.x, (float)1.0f, (float)0.0f, (float)0.0f);
                    GL11.glRotatef((float)rot.y, (float)0.0f, (float)1.0f, (float)0.0f);
                    GL11.glRotatef((float)rot.z, (float)0.0f, (float)0.0f, (float)1.0f);
                }
            }
            path = skinId > 0 ? attachmentType.modelSkins[skinId].getSkin() : attachmentType.modelSkins[lIIIlIIlI[4]].getSkin();
            this.bindTexture("attachments", path);
            if (attachmentType.attachmentType == AttachmentEnum.Sight && model.config.attachments.scopeIsOnSlide) {
                float lastCharge;
                float currentCharge;
                float f3 = currentReloadState.isPresent() ? (currentReloadState.get().stateType == StateType.Charge || currentReloadState.get().stateType == StateType.Uncharge ? currentReloadState.get().currentValue : 1.0f) : (currentCharge = 1.0f);
                float f4 = currentReloadState.isPresent() ? (currentReloadState.get().stateType == StateType.Charge || currentReloadState.get().stateType == StateType.Uncharge ? currentReloadState.get().lastValue : 1.0f) : (lastCharge = 1.0f);
                if (!anim.isGunEmpty) {
                    GL11.glTranslatef((float)(-(anim.lastGunSlide + (anim.gunSlide - anim.lastGunSlide) * RenderParameters.smoothing) * model.config.extra.gunSlideDistance), (float)0.0f, (float)0.0f);
                } else {
                    GL11.glTranslatef((float)(-model.config.extra.gunSlideDistance), (float)0.0f, (float)0.0f);
                }
                GL11.glTranslatef((float)(-(1.0f - Math.abs(lastCharge + (currentCharge - lastCharge) * RenderParameters.smoothing)) * model.config.extra.chargeHandleDistance), (float)0.0f, (float)0.0f);
            }
            attachmentModel.renderAttachment(worldScale);
            if (attachmentType.attachmentType == AttachmentEnum.Sight && mc.field_71474_y.field_74320_O == 0 && renderType == CustomItemRenderType.EQUIPPED_FIRST_PERSON) {
                this.renderScopeGlass(attachmentType, attachmentModel, RenderParameters.adsSwitch != 0.0f ? lIIIlIIlI[1] : lIIIlIIlI[4]);
            }
            GL11.glPopMatrix();
        }
        GL11.glPopMatrix();
        GL11.glPopMatrix();
        GL11.glPopMatrix();
    }

    @Override
    public void renderItem(CustomItemRenderType type, EnumHand hand, ItemStack item, Object ... data) {
        if (!(item.func_77973_b() instanceof ItemGun)) {
            return;
        }
        GunType gunType = ((ItemGun)item.func_77973_b()).type;
        if (gunType == null) {
            return;
        }
        ModelGun model = (ModelGun)gunType.model;
        if (model == null) {
            return;
        }
        AnimStateMachine anim = data.length >= lIIIlIIlI[0] ? ((EntityLivingBase)data[lIIIlIIlI[1]] instanceof EntityPlayer ? ClientRenderHooks.getAnimMachine((EntityPlayer)data[lIIIlIIlI[1]]) : new AnimStateMachine()) : new AnimStateMachine();
        GlStateManager.func_179103_j((int)lIIIlIIlI[2]);
        this.renderGun(type, item, anim, gunType, data);
        GlStateManager.func_179103_j((int)lIIIlIIlI[3]);
    }

    private static void lIlIIIlI() {
        lIIIlIIlI = new int[18];
        RenderGunStatic.lIIIlIIlI[0] = "  ".length();
        RenderGunStatic.lIIIlIIlI[1] = " ".length();
        RenderGunStatic.lIIIlIIlI[2] = 0xFFFF9FDB & 0x7D25;
        RenderGunStatic.lIIIlIIlI[3] = -(0xFFFFCCBA & 0x737F) & (0xFFFFDF3F & 0x7DF9);
        RenderGunStatic.lIIIlIIlI[4] = (70 + 180 - 220 + 173 ^ 45 + 48 - 1 + 57) & (0x12 ^ 0x4E ^ "  ".length() ^ -" ".length());
        RenderGunStatic.lIIIlIIlI[5] = 0x2F ^ 0x20;
        RenderGunStatic.lIIIlIIlI[6] = 0xFFFFBFDC & 0x4B73;
        RenderGunStatic.lIIIlIIlI[7] = 0xFFFFDFEF & 0x2BF2;
        RenderGunStatic.lIIIlIIlI[8] = 0xFFFFC24F & 0x7DB0;
        RenderGunStatic.lIIIlIIlI[9] = 0xFFFFEB46 & 0x17BF;
        RenderGunStatic.lIIIlIIlI[10] = -(0xFFFFFF75 & 0x1C9F) & (0xFFFFFFFF & 0x1F16);
        RenderGunStatic.lIIIlIIlI[11] = (0xBE ^ 0xA5) + (73 + 12 - -47 + 44) - -" ".length() + (0x16 ^ 0x25);
        RenderGunStatic.lIIIlIIlI[12] = 0xFFFFA73B & 0x5BC7;
        RenderGunStatic.lIIIlIIlI[13] = 0xFFFF9FF9 & 0x6DE7;
        RenderGunStatic.lIIIlIIlI[14] = 0xFFFFDB3B & 0x2FD4;
        RenderGunStatic.lIIIlIIlI[15] = -(0xFFFFB30B & 0x5FFF) & (0xFFFF9F5B & Short.MAX_VALUE);
        RenderGunStatic.lIIIlIIlI[16] = 0xFFFF9909 & 0x77F7;
        RenderGunStatic.lIIIlIIlI[17] = 83 + 46 - 14 + 33 ^ 86 + 96 - 115 + 79;
    }

    @SideOnly(value=Side.CLIENT)
    public void renderScopeGlass(AttachmentType attachmentType, ModelAttachment modelAttachment, boolean isAiming) {
        if (attachmentType.sight.scopeType != WeaponScopeType.REDDOT && Minecraft.func_71410_x().field_71441_e != null) {
            float gunRotX = RenderParameters.GUN_ROT_X_LAST + (RenderParameters.GUN_ROT_X - RenderParameters.GUN_ROT_X_LAST) * this.timer.field_194147_b;
            if (isAiming) {
                if (!OptifineHelper.isShadersEnabled()) {
                    GL11.glPushMatrix();
                    this.renderWorldOntoScope(attachmentType, modelAttachment);
                    float alpha = 1.0f;
                    if (RenderParameters.adsSwitch < 1.0f) {
                        alpha = 1.0f - RenderParameters.adsSwitch;
                    } else {
                        alpha = gunRotX;
                        alpha = Math.abs(alpha / 8.0f);
                    }
                    GlStateManager.func_179140_f();
                    GlStateManager.func_179132_a((boolean)lIIIlIIlI[4]);
                    GlStateManager.func_179147_l();
                    GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
                    renderEngine.func_110577_a(new ResourceLocation("modularwarfare", "textures/skins/black.png"));
                    modelAttachment.renderOverlay(0.0625f);
                    GlStateManager.func_179084_k();
                    GlStateManager.func_179132_a((boolean)lIIIlIIlI[1]);
                    GlStateManager.func_179145_e();
                    GL11.glPopMatrix();
                } else {
                    renderEngine.func_110577_a(ScopeUtils.NOT_COMPATIBLE);
                    modelAttachment.renderOverlay(0.0625f);
                }
            } else {
                GL11.glPushMatrix();
                renderEngine.func_110577_a(new ResourceLocation("modularwarfare", "textures/skins/black.png"));
                modelAttachment.renderOverlay(0.0625f);
                GL11.glPopMatrix();
            }
        }
    }

    static {
        RenderGunStatic.lIlIIIlI();
        prevBobModifier = 0.0f;
    }

    public void renderLeftSleeve(EntityPlayer player, ModelBiped modelplayer) {
        ItemStack armorStack;
        if (player.field_71071_by.func_70440_f(lIIIlIIlI[0]) != null && (armorStack = player.field_71071_by.func_70440_f(lIIIlIIlI[0])).func_77973_b() instanceof ItemMWArmor) {
            ModelCustomArmor modelArmor = (ModelCustomArmor)((ItemMWArmor)armorStack.func_77973_b()).type.bipedModel;
            int skinId = lIIIlIIlI[4];
            String path = skinId > 0 ? ((ItemMWArmor)armorStack.func_77973_b()).type.modelSkins[skinId].getSkin() : ((ItemMWArmor)armorStack.func_77973_b()).type.modelSkins[lIIIlIIlI[4]].getSkin();
            this.bindTexture("armor", path);
            GL11.glPushMatrix();
            float modelScale = modelArmor.config.extra.modelScale;
            GL11.glScalef((float)modelScale, (float)modelScale, (float)modelScale);
            modelArmor.showChest(lIIIlIIlI[1]);
            modelArmor.renderLeftArm((AbstractClientPlayer)player, modelplayer);
            GL11.glPopMatrix();
        }
    }
}

