/*
 * Decompiled with CFR 0.152.
 */
package com.modularwarfare.common.armor;

import com.modularwarfare.ModularWarfare;
import com.modularwarfare.api.MWArmorType;
import com.modularwarfare.client.model.ModelCustomArmor;
import com.modularwarfare.common.armor.ArmorType;
import com.modularwarfare.common.init.ModSounds;
import com.modularwarfare.common.type.BaseType;
import javax.annotation.Nullable;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemMWArmor
extends ItemArmor
implements ISpecialArmor {
    private static final int[] lIIllIII;
    public String internalName;
    public BaseType baseType;
    public ArmorType type;

    public int getArmorDisplay(EntityPlayer player, ItemStack armor, int slot) {
        return (int)(this.type.defense * 20.0);
    }

    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, ItemStack armor, DamageSource source, double damage, int slot) {
        return new ISpecialArmor.ArmorProperties(lIIllIII[1], this.type.defense, lIIllIII[2]);
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String armourType) {
        int skinId = stack.func_77978_p().func_74762_e("skinId");
        String path = skinId > 0 ? "skins/" + this.type.modelSkins[skinId].getSkin() : this.type.modelSkins[lIIllIII[0]].getSkin();
        return "modularwarfare:skins/armor/" + path + ".png";
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack itemstack = playerIn.func_184586_b(handIn);
        EntityEquipmentSlot entityequipmentslot = EntityLiving.func_184640_d((ItemStack)itemstack);
        ItemStack itemstack1 = playerIn.func_184582_a(entityequipmentslot);
        if (itemstack1.func_190926_b()) {
            playerIn.func_184201_a(entityequipmentslot, itemstack.func_77946_l());
            itemstack.func_190920_e(lIIllIII[0]);
            worldIn.func_184133_a(null, playerIn.func_180425_c(), ModSounds.EQUIP_EXTRA, SoundCategory.PLAYERS, 2.0f, 1.0f);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)itemstack);
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)itemstack);
    }

    public void func_77663_a(ItemStack unused, World world, Entity holdingEntity, int intI, boolean flag) {
        if (holdingEntity instanceof EntityPlayer && unused != null && unused.func_77973_b() instanceof ItemMWArmor && unused.func_77978_p() == null) {
            NBTTagCompound nbtTagCompound = new NBTTagCompound();
            nbtTagCompound.func_74768_a("skinId", lIIllIII[0]);
            unused.func_77982_d(nbtTagCompound);
        }
    }

    public ItemMWArmor(ArmorType type, MWArmorType armorSlot) {
        super(ItemArmor.ArmorMaterial.LEATHER, lIIllIII[0], EntityEquipmentSlot.func_188451_a((String)armorSlot.name().toLowerCase()));
        type.initializeArmor(armorSlot.name().toLowerCase());
        type.loadExtraValues();
        this.internalName = type.armorTypes.get((Object)((Object)armorSlot)).internalName;
        this.func_77655_b(this.internalName);
        this.setRegistryName(this.internalName);
        this.func_77637_a(ModularWarfare.MODS_TABS.get(type.contentPack));
        if (type.durability != null) {
            this.func_77656_e(type.durability);
        }
        this.baseType = type;
        this.type = type;
    }

    @SideOnly(value=Side.CLIENT)
    @Nullable
    public ModelBiped getArmorModel(EntityLivingBase living, ItemStack stack, EntityEquipmentSlot slot, ModelBiped defaultModel) {
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemMWArmor) {
            ArmorType armorType = ((ItemMWArmor)stack.func_77973_b()).type;
            ModelCustomArmor armorModel = (ModelCustomArmor)armorType.bipedModel;
            if (slot != EntityEquipmentSlot.MAINHAND) {
                if (slot != EntityEquipmentSlot.OFFHAND) {
                    armorModel.showChest(slot == EntityEquipmentSlot.CHEST ? lIIllIII[1] : lIIllIII[0]);
                    armorModel.showFeet(slot == EntityEquipmentSlot.FEET ? lIIllIII[1] : lIIllIII[0]);
                    armorModel.showHead(slot == EntityEquipmentSlot.HEAD ? lIIllIII[1] : lIIllIII[0]);
                    armorModel.showLegs(slot == EntityEquipmentSlot.LEGS ? lIIllIII[1] : lIIllIII[0]);
                }
            }
            armorModel.func_178686_a((ModelBase)defaultModel);
            return armorModel;
        }
        return null;
    }

    public void damageArmor(EntityLivingBase entity, ItemStack stack, DamageSource source, int damage, int slot) {
        if (this.type.durability != null) {
            stack.func_77972_a(damage, entity);
        }
    }

    static {
        ItemMWArmor.lIllIII();
    }

    public void setType(BaseType type) {
        this.type = (ArmorType)type;
    }

    public boolean func_77651_p() {
        return lIIllIII[1];
    }

    private static void lIllIII() {
        lIIllIII = new int[3];
        ItemMWArmor.lIIllIII[0] = (0xB7 ^ 0xA9) & ~(0x88 ^ 0x96);
        ItemMWArmor.lIIllIII[1] = " ".length();
        ItemMWArmor.lIIllIII[2] = 0xFFFFFFFF & Integer.MAX_VALUE;
    }
}

