/*
 * Decompiled with CFR 0.152.
 */
package com.modularwarfare.common.entity.item;

import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.stats.StatList;
import net.minecraft.util.DamageSource;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.datafix.FixTypes;
import net.minecraft.util.datafix.IDataWalker;
import net.minecraft.util.datafix.walkers.ItemStackData;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EntityItemNew
extends Entity {
    private static final int[] lIlIllIIl;
    private int age;
    private static final DataParameter<ItemStack> ITEM;
    private int health;
    public float hoverStart;
    public int lifespan = lIlIllIIl[0];
    private String thrower;
    private static final Logger LOGGER;
    private int delayBeforeCanPickup;
    private String owner;

    public String getOwner() {
        return this.owner;
    }

    public ItemStack getItem() {
        return (ItemStack)this.func_184212_Q().func_187225_a(ITEM);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.field_70170_p.field_72995_K || this.field_70128_L) {
            return lIlIllIIl[2];
        }
        if (this.func_180431_b(source)) {
            return lIlIllIIl[2];
        }
        if (!this.getItem().func_190926_b() && this.getItem().func_77973_b() == Items.field_151156_bN && source.func_94541_c()) {
            return lIlIllIIl[2];
        }
        this.func_70018_K();
        this.health -= (int)amount;
        if (this.health <= 0) {
            this.func_70106_y();
        }
        return lIlIllIIl[2];
    }

    public void makeFakeItem() {
        this.setInfinitePickupDelay();
        this.age = this.getItem().func_77973_b().getEntityLifespan(this.getItem(), this.field_70170_p) - lIlIllIIl[4];
    }

    public EntityItemNew(World worldIn) {
        super(worldIn);
        this.health = lIlIllIIl[1];
        this.hoverStart = (float)(Math.random() * Math.PI * 2.0);
        this.func_70105_a(0.25f, 0.25f);
        this.setItem(ItemStack.field_190927_a);
    }

    public void setDefaultPickupDelay() {
        this.delayBeforeCanPickup = lIlIllIIl[9];
    }

    @SideOnly(value=Side.CLIENT)
    public int getAge() {
        return this.age;
    }

    public String func_70005_c_() {
        return this.func_145818_k_() ? this.func_95999_t() : I18n.func_74838_a((String)("item." + this.getItem().func_77977_a()));
    }

    public boolean cannotPickup() {
        return this.delayBeforeCanPickup > 0 ? lIlIllIIl[4] : lIlIllIIl[2];
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public void setAgeToCreativeDespawnTime() {
        this.age = lIlIllIIl[7];
    }

    public void setThrower(String thrower) {
        this.thrower = thrower;
    }

    private void searchForOtherItemsNearby() {
        for (EntityItemNew entityitem : this.field_70170_p.func_72872_a(EntityItemNew.class, this.func_174813_aQ().func_72314_b(0.5, 0.0, 0.5))) {
            this.combineItems(entityitem);
        }
    }

    protected boolean func_70041_e_() {
        return lIlIllIIl[2];
    }

    protected void func_70081_e(int amount) {
        this.func_70097_a(DamageSource.field_76372_a, amount);
    }

    public void setPickupDelay(int ticks) {
        this.delayBeforeCanPickup = ticks;
    }

    public EntityItemNew(World worldIn, double x, double y, double z, ItemStack stack) {
        this(worldIn, x, y, z);
        this.setItem(stack);
        this.lifespan = stack.func_77973_b() == null ? lIlIllIIl[0] : stack.func_77973_b().getEntityLifespan(stack, worldIn);
    }

    protected void func_70088_a() {
        this.func_184212_Q().func_187214_a(ITEM, (Object)ItemStack.field_190927_a);
    }

    public String getThrower() {
        return this.thrower;
    }

    public void setItem(ItemStack stack) {
        this.func_184212_Q().func_187227_b(ITEM, (Object)stack);
        this.func_184212_Q().func_187217_b(ITEM);
    }

    public void setNoDespawn() {
        this.age = lIlIllIIl[10];
    }

    public void func_70037_a(NBTTagCompound compound) {
        this.health = compound.func_74765_d("Health");
        this.age = compound.func_74765_d("Age");
        if (compound.func_74764_b("PickupDelay")) {
            this.delayBeforeCanPickup = compound.func_74765_d("PickupDelay");
        }
        if (compound.func_74764_b("Owner")) {
            this.owner = compound.func_74779_i("Owner");
        }
        if (compound.func_74764_b("Thrower")) {
            this.thrower = compound.func_74779_i("Thrower");
        }
        NBTTagCompound nbttagcompound = compound.func_74775_l("Item");
        this.setItem(new ItemStack(nbttagcompound));
        if (this.getItem().func_190926_b()) {
            this.func_70106_y();
        }
        if (compound.func_74764_b("Lifespan")) {
            this.lifespan = compound.func_74762_e("Lifespan");
        }
    }

    public void setInfinitePickupDelay() {
        this.delayBeforeCanPickup = lIlIllIIl[3];
    }

    public boolean func_70075_an() {
        return lIlIllIIl[2];
    }

    private boolean combineItems(EntityItemNew other) {
        if (other == this) {
            return lIlIllIIl[2];
        }
        if (!other.func_70089_S() || !this.func_70089_S()) {
            return lIlIllIIl[2];
        }
        ItemStack itemstack = this.getItem();
        ItemStack itemstack2 = other.getItem();
        if (this.delayBeforeCanPickup == lIlIllIIl[3] || other.delayBeforeCanPickup == lIlIllIIl[3]) {
            return lIlIllIIl[2];
        }
        if (this.age == lIlIllIIl[6] || other.age == lIlIllIIl[6]) {
            return lIlIllIIl[2];
        }
        if (itemstack2.func_77973_b() != itemstack.func_77973_b()) {
            return lIlIllIIl[2];
        }
        if (itemstack2.func_77942_o() ^ itemstack.func_77942_o()) {
            return lIlIllIIl[2];
        }
        if (itemstack2.func_77942_o() && !itemstack2.func_77978_p().equals((Object)itemstack.func_77978_p())) {
            return lIlIllIIl[2];
        }
        if (itemstack2.func_77973_b() == null) {
            return lIlIllIIl[2];
        }
        if (itemstack2.func_77973_b().func_77614_k() && itemstack2.func_77960_j() != itemstack.func_77960_j()) {
            return lIlIllIIl[2];
        }
        if (itemstack2.func_190916_E() < itemstack.func_190916_E()) {
            return other.combineItems(this);
        }
        if (itemstack2.func_190916_E() + itemstack.func_190916_E() > itemstack2.func_77976_d()) {
            return lIlIllIIl[2];
        }
        if (!itemstack.areCapsCompatible(itemstack2)) {
            return lIlIllIIl[2];
        }
        itemstack2.func_190917_f(itemstack.func_190916_E());
        other.delayBeforeCanPickup = Math.max(other.delayBeforeCanPickup, this.delayBeforeCanPickup);
        other.age = Math.min(other.age, this.age);
        other.setItem(itemstack2);
        this.func_70106_y();
        return lIlIllIIl[4];
    }

    public EntityItemNew(World worldIn, double x, double y, double z) {
        super(worldIn);
        this.health = lIlIllIIl[1];
        this.hoverStart = (float)(Math.random() * Math.PI * 2.0);
        this.func_70105_a(0.65f, 0.65f);
        this.func_70107_b(x, y, z);
        this.field_70177_z = (float)(Math.random() * 360.0);
        this.field_70159_w = (float)(Math.random() * (double)0.2f - (double)0.1f) / 10.0f;
        this.field_70181_x = 0.020000000298023225;
        this.field_70179_y = (float)(Math.random() * (double)0.2f - (double)0.1f) / 10.0f;
    }

    public void setNoPickupDelay() {
        this.delayBeforeCanPickup = lIlIllIIl[2];
    }

    static {
        EntityItemNew.llIIIlIl();
        LOGGER = LogManager.getLogger();
        ITEM = EntityDataManager.func_187226_a(EntityItemNew.class, (DataSerializer)DataSerializers.field_187196_f);
    }

    public void func_70071_h_() {
        if (this.getItem().func_77973_b().onEntityItemUpdate(new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.getItem()))) {
            return;
        }
        if (this.getItem().func_190926_b()) {
            this.func_70106_y();
        } else {
            double d6;
            double d5;
            double d4;
            double d7;
            int flag;
            super.func_70071_h_();
            if (this.delayBeforeCanPickup > 0 && this.delayBeforeCanPickup != lIlIllIIl[3]) {
                this.delayBeforeCanPickup -= lIlIllIIl[4];
            }
            this.field_70169_q = this.field_70165_t;
            this.field_70167_r = this.field_70163_u;
            this.field_70166_s = this.field_70161_v;
            double d0 = this.field_70159_w;
            double d2 = this.field_70181_x;
            double d3 = this.field_70179_y;
            if (!this.func_189652_ae()) {
                this.field_70181_x -= (double)0.04f;
            }
            this.field_70145_X = this.field_70170_p.field_72995_K ? lIlIllIIl[2] : this.func_145771_j(this.field_70165_t, (this.func_174813_aQ().field_72338_b + this.func_174813_aQ().field_72337_e) / 2.0, this.field_70161_v);
            this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
            int n = flag = (int)this.field_70169_q != (int)this.field_70165_t || (int)this.field_70167_r != (int)this.field_70163_u || (int)this.field_70166_s != (int)this.field_70161_v ? lIlIllIIl[4] : lIlIllIIl[2];
            if (flag != 0 || this.field_70173_aa % lIlIllIIl[5] == 0) {
                if (this.field_70170_p.func_180495_p(new BlockPos((Entity)this)).func_185904_a() == Material.field_151587_i) {
                    this.field_70181_x = 0.2f;
                    this.field_70159_w = (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f;
                    this.field_70179_y = (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f;
                    this.func_184185_a(SoundEvents.field_187658_bx, 0.4f, 2.0f + this.field_70146_Z.nextFloat() * 0.4f);
                }
                if (!this.field_70170_p.field_72995_K) {
                    this.searchForOtherItemsNearby();
                }
            }
            float f = 0.98f;
            if (this.field_70122_E) {
                f = this.field_70170_p.func_180495_p((BlockPos)new BlockPos((int)MathHelper.func_76128_c((double)this.field_70165_t), (int)(MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b) - EntityItemNew.lIlIllIIl[4]), (int)MathHelper.func_76128_c((double)this.field_70161_v))).func_177230_c().field_149765_K * 0.98f;
            }
            this.field_70159_w *= (double)f;
            this.field_70181_x *= (double)0.98f;
            this.field_70179_y *= (double)f;
            if (this.field_70122_E) {
                this.field_70181_x *= -0.5;
            }
            if (this.age != lIlIllIIl[6]) {
                this.age += lIlIllIIl[4];
            }
            this.func_70072_I();
            if (!this.field_70170_p.field_72995_K && (d7 = (d4 = this.field_70159_w - d0) * d4 + (d5 = this.field_70181_x - d2) * d5 + (d6 = this.field_70179_y - d3) * d6) > 0.01) {
                this.field_70160_al = lIlIllIIl[4];
            }
            ItemStack item = this.getItem();
            if (this.field_70170_p.field_72995_K || this.age >= this.lifespan) {
                // empty if block
            }
            if (item.func_190926_b()) {
                this.func_70106_y();
            }
        }
    }

    public void func_70100_b_(EntityPlayer entityIn) {
        if (!this.field_70170_p.field_72995_K) {
            if (this.delayBeforeCanPickup > 0) {
                return;
            }
            ItemStack itemstack = this.getItem();
            Item item = itemstack.func_77973_b();
            int i = itemstack.func_190916_E();
            int hook = ForgeEventFactory.onItemPickup((EntityItem)new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.getItem()), (EntityPlayer)entityIn);
            if (hook < 0) {
                return;
            }
            if (this.delayBeforeCanPickup <= 0 && (this.owner == null || this.lifespan - this.age <= lIlIllIIl[8] || this.owner.equals(entityIn.func_70005_c_())) && (hook == lIlIllIIl[4] || i <= 0 || entityIn.field_71071_by.func_70441_a(itemstack))) {
                FMLCommonHandler.instance().firePlayerItemPickupEvent(entityIn, new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.getItem()), this.getItem());
                entityIn.func_71001_a((Entity)new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.getItem()), i);
                if (itemstack.func_190926_b()) {
                    this.func_70106_y();
                    itemstack.func_190920_e(i);
                }
                entityIn.func_71064_a(StatList.func_188056_d((Item)item), i);
            }
        }
    }

    private static void llIIIlIl() {
        lIlIllIIl = new int[11];
        EntityItemNew.lIlIllIIl[0] = -(0xFFFFFEDC & 0x69B3) & (0xFFFFFFFF & Short.MAX_VALUE);
        EntityItemNew.lIlIllIIl[1] = 0x18 ^ 0x69 ^ (0xD4 ^ 0xA0);
        EntityItemNew.lIlIllIIl[2] = (0x1F ^ 0x2F) & ~(0x4F ^ 0x7F);
        EntityItemNew.lIlIllIIl[3] = -" ".length() & (0xFFFFFFFF & Short.MAX_VALUE);
        EntityItemNew.lIlIllIIl[4] = " ".length();
        EntityItemNew.lIlIllIIl[5] = 0xA ^ 0x13;
        EntityItemNew.lIlIllIIl[6] = -(0xFFFFDBB8 & 0xA447);
        EntityItemNew.lIlIllIIl[7] = -(0xFFFFEDB7 & 0x3F49) & (0xFFFFFFFF & 0x3FC0);
        EntityItemNew.lIlIllIIl[8] = (0xF5 ^ 0x88) + (0x1D ^ 0x40) - (0x6F ^ 0xD) + (0x38 ^ 0x68);
        EntityItemNew.lIlIllIIl[9] = 0x89 ^ 0xA5 ^ (0x8C ^ 0xAA);
        EntityItemNew.lIlIllIIl[10] = -(0xFFFF977C & 0x7FF3);
    }

    @Nullable
    public Entity func_184204_a(int dimensionIn) {
        Entity entity = super.func_184204_a(dimensionIn);
        if (!this.field_70170_p.field_72995_K && entity instanceof EntityItemNew) {
            ((EntityItemNew)entity).searchForOtherItemsNearby();
        }
        return entity;
    }

    public void func_70014_b(NBTTagCompound compound) {
        compound.func_74777_a("Health", (short)this.health);
        compound.func_74777_a("Age", (short)this.age);
        compound.func_74777_a("PickupDelay", (short)this.delayBeforeCanPickup);
        compound.func_74768_a("Lifespan", this.lifespan);
        if (this.getThrower() != null) {
            compound.func_74778_a("Thrower", this.thrower);
        }
        if (this.getOwner() != null) {
            compound.func_74778_a("Owner", this.owner);
        }
        if (!this.getItem().func_190926_b()) {
            compound.func_74782_a("Item", (NBTBase)this.getItem().func_77955_b(new NBTTagCompound()));
        }
    }

    public boolean func_70072_I() {
        if (this.field_70170_p.func_72918_a(this.func_174813_aQ(), Material.field_151586_h, (Entity)this)) {
            if (!this.field_70171_ac && !this.field_70148_d) {
                this.func_71061_d_();
            }
            this.field_70171_ac = lIlIllIIl[4];
        } else {
            this.field_70171_ac = lIlIllIIl[2];
        }
        return this.field_70171_ac;
    }

    public static void registerFixesItem(DataFixer fixer) {
        String[] stringArray = new String[lIlIllIIl[4]];
        stringArray[EntityItemNew.lIlIllIIl[2]] = "Item";
        fixer.func_188258_a(FixTypes.ENTITY, (IDataWalker)new ItemStackData(EntityItemNew.class, stringArray));
    }
}

