/*
 * Decompiled with CFR 0.152.
 */
package com.modularwarfare.common.guns;

import com.google.common.collect.Multimap;
import com.licel.stringer.annotations.secured;
import com.modularwarfare.ModConfig;
import com.modularwarfare.ModularWarfare;
import com.modularwarfare.api.WeaponFireEvent;
import com.modularwarfare.api.WeaponHitEvent;
import com.modularwarfare.client.ClientRenderHooks;
import com.modularwarfare.client.handler.ClientTickHandler;
import com.modularwarfare.client.model.renders.RenderParameters;
import com.modularwarfare.common.armor.ArmorType;
import com.modularwarfare.common.armor.ItemSpecialArmor;
import com.modularwarfare.common.capability.extraslots.CapabilityExtra;
import com.modularwarfare.common.capability.extraslots.IExtraItemHandler;
import com.modularwarfare.common.entity.decals.EntityDecal;
import com.modularwarfare.common.entity.decals.EntityShell;
import com.modularwarfare.common.guns.AttachmentEnum;
import com.modularwarfare.common.guns.BulletProperty;
import com.modularwarfare.common.guns.GunType;
import com.modularwarfare.common.guns.ItemAmmo;
import com.modularwarfare.common.guns.ItemAttachment;
import com.modularwarfare.common.guns.ItemBullet;
import com.modularwarfare.common.guns.PotionEntry;
import com.modularwarfare.common.guns.WeaponFireMode;
import com.modularwarfare.common.guns.WeaponSoundType;
import com.modularwarfare.common.guns.WeaponType;
import com.modularwarfare.common.handler.ServerTickHandler;
import com.modularwarfare.common.hitbox.hits.BulletHit;
import com.modularwarfare.common.hitbox.hits.PlayerHit;
import com.modularwarfare.common.hitbox.maths.EnumHitboxType;
import com.modularwarfare.common.network.PacketAimingReponse;
import com.modularwarfare.common.network.PacketDecal;
import com.modularwarfare.common.network.PacketGunFire;
import com.modularwarfare.common.network.PacketPlayHitmarker;
import com.modularwarfare.common.network.PacketPlaySound;
import com.modularwarfare.common.type.BaseItem;
import com.modularwarfare.common.type.BaseType;
import com.modularwarfare.utility.ModularDamageSource;
import com.modularwarfare.utility.RayUtil;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityEvoker;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySnowman;
import net.minecraft.entity.monster.EntityStray;
import net.minecraft.entity.monster.EntityVindicator;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.monster.EntityWitherSkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemAir;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@secured
public class ItemGun
extends BaseItem {
    public GunType type;
    protected static final UUID MOVEMENT_SPEED_MODIFIER;
    public static final Function<GunType, ItemGun> factory;
    private static final int[] llllIII;
    public static boolean canDryFire;
    public static boolean lastFireButtonHeld;
    public static boolean fireButtonHeld;

    public static boolean isIndoors(EntityLivingBase givenEntity) {
        BlockPos blockPos = givenEntity.field_70170_p.func_175725_q(givenEntity.func_180425_c());
        if (blockPos != null) {
            if ((double)blockPos.func_177956_o() > givenEntity.field_70163_u) {
                return llllIII[1];
            }
            return llllIII[0];
        }
        return llllIII[0];
    }

    static {
        ItemGun.lIIlIll();
        factory = type -> new ItemGun((GunType)type);
        canDryFire = llllIII[1];
        fireButtonHeld = llllIII[0];
        lastFireButtonHeld = llllIII[0];
        MOVEMENT_SPEED_MODIFIER = UUID.fromString("99999999-4180-4865-B01B-BCCE9785ACA3");
    }

    public boolean onEntitySwing(EntityLivingBase entityLiving, ItemStack stack) {
        return llllIII[1];
    }

    public void func_77663_a(ItemStack unused, World world, Entity holdingEntity, int intI, boolean flag) {
        EntityPlayer entityPlayer;
        if (holdingEntity instanceof EntityPlayer && (entityPlayer = (EntityPlayer)holdingEntity).func_184614_ca() != null && entityPlayer.func_184614_ca().func_77973_b() instanceof ItemGun) {
            ItemStack heldStack = entityPlayer.func_184614_ca();
            ItemGun itemGun = (ItemGun)heldStack.func_77973_b();
            GunType gunType = itemGun.type;
            if (world.field_72995_K) {
                this.onUpdateClient(entityPlayer, world, heldStack, itemGun, gunType);
            } else {
                this.onUpdateServer(entityPlayer, world, heldStack, itemGun, gunType);
            }
            if (heldStack.func_77978_p() == null) {
                NBTTagCompound nbtTagCompound = new NBTTagCompound();
                nbtTagCompound.func_74778_a("firemode", gunType.fireModes[llllIII[0]].name().toLowerCase());
                nbtTagCompound.func_74768_a("skinId", llllIII[0]);
                nbtTagCompound.func_74757_a("punched", gunType.isEnergyGun);
                heldStack.func_77982_d(nbtTagCompound);
            }
        }
    }

    @secured
    public void fireServer(EntityPlayer entityPlayer, float rotationPitch, float rotationYaw, World world, ItemStack gunStack, ItemGun itemGun, WeaponFireMode fireMode, int clientFireTickDelay, float recoilPitch, float recoilYaw, float recoilAimReducer, float bulletSpread) {
        GunType gunType = itemGun.type;
        if (this.isValidShoot(clientFireTickDelay, recoilPitch, recoilYaw, recoilAimReducer, bulletSpread, this.type)) {
            int shotCount;
            if (ItemGun.isServerReloading(entityPlayer) || !this.type.allowSprintFiring && entityPlayer.func_70051_ag() || !itemGun.type.hasFireMode(fireMode)) {
                return;
            }
            WeaponFireEvent.PreServer preFireEvent = new WeaponFireEvent.PreServer(entityPlayer, gunStack, itemGun, gunType.weaponMaxRange);
            MinecraftForge.EVENT_BUS.post((Event)preFireEvent);
            if (preFireEvent.isCanceled()) {
                return;
            }
            int n = fireMode == WeaponFireMode.BURST ? (gunStack.func_77978_p().func_74762_e("shotsremaining") > 0 ? gunStack.func_77978_p().func_74762_e("shotsremaining") : gunType.numBurstRounds) : (shotCount = llllIII[1]);
            if (!(preFireEvent.getResult() != Event.Result.DEFAULT && preFireEvent.getResult() != Event.Result.ALLOW || ItemGun.hasNextShot(gunStack))) {
                if (canDryFire) {
                    gunType.playSound((EntityLivingBase)entityPlayer, WeaponSoundType.DryFire, gunStack);
                    canDryFire = llllIII[0];
                }
                if (fireMode == WeaponFireMode.BURST) {
                    gunStack.func_77978_p().func_74768_a("shotsremaining", llllIII[0]);
                }
                return;
            }
            if (GunType.getAttachment(gunStack, AttachmentEnum.Barrel) != null) {
                gunType.playSound((EntityLivingBase)entityPlayer, WeaponSoundType.FireSuppressed, gunStack, entityPlayer);
            } else if (GunType.isPackAPunched(gunStack)) {
                gunType.playSound((EntityLivingBase)entityPlayer, WeaponSoundType.Punched, gunStack, entityPlayer);
                gunType.playSound((EntityLivingBase)entityPlayer, WeaponSoundType.Fire, gunStack, entityPlayer);
            } else {
                gunType.playSound((EntityLivingBase)entityPlayer, WeaponSoundType.Fire, gunStack, entityPlayer);
            }
            ArrayList<Entity> entities = new ArrayList<Entity>();
            int numBullets = gunType.numBullets;
            ItemBullet bulletItem = ItemGun.getUsedBullet(gunStack, gunType);
            if (bulletItem != null && bulletItem.type.isSlug) {
                numBullets = llllIII[1];
            }
            ArrayList<Object> rayTraceList = new ArrayList<Object>();
            for (int i = llllIII[0]; i < numBullets; ++i) {
                BulletHit rayTrace = RayUtil.standardEntityRayTrace(world, rotationPitch, rotationYaw, (EntityLivingBase)entityPlayer, preFireEvent.getWeaponRange(), itemGun, GunType.isPackAPunched(gunStack));
                rayTraceList.add(rayTrace);
            }
            boolean headshot = llllIII[0];
            for (BulletHit bulletHit : rayTraceList) {
                EntityPlayer victim;
                if (bulletHit instanceof PlayerHit) {
                    if (world.field_72995_K || (victim = ((PlayerHit)bulletHit).getEntity()) == null || victim.field_70128_L) continue;
                    entities.add((Entity)victim);
                    gunType.playSoundPos(victim.func_180425_c(), world, WeaponSoundType.Penetration);
                    headshot = ((PlayerHit)bulletHit).hitbox.type.equals((Object)EnumHitboxType.HEAD);
                    if (!(entityPlayer instanceof EntityPlayerMP)) continue;
                    ModularWarfare.NETWORK.sendTo(new PacketPlayHitmarker(headshot), (EntityPlayerMP)entityPlayer);
                    ModularWarfare.NETWORK.sendTo(new PacketPlaySound(victim.func_180425_c(), "flyby", 1.0f, 1.0f), (EntityPlayerMP)victim);
                    continue;
                }
                if (world.field_72995_K || bulletHit.rayTraceResult == null) continue;
                if (bulletHit.rayTraceResult.field_72308_g instanceof EntityLivingBase) {
                    victim = (EntityLivingBase)bulletHit.rayTraceResult.field_72308_g;
                    if (victim == null) continue;
                    entities.add((Entity)victim);
                    gunType.playSoundPos(victim.func_180425_c(), world, WeaponSoundType.Penetration);
                    boolean bl = headshot = this.canEntityGetHeadshot((Entity)victim) && bulletHit.rayTraceResult.field_72307_f.field_72448_b >= (double)((float)victim.func_180425_c().func_177956_o() + victim.func_70047_e() - 0.15f) ? llllIII[1] : llllIII[0];
                    if (!(entityPlayer instanceof EntityPlayerMP)) continue;
                    ModularWarfare.NETWORK.sendTo(new PacketPlayHitmarker(headshot), (EntityPlayerMP)entityPlayer);
                    continue;
                }
                if (bulletHit.rayTraceResult.field_72307_f == null) continue;
                BlockPos blockPos = bulletHit.rayTraceResult.func_178782_a();
                this.playImpactSound(world, blockPos, gunType);
                gunType.playSoundPos(blockPos, world, WeaponSoundType.Crack, entityPlayer, 1.0f);
                this.doHit(bulletHit.rayTraceResult, entityPlayer);
            }
            if (ModConfig.INSTANCE.dropBulletCasing && this.type.dropBulletCasing) {
                EntityShell shell = new EntityShell(world, entityPlayer, itemGun, bulletItem);
                shell.setHeadingFromThrower((Entity)entityPlayer, entityPlayer.field_70125_A, entityPlayer.field_70177_z + 110.0f, 0.0f, 0.2f, 5.0f);
                if (!world.field_72995_K) {
                    world.func_72838_d((Entity)shell);
                }
            }
            WeaponFireEvent.Post postFireEvent = new WeaponFireEvent.Post(entityPlayer, gunStack, itemGun, entities);
            MinecraftForge.EVENT_BUS.post((Event)postFireEvent);
            if (postFireEvent.getAffectedEntities() != null && !postFireEvent.getAffectedEntities().isEmpty()) {
                for (Entity target : postFireEvent.getAffectedEntities()) {
                    IExtraItemHandler extraSlots;
                    ItemStack plate;
                    EntityPlayer player;
                    if (target == null || target == entityPlayer) continue;
                    WeaponHitEvent.Pre preHitEvent = new WeaponHitEvent.Pre(entityPlayer, gunStack, itemGun, headshot, postFireEvent.getDamage(), target);
                    MinecraftForge.EVENT_BUS.post((Event)preHitEvent);
                    if (preHitEvent.isCanceled()) {
                        return;
                    }
                    if (headshot) {
                        preHitEvent.setDamage(preHitEvent.getDamage() + gunType.gunDamageHeadshotBonus);
                    }
                    if (target instanceof EntityLivingBase) {
                        EntityLivingBase targetELB = (EntityLivingBase)target;
                        if (bulletItem != null && bulletItem.type != null) {
                            preHitEvent.setDamage(preHitEvent.getDamage() * bulletItem.type.bulletDamageFactor);
                            if (bulletItem.type.bulletProperties != null && !bulletItem.type.bulletProperties.isEmpty()) {
                                BulletProperty bulletProperty;
                                BulletProperty bulletProperty2 = bulletProperty = bulletItem.type.bulletProperties.get(targetELB.func_70005_c_()) != null ? bulletItem.type.bulletProperties.get(targetELB.func_70005_c_()) : bulletItem.type.bulletProperties.get("All");
                                if (bulletProperty.potionEffects != null) {
                                    PotionEntry[] potionEntryArray = bulletProperty.potionEffects;
                                    int n2 = potionEntryArray.length;
                                    for (int i = llllIII[0]; i < n2; ++i) {
                                        PotionEntry potionEntry = potionEntryArray[i];
                                        targetELB.func_70690_d(new PotionEffect(potionEntry.potionEffect.getPotion(), potionEntry.duration, potionEntry.level));
                                    }
                                }
                            }
                        }
                    }
                    if (target instanceof EntityPlayer && ((PlayerHit)rayTraceList.get((int)ItemGun.llllIII[0])).hitbox.type.equals((Object)EnumHitboxType.BODY) && (player = (EntityPlayer)target).hasCapability(CapabilityExtra.CAPABILITY, null) && (plate = (extraSlots = (IExtraItemHandler)player.getCapability(CapabilityExtra.CAPABILITY, null)).getStackInSlot(llllIII[1])) != null && plate.func_77973_b() instanceof ItemSpecialArmor) {
                        ArmorType armorType = ((ItemSpecialArmor)plate.func_77973_b()).type;
                        float damage = preHitEvent.getDamage();
                        preHitEvent.setDamage((float)((double)damage - (double)damage * armorType.defense));
                    }
                    if (!ModConfig.INSTANCE.applyKnockback) {
                        RayUtil.attackEntityWithoutKnockback(target, (DamageSource)new ModularDamageSource("modularwarfare", (Entity)entityPlayer, itemGun, headshot), preHitEvent.getDamage());
                    } else {
                        target.func_70097_a((DamageSource)new ModularDamageSource("modularwarfare", (Entity)entityPlayer, itemGun, headshot), preHitEvent.getDamage());
                    }
                    target.field_70172_ad = llllIII[0];
                    WeaponHitEvent.Post postHitEvent = new WeaponHitEvent.Post(entityPlayer, gunStack, itemGun, postFireEvent.getAffectedEntities(), preHitEvent.getDamage());
                    MinecraftForge.EVENT_BUS.post((Event)postHitEvent);
                }
            }
            if (fireMode == WeaponFireMode.BURST) {
                gunStack.func_77978_p().func_74768_a("shotsremaining", shotCount -= llllIII[1]);
            }
            if (preFireEvent.getResult() == Event.Result.DEFAULT || preFireEvent.getResult() == Event.Result.ALLOW) {
                ItemGun.consumeShot(gunStack);
            }
            if (ServerTickHandler.playerAimShootCooldown.get(entityPlayer.func_70005_c_()) == null) {
                ModularWarfare.NETWORK.sendToAll(new PacketAimingReponse(entityPlayer.func_70005_c_(), llllIII[1]));
            }
            ServerTickHandler.playerAimShootCooldown.put(entityPlayer.func_70005_c_(), llllIII[2]);
        } else if (ModConfig.INSTANCE.kickIfModifiedContentPack) {
            ((EntityPlayerMP)entityPlayer).field_71135_a.func_194028_b((ITextComponent)new TextComponentString("[ModularWarfare] Kicked for client-side modified content-pack. (Bad RPM/Recoil for the gun: " + itemGun.type.internalName + ") [RPM should be: " + itemGun.type.roundsPerMin + "]"));
        }
    }

    public boolean canHarvestBlock(IBlockState state, ItemStack stack) {
        return llllIII[0];
    }

    private static void lIIlIll() {
        llllIII = new int[5];
        ItemGun.llllIII[0] = (0x7B ^ 0x60 ^ (0x7A ^ 0x30)) & (0x30 ^ 0x1E ^ 72 + 78 - 105 + 82 ^ -" ".length());
        ItemGun.llllIII[1] = " ".length();
        ItemGun.llllIII[2] = 179 + 78 - 11 + 4 ^ 49 + 15 - 52 + 186;
        ItemGun.llllIII[3] = "  ".length();
        ItemGun.llllIII[4] = "   ".length();
    }

    public boolean isValidShoot(long clientFireTickDelay, float recoilPitch, float recoilYaw, float recoilAimReducer, float bulletSpread, GunType type) {
        return (clientFireTickDelay == (long)type.fireTickDelay && type.recoilPitch == recoilPitch && type.recoilYaw == recoilYaw && type.recoilAimReducer == recoilAimReducer && type.bulletSpread == bulletSpread ? llllIII[1] : llllIII[0]) != 0;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        boolean result;
        boolean bl = result = !oldStack.equals(newStack) ? llllIII[1] : llllIII[0];
        if (result) {
            // empty if block
        }
        return result;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        ItemStack ammoStack;
        GunType gunType = ((ItemGun)stack.func_77973_b()).type;
        if (gunType == null) {
            return;
        }
        if (ItemGun.hasAmmoLoaded(stack) && (ammoStack = new ItemStack(stack.func_77978_p().func_74775_l("ammo"))).func_77973_b() instanceof ItemAmmo) {
            ItemAmmo itemAmmo = (ItemAmmo)ammoStack.func_77973_b();
            if (itemAmmo.type.magazineCount == llllIII[1]) {
                int currentAmmoCount = llllIII[0];
                if (ammoStack.func_77978_p() != null) {
                    NBTTagCompound tag = ammoStack.func_77978_p();
                    currentAmmoCount = tag.func_74764_b("ammocount") ? tag.func_74762_e("ammocount") : llllIII[0];
                }
                tooltip.add(this.generateLoreLineAlt("Ammo", Integer.toString(currentAmmoCount), Integer.toString(itemAmmo.type.ammoCapacity)));
            } else if (stack.func_77978_p() != null) {
                if (gunType.acceptedBullets != null) {
                    int ammoCount = stack.func_77978_p().func_74764_b("ammocount") ? stack.func_77978_p().func_74762_e("ammocount") : llllIII[0];
                    tooltip.add(this.generateLoreLineAlt("Ammo", Integer.toString(ammoCount), Integer.toString(gunType.internalAmmoStorage)));
                }
                String baseDisplayLine = "Ammo %s: %g%s%dg/%g%s";
                baseDisplayLine = baseDisplayLine.replaceAll("%b", TextFormatting.BLUE.toString());
                baseDisplayLine = baseDisplayLine.replaceAll("%dg", TextFormatting.DARK_GRAY.toString());
                for (int i = llllIII[1]; i < itemAmmo.type.magazineCount + llllIII[1]; ++i) {
                    NBTTagCompound tag = ammoStack.func_77978_p();
                    String string = baseDisplayLine.replaceAll("%g", i == tag.func_74762_e("magcount") ? TextFormatting.YELLOW.toString() : TextFormatting.GRAY.toString());
                    Object[] objectArray = new Object[llllIII[4]];
                    objectArray[ItemGun.llllIII[0]] = i;
                    objectArray[ItemGun.llllIII[1]] = tag.func_74762_e("ammocount" + i);
                    objectArray[ItemGun.llllIII[3]] = itemAmmo.type.ammoCapacity;
                    tooltip.add(String.format(string, objectArray));
                }
            }
        }
        if (stack.func_77978_p() != null && gunType.acceptedBullets != null) {
            int ammoCount = stack.func_77978_p().func_74764_b("ammocount") ? stack.func_77978_p().func_74762_e("ammocount") : llllIII[0];
            tooltip.add(this.generateLoreLineAlt("Ammo", Integer.toString(ammoCount), Integer.toString(gunType.internalAmmoStorage)));
        }
        if (ItemAmmo.getUsedBullet(stack) != null) {
            ItemBullet itemBullet = ItemAmmo.getUsedBullet(stack);
            tooltip.add(this.generateLoreLine("Bullet", itemBullet.type.displayName));
        }
        String baseDisplayLine = "%bFire Mode: %g%s";
        baseDisplayLine = baseDisplayLine.replaceAll("%b", TextFormatting.BLUE.toString());
        baseDisplayLine = baseDisplayLine.replaceAll("%g", TextFormatting.GRAY.toString());
        Object[] objectArray = new Object[llllIII[1]];
        objectArray[ItemGun.llllIII[0]] = GunType.getFireMode(stack) != null ? GunType.getFireMode(stack) : gunType.fireModes[llllIII[0]];
        tooltip.add(String.format(baseDisplayLine, objectArray));
        if (GuiScreen.func_146272_n()) {
            String magName;
            String internalName;
            int n;
            String[] stringArray;
            DecimalFormat decimalFormat = new DecimalFormat("#.#");
            String damageLine = "%bDamage: %g%s";
            damageLine = damageLine.replaceAll("%b", TextFormatting.BLUE.toString());
            damageLine = damageLine.replaceAll("%g", TextFormatting.RED.toString());
            if (gunType.numBullets > llllIII[1]) {
                Object[] objectArray2 = new Object[llllIII[1]];
                objectArray2[ItemGun.llllIII[0]] = gunType.gunDamage + " x " + gunType.numBullets;
                tooltip.add(String.format(damageLine, objectArray2));
            } else {
                Object[] objectArray3 = new Object[llllIII[1]];
                objectArray3[ItemGun.llllIII[0]] = Float.valueOf(gunType.gunDamage);
                tooltip.add(String.format(damageLine, objectArray3));
            }
            String accuracyLine = "%bAccuracy: %g%s";
            accuracyLine = accuracyLine.replaceAll("%b", TextFormatting.BLUE.toString());
            accuracyLine = accuracyLine.replaceAll("%g", TextFormatting.RED.toString());
            Object[] objectArray4 = new Object[llllIII[1]];
            objectArray4[ItemGun.llllIII[0]] = decimalFormat.format(1.0f / gunType.bulletSpread * 100.0f) + "%";
            tooltip.add(String.format(accuracyLine, objectArray4));
            if (gunType.acceptedAttachments != null && !gunType.acceptedAttachments.isEmpty()) {
                tooltip.add("" + TextFormatting.BLUE.toString() + "Accepted attachments:");
                for (ArrayList n3 : gunType.acceptedAttachments.values()) {
                    for (int i = llllIII[0]; i < n3.size(); ++i) {
                        try {
                            String attachment = ModularWarfare.attachmentTypes.get(n3.get((int)i)).type.displayName;
                            if (attachment == null) continue;
                            tooltip.add("- " + attachment);
                            continue;
                        }
                        catch (NullPointerException attachment) {
                            // empty catch block
                        }
                    }
                }
            }
            if (gunType.acceptedAmmo != null) {
                tooltip.add("" + TextFormatting.BLUE.toString() + "Accepted mags:");
                if (gunType.acceptedAmmo.length > 0) {
                    stringArray = gunType.acceptedAmmo;
                    int n2 = stringArray.length;
                    for (n = llllIII[0]; n < n2; ++n) {
                        internalName = stringArray[n];
                        if (!ModularWarfare.ammoTypes.containsKey(internalName) || (magName = ModularWarfare.ammoTypes.get((Object)internalName).type.displayName) == null) continue;
                        tooltip.add("- " + magName);
                    }
                }
            }
            if (gunType.acceptedBullets != null) {
                tooltip.add("" + TextFormatting.BLUE.toString() + "Accepted bullets:");
                if (gunType.acceptedBullets.length > 0) {
                    stringArray = gunType.acceptedBullets;
                    int n3 = stringArray.length;
                    for (n = llllIII[0]; n < n3; ++n) {
                        internalName = stringArray[n];
                        if (!ModularWarfare.bulletTypes.containsKey(internalName) || (magName = ModularWarfare.bulletTypes.get((Object)internalName).type.displayName) == null) continue;
                        tooltip.add("- " + magName);
                    }
                }
            }
        } else {
            tooltip.add("\u00a7e[Shift]");
        }
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        Multimap multimap = super.getAttributeModifiers(slot, stack);
        if (slot == EntityEquipmentSlot.MAINHAND) {
            multimap.put((Object)SharedMonsterAttributes.field_111263_d.func_111108_a(), (Object)new AttributeModifier(MOVEMENT_SPEED_MODIFIER, "MovementSpeed", (double)(this.type.moveSpeedModifier - 1.0f), llllIII[3]));
        }
        return multimap;
    }

    public static boolean isOnShootCooldown(UUID uuid) {
        return ClientTickHandler.playerShootCooldown.containsKey(uuid);
    }

    public static boolean isServerReloading(EntityPlayer entityPlayer) {
        return ServerTickHandler.playerReloadCooldown.containsKey(entityPlayer.func_110124_au());
    }

    public boolean doesSneakBypassUse(ItemStack stack, IBlockAccess world, BlockPos pos, EntityPlayer player) {
        return llllIII[0];
    }

    public boolean func_77651_p() {
        return llllIII[1];
    }

    public static ItemBullet getUsedBullet(ItemStack gunStack, GunType gunType) {
        if (gunType.acceptedAmmo != null) {
            return ItemAmmo.getUsedBullet(gunStack);
        }
        if (gunType.acceptedBullets != null && gunStack.func_77942_o() && gunStack.func_77978_p().func_74764_b("bullet")) {
            ItemStack usedBullet = new ItemStack(gunStack.func_77978_p().func_74775_l("bullet"));
            ItemBullet usedBulletItem = (ItemBullet)usedBullet.func_77973_b();
            return usedBulletItem;
        }
        return null;
    }

    public static boolean hasAmmoLoaded(ItemStack gunStack) {
        return (!gunStack.func_190926_b() ? (!(gunStack.func_77973_b() instanceof ItemAir) ? (gunStack.func_77942_o() ? (gunStack.func_77978_p().func_74764_b("ammo") ? (gunStack.func_77978_p().func_74781_a("ammo") != null ? llllIII[1] : llllIII[0]) : llllIII[0]) : llllIII[0]) : llllIII[0]) : llllIII[0]) != 0;
    }

    public boolean onBlockStartBreak(ItemStack itemstack, BlockPos pos, EntityPlayer player) {
        World world = player.field_70170_p;
        if (!world.field_72995_K) {
            IBlockState state = world.func_180495_p(pos);
            world.func_184138_a(pos, state, state, llllIII[4]);
        }
        return llllIII[1];
    }

    public static int getMagazineBullets(ItemStack gunStack) {
        ItemStack ammoStack;
        if (ItemGun.hasAmmoLoaded(gunStack) && (ammoStack = new ItemStack(gunStack.func_77978_p().func_74775_l("ammo"))).func_77973_b() instanceof ItemAmmo) {
            ItemAmmo itemAmmo = (ItemAmmo)ammoStack.func_77973_b();
            if (ammoStack.func_77978_p() != null) {
                String key = itemAmmo.type.magazineCount > llllIII[1] ? "ammocount" + ammoStack.func_77978_p().func_74762_e("magcount") : "ammocount";
                int ammoCount = ammoStack.func_77978_p().func_74762_e(key);
                return ammoCount;
            }
        }
        return llllIII[0];
    }

    public void doHit(RayTraceResult raytraceResultIn, EntityPlayer shooter) {
        if (raytraceResultIn.func_178782_a() != null) {
            BlockPos pos = raytraceResultIn.func_178782_a();
            EntityDecal.EnumDecalSide side = EntityDecal.EnumDecalSide.ALL;
            int shouldRender = llllIII[0];
            double hitX = raytraceResultIn.field_72307_f.field_72450_a;
            double hitY = raytraceResultIn.field_72307_f.field_72448_b;
            double hitZ = raytraceResultIn.field_72307_f.field_72449_c;
            double milieuX = (double)pos.func_177958_n() + 0.5;
            double milieuY = (double)pos.func_177956_o() + 0.5;
            double milieuZ = (double)pos.func_177952_p() + 0.5;
            double differenceX = hitX - milieuX;
            double differenceY = hitY - milieuY;
            double differenceZ = hitZ - milieuZ;
            if (differenceX == 0.0) {
                if (shooter.field_70165_t < hitX) {
                    hitX -= 0.5;
                    differenceX -= 0.5;
                } else {
                    hitX += 0.5;
                    differenceX += 0.5;
                }
            }
            if (differenceY == 0.0) {
                hitY += 0.5;
                differenceY += 0.5;
            }
            if (differenceZ == 0.0) {
                if (shooter.field_70161_v < hitZ) {
                    hitZ -= 0.5;
                    differenceZ -= 0.5;
                } else {
                    hitZ += 0.5;
                    differenceZ += 0.5;
                }
            }
            if (differenceX == -0.5) {
                side = EntityDecal.EnumDecalSide.EAST;
                shouldRender = llllIII[1];
            }
            if (differenceX == 0.5) {
                side = EntityDecal.EnumDecalSide.WEST;
                shouldRender = llllIII[1];
            }
            if (differenceZ == -0.5) {
                side = EntityDecal.EnumDecalSide.SOUTH;
                shouldRender = llllIII[1];
            }
            if (differenceZ == 0.5) {
                side = EntityDecal.EnumDecalSide.NORTH;
                shouldRender = llllIII[1];
            }
            if (differenceY == 0.5) {
                side = EntityDecal.EnumDecalSide.FLOOR;
                shouldRender = llllIII[1];
            }
            if (shouldRender != 0) {
                ModularWarfare.NETWORK.sendToAll(new PacketDecal(llllIII[0], side, hitX, hitY + 0.095, hitZ, llllIII[0]));
            }
        }
    }

    public void onGunSwitchMode(EntityPlayer entityPlayer, World world, ItemStack gunStack, ItemGun itemGun, WeaponFireMode fireMode) {
        GunType.setFireMode(gunStack, fireMode);
        GunType gunType = itemGun.type;
        if (WeaponSoundType.ModeSwitch != null) {
            gunType.playSound((EntityLivingBase)entityPlayer, WeaponSoundType.ModeSwitch, gunStack);
        }
    }

    public static boolean isClientReloading(EntityPlayer entityPlayer) {
        return ClientTickHandler.playerReloadCooldown.containsKey(entityPlayer.func_110124_au());
    }

    /*
     * Unable to fully structure code
     */
    public void onUpdateClient(EntityPlayer entityPlayer, World world, ItemStack heldStack, ItemGun itemGun, GunType gunType) {
        block7: {
            block9: {
                block8: {
                    if (RenderParameters.switchDelay > 0) {
                        RenderParameters.switchDelay -= ItemGun.llllIII[1];
                    }
                    if (entityPlayer.func_184614_ca() == null || !(entityPlayer.func_184614_ca().func_77973_b() instanceof ItemGun) || RenderParameters.switchDelay != 0) break block7;
                    if (!ItemGun.fireButtonHeld || !Minecraft.func_71410_x().field_71415_G) break block8;
                    if (GunType.getFireMode(heldStack) != WeaponFireMode.FULL) break block8;
                    this.fireClient(entityPlayer, world, heldStack, itemGun, GunType.getFireMode(heldStack));
                    break block9;
                }
                if ((ItemGun.fireButtonHeld & (ItemGun.lastFireButtonHeld == false ? ItemGun.llllIII[1] : ItemGun.llllIII[0])) == 0 || !Minecraft.func_71410_x().field_71415_G) ** GOTO lbl-1000
                if (GunType.getFireMode(heldStack) == WeaponFireMode.SEMI) {
                    this.fireClient(entityPlayer, world, heldStack, itemGun, GunType.getFireMode(heldStack));
                } else if (GunType.getFireMode(heldStack) == WeaponFireMode.BURST) {
                    tagCompound = heldStack.func_77978_p();
                    canFire = ItemGun.llllIII[1];
                    if (tagCompound.func_74764_b("shotsremaining") && tagCompound.func_74762_e("shotsremaining") > 0) {
                        this.fireClient(entityPlayer, world, heldStack, itemGun, GunType.getFireMode(heldStack));
                        canFire = ItemGun.llllIII[0];
                    } else if ((ItemGun.fireButtonHeld & (ItemGun.lastFireButtonHeld == false ? ItemGun.llllIII[1] : ItemGun.llllIII[0])) != 0 && Minecraft.func_71410_x().field_71415_G && canFire != 0) {
                        this.fireClient(entityPlayer, world, heldStack, itemGun, GunType.getFireMode(heldStack));
                    }
                }
            }
            ItemGun.lastFireButtonHeld = ItemGun.fireButtonHeld;
        }
    }

    public void playImpactSound(World world, BlockPos pos, GunType gunType) {
        if (world.func_180495_p(pos).func_185904_a() == Material.field_151576_e) {
            gunType.playSoundPos(pos, world, WeaponSoundType.ImpactStone, null, 1.0f);
        } else if (world.func_180495_p(pos).func_185904_a() == Material.field_151577_b || world.func_180495_p(pos).func_185904_a() == Material.field_151578_c || world.func_180495_p(pos).func_185904_a() == Material.field_151595_p) {
            gunType.playSoundPos(pos, world, WeaponSoundType.ImpactDirt, null, 1.0f);
        } else if (world.func_180495_p(pos).func_185904_a() == Material.field_151575_d) {
            gunType.playSoundPos(pos, world, WeaponSoundType.ImpactWood, null, 1.0f);
        } else if (world.func_180495_p(pos).func_185904_a() == Material.field_151592_s) {
            gunType.playSoundPos(pos, world, WeaponSoundType.ImpactGlass, null, 1.0f);
        } else if (world.func_180495_p(pos).func_185904_a() == Material.field_151586_h) {
            gunType.playSoundPos(pos, world, WeaponSoundType.ImpactWater, null, 1.0f);
        } else if (world.func_180495_p(pos).func_185904_a() == Material.field_151573_f) {
            gunType.playSoundPos(pos, world, WeaponSoundType.ImpactMetal, null, 1.0f);
        } else {
            gunType.playSoundPos(pos, world, WeaponSoundType.ImpactDirt, null, 1.0f);
        }
    }

    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        return llllIII[1];
    }

    @secured
    public void fireClient(EntityPlayer entityPlayer, World world, ItemStack gunStack, ItemGun itemGun, WeaponFireMode fireMode) {
        GunType gunType = itemGun.type;
        if (ItemGun.isOnShootCooldown(entityPlayer.func_110124_au()) || ItemGun.isClientReloading(entityPlayer) || ClientRenderHooks.getAnimMachine((EntityPlayer)entityPlayer).attachmentMode || !this.type.allowSprintFiring && entityPlayer.func_70051_ag() || !itemGun.type.hasFireMode(fireMode)) {
            return;
        }
        int shotCount = fireMode == WeaponFireMode.BURST ? (gunStack.func_77978_p().func_74762_e("shotsremaining") > 0 ? gunStack.func_77978_p().func_74762_e("shotsremaining") : gunType.numBurstRounds) : llllIII[1];
        WeaponFireEvent.PreClient preFireEvent = new WeaponFireEvent.PreClient(entityPlayer, gunStack, itemGun, gunType.weaponMaxRange);
        MinecraftForge.EVENT_BUS.post((Event)preFireEvent);
        if (preFireEvent.isCanceled()) {
            return;
        }
        if (!(preFireEvent.getResult() != Event.Result.DEFAULT && preFireEvent.getResult() != Event.Result.ALLOW || ItemGun.hasNextShot(gunStack))) {
            if (canDryFire) {
                gunType.playClientSound(entityPlayer, WeaponSoundType.DryFire);
                gunType.playClientSound(entityPlayer, WeaponSoundType.FireLast);
                canDryFire = llllIII[0];
            }
            if (fireMode == WeaponFireMode.BURST) {
                gunStack.func_77978_p().func_74768_a("shotsremaining", llllIII[0]);
            }
            return;
        }
        if (gunStack.equals(entityPlayer.func_184586_b(EnumHand.MAIN_HAND))) {
            ModularWarfare.NETWORK.sendToServer(new PacketGunFire(gunType.internalName, gunType.fireTickDelay, gunType.recoilPitch, gunType.recoilYaw, gunType.recoilAimReducer, gunType.bulletSpread, entityPlayer.field_70125_A, entityPlayer.field_70177_z));
        }
        ModularWarfare.PROXY.onShootAnimation(entityPlayer, gunType.internalName, gunType.fireTickDelay, this.type.recoilPitch, this.type.recoilYaw);
        canDryFire = llllIII[1];
        if (GunType.getAttachment(gunStack, AttachmentEnum.Barrel) != null) {
            ItemAttachment barrelAttachment = (ItemAttachment)GunType.getAttachment(gunStack, AttachmentEnum.Barrel).func_77973_b();
            if (barrelAttachment.type.barrel.isSuppressor) {
                gunType.playClientSound(entityPlayer, WeaponSoundType.FireSuppressed);
            } else {
                gunType.playClientSound(entityPlayer, WeaponSoundType.Fire);
            }
        } else if (GunType.isPackAPunched(gunStack)) {
            gunType.playClientSound(entityPlayer, WeaponSoundType.Punched);
            gunType.playClientSound(entityPlayer, WeaponSoundType.Fire);
        } else {
            gunType.playClientSound(entityPlayer, WeaponSoundType.Fire);
        }
        if (gunType.weaponType == WeaponType.BoltSniper || gunType.weaponType == WeaponType.Shotgun) {
            gunType.playClientSound(entityPlayer, WeaponSoundType.Pump);
        }
        if (fireMode == WeaponFireMode.BURST) {
            gunStack.func_77978_p().func_74768_a("shotsremaining", shotCount -= llllIII[1]);
        }
        ClientTickHandler.playerShootCooldown.put(entityPlayer.func_110124_au(), gunType.fireTickDelay);
    }

    private boolean canEntityGetHeadshot(Entity e) {
        return (e instanceof EntityZombie || e instanceof EntitySkeleton || e instanceof EntityCreeper || e instanceof EntityWitch || e instanceof EntityPigZombie || e instanceof EntityEnderman || e instanceof EntityWitherSkeleton || e instanceof EntityPlayer || e instanceof EntityVillager || e instanceof EntityEvoker || e instanceof EntityStray || e instanceof EntityVindicator || e instanceof EntityIronGolem || e instanceof EntitySnowman || e.func_70005_c_().contains("common") ? llllIII[1] : llllIII[0]) != 0;
    }

    public int func_77626_a(ItemStack p_77626_1_) {
        return llllIII[0];
    }

    public static void consumeShot(ItemStack gunStack) {
        if (ItemGun.hasAmmoLoaded(gunStack)) {
            ItemStack ammoStack = new ItemStack(gunStack.func_77978_p().func_74775_l("ammo"));
            ItemAmmo itemAmmo = (ItemAmmo)ammoStack.func_77973_b();
            if (ammoStack.func_77978_p() != null) {
                NBTTagCompound nbtTagCompound = ammoStack.func_77978_p();
                String key = itemAmmo.type.magazineCount > llllIII[1] ? "ammocount" + nbtTagCompound.func_74762_e("magcount") : "ammocount";
                nbtTagCompound.func_74768_a(key, nbtTagCompound.func_74762_e(key) - llllIII[1]);
                gunStack.func_77978_p().func_74782_a("ammo", (NBTBase)ammoStack.func_77955_b(new NBTTagCompound()));
            }
        } else if (gunStack.func_77978_p() != null && gunStack.func_77978_p().func_74764_b("ammocount")) {
            int ammoCount = gunStack.func_77978_p().func_74762_e("ammocount");
            gunStack.func_77978_p().func_74768_a("ammocount", ammoCount - llllIII[1]);
        }
    }

    public static boolean hasNextShot(ItemStack gunStack) {
        if (ItemGun.hasAmmoLoaded(gunStack)) {
            ItemStack ammoStack = new ItemStack(gunStack.func_77978_p().func_74775_l("ammo"));
            if (ammoStack != null && ammoStack.func_77973_b() instanceof ItemAmmo) {
                ItemAmmo itemAmmo = (ItemAmmo)ammoStack.func_77973_b();
                if (ammoStack.func_77978_p() != null) {
                    String key = itemAmmo.type.magazineCount > llllIII[1] ? "ammocount" + ammoStack.func_77978_p().func_74762_e("magcount") : "ammocount";
                    int ammoCount = ammoStack.func_77978_p().func_74762_e(key) - llllIII[1];
                    return ammoCount >= 0 ? llllIII[1] : llllIII[0];
                }
            }
        } else if (gunStack.func_77978_p() != null && gunStack.func_77978_p().func_74764_b("ammocount")) {
            return gunStack.func_77978_p().func_74762_e("ammocount") > 0 ? llllIII[1] : llllIII[0];
        }
        return llllIII[0];
    }

    public ItemGun(GunType type) {
        super(type);
        this.type = type;
        this.setNoRepair();
    }

    public void onUpdateServer(EntityPlayer entityPlayer, World world, ItemStack heldStack, ItemGun itemGun, GunType gunType) {
    }

    public EnumAction func_77661_b(ItemStack p_77661_1_) {
        return EnumAction.BLOCK;
    }

    @Override
    public void setType(BaseType type) {
        this.type = (GunType)type;
    }

    public boolean func_82788_x() {
        return llllIII[0];
    }
}

