/*
 * Decompiled with CFR 0.152.
 */
package com.modularwarfare.common.hitbox;

import com.modularwarfare.api.AnimationUtils;
import com.modularwarfare.common.guns.ItemGun;
import com.modularwarfare.common.handler.ServerTickHandler;
import com.modularwarfare.common.hitbox.PlayerHitbox;
import com.modularwarfare.common.hitbox.maths.EnumHitboxType;
import com.modularwarfare.common.hitbox.maths.RotatedAxes;
import com.modularwarfare.common.vector.Vector3f;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PlayerSnapshot {
    public Vector3f pos;
    public EntityPlayer player;
    public ArrayList<PlayerHitbox> hitboxes;
    public long time;

    public PlayerSnapshot(EntityPlayer p) {
        this.player = p;
        this.pos = new Vector3f(p.field_70165_t, p.field_70163_u, p.field_70161_v);
        this.hitboxes = new ArrayList();
        RotatedAxes bodyAxes = new RotatedAxes(p.field_70761_aq, 0.0f, 0.0f);
        RotatedAxes headAxes = new RotatedAxes(p.field_70759_as - p.field_70761_aq, p.field_70125_A, 0.0f);
        if (p.func_70093_af()) {
            this.hitboxes.add(new PlayerHitbox(this.player, bodyAxes, new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(-0.25f, 0.0f, -0.15f), new Vector3f(0.5f, 1.0f, 0.3f), EnumHitboxType.BODY));
            this.hitboxes.add(new PlayerHitbox(this.player, bodyAxes.findLocalAxesGlobally(headAxes), new Vector3f(0.0f, 1.0f, 0.0f), new Vector3f(-0.25f, 0.0f, -0.25f), new Vector3f(0.5f, 0.5f, 0.5f), EnumHitboxType.HEAD));
        } else {
            this.hitboxes.add(new PlayerHitbox(this.player, bodyAxes, new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(-0.25f, 0.0f, -0.15f), new Vector3f(0.5f, 1.4f, 0.3f), EnumHitboxType.BODY));
            this.hitboxes.add(new PlayerHitbox(this.player, bodyAxes.findLocalAxesGlobally(headAxes), new Vector3f(0.0f, 1.4f, 0.0f), new Vector3f(-0.25f, 0.0f, -0.25f), new Vector3f(0.5f, 0.5f, 0.5f), EnumHitboxType.HEAD));
        }
        float yHead = (p.field_70759_as - p.field_70761_aq) / 57.295776f;
        float xHead = p.field_70125_A / 57.295776f;
        float zRight = 0.0f;
        float zLeft = 0.0f;
        float yRight = 0.0f;
        float yLeft = 0.0f;
        float xRight = 0.0f;
        float xLeft = 0.0f;
        if (p.func_184614_ca() != null && p.func_184614_ca().func_77973_b() instanceof ItemGun) {
            if (p.field_70170_p.field_72995_K) {
                if (AnimationUtils.isAiming.get(this.player.getDisplayNameString()) != null) {
                    yRight = -0.1f + yHead - 1.5707964f;
                    yLeft = 0.1f + yHead + 0.4f - 1.5707964f;
                    xRight = -1.5707964f + xHead;
                    xLeft = -1.5707964f + xHead;
                } else {
                    yRight = -1.8407964f;
                    yLeft = -1.2407963f;
                    xRight = -0.8717918f;
                    xLeft = -0.8717918f;
                }
            } else if (ServerTickHandler.playerAimShootCooldown.get(p.getDisplayNameString()) != null) {
                yRight = -0.1f + yHead - 1.5707964f;
                yLeft = 0.1f + yHead + 0.4f - 1.5707964f;
                xRight = -1.5707964f + xHead;
                xLeft = -1.5707964f + xHead;
            } else {
                yRight = -1.8407964f;
                yLeft = -1.2407963f;
                xRight = -0.8717918f;
                xLeft = -0.8717918f;
            }
        }
        RotatedAxes leftArmAxes = new RotatedAxes().rotateGlobalPitchInRads(xLeft).rotateGlobalYawInRads((float)Math.PI + yLeft).rotateGlobalRollInRads(-zLeft);
        RotatedAxes rightArmAxes = new RotatedAxes().rotateGlobalPitchInRads(xRight).rotateGlobalYawInRads((float)Math.PI + yRight).rotateGlobalRollInRads(-zRight);
        float originZRight = MathHelper.func_76126_a((float)(-p.field_70761_aq * (float)Math.PI / 180.0f)) * 5.0f / 16.0f;
        float originXRight = -MathHelper.func_76134_b((float)(-p.field_70761_aq * (float)Math.PI / 180.0f)) * 5.0f / 16.0f;
        float originZLeft = -MathHelper.func_76126_a((float)(-p.field_70761_aq * (float)Math.PI / 180.0f)) * 5.0f / 16.0f;
        float originXLeft = MathHelper.func_76134_b((float)(-p.field_70761_aq * (float)Math.PI / 180.0f)) * 5.0f / 16.0f;
        if (p.func_70093_af()) {
            this.hitboxes.add(new PlayerHitbox(this.player, bodyAxes.findLocalAxesGlobally(leftArmAxes), new Vector3f(originXLeft, 0.9f, originZLeft), new Vector3f(-0.125f, -0.6f, -0.125f), new Vector3f(0.25f, 0.7f, 0.25f), EnumHitboxType.LEFTARM));
            this.hitboxes.add(new PlayerHitbox(this.player, bodyAxes.findLocalAxesGlobally(rightArmAxes), new Vector3f(originXRight, 0.9f, originZRight), new Vector3f(-0.125f, -0.6f, -0.125f), new Vector3f(0.25f, 0.7f, 0.25f), EnumHitboxType.RIGHTARM));
        } else {
            this.hitboxes.add(new PlayerHitbox(this.player, bodyAxes.findLocalAxesGlobally(leftArmAxes), new Vector3f(originXLeft, 1.3f, originZLeft), new Vector3f(-0.125f, -0.6f, -0.125f), new Vector3f(0.25f, 0.7f, 0.25f), EnumHitboxType.LEFTARM));
            this.hitboxes.add(new PlayerHitbox(this.player, bodyAxes.findLocalAxesGlobally(rightArmAxes), new Vector3f(originXRight, 1.3f, originZRight), new Vector3f(-0.125f, -0.6f, -0.125f), new Vector3f(0.25f, 0.7f, 0.25f), EnumHitboxType.RIGHTARM));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void renderSnapshot() {
        for (PlayerHitbox hitbox : this.hitboxes) {
            hitbox.renderHitbox(this.player.field_70170_p, this.pos);
        }
    }

    public PlayerHitbox GetHitbox(EnumHitboxType type) {
        for (PlayerHitbox hitbox : this.hitboxes) {
            if (hitbox.type != type) continue;
            return hitbox;
        }
        return null;
    }
}

