/*
 * Decompiled with CFR 0.152.
 */
package com.modularwarfare.common.hitbox.maths;

import com.modularwarfare.common.vector.Matrix4f;
import com.modularwarfare.common.vector.Vector3f;

public class RotatedAxes {
    private float rotationPitch;
    private float rotationRoll;
    private Matrix4f rotationMatrix;
    private static final int[] lIlIIlll;
    private float rotationYaw;

    public float getRoll() {
        return this.rotationRoll;
    }

    public void rotateLocalPitch(float rotateBy) {
        this.rotationMatrix.rotate(rotateBy * (float)Math.PI / 180.0f, this.getZAxis().normalise(null));
        this.convertMatrixToAngles();
    }

    public void rotateGlobal(float rotateBy, Vector3f rotateAround) {
        this.rotationMatrix.rotate(rotateBy * (float)Math.PI / 180.0f, rotateAround);
        this.convertMatrixToAngles();
    }

    public RotatedAxes rotateGlobalYaw(float rotateBy) {
        this.rotationMatrix.rotate(rotateBy * (float)Math.PI / 180.0f, new Vector3f(0.0f, 1.0f, 0.0f));
        this.convertMatrixToAngles();
        return this;
    }

    public void rotateLocalRoll(float rotateBy) {
        this.rotationMatrix.rotate(rotateBy * (float)Math.PI / 180.0f, this.getXAxis().normalise(null));
        this.convertMatrixToAngles();
    }

    public RotatedAxes() {
        this.rotationMatrix = new Matrix4f();
    }

    private static void lIlllll() {
        lIlIIlll = new int[2];
        RotatedAxes.lIlIIlll[0] = (0x78 ^ 0x51 ^ (0xB8 ^ 0x98)) & (89 + 14 - 62 + 115 ^ 32 + 138 - 109 + 88 ^ -" ".length());
        RotatedAxes.lIlIIlll[1] = " ".length();
    }

    public RotatedAxes rotateGlobalRollInRads(float rotateBy) {
        this.rotationMatrix.rotate(rotateBy, new Vector3f(1.0f, 0.0f, 0.0f));
        this.convertMatrixToAngles();
        return this;
    }

    public RotatedAxes rotateGlobalPitch(float rotateBy) {
        this.rotationMatrix.rotate(rotateBy * (float)Math.PI / 180.0f, new Vector3f(0.0f, 0.0f, 1.0f));
        this.convertMatrixToAngles();
        return this;
    }

    public RotatedAxes(Matrix4f mat) {
        this.rotationMatrix = mat;
        this.convertMatrixToAngles();
    }

    public Vector3f getYAxis() {
        return new Vector3f(this.rotationMatrix.m01, this.rotationMatrix.m11, this.rotationMatrix.m21);
    }

    public RotatedAxes(float yaw, float pitch, float roll) {
        this.setAngles(yaw, pitch, roll);
    }

    private void convertAnglesToMatrix() {
        this.rotationMatrix = new Matrix4f();
        this.rotationMatrix.rotate(this.rotationRoll * (float)Math.PI / 180.0f, new Vector3f(1.0f, 0.0f, 0.0f));
        this.rotationMatrix.rotate(this.rotationPitch * (float)Math.PI / 180.0f, new Vector3f(0.0f, 0.0f, 1.0f));
        this.rotationMatrix.rotate(this.rotationYaw * (float)Math.PI / 180.0f, new Vector3f(0.0f, 1.0f, 0.0f));
        this.convertMatrixToAngles();
    }

    public RotatedAxes rotateGlobalYawInRads(float rotateBy) {
        this.rotationMatrix.rotate(rotateBy, new Vector3f(0.0f, 1.0f, 0.0f));
        this.convertMatrixToAngles();
        return this;
    }

    public RotatedAxes findLocalAxesGlobally(RotatedAxes in) {
        Matrix4f mat = new Matrix4f();
        mat.load(in.getMatrix());
        mat.rotate(this.rotationRoll * (float)Math.PI / 180.0f, new Vector3f(1.0f, 0.0f, 0.0f));
        mat.rotate(this.rotationPitch * (float)Math.PI / 180.0f, new Vector3f(0.0f, 0.0f, 1.0f));
        mat.rotate(this.rotationYaw * (float)Math.PI / 180.0f, new Vector3f(0.0f, 1.0f, 0.0f));
        return new RotatedAxes(mat);
    }

    public Matrix4f getMatrix() {
        return this.rotationMatrix;
    }

    public Vector3f getXAxis() {
        return new Vector3f(this.rotationMatrix.m00, this.rotationMatrix.m10, this.rotationMatrix.m20);
    }

    public void setAngles(float yaw, float pitch, float roll) {
        this.rotationYaw = yaw;
        this.rotationPitch = pitch;
        this.rotationRoll = roll;
        this.convertAnglesToMatrix();
    }

    public Vector3f findLocalVectorGlobally(Vector3f in) {
        Matrix4f mat = new Matrix4f();
        mat.m00 = in.x;
        mat.m10 = in.y;
        mat.m20 = in.z;
        mat.rotate(this.rotationRoll * (float)Math.PI / 180.0f, new Vector3f(1.0f, 0.0f, 0.0f));
        mat.rotate(this.rotationPitch * (float)Math.PI / 180.0f, new Vector3f(0.0f, 0.0f, 1.0f));
        mat.rotate(this.rotationYaw * (float)Math.PI / 180.0f, new Vector3f(0.0f, 1.0f, 0.0f));
        return new Vector3f(mat.m00, mat.m10, mat.m20);
    }

    static {
        RotatedAxes.lIlllll();
    }

    public void rotateLocalYaw(float rotateBy) {
        this.rotationMatrix.rotate(rotateBy * (float)Math.PI / 180.0f, this.getYAxis().normalise(null));
        this.convertMatrixToAngles();
    }

    public Vector3f getZAxis() {
        return new Vector3f(-this.rotationMatrix.m02, -this.rotationMatrix.m12, -this.rotationMatrix.m22);
    }

    public void rotateLocal(float rotateBy, Vector3f rotateAround) {
        this.rotationMatrix.rotate(rotateBy * (float)Math.PI / 180.0f, this.findLocalVectorGlobally(rotateAround));
        this.convertMatrixToAngles();
    }

    public boolean isValid() {
        if (this.rotationMatrix.determinant() == 0.0f) {
            return lIlIIlll[0];
        }
        if (Float.isNaN(this.rotationMatrix.determinant())) {
            return lIlIIlll[0];
        }
        return lIlIIlll[1];
    }

    public Vector3f findGlobalVectorLocally(Vector3f in) {
        Matrix4f mat = new Matrix4f();
        mat.m00 = in.x;
        mat.m10 = in.y;
        mat.m20 = in.z;
        mat.rotate(-this.rotationYaw * (float)Math.PI / 180.0f, new Vector3f(0.0f, 1.0f, 0.0f));
        mat.rotate(-this.rotationPitch * (float)Math.PI / 180.0f, new Vector3f(0.0f, 0.0f, 1.0f));
        mat.rotate(-this.rotationRoll * (float)Math.PI / 180.0f, new Vector3f(1.0f, 0.0f, 0.0f));
        return new Vector3f(mat.m00, mat.m10, mat.m20);
    }

    public float getPitch() {
        return this.rotationPitch;
    }

    public float getYaw() {
        return this.rotationYaw;
    }

    private void convertMatrixToAngles() {
        this.rotationYaw = (float)Math.atan2(this.rotationMatrix.m20, this.rotationMatrix.m00) * 180.0f / (float)Math.PI;
        this.rotationPitch = (float)Math.atan2(-this.rotationMatrix.m10, Math.sqrt(this.rotationMatrix.m12 * this.rotationMatrix.m12 + this.rotationMatrix.m11 * this.rotationMatrix.m11)) * 180.0f / (float)Math.PI;
        this.rotationRoll = (float)Math.atan2(this.rotationMatrix.m12, this.rotationMatrix.m11) * 180.0f / (float)Math.PI;
    }

    public RotatedAxes rotateGlobalRoll(float rotateBy) {
        this.rotationMatrix.rotate(rotateBy * (float)Math.PI / 180.0f, new Vector3f(1.0f, 0.0f, 0.0f));
        this.convertMatrixToAngles();
        return this;
    }

    public String toString() {
        return "RotatedAxes[Yaw = " + this.getYaw() + ", Pitch = " + this.getPitch() + ", Roll = " + this.getRoll() + "]";
    }

    public RotatedAxes rotateGlobalPitchInRads(float rotateBy) {
        this.rotationMatrix.rotate(rotateBy, new Vector3f(0.0f, 0.0f, 1.0f));
        this.convertMatrixToAngles();
        return this;
    }

    public RotatedAxes clone() {
        RotatedAxes newAxes = new RotatedAxes();
        newAxes.rotationMatrix.load(this.getMatrix());
        newAxes.convertMatrixToAngles();
        return newAxes;
    }
}

