/*
 * Decompiled with CFR 0.152.
 */
package com.modularwarfare.common.network;

import com.modularwarfare.common.guns.GunType;
import com.modularwarfare.common.guns.ItemGun;
import com.modularwarfare.common.guns.WeaponSoundType;
import com.modularwarfare.common.handler.ServerTickHandler;
import com.modularwarfare.common.network.PacketBase;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public class PacketGunReloadSound
extends PacketBase {
    public WeaponSoundType soundType;

    @Override
    public void decodeInto(ChannelHandlerContext ctx, ByteBuf data) {
        this.soundType = WeaponSoundType.fromString(ByteBufUtils.readUTF8String((ByteBuf)data));
    }

    @Override
    public void handleServerSide(EntityPlayerMP entityPlayer) {
        if (entityPlayer.func_184614_ca() != null && entityPlayer.func_184614_ca().func_77973_b() instanceof ItemGun) {
            ItemStack gunStack = entityPlayer.func_184614_ca();
            ItemGun itemGun = (ItemGun)entityPlayer.func_184614_ca().func_77973_b();
            GunType gunType = itemGun.type;
            InventoryPlayer inventory = entityPlayer.field_71071_by;
            if (!ServerTickHandler.playerReloadCooldown.containsKey(entityPlayer.func_110124_au())) {
                return;
            }
            if (this.soundType == null) {
                return;
            }
            gunType.playSound((EntityLivingBase)entityPlayer, this.soundType, gunStack);
        }
    }

    public PacketGunReloadSound() {
    }

    @Override
    public void encodeInto(ChannelHandlerContext ctx, ByteBuf data) {
        ByteBufUtils.writeUTF8String((ByteBuf)data, (String)this.soundType.eventName);
    }

    @Override
    public void handleClientSide(EntityPlayer entityPlayer) {
    }

    public PacketGunReloadSound(WeaponSoundType soundType) {
        this.soundType = soundType;
    }
}

