/*
 * Decompiled with CFR 0.152.
 */
package com.modularwarfare.common.vector;

import com.modularwarfare.common.vector.ReadableVector3f;
import com.modularwarfare.common.vector.Vector;
import com.modularwarfare.common.vector.WritableVector3f;
import io.netty.buffer.ByteBuf;
import java.io.Serializable;
import java.nio.FloatBuffer;
import net.minecraft.util.math.Vec3d;

public class Vector3f
extends Vector
implements ReadableVector3f,
WritableVector3f,
Serializable {
    public float x;
    private static final int[] lllIIlI;
    private static final long serialVersionUID = 1L;
    public float y;
    public float z;

    @Override
    public final void setX(float x) {
        this.x = x;
    }

    public Vector3f(float x, float y, float z) {
        this.set(x, y, z);
    }

    @Override
    public Vector negate() {
        this.x = -this.x;
        this.y = -this.y;
        this.z = -this.z;
        return this;
    }

    public Vector3f(Vec3d vec) {
        this((float)vec.field_72450_a, (float)vec.field_72448_b, (float)vec.field_72449_c);
    }

    @Override
    public void set(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public String toString() {
        return "Vector3f[" + this.x + ", " + this.y + ", " + this.z + lllIIlI[4];
    }

    @Override
    public Vector load(FloatBuffer buf) {
        this.x = buf.get();
        this.y = buf.get();
        this.z = buf.get();
        return this;
    }

    @Override
    public void set(float x, float y) {
        this.x = x;
        this.y = y;
    }

    @Override
    public final float getX() {
        return this.x;
    }

    public Vector3f(ReadableVector3f src) {
        this.set(src);
    }

    static {
        Vector3f.lIIIllI();
    }

    public static Vector3f sub(Vector3f left, Vector3f right, Vector3f dest) {
        if (dest == null) {
            return new Vector3f(left.x - right.x, left.y - right.y, left.z - right.z);
        }
        dest.set(left.x - right.x, left.y - right.y, left.z - right.z);
        return dest;
    }

    @Override
    public Vector scale(float scale) {
        this.x *= scale;
        this.y *= scale;
        this.z *= scale;
        return this;
    }

    public Vector3f negate(Vector3f dest) {
        if (dest == null) {
            dest = new Vector3f();
        }
        dest.x = -this.x;
        dest.y = -this.y;
        dest.z = -this.z;
        return dest;
    }

    @Override
    public final void setY(float y) {
        this.y = y;
    }

    private static void lIIIllI() {
        lllIIlI = new int[5];
        Vector3f.lllIIlI[0] = " ".length();
        Vector3f.lllIIlI[1] = "   ".length();
        Vector3f.lllIIlI[2] = (0x78 ^ 0x6B ^ (0x2E ^ 0x7A)) & (" ".length() ^ (0xF4 ^ 0xB2) ^ -" ".length());
        Vector3f.lllIIlI[3] = "  ".length();
        Vector3f.lllIIlI[4] = 0xD9 ^ 0x84;
    }

    @Override
    public void setZ(float z) {
        this.z = z;
    }

    public Vector3f set(ReadableVector3f src) {
        this.x = src.getX();
        this.y = src.getY();
        this.z = src.getZ();
        return this;
    }

    public static float dot(Vector3f left, Vector3f right) {
        return left.x * right.x + left.y * right.y + left.z * right.z;
    }

    public static Vector3f readFromBuffer(ByteBuf data) {
        return new Vector3f(data.readFloat(), data.readFloat(), data.readFloat());
    }

    public Vector3f(double x, double y, double z) {
        this((float)x, (float)y, (float)z);
    }

    public Vector3f() {
    }

    public static Vector3f cross(Vector3f left, Vector3f right, Vector3f dest) {
        if (dest == null) {
            dest = new Vector3f();
        }
        dest.set(left.y * right.z - left.z * right.y, right.x * left.z - right.z * left.x, left.x * right.y - left.y * right.x);
        return dest;
    }

    @Override
    public float lengthSquared() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public Vec3d toVec3() {
        return new Vec3d((double)this.x, (double)this.y, (double)this.z);
    }

    public Vector3f normalise(Vector3f dest) {
        float l = this.length();
        if (dest == null) {
            dest = new Vector3f(this.x / l, this.y / l, this.z / l);
        } else {
            dest.set(this.x / l, this.y / l, this.z / l);
        }
        return dest;
    }

    @Override
    public final float getY() {
        return this.y;
    }

    @Override
    public float getZ() {
        return this.z;
    }

    public Vector3f(String input, String typeName) {
        String noBrackets = input.substring(lllIIlI[0], input.length() - lllIIlI[0]);
        String[] split = noBrackets.split(",");
        if (split.length == lllIIlI[1]) {
            this.x = Float.parseFloat(split[lllIIlI[2]]);
            this.y = Float.parseFloat(split[lllIIlI[0]]);
            this.z = Float.parseFloat(split[lllIIlI[3]]);
        }
    }

    public static Vector3f add(Vector3f left, Vector3f right, Vector3f dest) {
        if (dest == null) {
            return new Vector3f(left.x + right.x, left.y + right.y, left.z + right.z);
        }
        dest.set(left.x + right.x, left.y + right.y, left.z + right.z);
        return dest;
    }

    public Vector3f translate(float x, float y, float z) {
        this.x += x;
        this.y += y;
        this.z += z;
        return this;
    }

    @Override
    public Vector store(FloatBuffer buf) {
        buf.put(this.x);
        buf.put(this.y);
        buf.put(this.z);
        return this;
    }

    public static float angle(Vector3f a, Vector3f b) {
        float dls = Vector3f.dot(a, b) / (a.length() * b.length());
        if (dls < -1.0f) {
            dls = -1.0f;
        } else if (dls > 1.0f) {
            dls = 1.0f;
        }
        return (float)Math.acos(dls);
    }

    public void writeToBuffer(ByteBuf data) {
        data.writeFloat(this.x);
        data.writeFloat(this.y);
        data.writeFloat(this.z);
    }
}

