/*
 * Decompiled with CFR 0.152.
 */
package com.modularwarfare.common.vector;

import com.modularwarfare.common.vector.Vector;
import java.nio.FloatBuffer;
import net.minecraft.util.math.Vec3d;

public class Vector3i
extends Vector {
    public int y;
    private static final long serialVersionUID = 1L;
    public int z;
    private static final int[] lIIlIIl;
    public int x;

    static {
        Vector3i.llIIII();
    }

    public String toString() {
        return "Vector3i[" + this.x + ", " + this.y + ", " + this.z + lIIlIIl[0];
    }

    public Vec3d toVec3() {
        return new Vec3d((double)this.x, (double)this.y, (double)this.z);
    }

    public final void setX(int x) {
        this.x = x;
    }

    public static Vector3i cross(Vector3i left, Vector3i right, Vector3i dest) {
        if (dest == null) {
            dest = new Vector3i();
        }
        dest.set(left.y * right.z - left.z * right.y, right.x * left.z - right.z * left.x, left.x * right.y - left.y * right.x);
        return dest;
    }

    public Vector3i normalise(Vector3i dest) {
        float l = this.length();
        if (dest == null) {
            dest = new Vector3i((float)this.x / l, (float)this.y / l, (float)this.z / l);
        } else {
            dest.set((int)((float)this.x / l), (int)((float)this.y / l), (int)((float)this.z / l));
        }
        return dest;
    }

    public Vector3i translate(int x, int y, int z) {
        this.x += x;
        this.y += y;
        this.z += z;
        return this;
    }

    public Vector3i(Vec3d vec) {
        this((int)vec.field_72450_a, (int)vec.field_72448_b, (int)vec.field_72449_c);
    }

    @Override
    public Vector negate() {
        this.x = -this.x;
        this.y = -this.y;
        this.z = -this.z;
        return this;
    }

    @Override
    public Vector store(FloatBuffer buf) {
        buf.put(this.x);
        buf.put(this.y);
        buf.put(this.z);
        return this;
    }

    @Override
    public float lengthSquared() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public Vector3i negate(Vector3i dest) {
        if (dest == null) {
            dest = new Vector3i();
        }
        dest.x = -this.x;
        dest.y = -this.y;
        dest.z = -this.z;
        return dest;
    }

    public final int getY() {
        return this.y;
    }

    public void setZ(int z) {
        this.z = z;
    }

    public static float angle(Vector3i a, Vector3i b) {
        float dls = Vector3i.dot(a, b) / (a.length() * b.length());
        if (dls < -1.0f) {
            dls = -1.0f;
        } else if (dls > 1.0f) {
            dls = 1.0f;
        }
        return (float)Math.acos(dls);
    }

    public final void setY(int y) {
        this.y = y;
    }

    private static void llIIII() {
        lIIlIIl = new int[1];
        Vector3i.lIIlIIl[0] = 0xF1 ^ 0xA9 ^ (0x9D ^ 0x98);
    }

    public static Vector3i sub(Vector3i left, Vector3i right, Vector3i dest) {
        if (dest == null) {
            return new Vector3i(left.x - right.x, left.y - right.y, left.z - right.z);
        }
        dest.set(left.x - right.x, left.y - right.y, left.z - right.z);
        return dest;
    }

    public Vector3i() {
    }

    public int getZ() {
        return this.z;
    }

    public Vector3i(int x, int y, int z) {
        this.set(x, y, z);
    }

    @Override
    public Vector scale(float scale) {
        this.x = (int)((float)this.x * scale);
        this.y = (int)((float)this.y * scale);
        this.z = (int)((float)this.z * scale);
        return this;
    }

    public Vector3i(double x, double y, double z) {
        this((int)x, (int)y, (int)z);
    }

    public static float dot(Vector3i left, Vector3i right) {
        return left.x * right.x + left.y * right.y + left.z * right.z;
    }

    @Override
    public Vector load(FloatBuffer buf) {
        this.x = (int)buf.get();
        this.y = (int)buf.get();
        this.z = (int)buf.get();
        return this;
    }

    public final int getX() {
        return this.x;
    }

    public static Vector3i add(Vector3i left, Vector3i right, Vector3i dest) {
        if (dest == null) {
            return new Vector3i(left.x + right.x, left.y + right.y, left.z + right.z);
        }
        dest.set(left.x + right.x, left.y + right.y, left.z + right.z);
        return dest;
    }

    public void set(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Vector3i(Vector3i v) {
        this(v.x, v.y, v.z);
    }
}

