/*
 * Decompiled with CFR 0.152.
 */
package com.modularwarfare.loader;

import com.modularwarfare.ModularWarfare;
import com.modularwarfare.loader.api.model.AbstractObjModel;
import com.modularwarfare.loader.api.model.ObjModelRenderer;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.List;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ObjModel
extends AbstractObjModel {
    public float modelScale = 1.0f;
    private static final int[] lIlllllII;
    private List<ObjModelRenderer> duplications = new ArrayList<ObjModelRenderer>();
    public List<ObjModelRenderer> parts;

    public ObjModel() {
    }

    @Override
    public void addDuplication(ObjModelRenderer renderer) {
        this.duplications.add(renderer);
    }

    private static void llIlIlIl() {
        lIlllllII = new int[2];
        ObjModel.lIlllllII[0] = " ".length();
        ObjModel.lIlllllII[1] = (17 + 109 - 115 + 143 ^ 54 + 144 - 54 + 44) & (0xFD ^ 0xBC ^ (0x2C ^ 0x4B) ^ -" ".length());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderOnly(float scale, ObjModelRenderer ... partsIn) {
        this.checkForNoDuplications();
        for (ObjModelRenderer part : this.parts) {
            ObjModelRenderer[] objModelRendererArray = partsIn;
            int n = objModelRendererArray.length;
            for (int i = lIlllllII[1]; i < n; ++i) {
                ObjModelRenderer partIn = objModelRendererArray[i];
                if (!part.equals(partIn)) continue;
                part.render(scale);
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderAllExcept(float scale, ObjModelRenderer ... excludedPartsIn) {
        this.checkForNoDuplications();
        for (ObjModelRenderer part : this.parts) {
            boolean skipPart = this.isExcepted(part, excludedPartsIn);
            if (skipPart) continue;
            part.render(scale);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderAll(float scale) {
        this.checkForNoDuplications();
        for (ObjModelRenderer part : this.parts) {
            part.render(scale);
        }
    }

    public ObjModel(List<ObjModelRenderer> parts) {
        this.parts = parts;
    }

    private boolean isExcepted(ObjModelRenderer part, ObjModelRenderer[] excludedList) {
        ObjModelRenderer[] objModelRendererArray = excludedList;
        int n = objModelRendererArray.length;
        for (int i = lIlllllII[1]; i < n; ++i) {
            ObjModelRenderer excludedPart = objModelRendererArray[i];
            if (!part.equals(excludedPart)) continue;
            return lIlllllII[0];
        }
        return lIlllllII[1];
    }

    void setParts(List<ObjModelRenderer> renderers) {
        this.parts = renderers;
    }

    @Override
    public List<ObjModelRenderer> getParts() {
        return this.parts;
    }

    @Override
    public boolean hasDuplications() {
        return !this.duplications.isEmpty() ? lIlllllII[0] : lIlllllII[1];
    }

    static {
        ObjModel.llIlIlIl();
    }

    private void checkForNoDuplications() {
        if (this.hasDuplications()) {
            ModularWarfare.LOGGER.error("=============================================================");
            ModularWarfare.LOGGER.error("Duplications were found! You must call method ObjModelRaw#clearDuplications() after adding children to renders.");
            ModularWarfare.LOGGER.error("Duplications:");
            String[] stringArray = this.formDuplicationList();
            int n = stringArray.length;
            for (int i = lIlllllII[1]; i < n; ++i) {
                String str = stringArray[i];
                ModularWarfare.LOGGER.error(str);
            }
            ModularWarfare.LOGGER.error("=============================================================");
        }
    }

    private String[] formDuplicationList() {
        String[] list = new String[this.duplications.size()];
        for (int i = lIlllllII[1]; i < this.duplications.size(); ++i) {
            list[i] = this.duplications.get(i).getName();
        }
        return list;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderOnly(float scale, String ... groupNames) {
        this.checkForNoDuplications();
        for (ObjModelRenderer part : this.parts) {
            String[] stringArray = groupNames;
            int n = stringArray.length;
            for (int i = lIlllllII[1]; i < n; ++i) {
                String groupName = stringArray[i];
                if (!groupName.equalsIgnoreCase(part.getName())) continue;
                part.render(scale);
            }
        }
    }

    @Override
    public ObjModelRenderer getPart(String name) {
        for (ObjModelRenderer part : this.parts) {
            if (!name.equalsIgnoreCase(part.getName())) continue;
            return part;
        }
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderPart(float scale, String partName) {
        this.checkForNoDuplications();
        for (ObjModelRenderer part : this.parts) {
            if (!partName.equalsIgnoreCase(part.getName())) continue;
            part.render(scale);
        }
    }

    @Override
    public void clearDuplications() throws ConcurrentModificationException {
        try {
            for (ObjModelRenderer renderer : this.duplications) {
                this.parts.remove(renderer);
            }
        }
        catch (ConcurrentModificationException e) {
            throw new ConcurrentModificationException("You must clear duplications ONLY AFTER passing ObjModelRaw#parts!!!\n" + e.getMessage());
        }
        this.duplications.clear();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderPart(float scale, ObjModelRenderer partIn) {
        this.checkForNoDuplications();
        for (ObjModelRenderer part : this.parts) {
            if (!part.equals(partIn)) continue;
            part.render(scale);
        }
    }
}

