/*
 * Decompiled with CFR 0.152.
 */
package com.modularwarfare.loader;

import com.modularwarfare.ModularWarfare;
import com.modularwarfare.common.type.BaseType;
import com.modularwarfare.loader.ModelFormatException;
import com.modularwarfare.loader.ObjModel;
import com.modularwarfare.loader.api.model.ObjModelRenderer;
import com.modularwarfare.loader.part.Face;
import com.modularwarfare.loader.part.ModelObject;
import com.modularwarfare.loader.part.TextureCoordinate;
import com.modularwarfare.loader.part.Vertex;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.io.ZipInputStream;
import net.lingala.zip4j.model.FileHeader;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IResource;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Loader;

public class ObjModelBuilder {
    private static Pattern face_V_VT_VN_Pattern;
    private static Matcher groupObjectMatcher;
    private static Pattern face_V_VT_Pattern;
    private static Pattern textureCoordinatePattern;
    private static final int[] lIIll;
    private static Matcher face_V_VT_Matcher;
    private ArrayList<Vertex> vertexNormals;
    private ArrayList<TextureCoordinate> textureCoordinates;
    private static Matcher face_V_VT_VN_Matcher;
    private ResourceLocation resourceLocation;
    private static Matcher vertexMatcher;
    private ArrayList<ObjModelRenderer> renderers;
    private String fileLocation;
    private static Pattern vertexNormalPattern;
    private static Pattern face_V_VN_Pattern;
    private static Pattern face_V_Pattern;
    private static Pattern groupObjectPattern;
    private static Matcher textureCoordinateMatcher;
    public ArrayList<Vertex> vertices = new ArrayList();
    private ModelObject currentModelObject;
    private static Matcher face_V_Matcher;
    private static Matcher vertexNormalMatcher;
    private static Pattern vertexPattern;
    private static Matcher face_V_VN_Matcher;

    public ObjModelBuilder(String rl) throws ModelFormatException {
        this.vertexNormals = new ArrayList();
        this.textureCoordinates = new ArrayList();
        this.renderers = new ArrayList();
        this.fileLocation = rl;
    }

    private static void lllI() {
        lIIll = new int[7];
        ObjModelBuilder.lIIll[0] = " ".length();
        ObjModelBuilder.lIIll[1] = (0xD ^ 0x48 ^ (0xE0 ^ 0xC5)) & (0x88 ^ 0xA6 ^ (0x27 ^ 0x69) ^ -" ".length());
        ObjModelBuilder.lIIll[2] = "  ".length();
        ObjModelBuilder.lIIll[3] = "   ".length();
        ObjModelBuilder.lIIll[4] = -" ".length();
        ObjModelBuilder.lIIll[5] = 3 ^ 7;
        ObjModelBuilder.lIIll[6] = 0x3F ^ 0x4B ^ (0xC4 ^ 0xB7);
    }

    private ModelObject parseGroupObject(String line, int lineCount) throws ModelFormatException {
        ModelObject group = null;
        if (ObjModelBuilder.isValidGroupObjectLine(line)) {
            String trimmedLine = line.substring(line.indexOf(" ") + lIIll[0]);
            if (trimmedLine.length() > 0) {
                group = new ModelObject(trimmedLine);
            }
        } else {
            throw new ModelFormatException("Error parsing entry ('" + line + "', line " + lineCount + ") in file '" + this.fileLocation + "' - Incorrect format");
        }
        return group;
    }

    private static boolean isValidVertexLine(String line) {
        if (vertexMatcher != null) {
            vertexMatcher.reset();
        }
        vertexMatcher = vertexPattern.matcher(line);
        return vertexMatcher.matches();
    }

    private static boolean isValidTextureCoordinateLine(String line) {
        if (textureCoordinateMatcher != null) {
            textureCoordinateMatcher.reset();
        }
        textureCoordinateMatcher = textureCoordinatePattern.matcher(line);
        return textureCoordinateMatcher.matches();
    }

    public ObjModel loadModelFromZIP(BaseType baseType) throws ModelFormatException {
        int lineCount = lIIll[1];
        ObjModel model = new ObjModel();
        int found = lIIll[1];
        if (ModularWarfare.zipContentsPack.containsKey(baseType.contentPack)) {
            if (ModularWarfare.zipContentsPack.get((Object)baseType.contentPack).models_cache.containsKey(this.fileLocation)) {
                return ModularWarfare.zipContentsPack.get((Object)baseType.contentPack).models_cache.get(this.fileLocation);
            }
            FileHeader foundFile = ModularWarfare.zipContentsPack.get((Object)baseType.contentPack).fileHeaders.stream().filter(fileHeader -> fileHeader.getFileName().equalsIgnoreCase(this.fileLocation)).findFirst().orElse(null);
            if (foundFile != null) {
                found = lIIll[0];
                ZipInputStream stream = null;
                try {
                    stream = ModularWarfare.zipContentsPack.get(baseType.contentPack).getZipFile().getInputStream(foundFile);
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(stream));){
                        String currentLine;
                        while ((currentLine = reader.readLine()) != null) {
                            Vertex vertex;
                            ++lineCount;
                            if ((currentLine = currentLine.replaceAll("\\s+", " ").trim()).startsWith("#") || currentLine.length() == 0) continue;
                            if (currentLine.startsWith("v ")) {
                                vertex = this.parseVertex(currentLine, lineCount);
                                if (vertex == null) continue;
                                this.vertices.add(vertex);
                                continue;
                            }
                            if (currentLine.startsWith("vn ")) {
                                vertex = this.parseVertexNormal(currentLine, lineCount);
                                if (vertex == null) continue;
                                this.vertexNormals.add(vertex);
                                continue;
                            }
                            if (currentLine.startsWith("vt ")) {
                                TextureCoordinate textureCoordinate = this.parseTextureCoordinate(currentLine, lineCount);
                                if (textureCoordinate == null) continue;
                                this.textureCoordinates.add(textureCoordinate);
                                continue;
                            }
                            if (currentLine.startsWith("f ")) {
                                Face face;
                                if (this.currentModelObject == null) {
                                    this.currentModelObject = new ModelObject("Default");
                                }
                                if ((face = this.parseFace(currentLine, lineCount)) == null) continue;
                                this.currentModelObject.faces.add(face);
                                continue;
                            }
                            if (!(currentLine.startsWith("g ") | currentLine.startsWith("o "))) continue;
                            ModelObject group = this.parseGroupObject(currentLine, lineCount);
                            if (group != null && this.currentModelObject != null) {
                                this.renderers.add(new ObjModelRenderer(model, this.currentModelObject));
                            }
                            this.currentModelObject = group;
                        }
                        this.renderers.add(new ObjModelRenderer(model, this.currentModelObject));
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                catch (ZipException e) {
                    e.printStackTrace();
                }
            }
            ModularWarfare.zipContentsPack.get((Object)baseType.contentPack).models_cache.put(this.fileLocation, model);
        }
        if (found == 0) {
            ModularWarfare.LOGGER.warn("The model file in " + baseType.contentPack + " at: " + this.fileLocation + " has not been found");
        }
        model.setParts(this.renderers);
        return model;
    }

    private static boolean isValidFace_V_Line(String line) {
        if (face_V_Matcher != null) {
            face_V_Matcher.reset();
        }
        face_V_Matcher = face_V_Pattern.matcher(line);
        return face_V_Matcher.matches();
    }

    private Vertex parseVertexNormal(String line, int lineCount) throws ModelFormatException {
        block4: {
            if (ObjModelBuilder.isValidVertexNormalLine(line)) {
                line = line.substring(line.indexOf(" ") + lIIll[0]);
                String[] tokens = line.split(" ");
                try {
                    if (tokens.length == lIIll[3]) {
                        return new Vertex(Float.parseFloat(tokens[lIIll[1]]), Float.parseFloat(tokens[lIIll[0]]), Float.parseFloat(tokens[lIIll[2]]));
                    }
                    break block4;
                }
                catch (NumberFormatException e) {
                    Object[] objectArray = new Object[lIIll[0]];
                    objectArray[ObjModelBuilder.lIIll[1]] = lineCount;
                    throw new ModelFormatException(String.format("Number formatting error at line %d", objectArray), e);
                }
            }
            throw new ModelFormatException("Error parsing entry ('" + line + "', line " + lineCount + ") in file '" + this.fileLocation + "' - Incorrect format");
        }
        return null;
    }

    private TextureCoordinate parseTextureCoordinate(String line, int lineCount) throws ModelFormatException {
        block5: {
            if (ObjModelBuilder.isValidTextureCoordinateLine(line)) {
                line = line.substring(line.indexOf(" ") + lIIll[0]);
                String[] tokens = line.split(" ");
                try {
                    if (tokens.length == lIIll[2]) {
                        return new TextureCoordinate(Float.parseFloat(tokens[lIIll[1]]), 1.0f - Float.parseFloat(tokens[lIIll[0]]));
                    }
                    if (tokens.length == lIIll[3]) {
                        return new TextureCoordinate(Float.parseFloat(tokens[lIIll[1]]), 1.0f - Float.parseFloat(tokens[lIIll[0]]), Float.parseFloat(tokens[lIIll[2]]));
                    }
                    break block5;
                }
                catch (NumberFormatException e) {
                    Object[] objectArray = new Object[lIIll[0]];
                    objectArray[ObjModelBuilder.lIIll[1]] = lineCount;
                    throw new ModelFormatException(String.format("Number formatting error at line %d", objectArray), e);
                }
            }
            throw new ModelFormatException("Error parsing entry ('" + line + "', line " + lineCount + ") in file '" + this.fileLocation + "' - Incorrect format");
        }
        return null;
    }

    private static boolean isValidVertexNormalLine(String line) {
        if (vertexNormalMatcher != null) {
            vertexNormalMatcher.reset();
        }
        vertexNormalMatcher = vertexNormalPattern.matcher(line);
        return vertexNormalMatcher.matches();
    }

    private static boolean isValidFace_V_VT_Line(String line) {
        if (face_V_VT_Matcher != null) {
            face_V_VT_Matcher.reset();
        }
        face_V_VT_Matcher = face_V_VT_Pattern.matcher(line);
        return face_V_VT_Matcher.matches();
    }

    public File checkValidPath(String path) {
        File file = null;
        String absPath = path;
        if (!path.endsWith(".obj")) {
            absPath = absPath + ".obj";
        }
        if ((file = new File(absPath)) == null || !file.exists()) {
            return null;
        }
        return file;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Face parseFace(String line, int lineCount) throws ModelFormatException {
        if (!ObjModelBuilder.isValidFaceLine(line)) throw new ModelFormatException("Error parsing entry ('" + line + "', line " + lineCount + ") in file '" + this.fileLocation + "' - Incorrect format");
        Face face = new Face();
        String trimmedLine = line.substring(line.indexOf(" ") + lIIll[0]);
        String[] tokens = trimmedLine.split(" ");
        if (tokens.length == lIIll[3]) {
            if (this.currentModelObject.glDrawingMode == lIIll[4]) {
                this.currentModelObject.glDrawingMode = lIIll[5];
            } else if (this.currentModelObject.glDrawingMode != lIIll[5]) {
                throw new ModelFormatException("Error parsing entry ('" + line + "', line " + lineCount + ") in file '" + this.fileLocation + "' - Invalid number of points for face (expected 4, found " + tokens.length + ")");
            }
        } else if (tokens.length == lIIll[5]) {
            if (this.currentModelObject.glDrawingMode == lIIll[4]) {
                this.currentModelObject.glDrawingMode = lIIll[6];
            } else if (this.currentModelObject.glDrawingMode != lIIll[6]) {
                throw new ModelFormatException("Error parsing entry ('" + line + "', line " + lineCount + ") in file '" + this.fileLocation + "' - Invalid number of points for face (expected 3, found " + tokens.length + ")");
            }
        }
        if (ObjModelBuilder.isValidFace_V_VT_VN_Line(line)) {
            face.vertices = new Vertex[tokens.length];
            face.textureCoordinates = new TextureCoordinate[tokens.length];
            face.vertexNormals = new Vertex[tokens.length];
            for (int i = lIIll[1]; i < tokens.length; ++i) {
                String[] subTokens = tokens[i].split("/");
                face.vertices[i] = this.vertices.get(Integer.parseInt(subTokens[lIIll[1]]) - lIIll[0]);
                face.textureCoordinates[i] = this.textureCoordinates.get(Integer.parseInt(subTokens[lIIll[0]]) - lIIll[0]);
                face.vertexNormals[i] = this.vertexNormals.get(Integer.parseInt(subTokens[lIIll[2]]) - lIIll[0]);
            }
            face.faceNormal = face.calculateFaceNormal();
            return face;
        } else if (ObjModelBuilder.isValidFace_V_VT_Line(line)) {
            face.vertices = new Vertex[tokens.length];
            face.textureCoordinates = new TextureCoordinate[tokens.length];
            for (int i = lIIll[1]; i < tokens.length; ++i) {
                String[] subTokens = tokens[i].split("/");
                face.vertices[i] = this.vertices.get(Integer.parseInt(subTokens[lIIll[1]]) - lIIll[0]);
                face.textureCoordinates[i] = this.textureCoordinates.get(Integer.parseInt(subTokens[lIIll[0]]) - lIIll[0]);
            }
            face.faceNormal = face.calculateFaceNormal();
            return face;
        } else if (ObjModelBuilder.isValidFace_V_VN_Line(line)) {
            face.vertices = new Vertex[tokens.length];
            face.vertexNormals = new Vertex[tokens.length];
            for (int i = lIIll[1]; i < tokens.length; ++i) {
                String[] subTokens = tokens[i].split("//");
                face.vertices[i] = this.vertices.get(Integer.parseInt(subTokens[lIIll[1]]) - lIIll[0]);
                face.vertexNormals[i] = this.vertexNormals.get(Integer.parseInt(subTokens[lIIll[0]]) - lIIll[0]);
            }
            face.faceNormal = face.calculateFaceNormal();
            return face;
        } else {
            if (!ObjModelBuilder.isValidFace_V_Line(line)) throw new ModelFormatException("Error parsing entry ('" + line + "', line " + lineCount + ") in file '" + this.fileLocation + "' - Incorrect format");
            face.vertices = new Vertex[tokens.length];
            for (int i = lIIll[1]; i < tokens.length; ++i) {
                face.vertices[i] = this.vertices.get(Integer.parseInt(tokens[i]) - lIIll[0]);
            }
            face.faceNormal = face.calculateFaceNormal();
        }
        return face;
    }

    private Vertex parseVertex(String line, int lineCount) throws ModelFormatException {
        block5: {
            if (ObjModelBuilder.isValidVertexLine(line)) {
                line = line.substring(line.indexOf(" ") + lIIll[0]);
                String[] tokens = line.split(" ");
                try {
                    if (tokens.length == lIIll[2]) {
                        return new Vertex(Float.parseFloat(tokens[lIIll[1]]), Float.parseFloat(tokens[lIIll[0]]));
                    }
                    if (tokens.length == lIIll[3]) {
                        return new Vertex(Float.parseFloat(tokens[lIIll[1]]), Float.parseFloat(tokens[lIIll[0]]), Float.parseFloat(tokens[lIIll[2]]));
                    }
                    break block5;
                }
                catch (NumberFormatException e) {
                    Object[] objectArray = new Object[lIIll[0]];
                    objectArray[ObjModelBuilder.lIIll[1]] = lineCount;
                    throw new ModelFormatException(String.format("Number formatting error at line %d", objectArray), e);
                }
            }
            throw new ModelFormatException("Error parsing entry ('" + line + "', line " + lineCount + ") in file '" + this.fileLocation + "' - Incorrect format");
        }
        return null;
    }

    private static boolean isValidGroupObjectLine(String line) {
        if (groupObjectMatcher != null) {
            groupObjectMatcher.reset();
        }
        groupObjectMatcher = groupObjectPattern.matcher(line);
        return groupObjectMatcher.matches();
    }

    private static boolean isValidFace_V_VN_Line(String line) {
        if (face_V_VN_Matcher != null) {
            face_V_VN_Matcher.reset();
        }
        face_V_VN_Matcher = face_V_VN_Pattern.matcher(line);
        return face_V_VN_Matcher.matches();
    }

    public ObjModelBuilder(ResourceLocation rl) throws ModelFormatException {
        this.vertexNormals = new ArrayList();
        this.textureCoordinates = new ArrayList();
        this.renderers = new ArrayList();
        this.resourceLocation = rl;
    }

    private static boolean isValidFace_V_VT_VN_Line(String line) {
        if (face_V_VT_VN_Matcher != null) {
            face_V_VT_VN_Matcher.reset();
        }
        face_V_VT_VN_Matcher = face_V_VT_VN_Pattern.matcher(line);
        return face_V_VT_VN_Matcher.matches();
    }

    public ObjModel loadModel() throws ModelFormatException {
        int lineCount = lIIll[1];
        ObjModel model = new ObjModel();
        File modelFile = null;
        String absPath = new File(Loader.instance().getConfigDir().getParent(), "ModularWarfare").getAbsolutePath();
        if (!absPath.endsWith("/") || !absPath.endsWith("\\")) {
            absPath = absPath + "/";
        }
        if ((modelFile = this.checkValidPath(absPath + this.fileLocation)) == null || !modelFile.exists()) {
            ModularWarfare.LOGGER.info("The staticModel with the name " + this.fileLocation + " does not exist.");
            return null;
        }
        try (BufferedReader reader = new BufferedReader(new FileReader(modelFile));){
            String currentLine;
            while ((currentLine = reader.readLine()) != null) {
                Vertex vertex;
                ++lineCount;
                if ((currentLine = currentLine.replaceAll("\\s+", " ").trim()).startsWith("#") || currentLine.length() == 0) continue;
                if (currentLine.startsWith("v ")) {
                    vertex = this.parseVertex(currentLine, lineCount);
                    if (vertex == null) continue;
                    this.vertices.add(vertex);
                    continue;
                }
                if (currentLine.startsWith("vn ")) {
                    vertex = this.parseVertexNormal(currentLine, lineCount);
                    if (vertex == null) continue;
                    this.vertexNormals.add(vertex);
                    continue;
                }
                if (currentLine.startsWith("vt ")) {
                    TextureCoordinate textureCoordinate = this.parseTextureCoordinate(currentLine, lineCount);
                    if (textureCoordinate == null) continue;
                    this.textureCoordinates.add(textureCoordinate);
                    continue;
                }
                if (currentLine.startsWith("f ")) {
                    Face face;
                    if (this.currentModelObject == null) {
                        this.currentModelObject = new ModelObject("Default");
                    }
                    if ((face = this.parseFace(currentLine, lineCount)) == null) continue;
                    this.currentModelObject.faces.add(face);
                    continue;
                }
                if (!(currentLine.startsWith("g ") | currentLine.startsWith("o "))) continue;
                ModelObject group = this.parseGroupObject(currentLine, lineCount);
                if (group != null && this.currentModelObject != null) {
                    this.renderers.add(new ObjModelRenderer(model, this.currentModelObject));
                }
                this.currentModelObject = group;
            }
            this.renderers.add(new ObjModelRenderer(model, this.currentModelObject));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String[] path = modelFile.getAbsolutePath().split("/");
        String fileName = path[path.length - lIIll[0]].split("\\.")[lIIll[1]];
        StringBuilder newPath = new StringBuilder();
        for (int i = lIIll[1]; i < path.length - lIIll[0]; ++i) {
            if (i != 0) {
                newPath.append("/");
            }
            newPath.append(path[i]);
        }
        model.setParts(this.renderers);
        return model;
    }

    static {
        ObjModelBuilder.lllI();
        vertexPattern = Pattern.compile("(v( (\\-){0,1}\\d+(\\.\\d+)?){3,4} *\\n)|(v( (\\-){0,1}\\d+(\\.\\d+)?){3,4} *$)");
        vertexNormalPattern = Pattern.compile("(vn( (\\-){0,1}\\d+(\\.\\d+)?){3,4} *\\n)|(vn( (\\-){0,1}\\d+(\\.\\d+)?){3,4} *$)");
        textureCoordinatePattern = Pattern.compile("(vt( (\\-){0,1}\\d+\\.\\d+){2,3} *\\n)|(vt( (\\-){0,1}\\d+(\\.\\d+)?){2,3} *$)");
        face_V_VT_VN_Pattern = Pattern.compile("(f( \\d+/\\d+/\\d+){3,4} *\\n)|(f( \\d+/\\d+/\\d+){3,4} *$)");
        face_V_VT_Pattern = Pattern.compile("(f( \\d+/\\d+){3,4} *\\n)|(f( \\d+/\\d+){3,4} *$)");
        face_V_VN_Pattern = Pattern.compile("(f( \\d+//\\d+){3,4} *\\n)|(f( \\d+//\\d+){3,4} *$)");
        face_V_Pattern = Pattern.compile("(f( \\d+){3,4} *\\n)|(f( \\d+){3,4} *$)");
        groupObjectPattern = Pattern.compile("([go]( [\\w\\d\\.]+) *\\n)|([go]( [\\w\\d\\.]+) *$)");
    }

    public ObjModel loadModelFromRL() throws ModelFormatException {
        int lineCount = lIIll[1];
        ObjModel model = new ObjModel();
        try (IResource objFile = Minecraft.func_71410_x().func_110442_L().func_110536_a(this.resourceLocation);
             BufferedReader reader = new BufferedReader(new InputStreamReader(objFile.func_110527_b()));){
            String currentLine;
            while ((currentLine = reader.readLine()) != null) {
                Vertex vertex;
                ++lineCount;
                if ((currentLine = currentLine.replaceAll("\\s+", " ").trim()).startsWith("#") || currentLine.length() == 0) continue;
                if (currentLine.startsWith("v ")) {
                    vertex = this.parseVertex(currentLine, lineCount);
                    if (vertex == null) continue;
                    this.vertices.add(vertex);
                    continue;
                }
                if (currentLine.startsWith("vn ")) {
                    vertex = this.parseVertexNormal(currentLine, lineCount);
                    if (vertex == null) continue;
                    this.vertexNormals.add(vertex);
                    continue;
                }
                if (currentLine.startsWith("vt ")) {
                    TextureCoordinate textureCoordinate = this.parseTextureCoordinate(currentLine, lineCount);
                    if (textureCoordinate == null) continue;
                    this.textureCoordinates.add(textureCoordinate);
                    continue;
                }
                if (currentLine.startsWith("f ")) {
                    Face face;
                    if (this.currentModelObject == null) {
                        this.currentModelObject = new ModelObject("Default");
                    }
                    if ((face = this.parseFace(currentLine, lineCount)) == null) continue;
                    this.currentModelObject.faces.add(face);
                    continue;
                }
                if (!(currentLine.startsWith("g ") | currentLine.startsWith("o "))) continue;
                ModelObject group = this.parseGroupObject(currentLine, lineCount);
                if (group != null && this.currentModelObject != null) {
                    this.renderers.add(new ObjModelRenderer(model, this.currentModelObject));
                }
                this.currentModelObject = group;
            }
            this.renderers.add(new ObjModelRenderer(model, this.currentModelObject));
        }
        catch (IOException e) {
            throw new ModelFormatException("IO Exception reading model format", e);
        }
        model.setParts(this.renderers);
        return model;
    }

    private static boolean isValidFaceLine(String line) {
        return (ObjModelBuilder.isValidFace_V_VT_VN_Line(line) || ObjModelBuilder.isValidFace_V_VT_Line(line) || ObjModelBuilder.isValidFace_V_VN_Line(line) || ObjModelBuilder.isValidFace_V_Line(line) ? lIIll[0] : lIIll[1]) != 0;
    }
}

