/*
 * Decompiled with CFR 0.152.
 */
package net.lingala.zip4j.crypto;

import java.util.ArrayList;
import java.util.Arrays;
import net.lingala.zip4j.crypto.IDecrypter;
import net.lingala.zip4j.crypto.PBKDF2.MacBasedPRF;
import net.lingala.zip4j.crypto.PBKDF2.PBKDF2Engine;
import net.lingala.zip4j.crypto.PBKDF2.PBKDF2Parameters;
import net.lingala.zip4j.crypto.engine.AESEngine;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.model.AESExtraDataRecord;
import net.lingala.zip4j.model.LocalFileHeader;
import net.lingala.zip4j.util.Raw;
import net.lingala.zip4j.util.Zip4jUtil;

public class AESDecrypter
implements IDecrypter {
    private AESEngine aesEngine;
    private static final int[] lIlIlllI;
    private int nonce;
    private int KEY_LENGTH;
    private byte[] macKey;
    private byte[] storedMac;
    private byte[] derivedPasswordVerifier;
    private MacBasedPRF mac;
    private int MAC_LENGTH;
    private LocalFileHeader localFileHeader;
    private int SALT_LENGTH;
    private final int PASSWORD_VERIFIER_LENGTH = lIlIlllI[0];
    private byte[] aesKey;

    static {
        AESDecrypter.llIIlII();
    }

    public byte[] getCalculatedAuthenticationBytes() {
        return this.mac.doFinal();
    }

    public int getPasswordVerifierLength() {
        return lIlIlllI[0];
    }

    public AESDecrypter(LocalFileHeader localFileHeader, byte[] salt, byte[] passwordVerifier) throws ZipException {
        this.nonce = lIlIlllI[1];
        if (localFileHeader == null) {
            throw new ZipException("one of the input parameters is null in AESDecryptor Constructor");
        }
        this.localFileHeader = localFileHeader;
        this.storedMac = null;
        this.init(salt, passwordVerifier);
    }

    private void init(byte[] salt, byte[] passwordVerifier) throws ZipException {
        if (this.localFileHeader == null) {
            throw new ZipException("invalid file header in init method of AESDecryptor");
        }
        AESExtraDataRecord aesExtraDataRecord = this.localFileHeader.getAesExtraDataRecord();
        if (aesExtraDataRecord == null) {
            throw new ZipException("invalid aes extra data record - in init method of AESDecryptor");
        }
        switch (aesExtraDataRecord.getAesStrength()) {
            case 1: {
                this.KEY_LENGTH = lIlIlllI[2];
                this.MAC_LENGTH = lIlIlllI[2];
                this.SALT_LENGTH = lIlIlllI[3];
                break;
            }
            case 2: {
                this.KEY_LENGTH = lIlIlllI[4];
                this.MAC_LENGTH = lIlIlllI[4];
                this.SALT_LENGTH = lIlIlllI[5];
                break;
            }
            case 3: {
                this.KEY_LENGTH = lIlIlllI[6];
                this.MAC_LENGTH = lIlIlllI[6];
                this.SALT_LENGTH = lIlIlllI[2];
                break;
            }
            default: {
                throw new ZipException("invalid aes key strength for file: " + this.localFileHeader.getFileName());
            }
        }
        if (!Zip4jUtil.isStringNotNullAndNotEmpty(this.localFileHeader.getPassword())) {
            throw new ZipException("empty or null password provided for AES Decryptor");
        }
        byte[] derivedKey = this.deriveKey(salt, this.localFileHeader.getPassword());
        if (derivedKey == null || derivedKey.length != this.KEY_LENGTH + this.MAC_LENGTH + lIlIlllI[0]) {
            throw new ZipException("invalid derived key");
        }
        this.aesKey = new byte[this.KEY_LENGTH];
        this.macKey = new byte[this.MAC_LENGTH];
        this.derivedPasswordVerifier = new byte[lIlIlllI[0]];
        System.arraycopy(derivedKey, lIlIlllI[7], this.aesKey, lIlIlllI[7], this.KEY_LENGTH);
        System.arraycopy(derivedKey, this.KEY_LENGTH, this.macKey, lIlIlllI[7], this.MAC_LENGTH);
        System.arraycopy(derivedKey, this.KEY_LENGTH + this.MAC_LENGTH, this.derivedPasswordVerifier, lIlIlllI[7], lIlIlllI[0]);
        if (this.derivedPasswordVerifier == null) {
            throw new ZipException("invalid derived password verifier for AES");
        }
        if (!Arrays.equals(passwordVerifier, this.derivedPasswordVerifier)) {
            throw new ZipException("Wrong Password for file: " + this.localFileHeader.getFileName());
        }
        this.aesEngine = new AESEngine(this.aesKey);
        this.mac = new MacBasedPRF("HmacSHA1");
        this.mac.init(this.macKey);
    }

    private byte[] deriveKey(byte[] salt, String password) throws ZipException {
        try {
            PBKDF2Parameters p = new PBKDF2Parameters("HmacSHA1", "ISO-8859-1", salt, lIlIlllI[8]);
            PBKDF2Engine e = new PBKDF2Engine(p);
            byte[] derivedKey = e.deriveKey(password, this.KEY_LENGTH + this.MAC_LENGTH + lIlIlllI[0]);
            return derivedKey;
        }
        catch (Exception e) {
            throw new ZipException(e);
        }
    }

    @Override
    public int decryptData(byte[] buff, int start, int len) throws ZipException {
        if (this.aesEngine == null) {
            throw new ZipException("AES not initialized properly");
        }
        try {
            ArrayList<byte[]> byteBlocks = new ArrayList<byte[]>();
            ArrayList<byte[]> decBlocks = new ArrayList<byte[]>();
            for (int i = lIlIlllI[7]; i < len; i += 16) {
                byte[] block = i + lIlIlllI[2] > len ? new byte[len - i] : new byte[lIlIlllI[2]];
                System.arraycopy(buff, i, block, lIlIlllI[7], block.length);
                byteBlocks.add(block);
            }
            byte[] iv = new byte[lIlIlllI[2]];
            byte[] counterBlock = new byte[lIlIlllI[2]];
            for (int i = lIlIlllI[7]; i < byteBlocks.size(); ++i) {
                byte[] cipherBlock = (byte[])byteBlocks.get(i);
                byte[] decryptedBlock = new byte[cipherBlock.length];
                this.mac.update(cipherBlock);
                iv = Raw.toByteArray(this.nonce, lIlIlllI[2]);
                this.aesEngine.processBlock(iv, counterBlock);
                for (int j = lIlIlllI[7]; j < cipherBlock.length; ++j) {
                    decryptedBlock[j] = (byte)(cipherBlock[j] ^ counterBlock[j]);
                }
                decBlocks.add(decryptedBlock);
                this.nonce += lIlIlllI[1];
            }
            int pos = lIlIlllI[7];
            for (int i = lIlIlllI[7]; i < decBlocks.size(); ++i) {
                System.arraycopy(decBlocks.get(i), lIlIlllI[7], buff, pos, ((byte[])decBlocks.get(i)).length);
                pos += ((byte[])decBlocks.get(i)).length;
            }
            return len;
        }
        catch (ZipException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ZipException(e);
        }
    }

    @Override
    public int decryptData(byte[] buff) throws ZipException {
        return this.decryptData(buff, lIlIlllI[7], buff.length);
    }

    public byte[] getStoredMac() {
        return this.storedMac;
    }

    private static void llIIlII() {
        lIlIlllI = new int[9];
        AESDecrypter.lIlIlllI[0] = "  ".length();
        AESDecrypter.lIlIlllI[1] = " ".length();
        AESDecrypter.lIlIlllI[2] = 149 + 51 - 72 + 28 ^ 14 + 116 - 74 + 84;
        AESDecrypter.lIlIlllI[3] = 40 + 8 - -19 + 91 ^ 25 + 35 - 52 + 142;
        AESDecrypter.lIlIlllI[4] = 0xC ^ 0x14;
        AESDecrypter.lIlIlllI[5] = 0x2B ^ 0x27;
        AESDecrypter.lIlIlllI[6] = 0x88 ^ 0xAB ^ "   ".length();
        AESDecrypter.lIlIlllI[7] = (0x9B ^ 0x8C) & ~(0xA0 ^ 0xB7);
        AESDecrypter.lIlIlllI[8] = -(0xFFFFFF5A & 0x3CB7) & (0xFFFFFFFF & 0x3FF9);
    }

    public void setStoredMac(byte[] storedMac) {
        this.storedMac = storedMac;
    }

    public int getSaltLength() {
        return this.SALT_LENGTH;
    }
}

