/*
 * Decompiled with CFR 0.152.
 */
package net.lingala.zip4j.crypto;

import java.util.ArrayList;
import java.util.Random;
import net.lingala.zip4j.crypto.IEncrypter;
import net.lingala.zip4j.crypto.PBKDF2.MacBasedPRF;
import net.lingala.zip4j.crypto.PBKDF2.PBKDF2Engine;
import net.lingala.zip4j.crypto.PBKDF2.PBKDF2Parameters;
import net.lingala.zip4j.crypto.engine.AESEngine;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.util.Raw;
import net.lingala.zip4j.util.Zip4jUtil;

public class AESEncrpyter
implements IEncrypter {
    private MacBasedPRF mac;
    private byte[] aesSplitBlock;
    private int keyStrength;
    private byte[] iv;
    private int SALT_LENGTH;
    private byte[] derivedPasswordVerifier;
    private byte[] saltBytes;
    private String password;
    private byte[] aesKey;
    private final int PASSWORD_VERIFIER_LENGTH = lIIllIIll[0];
    private byte[] macKey;
    private static final int[] lIIllIIll;
    private int nonce = lIIllIIll[1];
    private AESEngine aesEngine;
    private boolean finished;
    private int KEY_LENGTH;
    private int MAC_LENGTH;
    private byte[] counterBlock;

    public byte[] getSaltBytes() {
        return this.saltBytes;
    }

    private byte[] deriveKey(byte[] salt, String password) throws ZipException {
        try {
            PBKDF2Parameters p = new PBKDF2Parameters("HmacSHA1", "ISO-8859-1", salt, lIIllIIll[7]);
            PBKDF2Engine e = new PBKDF2Engine(p);
            byte[] derivedKey = e.deriveKey(password, this.KEY_LENGTH + this.MAC_LENGTH + lIIllIIll[0]);
            return derivedKey;
        }
        catch (Exception e) {
            throw new ZipException(e);
        }
    }

    private static void lIllIIII() {
        lIIllIIll = new int[11];
        AESEncrpyter.lIIllIIll[0] = "  ".length();
        AESEncrpyter.lIIllIIll[1] = " ".length();
        AESEncrpyter.lIIllIIll[2] = 4 ^ 0x14;
        AESEncrpyter.lIIllIIll[3] = "   ".length();
        AESEncrpyter.lIIllIIll[4] = (0x69 ^ 0x31 ^ (0x79 ^ 0x24)) & (6 + 98 - 62 + 153 ^ 131 + 116 - 149 + 100 ^ -" ".length());
        AESEncrpyter.lIIllIIll[5] = 0x71 ^ 0x79;
        AESEncrpyter.lIIllIIll[6] = 38 + 162 - 51 + 15 ^ 52 + 38 - -1 + 41;
        AESEncrpyter.lIIllIIll[7] = 0xFFFF87EC & 0x7BFB;
        AESEncrpyter.lIIllIIll[8] = 4 + 132 - -30 + 26 ^ 101 + 184 - 180 + 91;
        AESEncrpyter.lIIllIIll[9] = 0x16 ^ 0xE;
        AESEncrpyter.lIIllIIll[10] = 3 ^ 0x10 ^ (0xA2 ^ 0xBB);
    }

    public byte[] getDerivedPasswordVerifier() {
        return this.derivedPasswordVerifier;
    }

    @Override
    public int encryptData(byte[] buff, int start, int len) throws ZipException {
        int i;
        if (this.finished) {
            throw new ZipException("AES Encrypter is in finished state (A non 16 byte block has already been passed to encrypter)");
        }
        if (len % lIIllIIll[2] != 0) {
            this.finished = lIIllIIll[1];
        }
        ArrayList<Object> byteBlocks = new ArrayList<Object>();
        ArrayList<byte[]> encBlocks = new ArrayList<byte[]>();
        for (i = lIIllIIll[4]; i < len; i += 16) {
            if (i + lIIllIIll[2] > len) {
                byte[] block = new byte[len - i];
                System.arraycopy(buff, i + start, block, lIIllIIll[4], block.length);
                byteBlocks.add(block);
                continue;
            }
            System.arraycopy(buff, i + start, this.aesSplitBlock, lIIllIIll[4], this.aesSplitBlock.length);
            byteBlocks.add(this.aesSplitBlock.clone());
        }
        for (i = lIIllIIll[4]; i < byteBlocks.size(); ++i) {
            byte[] plainBlock = (byte[])byteBlocks.get(i);
            byte[] encryptedBlock = new byte[plainBlock.length];
            this.iv = Raw.toByteArray(this.nonce, lIIllIIll[2]);
            this.aesEngine.processBlock(this.iv, this.counterBlock);
            for (int j = lIIllIIll[4]; j < plainBlock.length; ++j) {
                encryptedBlock[j] = (byte)(plainBlock[j] ^ this.counterBlock[j]);
            }
            encBlocks.add(encryptedBlock);
            this.mac.update(encryptedBlock);
            this.nonce += lIIllIIll[1];
        }
        int pos = start;
        for (int i2 = lIIllIIll[4]; i2 < encBlocks.size(); ++i2) {
            System.arraycopy(encBlocks.get(i2), lIIllIIll[4], buff, pos, ((byte[])encBlocks.get(i2)).length);
            pos += ((byte[])encBlocks.get(i2)).length;
        }
        return len;
    }

    public AESEncrpyter(String password, int keyStrength) throws ZipException {
        this.iv = new byte[lIIllIIll[2]];
        this.counterBlock = new byte[lIIllIIll[2]];
        this.aesSplitBlock = new byte[lIIllIIll[2]];
        if (!Zip4jUtil.isStringNotNullAndNotEmpty(password)) {
            throw new ZipException("input password is empty or null in AES encrypter constructor");
        }
        if (keyStrength != lIIllIIll[1] && keyStrength != lIIllIIll[3]) {
            throw new ZipException("Invalid key strength in AES encrypter constructor");
        }
        this.password = password;
        this.keyStrength = keyStrength;
        this.finished = lIIllIIll[4];
        this.init();
    }

    public void setDerivedPasswordVerifier(byte[] derivedPasswordVerifier) {
        this.derivedPasswordVerifier = derivedPasswordVerifier;
    }

    public void setSaltBytes(byte[] saltBytes) {
        this.saltBytes = saltBytes;
    }

    @Override
    public int encryptData(byte[] buff) throws ZipException {
        if (buff == null) {
            throw new ZipException("input bytes are null, cannot perform AES encrpytion");
        }
        return this.encryptData(buff, lIIllIIll[4], buff.length);
    }

    public int getSaltLength() {
        return this.SALT_LENGTH;
    }

    public byte[] getFinalMac() {
        byte[] rawMacBytes = this.mac.doFinal();
        byte[] macBytes = new byte[lIIllIIll[10]];
        System.arraycopy(rawMacBytes, lIIllIIll[4], macBytes, lIIllIIll[4], lIIllIIll[10]);
        return macBytes;
    }

    private static byte[] generateSalt(int size) throws ZipException {
        if (size != lIIllIIll[5] && size != lIIllIIll[2]) {
            throw new ZipException("invalid salt size, cannot generate salt");
        }
        int rounds = lIIllIIll[4];
        if (size == lIIllIIll[5]) {
            rounds = lIIllIIll[0];
        }
        if (size == lIIllIIll[2]) {
            rounds = lIIllIIll[8];
        }
        byte[] salt = new byte[size];
        for (int j = lIIllIIll[4]; j < rounds; ++j) {
            Random rand = new Random();
            int i = rand.nextInt();
            salt[AESEncrpyter.lIIllIIll[4] + j * AESEncrpyter.lIIllIIll[8]] = (byte)(i >> lIIllIIll[9]);
            salt[AESEncrpyter.lIIllIIll[1] + j * AESEncrpyter.lIIllIIll[8]] = (byte)(i >> lIIllIIll[2]);
            salt[AESEncrpyter.lIIllIIll[0] + j * AESEncrpyter.lIIllIIll[8]] = (byte)(i >> lIIllIIll[5]);
            salt[AESEncrpyter.lIIllIIll[3] + j * AESEncrpyter.lIIllIIll[8]] = (byte)i;
        }
        return salt;
    }

    public int getPasswordVeriifierLength() {
        return lIIllIIll[0];
    }

    static {
        AESEncrpyter.lIllIIII();
    }

    private void init() throws ZipException {
        switch (this.keyStrength) {
            case 1: {
                this.KEY_LENGTH = lIIllIIll[2];
                this.MAC_LENGTH = lIIllIIll[2];
                this.SALT_LENGTH = lIIllIIll[5];
                break;
            }
            case 3: {
                this.KEY_LENGTH = lIIllIIll[6];
                this.MAC_LENGTH = lIIllIIll[6];
                this.SALT_LENGTH = lIIllIIll[2];
                break;
            }
            default: {
                throw new ZipException("invalid aes key strength, cannot determine key sizes");
            }
        }
        this.saltBytes = AESEncrpyter.generateSalt(this.SALT_LENGTH);
        byte[] keyBytes = this.deriveKey(this.saltBytes, this.password);
        if (keyBytes == null || keyBytes.length != this.KEY_LENGTH + this.MAC_LENGTH + lIIllIIll[0]) {
            throw new ZipException("invalid key generated, cannot decrypt file");
        }
        this.aesKey = new byte[this.KEY_LENGTH];
        this.macKey = new byte[this.MAC_LENGTH];
        this.derivedPasswordVerifier = new byte[lIIllIIll[0]];
        System.arraycopy(keyBytes, lIIllIIll[4], this.aesKey, lIIllIIll[4], this.KEY_LENGTH);
        System.arraycopy(keyBytes, this.KEY_LENGTH, this.macKey, lIIllIIll[4], this.MAC_LENGTH);
        System.arraycopy(keyBytes, this.KEY_LENGTH + this.MAC_LENGTH, this.derivedPasswordVerifier, lIIllIIll[4], lIIllIIll[0]);
        this.aesEngine = new AESEngine(this.aesKey);
        this.mac = new MacBasedPRF("HmacSHA1");
        this.mac.init(this.macKey);
    }
}

