/*
 * Decompiled with CFR 0.152.
 */
package net.lingala.zip4j.crypto;

import net.lingala.zip4j.crypto.IDecrypter;
import net.lingala.zip4j.crypto.engine.ZipCryptoEngine;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.model.FileHeader;
import net.lingala.zip4j.util.Zip4jUtil;

public class StandardDecrypter
implements IDecrypter {
    private FileHeader fileHeader;
    private static final int[] lIllI;
    private byte[] crc = new byte[lIllI[0]];
    private ZipCryptoEngine zipCryptoEngine;

    @Override
    public int decryptData(byte[] buff, int start, int len) throws ZipException {
        if (start < 0 || len < 0) {
            throw new ZipException("one of the input parameters were null in standard decrpyt data");
        }
        try {
            for (int i = lIllI[1]; i < len; ++i) {
                int val = buff[i] & lIllI[2];
                val = (val ^ this.zipCryptoEngine.decryptByte()) & lIllI[2];
                this.zipCryptoEngine.updateKeys((byte)val);
                buff[i] = (byte)val;
            }
            return len;
        }
        catch (Exception e) {
            throw new ZipException(e);
        }
    }

    public StandardDecrypter(FileHeader fileHeader, byte[] headerBytes) throws ZipException {
        if (fileHeader == null) {
            throw new ZipException("one of more of the input parameters were null in StandardDecryptor");
        }
        this.fileHeader = fileHeader;
        this.zipCryptoEngine = new ZipCryptoEngine();
        this.init(headerBytes);
    }

    static {
        StandardDecrypter.lIIlI();
    }

    private static void lIIlI() {
        lIllI = new int[11];
        StandardDecrypter.lIllI[0] = 0xBC ^ 0xB4 ^ (0xB5 ^ 0xB9);
        StandardDecrypter.lIllI[1] = (0xC8 ^ 0xA8) & ~(0x28 ^ 0x48);
        StandardDecrypter.lIllI[2] = (0xE1 ^ 0xB3) + (109 + 42 - 51 + 94) - (0xFFFF8531 & 0x7BDE) + (57 + 15 - -38 + 141);
        StandardDecrypter.lIllI[3] = "   ".length();
        StandardDecrypter.lIllI[4] = "  ".length();
        StandardDecrypter.lIllI[5] = 15 + 19 - -105 + 19 ^ 126 + 3 - 117 + 138;
        StandardDecrypter.lIllI[6] = " ".length();
        StandardDecrypter.lIllI[7] = 0x8E ^ 0x83 ^ (0x2E ^ 0x33);
        StandardDecrypter.lIllI[8] = 0x39 ^ 0x21;
        StandardDecrypter.lIllI[9] = 12 + 166 - 52 + 73 ^ 83 + 70 - 5 + 46;
        StandardDecrypter.lIllI[10] = 0x58 ^ 0x54;
    }

    @Override
    public int decryptData(byte[] buff) throws ZipException {
        return this.decryptData(buff, lIllI[1], buff.length);
    }

    public void init(byte[] headerBytes) throws ZipException {
        byte[] crcBuff = this.fileHeader.getCrcBuff();
        this.crc[StandardDecrypter.lIllI[3]] = (byte)(crcBuff[lIllI[3]] & lIllI[2]);
        this.crc[StandardDecrypter.lIllI[4]] = (byte)(crcBuff[lIllI[3]] >> lIllI[5] & lIllI[2]);
        this.crc[StandardDecrypter.lIllI[6]] = (byte)(crcBuff[lIllI[3]] >> lIllI[7] & lIllI[2]);
        this.crc[StandardDecrypter.lIllI[1]] = (byte)(crcBuff[lIllI[3]] >> lIllI[8] & lIllI[2]);
        if (this.crc[lIllI[4]] > 0 || this.crc[lIllI[6]] > 0 || this.crc[lIllI[1]] > 0) {
            throw new IllegalStateException("Invalid CRC in File Header");
        }
        String password = this.fileHeader.getPassword();
        if (!Zip4jUtil.isStringNotNullAndNotEmpty(password)) {
            throw new ZipException("Wrong password!", lIllI[9]);
        }
        this.zipCryptoEngine.initKeys(password);
        try {
            byte result = headerBytes[lIllI[1]];
            for (int i = lIllI[1]; i < lIllI[10]; ++i) {
                this.zipCryptoEngine.updateKeys((byte)(result ^ this.zipCryptoEngine.decryptByte()));
                if (i + lIllI[6] == lIllI[10]) continue;
                result = headerBytes[i + lIllI[6]];
            }
        }
        catch (Exception e) {
            throw new ZipException(e);
        }
    }
}

