/*
 * Decompiled with CFR 0.152.
 */
package net.lingala.zip4j.io;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.Deflater;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.io.CipherOutputStream;
import net.lingala.zip4j.model.ZipModel;
import net.lingala.zip4j.model.ZipParameters;

public class DeflaterOutputStream
extends CipherOutputStream {
    private byte[] buff;
    protected Deflater deflater = new Deflater();
    private boolean firstBytesRead;
    private static final int[] lIIlIlI;

    @Override
    public void write(int bval) throws IOException {
        byte[] b = new byte[lIIlIlI[6]];
        b[DeflaterOutputStream.lIIlIlI[1]] = (byte)bval;
        this.write(b, lIIlIlI[1], lIIlIlI[6]);
    }

    @Override
    public void closeEntry() throws ZipException, IOException {
        if (this.zipParameters.getCompressionMethod() == lIIlIlI[2]) {
            if (!this.deflater.finished()) {
                this.deflater.finish();
                while (!this.deflater.finished()) {
                    this.deflate();
                }
            }
            this.firstBytesRead = lIIlIlI[1];
        }
        super.closeEntry();
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, lIIlIlI[1], b.length);
    }

    public DeflaterOutputStream(OutputStream outputStream, ZipModel zipModel) {
        super(outputStream, zipModel);
        this.buff = new byte[lIIlIlI[0]];
        this.firstBytesRead = lIIlIlI[1];
    }

    @Override
    public void finish() throws IOException, ZipException {
        super.finish();
    }

    @Override
    public void write(byte[] buf, int off, int len) throws IOException {
        if (this.zipParameters.getCompressionMethod() != lIIlIlI[2]) {
            super.write(buf, off, len);
        } else {
            this.deflater.setInput(buf, off, len);
            while (!this.deflater.needsInput()) {
                this.deflate();
            }
        }
    }

    private static void llIIlI() {
        lIIlIlI = new int[7];
        DeflaterOutputStream.lIIlIlI[0] = 0xFFFFD1C9 & 0x3E36;
        DeflaterOutputStream.lIIlIlI[1] = (0x42 ^ 0x71) & ~(0x44 ^ 0x77);
        DeflaterOutputStream.lIIlIlI[2] = 0x8C ^ 0x84;
        DeflaterOutputStream.lIIlIlI[3] = 130 + 55 - 32 + 4 ^ 54 + 132 - 151 + 113;
        DeflaterOutputStream.lIIlIlI[4] = -" ".length();
        DeflaterOutputStream.lIIlIlI[5] = "  ".length();
        DeflaterOutputStream.lIIlIlI[6] = " ".length();
    }

    static {
        DeflaterOutputStream.llIIlI();
    }

    private void deflate() throws IOException {
        int len = this.deflater.deflate(this.buff, lIIlIlI[1], this.buff.length);
        if (len > 0) {
            if (this.deflater.finished()) {
                len -= 4;
            }
            if (!this.firstBytesRead) {
                super.write(this.buff, lIIlIlI[5], len - lIIlIlI[5]);
                this.firstBytesRead = lIIlIlI[6];
            } else {
                super.write(this.buff, lIIlIlI[1], len);
            }
        }
    }

    @Override
    public void putNextEntry(File file, ZipParameters zipParameters) throws ZipException {
        super.putNextEntry(file, zipParameters);
        if (zipParameters.getCompressionMethod() == lIIlIlI[2]) {
            this.deflater.reset();
            if ((zipParameters.getCompressionLevel() < 0 || zipParameters.getCompressionLevel() > lIIlIlI[3]) && zipParameters.getCompressionLevel() != lIIlIlI[4]) {
                throw new ZipException("invalid compression level for deflater. compression level should be in the range of 0-9");
            }
            this.deflater.setLevel(zipParameters.getCompressionLevel());
        }
    }
}

